/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.rpc.subscription.config;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class TopicConfig
extends PipeParameters {
    private static final String SQL_DIALECT_KEY = "__system.sql-dialect";
    private static final String SQL_DIALECT_TREE_VALUE = "tree";
    private static final String SQL_DIALECT_TABLE_VALUE = "table";
    private static final Map<String, String> REALTIME_BATCH_MODE_CONFIG = Collections.singletonMap("realtime.mode", "batch");
    private static final Map<String, String> REALTIME_STREAM_MODE_CONFIG = Collections.singletonMap("realtime.mode", "stream");
    private static final Map<String, String> SINK_TABLET_FORMAT_CONFIG = Collections.singletonMap("format", "tablet");
    private static final Map<String, String> SINK_TS_FILE_FORMAT_CONFIG = Collections.singletonMap("format", "tsfile");
    private static final Map<String, String> SINK_HYBRID_FORMAT_CONFIG = Collections.singletonMap("format", "hybrid");
    private static final Map<String, String> SNAPSHOT_MODE_CONFIG = Collections.singletonMap("mode", "snapshot");
    private static final Map<String, String> LIVE_MODE_CONFIG = Collections.singletonMap("mode", "live");
    private static final Map<String, String> STRICT_MODE_CONFIG = Collections.singletonMap("mode.strict", "true");
    private static final Set<String> LOOSE_RANGE_KEY_SET;

    public TopicConfig() {
        super(Collections.emptyMap());
    }

    public TopicConfig(Map<String, String> attributes) {
        super(attributes);
    }

    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((Map)this.attributes, (OutputStream)stream);
    }

    public static TopicConfig deserialize(ByteBuffer buffer) {
        return new TopicConfig(ReadWriteIOUtils.readMap((ByteBuffer)buffer));
    }

    public boolean isTableTopic() {
        return SQL_DIALECT_TABLE_VALUE.equalsIgnoreCase(this.attributes.getOrDefault(SQL_DIALECT_KEY, SQL_DIALECT_TREE_VALUE));
    }

    public Map<String, String> getAttributeWithSqlDialect() {
        return Collections.singletonMap(SQL_DIALECT_KEY, this.attributes.getOrDefault(SQL_DIALECT_KEY, SQL_DIALECT_TREE_VALUE));
    }

    public Map<String, String> getAttributesWithSourcePathOrPattern() {
        if (this.attributes.containsKey("pattern")) {
            return Collections.singletonMap("pattern", (String)this.attributes.get("pattern"));
        }
        return Collections.singletonMap("path", this.attributes.getOrDefault("path", "root.**"));
    }

    public Map<String, String> getAttributesWithSourceDatabaseAndTableName() {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("database", this.attributes.getOrDefault("database", ".*"));
        attributes.put(SQL_DIALECT_TABLE_VALUE, this.attributes.getOrDefault(SQL_DIALECT_TABLE_VALUE, ".*"));
        return attributes;
    }

    public Map<String, String> getAttributesWithSourceTimeRange() {
        HashMap<String, String> attributesWithTimeRange = new HashMap<String, String>();
        attributesWithTimeRange.put("start-time", this.attributes.getOrDefault("start-time", String.valueOf(Long.MIN_VALUE)));
        attributesWithTimeRange.put("end-time", this.attributes.getOrDefault("end-time", String.valueOf(Long.MAX_VALUE)));
        return attributesWithTimeRange;
    }

    public Map<String, String> getAttributesWithSourceRealtimeMode() {
        return REALTIME_STREAM_MODE_CONFIG;
    }

    public Map<String, String> getAttributesWithSourceMode() {
        return "snapshot".equalsIgnoreCase(this.attributes.getOrDefault("mode", "live")) ? SNAPSHOT_MODE_CONFIG : LIVE_MODE_CONFIG;
    }

    public Map<String, String> getAttributesWithSourceLooseRangeOrStrict() {
        if (this.attributes.containsKey("loose-range") && !this.attributes.containsKey("strict")) {
            String looseRangeValue = this.attributes.getOrDefault("loose-range", "");
            return LOOSE_RANGE_KEY_SET.stream().collect(Collectors.toMap(key -> key, key -> looseRangeValue));
        }
        return Collections.singletonMap("strict", this.attributes.getOrDefault("strict", "true"));
    }

    public Map<String, String> getAttributesWithSourcePrefix() {
        HashMap<String, String> attributesWithProcessorPrefix = new HashMap<String, String>();
        this.attributes.forEach((key, value) -> {
            if (key.toLowerCase().startsWith("source")) {
                attributesWithProcessorPrefix.put((String)key, (String)value);
            }
        });
        return attributesWithProcessorPrefix;
    }

    public Map<String, String> getAttributesWithProcessorPrefix() {
        HashMap<String, String> attributesWithProcessorPrefix = new HashMap<String, String>();
        this.attributes.forEach((key, value) -> {
            if (key.toLowerCase().startsWith("processor")) {
                attributesWithProcessorPrefix.put((String)key, (String)value);
            }
        });
        return attributesWithProcessorPrefix;
    }

    public Map<String, String> getAttributesWithSinkFormat() {
        return "TsFileHandler".equalsIgnoreCase(this.attributes.getOrDefault("format", "SessionDataSetsHandler")) ? SINK_TS_FILE_FORMAT_CONFIG : SINK_TABLET_FORMAT_CONFIG;
    }

    public Map<String, String> getAttributesWithSinkPrefix() {
        HashMap<String, String> attributesWithProcessorPrefix = new HashMap<String, String>();
        this.attributes.forEach((key, value) -> {
            if (key.toLowerCase().startsWith("sink")) {
                attributesWithProcessorPrefix.put((String)key, (String)value);
            }
        });
        return attributesWithProcessorPrefix;
    }

    static {
        HashSet<String> set = new HashSet<String>(2);
        set.add("history.loose-range");
        set.add("realtime.loose-range");
        LOOSE_RANGE_KEY_SET = Collections.unmodifiableSet(set);
    }
}

