/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.mem;

import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.schema.SchemaConstant;
import org.apache.iotdb.commons.schema.node.IMNode;
import org.apache.iotdb.commons.schema.node.role.IDeviceMNode;
import org.apache.iotdb.commons.schema.node.role.IMeasurementMNode;
import org.apache.iotdb.commons.schema.node.utils.IMNodeFactory;
import org.apache.iotdb.commons.schema.node.utils.IMNodeIterator;
import org.apache.iotdb.commons.schema.tree.ITreeNode;
import org.apache.iotdb.commons.schema.tree.SchemaIterator;
import org.apache.iotdb.commons.schema.view.LogicalViewSchema;
import org.apache.iotdb.commons.schema.view.viewExpression.ViewExpression;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.metadata.AliasAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.AlignedTimeseriesException;
import org.apache.iotdb.db.exception.metadata.MNodeTypeMismatchException;
import org.apache.iotdb.db.exception.metadata.MeasurementAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.MeasurementInBlackListException;
import org.apache.iotdb.db.exception.metadata.PathAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.exception.metadata.template.DifferentTemplateException;
import org.apache.iotdb.db.exception.metadata.template.TemplateIsInUseException;
import org.apache.iotdb.db.exception.quota.ExceedQuotaException;
import org.apache.iotdb.db.queryengine.common.schematree.ClusterSchemaTree;
import org.apache.iotdb.db.queryengine.execution.operator.schema.source.DeviceAttributeUpdater;
import org.apache.iotdb.db.queryengine.execution.operator.schema.source.DeviceBlackListConstructor;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.cache.TableId;
import org.apache.iotdb.db.schemaengine.metric.SchemaRegionMemMetric;
import org.apache.iotdb.db.schemaengine.rescon.MemSchemaRegionStatistics;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.IMTreeStore;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.mem.MemMTreeStore;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.mem.mnode.IMemMNode;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.mem.mnode.info.TableDeviceInfo;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.loader.MNodeFactoryLoader;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.traverser.collector.EntityCollector;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.traverser.collector.MNodeCollector;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.traverser.collector.MeasurementCollector;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.traverser.counter.EntityCounter;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.traverser.updater.EntityUpdater;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.traverser.updater.MeasurementUpdater;
import org.apache.iotdb.db.schemaengine.schemaregion.read.req.IShowDevicesPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.read.req.IShowNodesPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.read.req.IShowTimeSeriesPlan;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.IDeviceSchemaInfo;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.INodeSchemaInfo;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.ITimeSeriesSchemaInfo;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.impl.ShowDevicesResult;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.impl.ShowNodesResult;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.impl.TimeseriesSchemaInfo;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.reader.ISchemaReader;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.reader.impl.SchemaReaderLimitOffsetWrapper;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.reader.impl.TimeseriesReaderWithViewFetch;
import org.apache.iotdb.db.schemaengine.schemaregion.utils.MetaFormatUtils;
import org.apache.iotdb.db.schemaengine.schemaregion.utils.filter.DeviceFilterVisitor;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.iotdb.db.storageengine.rescon.quotas.DataNodeSpaceQuotaManager;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.read.TimeValuePair;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.apache.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MTreeBelowSGMemoryImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(MTreeBelowSGMemoryImpl.class);
    private final MemMTreeStore store;
    private volatile IMemMNode storageGroupMNode;
    private final IMemMNode rootNode;
    private final Function<IMeasurementMNode<IMemMNode>, Map<String, String>> tagGetter;
    private final Function<IMeasurementMNode<IMemMNode>, Map<String, String>> attributeGetter;
    private final IMNodeFactory<IMemMNode> nodeFactory = MNodeFactoryLoader.getInstance().getMemMNodeIMNodeFactory();
    private final int levelOfSG;
    private final MemSchemaRegionStatistics regionStatistics;

    public MTreeBelowSGMemoryImpl(PartialPath storageGroupPath, Function<IMeasurementMNode<IMemMNode>, Map<String, String>> tagGetter, Function<IMeasurementMNode<IMemMNode>, Map<String, String>> attributeGetter, MemSchemaRegionStatistics regionStatistics, SchemaRegionMemMetric metric) {
        this.store = new MemMTreeStore(storageGroupPath, regionStatistics, metric);
        this.regionStatistics = regionStatistics;
        this.storageGroupMNode = this.store.getRoot();
        this.rootNode = this.store.generatePrefix(storageGroupPath);
        this.levelOfSG = storageGroupPath.getNodeLength() - 1;
        this.tagGetter = tagGetter;
        this.attributeGetter = attributeGetter;
    }

    private MTreeBelowSGMemoryImpl(PartialPath storageGroupPath, MemMTreeStore store, Function<IMeasurementMNode<IMemMNode>, Map<String, String>> tagGetter, Function<IMeasurementMNode<IMemMNode>, Map<String, String>> attributeGetter, MemSchemaRegionStatistics regionStatistics) {
        this.store = store;
        this.regionStatistics = regionStatistics;
        this.storageGroupMNode = store.getRoot();
        this.rootNode = store.generatePrefix(storageGroupPath);
        this.levelOfSG = storageGroupPath.getNodeLength() - 1;
        this.tagGetter = tagGetter;
        this.attributeGetter = attributeGetter;
    }

    public void clear() {
        this.store.clear();
        this.storageGroupMNode = null;
    }

    public synchronized boolean createSnapshot(File snapshotDir) {
        return this.store.createSnapshot(snapshotDir);
    }

    public static MTreeBelowSGMemoryImpl loadFromSnapshot(File snapshotDir, String storageGroupFullPath, MemSchemaRegionStatistics regionStatistics, SchemaRegionMemMetric metric, Consumer<IMeasurementMNode<IMemMNode>> measurementProcess, Consumer<IDeviceMNode<IMemMNode>> deviceProcess, BiConsumer<IDeviceMNode<IMemMNode>, String> tableDeviceProcess, Function<IMeasurementMNode<IMemMNode>, Map<String, String>> tagGetter, Function<IMeasurementMNode<IMemMNode>, Map<String, String>> attributeGetter) throws IOException, IllegalPathException {
        return new MTreeBelowSGMemoryImpl(PartialPath.getQualifiedDatabasePartialPath((String)storageGroupFullPath), MemMTreeStore.loadFromSnapshot(snapshotDir, measurementProcess, deviceProcess, tableDeviceProcess, regionStatistics, metric), tagGetter, attributeGetter, regionStatistics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMeasurementMNode<IMemMNode> createTimeSeries(PartialPath path, TSDataType dataType, TSEncoding encoding, CompressionType compressor, Map<String, String> props, String alias, boolean withMerge) throws MetadataException {
        String[] nodeNames = path.getNodes();
        if (nodeNames.length <= 2) {
            throw new IllegalPathException(path.getFullPath());
        }
        MetaFormatUtils.checkTimeseries(path);
        PartialPath devicePath = path.getDevicePath();
        IMemMNode deviceParent = this.checkAndAutoCreateInternalPath(devicePath);
        MTreeBelowSGMemoryImpl mTreeBelowSGMemoryImpl = this;
        synchronized (mTreeBelowSGMemoryImpl) {
            IMemMNode device = this.checkAndAutoCreateDeviceNode(devicePath.getTailNode(), deviceParent);
            MetaFormatUtils.checkTimeseriesProps(path.getFullPath(), props);
            String leafName = path.getMeasurement();
            if (!withMerge && alias != null && device.hasChild(alias)) {
                throw new AliasAlreadyExistException(path.getFullPath(), alias);
            }
            if (device.hasChild(leafName)) {
                IMemMNode node = (IMemMNode)device.getChild(leafName);
                if (node.isMeasurement()) {
                    IMeasurementMNode measurementNode = node.getAsMeasurementMNode();
                    if (measurementNode.isPreDeleted()) {
                        throw new MeasurementInBlackListException(path);
                    }
                    if (!withMerge || measurementNode.getDataType() != dataType) {
                        throw new MeasurementAlreadyExistException(path.getFullPath(), node.getAsMeasurementMNode().getMeasurementPath());
                    }
                    return null;
                }
                throw new PathAlreadyExistException(path.getFullPath());
            }
            if (device.isDevice() && device.getAsDeviceMNode().isAlignedNullable() != null && device.getAsDeviceMNode().isAligned()) {
                throw new AlignedTimeseriesException("time series under this device is aligned, please use createAlignedTimeseries or change device.", device.getFullPath());
            }
            IDeviceMNode<IMemMNode> entityMNode = device.isDevice() ? device.getAsDeviceMNode() : this.store.setToEntity(device);
            if (entityMNode.isAlignedNullable() == null) {
                entityMNode.setAligned(Boolean.valueOf(false));
            }
            IMeasurementMNode measurementMNode = this.nodeFactory.createMeasurementMNode(entityMNode, leafName, (IMeasurementSchema)new MeasurementSchema(leafName, dataType, encoding, compressor, props), alias);
            this.store.addChild((IMemMNode)entityMNode.getAsMNode(), leafName, (IMemMNode)measurementMNode.getAsMNode());
            if (alias != null) {
                entityMNode.addAlias(alias, measurementMNode);
            }
            return measurementMNode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IMeasurementMNode<IMemMNode>> createAlignedTimeSeries(PartialPath devicePath, List<String> measurements, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors, List<String> aliasList, boolean withMerge, Set<Integer> existingMeasurementIndexes) throws MetadataException {
        ArrayList<IMeasurementMNode<IMemMNode>> measurementMNodeList = new ArrayList<IMeasurementMNode<IMemMNode>>();
        MetaFormatUtils.checkSchemaMeasurementNames(measurements);
        IMemMNode deviceParent = this.checkAndAutoCreateInternalPath(devicePath);
        MTreeBelowSGMemoryImpl mTreeBelowSGMemoryImpl = this;
        synchronized (mTreeBelowSGMemoryImpl) {
            IDeviceMNode<IMemMNode> entityMNode;
            IMemMNode device = this.checkAndAutoCreateDeviceNode(devicePath.getTailNode(), deviceParent);
            for (int i = 0; i < measurements.size(); ++i) {
                if (device.hasChild(measurements.get(i))) {
                    IMemMNode node = (IMemMNode)device.getChild(measurements.get(i));
                    if (node.isMeasurement()) {
                        IMeasurementMNode measurementNode = node.getAsMeasurementMNode();
                        if (node.getAsMeasurementMNode().isPreDeleted()) {
                            throw new MeasurementInBlackListException((PartialPath)devicePath.concatAsMeasurementPath(measurements.get(i)));
                        }
                        if (!withMerge || measurementNode.getDataType() != dataTypes.get(i)) {
                            throw new MeasurementAlreadyExistException(devicePath.getFullPath() + "." + measurements.get(i), node.getAsMeasurementMNode().getMeasurementPath());
                        }
                        existingMeasurementIndexes.add(i);
                        continue;
                    }
                    throw new PathAlreadyExistException(devicePath.getFullPath() + "." + measurements.get(i));
                }
                if (aliasList == null || aliasList.get(i) == null || !device.hasChild(aliasList.get(i))) continue;
                throw new AliasAlreadyExistException(devicePath.getFullPath() + "." + measurements.get(i), aliasList.get(i));
            }
            if (device.isDevice() && device.getAsDeviceMNode().isAlignedNullable() != null && !device.getAsDeviceMNode().isAligned()) {
                throw new AlignedTimeseriesException("Time series under this device is not aligned, please use createTimeSeries or change device.", devicePath.getFullPath());
            }
            if (device.isDevice()) {
                entityMNode = device.getAsDeviceMNode();
            } else {
                entityMNode = this.store.setToEntity(device);
                entityMNode.setAligned(Boolean.valueOf(true));
            }
            if (entityMNode.isAlignedNullable() == null) {
                entityMNode.setAligned(Boolean.valueOf(true));
            }
            for (int i = 0; i < measurements.size(); ++i) {
                if (existingMeasurementIndexes.contains(i)) continue;
                IMeasurementMNode measurementMNode = this.nodeFactory.createMeasurementMNode(entityMNode, measurements.get(i), (IMeasurementSchema)new MeasurementSchema(measurements.get(i), dataTypes.get(i), encodings.get(i), compressors.get(i)), aliasList == null ? null : aliasList.get(i));
                this.store.addChild((IMemMNode)entityMNode.getAsMNode(), measurements.get(i), (IMemMNode)measurementMNode.getAsMNode());
                if (aliasList != null && aliasList.get(i) != null) {
                    entityMNode.addAlias(aliasList.get(i), measurementMNode);
                }
                measurementMNodeList.add((IMeasurementMNode<IMemMNode>)measurementMNode);
            }
            return measurementMNodeList;
        }
    }

    private IMemMNode checkAndAutoCreateInternalPath(PartialPath devicePath) throws MetadataException {
        String[] nodeNames = devicePath.getNodes();
        MetaFormatUtils.checkTimeseries(devicePath);
        if (nodeNames.length == this.levelOfSG + 1) {
            return null;
        }
        IMemMNode cur = this.storageGroupMNode;
        for (int i = this.levelOfSG + 1; i < nodeNames.length - 1; ++i) {
            String childName = nodeNames[i];
            IMemMNode child = (IMemMNode)cur.getChild(childName);
            if (child == null) {
                child = this.store.addChild(cur, childName, (IMemMNode)this.nodeFactory.createInternalMNode((IMNode)cur, childName));
            }
            if (!(cur = child).isMeasurement()) continue;
            throw new PathAlreadyExistException(cur.getFullPath());
        }
        return cur;
    }

    private IMemMNode checkAndAutoCreateDeviceNode(String deviceName, IMemMNode deviceParent) throws PathAlreadyExistException, ExceedQuotaException {
        if (deviceParent == null) {
            return this.storageGroupMNode;
        }
        IMemMNode device = this.store.getChild(deviceParent, deviceName);
        if (device == null) {
            if (IoTDBDescriptor.getInstance().getConfig().isQuotaEnable() && !DataNodeSpaceQuotaManager.getInstance().checkDeviceLimit(this.storageGroupMNode.getName())) {
                throw new ExceedQuotaException("The number of devices has reached the upper limit", TSStatusCode.SPACE_QUOTA_EXCEEDED.getStatusCode());
            }
            device = this.store.addChild(deviceParent, deviceName, (IMemMNode)this.nodeFactory.createInternalMNode((IMNode)deviceParent, deviceName));
        }
        if (device.isMeasurement()) {
            throw new PathAlreadyExistException(device.getFullPath());
        }
        return device;
    }

    public Map<Integer, MetadataException> checkMeasurementExistence(PartialPath devicePath, List<String> measurementList, List<String> aliasList) {
        IMemMNode device;
        try {
            device = this.getNodeByPath(devicePath);
        }
        catch (PathNotExistException e) {
            return Collections.emptyMap();
        }
        if (!device.isDevice()) {
            return Collections.emptyMap();
        }
        HashMap<Integer, MetadataException> failingMeasurementMap = new HashMap<Integer, MetadataException>();
        for (int i = 0; i < measurementList.size(); ++i) {
            if (device.hasChild(measurementList.get(i))) {
                IMemMNode node = (IMemMNode)device.getChild(measurementList.get(i));
                if (node.isMeasurement()) {
                    if (node.getAsMeasurementMNode().isPreDeleted()) {
                        failingMeasurementMap.put(i, new MeasurementInBlackListException((PartialPath)devicePath.concatAsMeasurementPath(measurementList.get(i))));
                    } else {
                        failingMeasurementMap.put(i, new MeasurementAlreadyExistException(devicePath.getFullPath() + "." + measurementList.get(i), node.getAsMeasurementMNode().getMeasurementPath()));
                    }
                } else {
                    failingMeasurementMap.put(i, new PathAlreadyExistException(devicePath.getFullPath() + "." + measurementList.get(i)));
                }
            }
            if (aliasList != null && aliasList.get(i) != null && device.hasChild(aliasList.get(i))) {
                failingMeasurementMap.put(i, new AliasAlreadyExistException(devicePath.getFullPath() + "." + measurementList.get(i), aliasList.get(i)));
            }
            if (!IoTDBDescriptor.getInstance().getConfig().isQuotaEnable() || DataNodeSpaceQuotaManager.getInstance().checkTimeSeriesNum(this.storageGroupMNode.getName())) continue;
            failingMeasurementMap.put(i, new ExceedQuotaException("The number of timeseries has reached the upper limit", TSStatusCode.SPACE_QUOTA_EXCEEDED.getStatusCode()));
        }
        return failingMeasurementMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean changeAlias(String alias, PartialPath fullPath) throws MetadataException {
        IMeasurementMNode<IMemMNode> measurementMNode = this.getMeasurementMNode(fullPath);
        if (alias != null && !alias.equals(measurementMNode.getAlias())) {
            MTreeBelowSGMemoryImpl mTreeBelowSGMemoryImpl = this;
            synchronized (mTreeBelowSGMemoryImpl) {
                IDeviceMNode device = ((IMemMNode)measurementMNode.getParent()).getAsDeviceMNode();
                IMemMNode memMNode = this.store.getChild((IMemMNode)device.getAsMNode(), alias);
                if (memMNode != null) {
                    throw new MetadataException("The alias is duplicated with the name or alias of other measurement, alias: " + alias + ", fullPath: " + fullPath + ", otherMeasurement: " + memMNode.getFullPath());
                }
                if (measurementMNode.getAlias() != null) {
                    device.deleteAliasChild(measurementMNode.getAlias());
                }
                device.addAlias(alias, measurementMNode);
                this.setAlias(measurementMNode, alias);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMeasurementMNode<IMemMNode> deleteTimeSeries(PartialPath path) throws MetadataException {
        String[] nodes = path.getNodes();
        if (nodes.length == 0) {
            throw new IllegalPathException(path.getFullPath());
        }
        IMeasurementMNode<IMemMNode> deletedNode = this.getMeasurementMNode(path);
        IMemMNode parent = (IMemMNode)deletedNode.getParent();
        MTreeBelowSGMemoryImpl mTreeBelowSGMemoryImpl = this;
        synchronized (mTreeBelowSGMemoryImpl) {
            this.store.deleteChild(parent, path.getMeasurement());
            if (deletedNode.getAlias() != null) {
                parent.getAsDeviceMNode().deleteAliasChild(deletedNode.getAlias());
            }
        }
        this.deleteEmptyInternalMNode((IDeviceMNode<IMemMNode>)parent.getAsDeviceMNode());
        return deletedNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteEmptyInternalMNode(IDeviceMNode<IMemMNode> entityMNode) {
        IMemMNode curNode = (IMemMNode)entityMNode.getAsMNode();
        if (!entityMNode.isUseTemplate()) {
            boolean hasMeasurement = false;
            boolean hasNonViewMeasurement = false;
            IMNodeIterator<IMemMNode> iterator = this.store.getChildrenIterator(curNode);
            while (iterator.hasNext()) {
                IMemMNode child = (IMemMNode)iterator.next();
                if (!child.isMeasurement()) continue;
                hasMeasurement = true;
                if (child.getAsMeasurementMNode().isLogicalView()) continue;
                hasNonViewMeasurement = true;
                break;
            }
            if (!hasMeasurement) {
                MTreeBelowSGMemoryImpl mTreeBelowSGMemoryImpl = this;
                synchronized (mTreeBelowSGMemoryImpl) {
                    curNode = this.store.setToInternal((IDeviceMNode)entityMNode);
                }
            } else if (!hasNonViewMeasurement) {
                entityMNode.setAligned(null);
            }
        }
        while (true) {
            if (curNode.isDatabase()) {
                return;
            }
            MTreeBelowSGMemoryImpl mTreeBelowSGMemoryImpl = this;
            synchronized (mTreeBelowSGMemoryImpl) {
                if (!this.isEmptyInternalMNode(curNode)) {
                    break;
                }
                this.store.deleteChild((IMemMNode)curNode.getParent(), curNode.getName());
                curNode = (IMemMNode)curNode.getParent();
            }
        }
    }

    private boolean isEmptyInternalMNode(IMemMNode node) {
        return !"root".equals(node.getName()) && !node.isMeasurement() && (!node.isDevice() || !node.getAsDeviceMNode().isUseTemplate()) && node.getChildren().isEmpty();
    }

    public List<PartialPath> constructSchemaBlackList(PartialPath pathPattern, final AtomicBoolean isAllLogicalView) throws MetadataException {
        final ArrayList<PartialPath> result = new ArrayList<PartialPath>();
        try (MeasurementUpdater<IMemMNode> updater = new MeasurementUpdater<IMemMNode>(this.rootNode, pathPattern, (IMTreeStore)this.store, false, SchemaConstant.ALL_MATCH_SCOPE){

            @Override
            protected void updateMeasurement(IMeasurementMNode<IMemMNode> node) {
                if (!node.isLogicalView()) {
                    isAllLogicalView.set(false);
                }
                node.setPreDeleted(true);
                result.add(this.getPartialPathFromRootToNode((ITreeNode)((IMemMNode)node.getAsMNode())));
            }
        };){
            updater.update();
        }
        return result;
    }

    public List<PartialPath> rollbackSchemaBlackList(PartialPath pathPattern) throws MetadataException {
        final ArrayList<PartialPath> result = new ArrayList<PartialPath>();
        try (MeasurementUpdater<IMemMNode> updater = new MeasurementUpdater<IMemMNode>(this.rootNode, pathPattern, (IMTreeStore)this.store, false, SchemaConstant.ALL_MATCH_SCOPE){

            @Override
            protected void updateMeasurement(IMeasurementMNode<IMemMNode> node) {
                node.setPreDeleted(false);
                result.add(this.getPartialPathFromRootToNode((ITreeNode)((IMemMNode)node.getAsMNode())));
            }
        };){
            updater.update();
        }
        return result;
    }

    public List<PartialPath> getPreDeletedTimeSeries(PartialPath pathPattern) throws MetadataException {
        final LinkedList<PartialPath> result = new LinkedList<PartialPath>();
        try (MeasurementCollector<Void, IMemMNode> collector = new MeasurementCollector<Void, IMemMNode>(this.rootNode, pathPattern, (IMTreeStore)this.store, false, SchemaConstant.ALL_MATCH_SCOPE){

            @Override
            protected Void collectMeasurement(IMeasurementMNode<IMemMNode> node) {
                if (node.isPreDeleted()) {
                    result.add(this.getPartialPathFromRootToNode((ITreeNode)((IMemMNode)node.getAsMNode())));
                }
                return null;
            }
        };){
            collector.traverse();
        }
        return result;
    }

    public Set<PartialPath> getDevicesOfPreDeletedTimeSeries(PartialPath pathPattern) throws MetadataException {
        final HashSet<PartialPath> result = new HashSet<PartialPath>();
        try (MeasurementCollector<Void, IMemMNode> collector = new MeasurementCollector<Void, IMemMNode>(this.rootNode, pathPattern, (IMTreeStore)this.store, false, SchemaConstant.ALL_MATCH_SCOPE){

            @Override
            protected Void collectMeasurement(IMeasurementMNode<IMemMNode> node) {
                if (node.isPreDeleted()) {
                    result.add(this.getPartialPathFromRootToNode((ITreeNode)((IMemMNode)node.getAsMNode())).getDevicePath());
                }
                return null;
            }
        };){
            collector.traverse();
        }
        return result;
    }

    public void setAlias(IMeasurementMNode<IMemMNode> measurementMNode, String alias) throws MetadataException {
        this.store.setAlias(measurementMNode, alias);
    }

    public IMemMNode getDeviceNodeWithAutoCreating(PartialPath deviceId) throws MetadataException {
        MetaFormatUtils.checkTimeseries(deviceId);
        String[] nodeNames = deviceId.getNodes();
        IMemMNode cur = this.storageGroupMNode;
        for (int i = this.levelOfSG + 1; i < nodeNames.length; ++i) {
            IMemMNode child = (IMemMNode)cur.getChild(nodeNames[i]);
            if (child == null) {
                child = this.store.addChild(cur, nodeNames[i], (IMemMNode)this.nodeFactory.createInternalMNode((IMNode)cur, nodeNames[i]));
            }
            cur = child;
        }
        return cur;
    }

    public boolean checkDeviceNodeExists(PartialPath deviceId) {
        try {
            IMemMNode deviceMNode = this.getNodeByPath(deviceId);
            return deviceMNode.isDevice();
        }
        catch (MetadataException e) {
            return false;
        }
    }

    public ClusterSchemaTree fetchSchema(PartialPath pathPattern, Map<Integer, Template> templateMap, final boolean withTags, final boolean withAttributes, final boolean withTemplate, final boolean withAliasForce) throws MetadataException {
        final ClusterSchemaTree schemaTree = new ClusterSchemaTree();
        try (MeasurementCollector<Void, IMemMNode> collector = new MeasurementCollector<Void, IMemMNode>(this.rootNode, pathPattern, (IMTreeStore)this.store, false, SchemaConstant.ALL_MATCH_SCOPE){

            @Override
            protected Void collectMeasurement(IMeasurementMNode<IMemMNode> node) {
                IDeviceMNode deviceMNode = ((IMemMNode)this.getParentOfNextMatchedNode()).getAsDeviceMNode();
                int templateId = deviceMNode.getSchemaTemplateIdWithState();
                if (withTemplate && templateId >= 0) {
                    schemaTree.appendTemplateDevice(deviceMNode.getPartialPath(), deviceMNode.isAligned(), templateId, null);
                    this.skipTemplateChildren(deviceMNode);
                } else {
                    MeasurementPath path = this.getCurrentMeasurementPathInTraverse(node);
                    schemaTree.appendSingleMeasurement((PartialPath)path, path.getMeasurementSchema(), withTags ? (Map)MTreeBelowSGMemoryImpl.this.tagGetter.apply(node) : null, withAttributes ? (Map)MTreeBelowSGMemoryImpl.this.attributeGetter.apply(node) : null, withAliasForce || this.nodes[this.nodes.length - 1].equals(node.getAlias()) ? node.getAlias() : null, deviceMNode.isAligned());
                }
                return null;
            }
        };){
            collector.setTemplateMap(templateMap, this.nodeFactory);
            collector.setSkipPreDeletedSchema(true);
            collector.traverse();
        }
        return schemaTree;
    }

    public ClusterSchemaTree fetchSchemaWithoutWildcard(PathPatternTree patternTree, Map<Integer, Template> templateMap, final boolean withTags, final boolean withAttributes, final boolean withTemplate) throws MetadataException {
        final ClusterSchemaTree schemaTree = new ClusterSchemaTree();
        try (MeasurementCollector<Void, IMemMNode> collector = new MeasurementCollector<Void, IMemMNode>(this.rootNode, patternTree, (IMTreeStore)this.store, SchemaConstant.ALL_MATCH_SCOPE){

            @Override
            protected Void collectMeasurement(IMeasurementMNode<IMemMNode> node) {
                IDeviceMNode deviceMNode = ((IMemMNode)this.getParentOfNextMatchedNode()).getAsDeviceMNode();
                int templateId = deviceMNode.getSchemaTemplateIdWithState();
                if (withTemplate && templateId >= 0) {
                    schemaTree.appendTemplateDevice(deviceMNode.getPartialPath(), deviceMNode.isAligned(), templateId, null);
                    this.skipTemplateChildren(deviceMNode);
                } else {
                    MeasurementPath path = this.getCurrentMeasurementPathInTraverse(node);
                    schemaTree.appendSingleMeasurement((PartialPath)path, path.getMeasurementSchema(), withTags ? (Map)MTreeBelowSGMemoryImpl.this.tagGetter.apply(node) : null, withAttributes ? (Map)MTreeBelowSGMemoryImpl.this.attributeGetter.apply(node) : null, node.getAlias(), deviceMNode.isAligned());
                }
                return null;
            }
        };){
            collector.setTemplateMap(templateMap, this.nodeFactory);
            collector.setSkipPreDeletedSchema(true);
            collector.traverse();
        }
        return schemaTree;
    }

    public ClusterSchemaTree fetchDeviceSchema(PathPatternTree patternTree, PathPatternTree authorityScope) throws MetadataException {
        final ClusterSchemaTree schemaTree = new ClusterSchemaTree();
        for (PartialPath pattern : patternTree.getAllPathPatterns()) {
            try (EntityCollector<Void, IMemMNode> collector = new EntityCollector<Void, IMemMNode>(this.rootNode, pattern, (IMTreeStore)this.store, false, authorityScope){

                @Override
                protected Void collectEntity(IDeviceMNode<IMemMNode> node) {
                    if (node.isAlignedNullable() != null) {
                        schemaTree.appendTemplateDevice(node.getPartialPath(), node.isAligned(), node.getSchemaTemplateId(), null);
                    }
                    return null;
                }
            };){
                collector.traverse();
            }
        }
        return schemaTree;
    }

    public IMemMNode getNodeByPath(PartialPath path) throws PathNotExistException {
        String[] nodes = path.getNodes();
        IMemMNode cur = this.storageGroupMNode;
        for (int i = this.levelOfSG + 1; i < nodes.length; ++i) {
            IMemMNode next = (IMemMNode)cur.getChild(nodes[i]);
            if (next == null) {
                throw new PathNotExistException(path.getFullPath(), true);
            }
            if (next.isMeasurement()) {
                if (i == nodes.length - 1) {
                    return next;
                }
                throw new PathNotExistException(path.getFullPath(), true);
            }
            cur = next;
        }
        return cur;
    }

    public IMeasurementMNode<IMemMNode> getMeasurementMNode(PartialPath path) throws MetadataException {
        IMemMNode node = this.getNodeByPath(path);
        if (node.isMeasurement()) {
            return node.getAsMeasurementMNode();
        }
        throw new MNodeTypeMismatchException(path.getFullPath(), 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateTemplate(PartialPath activatePath, Template template) throws MetadataException {
        IDeviceMNode<IMemMNode> entityMNode;
        String[] nodes = activatePath.getNodes();
        IMemMNode cur = this.storageGroupMNode;
        for (int i = this.levelOfSG + 1; i < nodes.length; ++i) {
            cur = (IMemMNode)cur.getChild(nodes[i]);
        }
        MTreeBelowSGMemoryImpl mTreeBelowSGMemoryImpl = this;
        synchronized (mTreeBelowSGMemoryImpl) {
            entityMNode = cur.isDevice() ? cur.getAsDeviceMNode() : this.store.setToEntity(cur);
        }
        if (entityMNode.isUseTemplate()) {
            if (template.getId() == entityMNode.getSchemaTemplateId()) {
                throw new TemplateIsInUseException(cur.getFullPath());
            }
            throw new DifferentTemplateException(activatePath.getFullPath(), template.getName());
        }
        if (!entityMNode.isAligned()) {
            entityMNode.setAligned(Boolean.valueOf(template.isDirectAligned()));
        }
        entityMNode.setUseTemplate(true);
        entityMNode.setSchemaTemplateId(template.getId());
        this.regionStatistics.activateTemplate(template.getId());
    }

    public Map<PartialPath, List<Integer>> constructSchemaBlackListWithTemplate(Map<PartialPath, List<Integer>> templateSetInfo) throws MetadataException {
        final HashMap<PartialPath, List<Integer>> resultTemplateSetInfo = new HashMap<PartialPath, List<Integer>>();
        for (final Map.Entry<PartialPath, List<Integer>> entry : templateSetInfo.entrySet()) {
            try (EntityUpdater<IMemMNode> updater = new EntityUpdater<IMemMNode>(this.rootNode, entry.getKey(), (IMTreeStore)this.store, false, SchemaConstant.ALL_MATCH_SCOPE){

                @Override
                protected void updateEntity(IDeviceMNode<IMemMNode> node) {
                    if (((List)entry.getValue()).contains(node.getSchemaTemplateId())) {
                        resultTemplateSetInfo.put(node.getPartialPath(), Collections.singletonList(node.getSchemaTemplateId()));
                        node.preDeactivateSelfOrTemplate();
                    }
                }
            };){
                updater.update();
            }
        }
        return resultTemplateSetInfo;
    }

    public Map<PartialPath, List<Integer>> rollbackSchemaBlackListWithTemplate(Map<PartialPath, List<Integer>> templateSetInfo) throws MetadataException {
        final HashMap<PartialPath, List<Integer>> resultTemplateSetInfo = new HashMap<PartialPath, List<Integer>>();
        for (final Map.Entry<PartialPath, List<Integer>> entry : templateSetInfo.entrySet()) {
            try (EntityUpdater<IMemMNode> updater = new EntityUpdater<IMemMNode>(this.rootNode, entry.getKey(), (IMTreeStore)this.store, false, SchemaConstant.ALL_MATCH_SCOPE){

                @Override
                protected void updateEntity(IDeviceMNode<IMemMNode> node) {
                    if (((List)entry.getValue()).contains(node.getSchemaTemplateId()) && node.isPreDeactivateSelfOrTemplate()) {
                        resultTemplateSetInfo.put(node.getPartialPath(), Collections.singletonList(node.getSchemaTemplateId()));
                        node.rollbackPreDeactivateSelfOrTemplate();
                    }
                }
            };){
                updater.update();
            }
        }
        return resultTemplateSetInfo;
    }

    public Map<PartialPath, List<Integer>> deactivateTemplateInBlackList(Map<PartialPath, List<Integer>> templateSetInfo) throws MetadataException {
        final HashMap<PartialPath, List<Integer>> resultTemplateSetInfo = new HashMap<PartialPath, List<Integer>>();
        for (final Map.Entry<PartialPath, List<Integer>> entry : templateSetInfo.entrySet()) {
            try (EntityUpdater<IMemMNode> collector = new EntityUpdater<IMemMNode>(this.rootNode, entry.getKey(), (IMTreeStore)this.store, false, SchemaConstant.ALL_MATCH_SCOPE){

                @Override
                protected void updateEntity(IDeviceMNode<IMemMNode> node) {
                    if (((List)entry.getValue()).contains(node.getSchemaTemplateId()) && node.isPreDeactivateSelfOrTemplate()) {
                        resultTemplateSetInfo.put(node.getPartialPath(), Collections.singletonList(node.getSchemaTemplateId()));
                        MTreeBelowSGMemoryImpl.this.regionStatistics.deactivateTemplate(node.getSchemaTemplateId());
                        node.deactivateTemplate();
                        MTreeBelowSGMemoryImpl.this.deleteEmptyInternalMNode(node);
                    }
                }
            };){
                collector.traverse();
            }
        }
        return resultTemplateSetInfo;
    }

    public void activateTemplateWithoutCheck(PartialPath activatePath, int templateId, boolean isAligned) {
        String[] nodes = activatePath.getNodes();
        IMemMNode cur = this.storageGroupMNode;
        for (int i = this.levelOfSG + 1; i < nodes.length; ++i) {
            cur = (IMemMNode)cur.getChild(nodes[i]);
        }
        IDeviceMNode<IMemMNode> entityMNode = cur.isDevice() ? cur.getAsDeviceMNode() : this.store.setToEntity(cur);
        if (!entityMNode.isAligned()) {
            entityMNode.setAligned(Boolean.valueOf(isAligned));
        }
        entityMNode.setUseTemplate(true);
        entityMNode.setSchemaTemplateId(templateId);
        this.regionStatistics.activateTemplate(templateId);
    }

    public long countPathsUsingTemplate(PartialPath pathPattern, int templateId) throws MetadataException {
        try (EntityCounter<IMemMNode> counter = new EntityCounter<IMemMNode>(this.rootNode, pathPattern, this.store, false, SchemaConstant.ALL_MATCH_SCOPE);){
            counter.setSchemaTemplateFilter(templateId);
            long l = counter.count();
            return l;
        }
    }

    public ISchemaReader<IDeviceSchemaInfo> getDeviceReader(final IShowDevicesPlan showDevicesPlan, final BiFunction<Integer, String, Binary> attributeProvider) throws MetadataException {
        final EntityCollector<IDeviceSchemaInfo, IMemMNode> collector = new EntityCollector<IDeviceSchemaInfo, IMemMNode>(this.rootNode, showDevicesPlan.getPath(), (IMTreeStore)this.store, showDevicesPlan.isPrefixMatch(), showDevicesPlan.getScope()){

            @Override
            protected IDeviceSchemaInfo collectEntity(IDeviceMNode<IMemMNode> node) {
                PartialPath device = this.getPartialPathFromRootToNode((ITreeNode)((IMemMNode)node.getAsMNode()));
                ShowDevicesResult result = new ShowDevicesResult(device.getFullPath(), node.isAlignedNullable(), node.getSchemaTemplateId());
                result.setAttributeProvider(k -> (Binary)attributeProvider.apply(((TableDeviceInfo)node.getDeviceInfo()).getAttributePointer(), k));
                return result;
            }
        };
        if (showDevicesPlan.usingSchemaTemplate()) {
            collector.setSchemaTemplateFilter(showDevicesPlan.getSchemaTemplateId());
        }
        ISchemaReader<IDeviceSchemaInfo> reader = new ISchemaReader<IDeviceSchemaInfo>(){
            private final DeviceFilterVisitor filterVisitor = new DeviceFilterVisitor();
            private IDeviceSchemaInfo next;

            @Override
            public boolean isSuccess() {
                return collector.isSuccess();
            }

            @Override
            public Throwable getFailure() {
                return collector.getFailure();
            }

            @Override
            public void close() {
                collector.close();
            }

            @Override
            public ListenableFuture<?> isBlocked() {
                return NOT_BLOCKED;
            }

            @Override
            public boolean hasNext() {
                while (this.next == null && collector.hasNext()) {
                    IDeviceSchemaInfo temp = (IDeviceSchemaInfo)collector.next();
                    if (showDevicesPlan.getSchemaFilter() != null && !this.filterVisitor.process(showDevicesPlan.getSchemaFilter(), temp).booleanValue()) continue;
                    this.next = temp;
                }
                return this.next != null;
            }

            @Override
            public IDeviceSchemaInfo next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                IDeviceSchemaInfo result = this.next;
                this.next = null;
                return result;
            }
        };
        if (showDevicesPlan.getLimit() > 0L || showDevicesPlan.getOffset() > 0L) {
            return new SchemaReaderLimitOffsetWrapper<IDeviceSchemaInfo>(reader, showDevicesPlan.getLimit(), showDevicesPlan.getOffset());
        }
        return reader;
    }

    public int fillLastQueryMap(PartialPath prefixPath, final Map<TableId, Map<IDeviceID, Map<String, Pair<TSDataType, TimeValuePair>>>> mapToFill) throws MetadataException {
        final int[] sensorNum = new int[]{0};
        try (EntityUpdater<IMemMNode> updater = new EntityUpdater<IMemMNode>(this.rootNode, prefixPath, (IMTreeStore)this.store, true, SchemaConstant.ALL_MATCH_SCOPE){

            @Override
            protected void updateEntity(IDeviceMNode<IMemMNode> node) {
                HashMap<String, Pair> measurementMap = new HashMap<String, Pair>();
                for (IMemMNode child : node.getChildren().values()) {
                    if (!(child instanceof IMeasurementMNode)) continue;
                    measurementMap.put(child.getName(), new Pair((Object)((IMeasurementMNode)child).getDataType(), null));
                }
                IDeviceID deviceID = node.getPartialPath().getIDeviceID();
                mapToFill.computeIfAbsent(new TableId(null, deviceID.getTableName()), o -> new HashMap()).put(deviceID, measurementMap);
                sensorNum[0] = sensorNum[0] + measurementMap.size();
            }
        };){
            updater.update();
        }
        return sensorNum[0];
    }

    public ISchemaReader<IDeviceSchemaInfo> getTableDeviceReader(PartialPath pattern, final BiFunction<Integer, String, Binary> attributeProvider) throws MetadataException {
        final EntityCollector<IDeviceSchemaInfo, IMemMNode> collector = new EntityCollector<IDeviceSchemaInfo, IMemMNode>(this.rootNode, pattern, (IMTreeStore)this.store, false, null){

            @Override
            protected boolean acceptFullMatchedNode(IMemMNode node) {
                return node.isDevice() && !node.getAsDeviceMNode().isPreDeactivateSelfOrTemplate();
            }

            @Override
            protected IDeviceSchemaInfo collectEntity(IDeviceMNode<IMemMNode> node) {
                ShowDevicesResult result = new ShowDevicesResult(null, node.isAlignedNullable(), node.getSchemaTemplateId(), node.getPartialPath().getNodes());
                result.setAttributeProvider(k -> (Binary)attributeProvider.apply(((TableDeviceInfo)node.getDeviceInfo()).getAttributePointer(), k));
                return result;
            }
        };
        return new ISchemaReader<IDeviceSchemaInfo>(){

            @Override
            public boolean isSuccess() {
                return collector.isSuccess();
            }

            @Override
            public Throwable getFailure() {
                return collector.getFailure();
            }

            @Override
            public void close() {
                collector.close();
            }

            @Override
            public ListenableFuture<?> isBlocked() {
                return NOT_BLOCKED;
            }

            @Override
            public boolean hasNext() {
                return collector.hasNext();
            }

            @Override
            public IDeviceSchemaInfo next() {
                return (IDeviceSchemaInfo)collector.next();
            }
        };
    }

    public ISchemaReader<IDeviceSchemaInfo> getTableDeviceReader(final String table, final List<Object[]> devicePathList, final BiFunction<Integer, String, Binary> attributeProvider) {
        return new ISchemaReader<IDeviceSchemaInfo>(){
            final Iterator<Object[]> deviceIdIterator;
            IDeviceSchemaInfo next;
            Throwable t;
            {
                this.deviceIdIterator = devicePathList.listIterator();
                this.next = null;
                this.t = null;
            }

            @Override
            public boolean isSuccess() {
                return this.t == null;
            }

            @Override
            public Throwable getFailure() {
                return this.t;
            }

            @Override
            public ListenableFuture<?> isBlocked() {
                return NOT_BLOCKED;
            }

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    this.tryGetNext();
                }
                return this.next != null;
            }

            @Override
            public IDeviceSchemaInfo next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                IDeviceSchemaInfo result = this.next;
                this.next = null;
                return result;
            }

            private void tryGetNext() {
                while (this.deviceIdIterator.hasNext()) {
                    try {
                        IMemMNode node = MTreeBelowSGMemoryImpl.this.getTableDeviceNode(table, this.deviceIdIterator.next());
                        if (!node.isDevice() || node.getAsDeviceMNode().isPreDeactivateSelfOrTemplate()) continue;
                        IDeviceMNode deviceNode = node.getAsDeviceMNode();
                        ShowDevicesResult result = new ShowDevicesResult(null, deviceNode.isAlignedNullable(), deviceNode.getSchemaTemplateId(), deviceNode.getPartialPath().getNodes());
                        result.setAttributeProvider(k -> (Binary)attributeProvider.apply(((TableDeviceInfo)deviceNode.getDeviceInfo()).getAttributePointer(), k));
                        this.next = result;
                        break;
                    }
                    catch (PathNotExistException node) {
                    }
                    catch (Throwable e) {
                        this.t = e;
                        return;
                    }
                }
            }

            @Override
            public void close() {
            }
        };
    }

    private IMemMNode getTableDeviceNode(String table, Object[] deviceId) throws PathNotExistException {
        IMemMNode cur = this.storageGroupMNode;
        IMemMNode next = (IMemMNode)cur.getChild(table);
        if (next == null) {
            throw new PathNotExistException(this.storageGroupMNode.getFullPath() + '.' + table + Arrays.toString(deviceId), true);
        }
        if (next.isMeasurement()) {
            throw new PathNotExistException(this.storageGroupMNode.getFullPath() + '.' + table + Arrays.toString(deviceId), true);
        }
        cur = next;
        for (int i = 0; i < deviceId.length; ++i) {
            next = (IMemMNode)cur.getChild(deviceId[i] == null ? null : String.valueOf(deviceId[i]));
            if (next == null) {
                throw new PathNotExistException(this.storageGroupMNode.getFullPath() + '.' + table + Arrays.toString(deviceId), true);
            }
            if (next.isMeasurement()) {
                if (i == deviceId.length - 1) {
                    return next;
                }
                throw new PathNotExistException(this.storageGroupMNode.getFullPath() + '.' + table + Arrays.toString(deviceId), true);
            }
            cur = next;
        }
        return cur;
    }

    public ISchemaReader<ITimeSeriesSchemaInfo> getTimeSeriesReader(IShowTimeSeriesPlan showTimeSeriesPlan, final Function<Long, Pair<Map<String, String>, Map<String, String>>> tagAndAttributeProvider) throws MetadataException {
        MeasurementCollector<ITimeSeriesSchemaInfo, IMemMNode> collector = new MeasurementCollector<ITimeSeriesSchemaInfo, IMemMNode>(this.rootNode, showTimeSeriesPlan.getPath(), (IMTreeStore)this.store, showTimeSeriesPlan.isPrefixMatch(), showTimeSeriesPlan.getScope()){

            @Override
            protected ITimeSeriesSchemaInfo collectMeasurement(final IMeasurementMNode<IMemMNode> node) {
                return new ITimeSeriesSchemaInfo(){
                    private Pair<Map<String, String>, Map<String, String>> tagAndAttribute = null;

                    @Override
                    public String getAlias() {
                        return node.getAlias();
                    }

                    @Override
                    public IMeasurementSchema getSchema() {
                        return node.getSchema();
                    }

                    @Override
                    public Map<String, String> getTags() {
                        if (this.tagAndAttribute == null) {
                            this.tagAndAttribute = (Pair)tagAndAttributeProvider.apply(node.getOffset());
                        }
                        return (Map)this.tagAndAttribute.left;
                    }

                    @Override
                    public Map<String, String> getAttributes() {
                        if (this.tagAndAttribute == null) {
                            this.tagAndAttribute = (Pair)tagAndAttributeProvider.apply(node.getOffset());
                        }
                        return (Map)this.tagAndAttribute.right;
                    }

                    @Override
                    public boolean isUnderAlignedDevice() {
                        return ((IMemMNode)this.getParentOfNextMatchedNode()).getAsDeviceMNode().isAligned();
                    }

                    @Override
                    public boolean isLogicalView() {
                        return node.isLogicalView();
                    }

                    @Override
                    public String getFullPath() {
                        return this.getPartialPathFromRootToNode((ITreeNode)((IMemMNode)node.getAsMNode())).getFullPath();
                    }

                    @Override
                    public PartialPath getPartialPath() {
                        return this.getPartialPathFromRootToNode((ITreeNode)((IMemMNode)node.getAsMNode()));
                    }

                    @Override
                    public ITimeSeriesSchemaInfo snapshot() {
                        return new TimeseriesSchemaInfo(node, this.getPartialPath(), this.getTags(), this.getAttributes(), this.isUnderAlignedDevice());
                    }
                };
            }
        };
        collector.setTemplateMap(showTimeSeriesPlan.getRelatedTemplate(), this.nodeFactory);
        TimeseriesReaderWithViewFetch reader = new TimeseriesReaderWithViewFetch((SchemaIterator<ITimeSeriesSchemaInfo>)collector, showTimeSeriesPlan.getSchemaFilter(), showTimeSeriesPlan.needViewDetail());
        if (showTimeSeriesPlan.getLimit() > 0L || showTimeSeriesPlan.getOffset() > 0L) {
            return new SchemaReaderLimitOffsetWrapper<ITimeSeriesSchemaInfo>(reader, showTimeSeriesPlan.getLimit(), showTimeSeriesPlan.getOffset());
        }
        return reader;
    }

    public ISchemaReader<INodeSchemaInfo> getNodeReader(IShowNodesPlan showNodesPlan) throws MetadataException {
        final MNodeCollector<INodeSchemaInfo, IMemMNode> collector = new MNodeCollector<INodeSchemaInfo, IMemMNode>(this.rootNode, showNodesPlan.getPath(), (IMTreeStore)this.store, showNodesPlan.isPrefixMatch(), showNodesPlan.getScope()){

            @Override
            protected INodeSchemaInfo collectMNode(IMemMNode node) {
                return new ShowNodesResult(this.getPartialPathFromRootToNode((ITreeNode)node).getFullPath(), node.getMNodeType());
            }
        };
        collector.setTargetLevel(showNodesPlan.getLevel());
        return new ISchemaReader<INodeSchemaInfo>(){

            @Override
            public boolean isSuccess() {
                return collector.isSuccess();
            }

            @Override
            public Throwable getFailure() {
                return collector.getFailure();
            }

            @Override
            public void close() {
                collector.close();
            }

            @Override
            public ListenableFuture<?> isBlocked() {
                return NOT_BLOCKED;
            }

            @Override
            public boolean hasNext() {
                return collector.hasNext();
            }

            @Override
            public INodeSchemaInfo next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return (INodeSchemaInfo)collector.next();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMeasurementMNode<IMemMNode> createLogicalView(PartialPath path, ViewExpression viewExpression) throws MetadataException {
        String[] nodeNames = path.getNodes();
        if (nodeNames.length <= 2) {
            throw new IllegalPathException(path.getFullPath());
        }
        MetaFormatUtils.checkTimeseries(path);
        PartialPath devicePath = path.getDevicePath();
        IMemMNode deviceParent = this.checkAndAutoCreateInternalPath(devicePath);
        MTreeBelowSGMemoryImpl mTreeBelowSGMemoryImpl = this;
        synchronized (mTreeBelowSGMemoryImpl) {
            IDeviceMNode<IMemMNode> entityMNode;
            String leafName = path.getMeasurement();
            IMeasurementMNode measurementMNode = this.nodeFactory.createLogicalViewMNode(null, leafName, (IMeasurementSchema)new LogicalViewSchema(leafName, viewExpression));
            IMemMNode device = this.checkAndAutoCreateDeviceNode(devicePath.getTailNode(), deviceParent);
            if (device.hasChild(leafName)) {
                IMemMNode node = (IMemMNode)device.getChild(leafName);
                if (node.isMeasurement()) {
                    if (node.getAsMeasurementMNode().isPreDeleted()) {
                        throw new MeasurementInBlackListException(path);
                    }
                    throw new MeasurementAlreadyExistException(path.getFullPath(), node.getAsMeasurementMNode().getMeasurementPath());
                }
                throw new PathAlreadyExistException(path.getFullPath());
            }
            if (device.isDevice()) {
                entityMNode = device.getAsDeviceMNode();
            } else {
                entityMNode = this.store.setToEntity(device);
                entityMNode.setAligned(null);
            }
            measurementMNode.setParent((IMNode)((IMemMNode)entityMNode.getAsMNode()));
            this.store.addChild((IMemMNode)entityMNode.getAsMNode(), leafName, (IMemMNode)measurementMNode.getAsMNode());
            return measurementMNode;
        }
    }

    public List<PartialPath> constructLogicalViewBlackList(PartialPath pathPattern) throws MetadataException {
        final ArrayList<PartialPath> result = new ArrayList<PartialPath>();
        try (MeasurementUpdater<IMemMNode> updater = new MeasurementUpdater<IMemMNode>(this.rootNode, pathPattern, (IMTreeStore)this.store, false, SchemaConstant.ALL_MATCH_SCOPE){

            @Override
            protected void updateMeasurement(IMeasurementMNode<IMemMNode> node) {
                if (node.isLogicalView()) {
                    node.setPreDeleted(true);
                    result.add(this.getPartialPathFromRootToNode((ITreeNode)((IMemMNode)node.getAsMNode())));
                }
            }
        };){
            updater.update();
        }
        return result;
    }

    public List<PartialPath> rollbackLogicalViewBlackList(PartialPath pathPattern) throws MetadataException {
        final ArrayList<PartialPath> result = new ArrayList<PartialPath>();
        try (MeasurementUpdater<IMemMNode> updater = new MeasurementUpdater<IMemMNode>(this.rootNode, pathPattern, (IMTreeStore)this.store, false, SchemaConstant.ALL_MATCH_SCOPE){

            @Override
            protected void updateMeasurement(IMeasurementMNode<IMemMNode> node) {
                if (node.isLogicalView()) {
                    node.setPreDeleted(false);
                    result.add(this.getPartialPathFromRootToNode((ITreeNode)((IMemMNode)node.getAsMNode())));
                }
            }
        };){
            updater.update();
        }
        return result;
    }

    public List<PartialPath> getPreDeletedLogicalView(PartialPath pathPattern) throws MetadataException {
        final LinkedList<PartialPath> result = new LinkedList<PartialPath>();
        try (MeasurementCollector<Void, IMemMNode> collector = new MeasurementCollector<Void, IMemMNode>(this.rootNode, pathPattern, (IMTreeStore)this.store, false, SchemaConstant.ALL_MATCH_SCOPE){

            @Override
            protected Void collectMeasurement(IMeasurementMNode<IMemMNode> node) {
                if (node.isLogicalView() && node.isPreDeleted()) {
                    result.add(this.getPartialPathFromRootToNode((ITreeNode)((IMemMNode)node.getAsMNode())));
                }
                return null;
            }
        };){
            collector.traverse();
        }
        return result;
    }

    public int getTableDeviceNotExistNum(String tableName, List<Object[]> deviceIdList) {
        IMemMNode tableNode = (IMemMNode)this.storageGroupMNode.getChild(tableName);
        int notExistNum = deviceIdList.size();
        if (tableNode == null) {
            return notExistNum;
        }
        for (Object[] deviceId : deviceIdList) {
            Object device;
            IMemMNode cur = tableNode;
            Object[] objectArray = deviceId;
            int n = objectArray.length;
            for (int i = 0; i < n && (cur = (IMemMNode)cur.getChild(Objects.nonNull(device = objectArray[i]) ? device.toString() : null)) != null; ++i) {
            }
            if (!Objects.nonNull(cur)) continue;
            --notExistNum;
        }
        return notExistNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createOrUpdateTableDevice(String tableName, String[] devicePath, IntSupplier attributePointerGetter, IntConsumer attributeUpdater) throws MetadataException {
        IMemMNode cur;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Start to create table device {}.{}", (Object)tableName, (Object)Arrays.toString(devicePath));
        }
        if ((cur = (IMemMNode)this.storageGroupMNode.getChild(tableName)) == null) {
            cur = this.store.addChild(this.storageGroupMNode, tableName, (IMemMNode)this.nodeFactory.createInternalMNode((IMNode)cur, tableName));
        }
        for (String childName : devicePath) {
            IMemMNode child = (IMemMNode)cur.getChild(childName);
            if (child == null) {
                child = this.store.addChild(cur, childName, (IMemMNode)this.nodeFactory.createInternalMNode((IMNode)cur, childName));
            }
            cur = child;
        }
        MTreeBelowSGMemoryImpl mTreeBelowSGMemoryImpl = this;
        synchronized (mTreeBelowSGMemoryImpl) {
            IDeviceMNode entityMNode;
            if (cur.isDevice()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Table device {}.{} already exists", (Object)tableName, (Object)Arrays.toString(devicePath));
                }
                if (!((entityMNode = cur.getAsDeviceMNode()).getDeviceInfo() instanceof TableDeviceInfo)) {
                    throw new MetadataException("Table device shall not create under tree model");
                }
                TableDeviceInfo deviceInfo = (TableDeviceInfo)entityMNode.getDeviceInfo();
                attributeUpdater.accept(deviceInfo.getAttributePointer());
            } else {
                entityMNode = this.store.setToEntity(cur);
                TableDeviceInfo deviceInfo = new TableDeviceInfo();
                deviceInfo.setAttributePointer(attributePointerGetter.getAsInt());
                entityMNode.getAsInternalMNode().setDeviceInfo(deviceInfo);
                this.regionStatistics.addTableDevice(tableName);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Table device {}.{} created", (Object)tableName, (Object)Arrays.toString(devicePath));
                }
            }
        }
    }

    public void updateTableDevice(PartialPath pattern, final DeviceAttributeUpdater batchUpdater) throws MetadataException {
        try (EntityUpdater<IMemMNode> updater = new EntityUpdater<IMemMNode>(this.rootNode, pattern, (IMTreeStore)this.store, false, SchemaConstant.ALL_MATCH_SCOPE){

            @Override
            protected void updateEntity(IDeviceMNode<IMemMNode> node) throws MetadataException {
                batchUpdater.handleDeviceNode(node);
            }
        };){
            updater.update();
        }
    }

    public void constructTableDeviceBlackList(PartialPath pattern, final DeviceBlackListConstructor blackListConstructor) throws MetadataException {
        try (EntityUpdater<IMemMNode> updater = new EntityUpdater<IMemMNode>(this.rootNode, pattern, (IMTreeStore)this.store, false, SchemaConstant.ALL_MATCH_SCOPE){

            @Override
            protected void updateEntity(IDeviceMNode<IMemMNode> node) throws MetadataException {
                blackListConstructor.handleDeviceNode(node);
            }
        };){
            updater.update();
        }
    }

    public void rollbackTableDeviceBlackList(final PartialPath pattern) throws MetadataException {
        try (EntityUpdater<IMemMNode> updater = new EntityUpdater<IMemMNode>(this.rootNode, pattern, (IMTreeStore)this.store, false, SchemaConstant.ALL_MATCH_SCOPE){

            @Override
            protected void updateEntity(IDeviceMNode<IMemMNode> node) {
                if (node.isPreDeactivateSelfOrTemplate()) {
                    MTreeBelowSGMemoryImpl.this.regionStatistics.addTableDevice(pattern.getNodes()[2]);
                    node.rollbackPreDeactivateSelfOrTemplate();
                }
            }
        };){
            updater.update();
        }
    }

    public void deleteTableDevicesInBlackList(PartialPath pattern, final IntConsumer attributeDeleter, final Consumer<String[]> deviceAttributeCacheUpdateInvalidator) throws MetadataException {
        try (EntityUpdater<IMemMNode> updater = new EntityUpdater<IMemMNode>(this.rootNode, pattern, (IMTreeStore)this.store, false, SchemaConstant.ALL_MATCH_SCOPE){

            @Override
            protected void updateEntity(IDeviceMNode<IMemMNode> node) {
                if (node.isPreDeactivateSelfOrTemplate()) {
                    attributeDeleter.accept(((TableDeviceInfo)node.getAsDeviceMNode().getDeviceInfo()).getAttributePointer());
                    deviceAttributeCacheUpdateInvalidator.accept(node.getPartialPath().getNodes());
                    MTreeBelowSGMemoryImpl.this.deleteEmptyInternalMNode(node);
                }
            }
        };){
            updater.update();
        }
    }

    public boolean deleteTableDevice(String tableName, final IntConsumer attributeDeleter) throws MetadataException {
        if (!this.store.hasChild(this.storageGroupMNode, tableName)) {
            return false;
        }
        final AtomicInteger memoryReleased = new AtomicInteger(0);
        try (MNodeCollector<Void, IMemMNode> collector = new MNodeCollector<Void, IMemMNode>(this.storageGroupMNode, new PartialPath(new String[]{this.storageGroupMNode.getName(), tableName}), (IMTreeStore)this.store, true, SchemaConstant.ALL_MATCH_SCOPE){

            @Override
            protected boolean acceptInternalMatchedNode(IMemMNode node) {
                return true;
            }

            @Override
            protected Void collectMNode(IMemMNode node) {
                if (node.isDevice()) {
                    attributeDeleter.accept(((TableDeviceInfo)node.getAsDeviceMNode().getDeviceInfo()).getAttributePointer());
                }
                memoryReleased.addAndGet(node.estimateSize());
                return null;
            }
        };){
            collector.traverse();
        }
        this.storageGroupMNode.deleteChild(tableName);
        this.regionStatistics.resetTableDevice(tableName);
        this.store.releaseMemory(memoryReleased.get());
        return true;
    }

    public boolean dropTableAttribute(String tableName, final IntConsumer attributeDropper) throws MetadataException {
        if (!this.store.hasChild(this.storageGroupMNode, tableName)) {
            return false;
        }
        AtomicInteger memoryReleased = new AtomicInteger(0);
        try (EntityUpdater<IMemMNode> updater = new EntityUpdater<IMemMNode>(this.storageGroupMNode, new PartialPath(new String[]{this.storageGroupMNode.getName(), tableName}), (IMTreeStore)this.store, true, SchemaConstant.ALL_MATCH_SCOPE){

            @Override
            protected void updateEntity(IDeviceMNode<IMemMNode> node) {
                attributeDropper.accept(((TableDeviceInfo)node.getAsDeviceMNode().getDeviceInfo()).getAttributePointer());
            }
        };){
            updater.update();
        }
        this.store.releaseMemory(memoryReleased.get());
        return true;
    }
}

