/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.data;

import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.jackrabbit.core.data.DataIdentifier;
import org.apache.jackrabbit.core.data.DataRecord;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataStore
implements DataStore {
    private static Logger LOG = LoggerFactory.getLogger(AbstractDataStore.class);
    private static final String ALGORITHM = "HmacSHA1";
    private static final char[] HEX = "0123456789abcdef".toCharArray();
    protected String DIGEST = System.getProperty("ds.digest.algorithm", "SHA-256");
    private byte[] referenceKey = null;

    @Override
    public DataRecord getRecord(DataIdentifier identifier) throws DataStoreException {
        DataRecord record = this.getRecordIfStored(identifier);
        if (record != null) {
            return record;
        }
        throw new DataStoreException("Record " + String.valueOf(identifier) + " does not exist");
    }

    @Override
    public DataRecord getRecordFromReference(String reference) throws DataStoreException {
        DataIdentifier identifier;
        int colon;
        if (reference != null && (colon = reference.indexOf(58)) != -1 && reference.equals(this.getReferenceFromIdentifier(identifier = new DataIdentifier(reference.substring(0, colon))))) {
            return this.getRecordIfStored(identifier);
        }
        return null;
    }

    protected static String encodeHexString(byte[] value) {
        char[] buffer = new char[value.length * 2];
        for (int i = 0; i < value.length; ++i) {
            buffer[2 * i] = HEX[value[i] >> 4 & 0xF];
            buffer[2 * i + 1] = HEX[value[i] & 0xF];
        }
        return new String(buffer);
    }

    protected String getReferenceFromIdentifier(DataIdentifier identifier) {
        try {
            String id = identifier.toString();
            Mac mac = Mac.getInstance(ALGORITHM);
            mac.init(new SecretKeySpec(this.getReferenceKey(), ALGORITHM));
            byte[] hash = mac.doFinal(id.getBytes(StandardCharsets.UTF_8));
            return id + ":" + AbstractDataStore.encodeHexString(hash);
        }
        catch (Exception e) {
            LOG.error("Failed to hash identifier using MAC (Message Authentication Code) algorithm.", e);
            return null;
        }
    }

    protected byte[] getOrCreateReferenceKey() throws DataStoreException {
        byte[] referenceKeyValue = new byte[256];
        new SecureRandom().nextBytes(referenceKeyValue);
        return referenceKeyValue;
    }

    private synchronized byte[] getReferenceKey() throws DataStoreException {
        if (this.referenceKey == null) {
            this.referenceKey = this.getOrCreateReferenceKey();
        }
        return this.referenceKey;
    }
}

