/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.tika;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.lambdas.Throwing;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.james.mailbox.extractor.ParsedContent;
import org.apache.james.mailbox.extractor.TextExtractor;
import org.apache.james.mailbox.model.ContentType;
import org.apache.james.mailbox.store.extractor.JsoupTextExtractor;
import org.apache.james.mailbox.tika.TikaHttpClient;
import org.apache.james.metrics.api.MetricFactory;

public class TikaTextExtractor
implements TextExtractor {
    private static final ContentType.MediaType TEXT = ContentType.MediaType.of((String)"text");
    private final MetricFactory metricFactory;
    private final TikaHttpClient tikaHttpClient;
    private final ObjectMapper objectMapper;
    private final JsoupTextExtractor jsoupTextExtractor;

    @Inject
    public TikaTextExtractor(MetricFactory metricFactory, TikaHttpClient tikaHttpClient) {
        this.metricFactory = metricFactory;
        this.tikaHttpClient = tikaHttpClient;
        this.objectMapper = this.initializeObjectMapper();
        this.jsoupTextExtractor = new JsoupTextExtractor();
    }

    private ObjectMapper initializeObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        SimpleModule mapModule = new SimpleModule();
        mapModule.addDeserializer(ContentAndMetadata.class, (JsonDeserializer)new ContentAndMetadataDeserializer());
        objectMapper.registerModule((Module)mapModule);
        return objectMapper;
    }

    public ParsedContent extractContent(InputStream inputStream, ContentType contentType) throws Exception {
        if (contentType.mediaType().equals((Object)TEXT)) {
            return this.jsoupTextExtractor.extractContent(inputStream, contentType);
        }
        return (ParsedContent)this.metricFactory.decorateSupplierWithTimerMetric("tikaTextExtraction", Throwing.supplier(() -> this.performContentExtraction(inputStream, contentType)).sneakyThrow());
    }

    public ParsedContent performContentExtraction(InputStream inputStream, ContentType contentType) throws IOException {
        ContentAndMetadata contentAndMetadata = this.convert(this.tikaHttpClient.recursiveMetaDataAsJson(inputStream, contentType));
        return new ParsedContent(contentAndMetadata.getContent(), contentAndMetadata.getMetadata());
    }

    private ContentAndMetadata convert(Optional<InputStream> maybeInputStream) throws IOException {
        return maybeInputStream.map(Throwing.function(inputStream -> (ContentAndMetadata)this.objectMapper.readValue(inputStream, ContentAndMetadata.class))).orElse(ContentAndMetadata.empty());
    }

    private static class ContentAndMetadata {
        private static final String TIKA_HEADER = "X-TIKA";
        private static final String CONTENT_METADATA_HEADER_NAME = "X-TIKA:content";
        private final Optional<String> content;
        private final Map<String, List<String>> metadata;

        public static ContentAndMetadata empty() {
            return new ContentAndMetadata();
        }

        public static ContentAndMetadata from(Map<String, List<String>> contentAndMetadataMap) {
            return new ContentAndMetadata(Optional.ofNullable(ContentAndMetadata.content(contentAndMetadataMap)), (Map)contentAndMetadataMap.entrySet().stream().filter(ContentAndMetadata.allHeadersButTika()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue)));
        }

        private static Predicate<? super Map.Entry<String, List<String>>> allHeadersButTika() {
            return entry -> !((String)entry.getKey()).startsWith(TIKA_HEADER);
        }

        private static String content(Map<String, List<String>> contentAndMetadataMap) {
            List<String> content = contentAndMetadataMap.get(CONTENT_METADATA_HEADER_NAME);
            if (content == null) {
                return null;
            }
            String onlySpaces = null;
            return StringUtils.stripStart((String)content.get(0), onlySpaces);
        }

        private ContentAndMetadata() {
            this(Optional.empty(), (Map<String, List<String>>)ImmutableMap.of());
        }

        private ContentAndMetadata(Optional<String> content, Map<String, List<String>> metadata) {
            this.content = content;
            this.metadata = metadata;
        }

        public Optional<String> getContent() {
            return this.content;
        }

        public Map<String, List<String>> getMetadata() {
            return this.metadata;
        }

        public final boolean equals(Object o) {
            if (o instanceof ContentAndMetadata) {
                ContentAndMetadata other = (ContentAndMetadata)o;
                return Objects.equals(this.content, other.content) && Objects.equals(this.metadata, other.metadata);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.content, this.metadata);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("content", this.content).add("metadata", this.metadata).toString();
        }
    }

    @VisibleForTesting
    static class ContentAndMetadataDeserializer
    extends JsonDeserializer<ContentAndMetadata> {
        ContentAndMetadataDeserializer() {
        }

        public ContentAndMetadata deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            TreeNode treeNode = jsonParser.getCodec().readTree(jsonParser);
            Preconditions.checkState((treeNode.isArray() && treeNode.size() >= 1 ? 1 : 0) != 0, (Object)"The response should be an array with at least one element");
            Preconditions.checkState((boolean)treeNode.get(0).isObject(), (Object)"The element should be a Json object");
            ObjectNode node = (ObjectNode)treeNode.get(0);
            return ContentAndMetadata.from((Map)ImmutableList.copyOf((Iterator)node.fields()).stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> this.asListOfString((JsonNode)entry.getValue()))));
        }

        @VisibleForTesting
        List<String> asListOfString(JsonNode jsonNode) {
            if (jsonNode.isArray()) {
                return (List)ImmutableList.copyOf((Iterator)jsonNode.elements()).stream().map(JsonNode::asText).collect(ImmutableList.toImmutableList());
            }
            return ImmutableList.of((Object)jsonNode.asText());
        }
    }
}

