/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener;

import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.ReadOnlyEntry;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class InMemoryDirectoryServerSnapshot
implements Serializable {
    private static final long serialVersionUID = 4691579754615787705L;
    private final long firstChangeNumber;
    private final long lastChangeNumber;
    @NotNull
    private final Map<DN, ReadOnlyEntry> entryMap;

    InMemoryDirectoryServerSnapshot(@NotNull Map<DN, ReadOnlyEntry> m, long firstChangeNumber, long lastChangeNumber) {
        this.firstChangeNumber = firstChangeNumber;
        this.lastChangeNumber = lastChangeNumber;
        this.entryMap = Collections.unmodifiableMap(new TreeMap<DN, ReadOnlyEntry>(m));
    }

    @NotNull
    public Map<DN, ReadOnlyEntry> getEntryMap() {
        return this.entryMap;
    }

    public long getFirstChangeNumber() {
        return this.firstChangeNumber;
    }

    public long getLastChangeNumber() {
        return this.lastChangeNumber;
    }
}

