/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.protocol.internal.util.collection;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;

public class NullAllowingImmutableSet<E>
extends AbstractSet<E>
implements Serializable {
    private static final NullAllowingImmutableSet EMPTY = new NullAllowingImmutableSet<Object[]>(new Object[0]);
    final Object[] elements;

    @SafeVarargs
    public static <E> NullAllowingImmutableSet<E> of(E ... elements) {
        return new NullAllowingImmutableSet<Object[]>(NullAllowingImmutableSet.deduplicate(elements));
    }

    public static <E> NullAllowingImmutableSet<E> of() {
        return EMPTY;
    }

    public static <E> NullAllowingImmutableSet<E> of(E element) {
        return new NullAllowingImmutableSet<Object[]>(new Object[]{element});
    }

    public static <E> NullAllowingImmutableSet<E> of(E element1, E element2) {
        return Objects.equals(element1, element2) ? NullAllowingImmutableSet.of(element1) : new NullAllowingImmutableSet<Object[]>(new Object[]{element1, element2});
    }

    public static <E> NullAllowingImmutableSet<E> of(E element1, E element2, E element3) {
        boolean equal12 = Objects.equals(element1, element2);
        boolean equal13 = Objects.equals(element1, element3);
        boolean equal23 = Objects.equals(element2, element3);
        if (equal12) {
            return equal13 ? NullAllowingImmutableSet.of(element1) : NullAllowingImmutableSet.of(element1, element3);
        }
        if (equal13) {
            return NullAllowingImmutableSet.of(element1, element2);
        }
        if (equal23) {
            return NullAllowingImmutableSet.of(element1, element2);
        }
        return new NullAllowingImmutableSet<Object[]>(new Object[]{element1, element2, element3});
    }

    public static <E> NullAllowingImmutableSet<E> copyOf(Iterable<E> iterable) {
        if (iterable instanceof NullAllowingImmutableSet) {
            return (NullAllowingImmutableSet)iterable;
        }
        if (iterable instanceof Set) {
            Set set = (Set)iterable;
            return new NullAllowingImmutableSet<Object[]>(set.toArray());
        }
        if (iterable instanceof Collection) {
            Collection collection = (Collection)iterable;
            return new NullAllowingImmutableSet<Object[]>(NullAllowingImmutableSet.deduplicate(collection.toArray()));
        }
        LinkedHashSet<E> set = new LinkedHashSet<E>();
        for (E element : iterable) {
            set.add(element);
        }
        return NullAllowingImmutableSet.copyOf(set);
    }

    public static <E> Builder<E> builder() {
        return NullAllowingImmutableSet.builder(16);
    }

    public static <E> Builder<E> builder(int expectedSize) {
        return new Builder(expectedSize);
    }

    NullAllowingImmutableSet(Object[] elements) {
        this.elements = elements;
    }

    static Object[] deduplicate(Object[] elements) {
        Object[] result = new Object[elements.length];
        int copied = 0;
        for (Object element : elements) {
            boolean isDuplicate = false;
            for (int j = 0; j < copied; ++j) {
                if (!Objects.equals(result[j], element)) continue;
                isDuplicate = true;
                break;
            }
            if (isDuplicate) continue;
            result[copied++] = element;
        }
        return copied == elements.length ? result : Arrays.copyOfRange(result, 0, copied);
    }

    private NullAllowingImmutableSet(E element) {
        this(new Object[]{element});
    }

    private NullAllowingImmutableSet(E element1, E element2) {
        this(new Object[]{element1, element2});
    }

    private NullAllowingImmutableSet(E element1, E element2, E element3) {
        this(new Object[]{element1, element2, element3});
    }

    @Override
    public Iterator<E> iterator() {
        return new ArrayIterator(this.elements);
    }

    @Override
    public int size() {
        return this.elements.length;
    }

    public static class Builder<E> {
        private Object[] elements;
        private int size;

        public Builder(int expectedSize) {
            this.elements = new Object[expectedSize];
        }

        public Builder<E> add(E newElement) {
            this.maybeResize(1);
            this.elements[this.size++] = newElement;
            return this;
        }

        public Builder<E> addAll(Iterable<? extends E> newElements) {
            LinkedHashSet<Object> collection;
            if (newElements instanceof Collection) {
                collection = (LinkedHashSet<Object>)newElements;
            } else {
                collection = new LinkedHashSet<Object>();
                for (Object newElement : newElements) {
                    collection.add(newElement);
                }
            }
            this.maybeResize(collection.size());
            for (Object newElement : collection) {
                this.elements[this.size++] = newElement;
            }
            return this;
        }

        public NullAllowingImmutableSet<E> build() {
            this.failIfDuplicates();
            return new NullAllowingImmutableSet<Object[]>(this.size == this.elements.length ? this.elements : Arrays.copyOfRange(this.elements, 0, this.size));
        }

        private void maybeResize(int toAdd) {
            int neededSize = this.size + toAdd;
            if (neededSize < 0) {
                throw new OutOfMemoryError();
            }
            while (neededSize > this.elements.length) {
                int newLength = this.elements.length * 2;
                if (newLength < 0) {
                    newLength = neededSize;
                }
                this.elements = Arrays.copyOf(this.elements, newLength);
            }
        }

        private void failIfDuplicates() {
            for (int i = 0; i < this.size; ++i) {
                Object element = this.elements[i];
                for (int j = i + 1; j < this.size; ++j) {
                    if (!Objects.equals(element, this.elements[j])) continue;
                    throw new IllegalArgumentException("Duplicate element " + element);
                }
            }
        }
    }

    private static class ArrayIterator<E>
    implements Iterator<E> {
        private final Object[] elements;
        private int nextIndex;

        private ArrayIterator(Object[] elements) {
            this.elements = elements;
            this.nextIndex = 0;
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex < this.elements.length;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Iterator is exhausted");
            }
            return (E)this.elements[this.nextIndex++];
        }
    }
}

