/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode.parser;

import javax.inject.Inject;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.Tag;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.decode.DecodingException;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imap.decode.base.AbstractImapCommandParser;
import org.apache.james.imap.message.request.AuthenticateRequest;
import org.apache.james.imap.message.request.IRAuthenticateRequest;

public class AuthenticateCommandParser
extends AbstractImapCommandParser {
    @Inject
    public AuthenticateCommandParser(StatusResponseFactory statusResponseFactory) {
        super(ImapConstants.AUTHENTICATE_COMMAND, statusResponseFactory);
    }

    @Override
    protected ImapMessage decode(ImapRequestLineReader request, Tag tag, ImapSession session) throws DecodingException {
        AuthenticateRequest result;
        String authType = request.astring();
        try {
            result = new AuthenticateRequest(authType, tag);
            request.eol();
        }
        catch (DecodingException e) {
            String initialClientResponse = request.astring();
            result = new IRAuthenticateRequest(authType, tag, initialClientResponse);
            request.eol();
        }
        return result;
    }
}

