/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.client;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.r2dbc.postgresql.api.ErrorDetails;
import io.r2dbc.postgresql.api.PostgresqlException;
import io.r2dbc.postgresql.client.SSLConfig;
import io.r2dbc.postgresql.client.SSLMode;
import io.r2dbc.spi.R2dbcPermissionDeniedException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.CompletableFuture;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import reactor.core.publisher.Mono;

abstract class AbstractPostgresSSLHandlerAdapter
extends ChannelInboundHandlerAdapter
implements GenericFutureListener<Future<Channel>> {
    private final SSLConfig sslConfig;
    private final SSLEngine sslEngine;
    private final SslHandler sslHandler;
    private final CompletableFuture<Void> handshakeFuture;

    AbstractPostgresSSLHandlerAdapter(ByteBufAllocator alloc, SocketAddress socketAddress, SSLConfig sslConfig) {
        this.sslConfig = sslConfig;
        SSLEngine sslEngine = sslConfig.getSslProvider().get().newEngine(alloc);
        SSLParameters sslParameters = sslConfig.getSslParametersFactory().apply(socketAddress);
        sslEngine.setSSLParameters(sslParameters);
        this.sslEngine = sslConfig.getSslEngineCustomizer().apply(sslEngine);
        this.handshakeFuture = new CompletableFuture();
        this.sslHandler = new SslHandler(this.sslEngine);
        this.sslHandler.handshakeFuture().addListener((GenericFutureListener)this);
    }

    public void operationComplete(Future<Channel> future) throws Exception {
        if (!future.isSuccess()) {
            this.completeHandshakeExceptionally(future.cause());
            return;
        }
        if (this.sslConfig.getSslMode() != SSLMode.VERIFY_FULL) {
            this.completeHandshake();
            return;
        }
        Channel channel = (Channel)future.get();
        InetSocketAddress socketAddress = (InetSocketAddress)channel.remoteAddress();
        String hostName = socketAddress.getHostName();
        if (this.sslConfig.getHostnameVerifier().verify(hostName, this.sslEngine.getSession())) {
            this.completeHandshake();
        } else {
            this.completeHandshakeExceptionally((Throwable)((Object)new PostgresqlSslException(String.format("The hostname '%s' could not be verified.", socketAddress.getAddress().toString()))));
        }
    }

    void completeHandshakeExceptionally(Throwable ex) {
        this.handshakeFuture.completeExceptionally(ex);
    }

    boolean completeHandshake() {
        return this.handshakeFuture.complete(null);
    }

    Mono<Void> getHandshake() {
        return Mono.fromFuture(this.handshakeFuture);
    }

    SslHandler getSslHandler() {
        return this.sslHandler;
    }

    static final class PostgresqlSslException
    extends R2dbcPermissionDeniedException
    implements PostgresqlException {
        private final ErrorDetails errorDetails;

        PostgresqlSslException(String reason) {
            super(reason, "08006", 0, (String)null);
            this.errorDetails = ErrorDetails.fromCodeAndMessage("08006", reason);
        }

        @Override
        public ErrorDetails getErrorDetails() {
            return this.errorDetails;
        }
    }
}

