/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver.tls;

import org.apache.james.core.MaybeSender;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookReturnCode;
import org.apache.james.protocols.smtp.hook.MailHook;
import org.apache.james.util.MDCStructuredLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnforceMtaSts
implements MailHook {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnforceMtaSts.class);

    public HookResult doMail(SMTPSession session, MaybeSender sender) {
        if (!session.isTLSStarted()) {
            MDCStructuredLogger.forLogger((Logger)LOGGER).field("sessionId", session.getSessionID()).field("sender", sender.asPrettyString()).log(logger -> logger.warn("Attempt to send to us a clear text message"));
            return HookResult.builder().hookReturnCode(HookReturnCode.deny()).smtpReturnCode("571").smtpDescription("StartTLS required").build();
        }
        return HookResult.DECLINED;
    }
}

