/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.ops4j.net;

import java.net.ServerSocket;

public class FreePort {
    private int m_from = 0;
    private int m_to = Integer.MAX_VALUE;
    private int m_found = -1;

    public FreePort(int from, int to) {
        this.m_from = from;
        this.m_to = to;
    }

    public int getPort() {
        if (this.m_found == -1) {
            this.m_found = this.findFree();
        }
        return this.m_found;
    }

    private int findFree() {
        for (int i = this.m_from; i <= this.m_to; ++i) {
            if (!this.isFree(i)) continue;
            return i;
        }
        throw new RuntimeException("No free port in range " + this.m_from + ":" + this.m_to);
    }

    boolean isFree(int port) {
        try {
            ServerSocket sock = new ServerSocket(port);
            sock.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String toString() {
        return "FreePort[" + this.m_from + ", " + this.m_to + "] " + (this.m_found != -1 ? "m_found: " + this.m_found : "non m_found");
    }
}

