/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.demo.facet;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoubleDocValuesField;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.facet.DrillDownQuery;
import org.apache.lucene.facet.DrillSideways;
import org.apache.lucene.facet.FacetField;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.LabelAndValue;
import org.apache.lucene.facet.MultiLongValuesSource;
import org.apache.lucene.facet.range.LongRange;
import org.apache.lucene.facet.range.Range;
import org.apache.lucene.facet.taxonomy.FacetLabel;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.facet.taxonomy.TaxonomyWriter;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyReader;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyWriter;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.sandbox.facet.ComparableUtils;
import org.apache.lucene.sandbox.facet.FacetFieldCollectorManager;
import org.apache.lucene.sandbox.facet.cutters.FacetCutter;
import org.apache.lucene.sandbox.facet.cutters.TaxonomyFacetsCutter;
import org.apache.lucene.sandbox.facet.cutters.ranges.LongRangeFacetCutter;
import org.apache.lucene.sandbox.facet.iterators.ComparableSupplier;
import org.apache.lucene.sandbox.facet.iterators.OrdinalIterator;
import org.apache.lucene.sandbox.facet.iterators.TaxonomyChildrenOrdinalIterator;
import org.apache.lucene.sandbox.facet.iterators.TopnOrdinalIterator;
import org.apache.lucene.sandbox.facet.labels.RangeOrdToLabel;
import org.apache.lucene.sandbox.facet.labels.TaxonomyOrdLabelBiMap;
import org.apache.lucene.sandbox.facet.recorders.CountFacetRecorder;
import org.apache.lucene.sandbox.facet.recorders.FacetRecorder;
import org.apache.lucene.sandbox.facet.recorders.LongAggregationsFacetRecorder;
import org.apache.lucene.sandbox.facet.recorders.MultiFacetsRecorder;
import org.apache.lucene.sandbox.facet.recorders.Reducer;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LongValuesSource;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MultiCollectorManager;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopScoreDocCollectorManager;
import org.apache.lucene.store.ByteBuffersDirectory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.IOUtils;

public class SandboxFacetsExample {
    private final Directory indexDir = new ByteBuffersDirectory();
    private final Directory taxoDir = new ByteBuffersDirectory();
    private final FacetsConfig config = new FacetsConfig();

    private SandboxFacetsExample() {
        this.config.setHierarchical("Publish Date", true);
    }

    void index() throws IOException {
        IndexWriter indexWriter = new IndexWriter(this.indexDir, new IndexWriterConfig((Analyzer)new WhitespaceAnalyzer()).setOpenMode(IndexWriterConfig.OpenMode.CREATE));
        DirectoryTaxonomyWriter taxoWriter = new DirectoryTaxonomyWriter(this.taxoDir);
        Document doc = new Document();
        doc.add((IndexableField)new FacetField("Author", new String[]{"Bob"}));
        doc.add((IndexableField)new FacetField("Publish Date", new String[]{"2010", "10", "15"}));
        doc.add((IndexableField)new NumericDocValuesField("Price", 10L));
        doc.add((IndexableField)new NumericDocValuesField("Units", 9L));
        doc.add((IndexableField)new DoubleDocValuesField("Popularity", 3.5));
        indexWriter.addDocument((Iterable)this.config.build((TaxonomyWriter)taxoWriter, doc));
        doc = new Document();
        doc.add((IndexableField)new FacetField("Author", new String[]{"Lisa"}));
        doc.add((IndexableField)new FacetField("Publish Date", new String[]{"2010", "10", "20"}));
        doc.add((IndexableField)new NumericDocValuesField("Price", 4L));
        doc.add((IndexableField)new NumericDocValuesField("Units", 2L));
        doc.add((IndexableField)new DoubleDocValuesField("Popularity", 4.1));
        indexWriter.addDocument((Iterable)this.config.build((TaxonomyWriter)taxoWriter, doc));
        doc = new Document();
        doc.add((IndexableField)new FacetField("Author", new String[]{"Lisa"}));
        doc.add((IndexableField)new FacetField("Publish Date", new String[]{"2012", "1", "1"}));
        doc.add((IndexableField)new NumericDocValuesField("Price", 3L));
        doc.add((IndexableField)new NumericDocValuesField("Units", 5L));
        doc.add((IndexableField)new DoubleDocValuesField("Popularity", 3.9));
        indexWriter.addDocument((Iterable)this.config.build((TaxonomyWriter)taxoWriter, doc));
        doc = new Document();
        doc.add((IndexableField)new FacetField("Author", new String[]{"Susan"}));
        doc.add((IndexableField)new FacetField("Publish Date", new String[]{"2012", "1", "7"}));
        doc.add((IndexableField)new NumericDocValuesField("Price", 8L));
        doc.add((IndexableField)new NumericDocValuesField("Units", 7L));
        doc.add((IndexableField)new DoubleDocValuesField("Popularity", 4.0));
        indexWriter.addDocument((Iterable)this.config.build((TaxonomyWriter)taxoWriter, doc));
        doc = new Document();
        doc.add((IndexableField)new FacetField("Author", new String[]{"Frank"}));
        doc.add((IndexableField)new FacetField("Publish Date", new String[]{"1999", "5", "5"}));
        doc.add((IndexableField)new NumericDocValuesField("Price", 9L));
        doc.add((IndexableField)new NumericDocValuesField("Units", 6L));
        doc.add((IndexableField)new DoubleDocValuesField("Popularity", 4.9));
        indexWriter.addDocument((Iterable)this.config.build((TaxonomyWriter)taxoWriter, doc));
        IOUtils.close((Closeable[])new Closeable[]{indexWriter, taxoWriter});
    }

    List<FacetResult> facetsOnly() throws IOException {
        DirectoryReader indexReader = DirectoryReader.open((Directory)this.indexDir);
        IndexSearcher searcher = new IndexSearcher((IndexReader)indexReader);
        DirectoryTaxonomyReader taxoReader = new DirectoryTaxonomyReader(this.taxoDir);
        TaxonomyFacetsCutter defaultTaxoCutter = new TaxonomyFacetsCutter("$facets", this.config, (TaxonomyReader)taxoReader);
        CountFacetRecorder defaultRecorder = new CountFacetRecorder();
        FacetFieldCollectorManager collectorManager = new FacetFieldCollectorManager((FacetCutter)defaultTaxoCutter, (FacetRecorder)defaultRecorder);
        searcher.search((Query)new MatchAllDocsQuery(), (CollectorManager)collectorManager);
        ComparableSupplier countComparable = ComparableUtils.byCount((CountFacetRecorder)defaultRecorder);
        ArrayList<FacetResult> results = new ArrayList<FacetResult>(2);
        TaxonomyOrdLabelBiMap ordLabels = new TaxonomyOrdLabelBiMap((TaxonomyReader)taxoReader);
        for (String dimension : List.of("Author", "Publish Date")) {
            int dimOrdinal = ordLabels.getOrd(new FacetLabel(new String[]{dimension}));
            TaxonomyChildrenOrdinalIterator childrenIterator = new TaxonomyChildrenOrdinalIterator(defaultRecorder.recordedOrds(), taxoReader.getParallelTaxonomyArrays().parents(), dimOrdinal);
            TopnOrdinalIterator topByCountOrds = new TopnOrdinalIterator((OrdinalIterator)childrenIterator, countComparable, 10);
            int[] resultOrdinals = topByCountOrds.toArray();
            FacetLabel[] labels = ordLabels.getLabels(resultOrdinals);
            ArrayList<LabelAndValue> labelsAndValues = new ArrayList<LabelAndValue>(labels.length);
            for (int i = 0; i < resultOrdinals.length; ++i) {
                labelsAndValues.add(new LabelAndValue(labels[i].lastComponent(), (Number)defaultRecorder.getCount(resultOrdinals[i])));
            }
            int dimensionValue = defaultRecorder.getCount(dimOrdinal);
            results.add(new FacetResult(dimension, new String[0], (Number)dimensionValue, labelsAndValues.toArray(new LabelAndValue[0]), labelsAndValues.size()));
        }
        IOUtils.close((Closeable[])new Closeable[]{indexReader, taxoReader});
        return results;
    }

    List<FacetResult> exclusiveRangesCountFacetsOnly() throws IOException {
        DirectoryReader indexReader = DirectoryReader.open((Directory)this.indexDir);
        IndexSearcher searcher = new IndexSearcher((IndexReader)indexReader);
        MultiLongValuesSource valuesSource = MultiLongValuesSource.fromLongField((String)"Price");
        LongRange[] inputRanges = new LongRange[]{new LongRange("0-5", 0L, true, 5L, true), new LongRange("5-10", 5L, false, 10L, true)};
        LongRangeFacetCutter longRangeFacetCutter = LongRangeFacetCutter.create((MultiLongValuesSource)valuesSource, (LongRange[])inputRanges);
        CountFacetRecorder countRecorder = new CountFacetRecorder();
        FacetFieldCollectorManager collectorManager = new FacetFieldCollectorManager((FacetCutter)longRangeFacetCutter, (FacetRecorder)countRecorder);
        searcher.search((Query)new MatchAllDocsQuery(), (CollectorManager)collectorManager);
        RangeOrdToLabel ordToLabels = new RangeOrdToLabel((Range[])inputRanges);
        ComparableSupplier countComparable = ComparableUtils.byCount((CountFacetRecorder)countRecorder);
        TopnOrdinalIterator topByCountOrds = new TopnOrdinalIterator(countRecorder.recordedOrds(), countComparable, 10);
        ArrayList<FacetResult> results = new ArrayList<FacetResult>(2);
        int[] resultOrdinals = topByCountOrds.toArray();
        FacetLabel[] labels = ordToLabels.getLabels(resultOrdinals);
        ArrayList<LabelAndValue> labelsAndValues = new ArrayList<LabelAndValue>(labels.length);
        for (int i = 0; i < resultOrdinals.length; ++i) {
            labelsAndValues.add(new LabelAndValue(labels[i].lastComponent(), (Number)countRecorder.getCount(resultOrdinals[i])));
        }
        results.add(new FacetResult("Price", new String[0], (Number)0, labelsAndValues.toArray(new LabelAndValue[0]), 0));
        System.out.println("Computed counts");
        IOUtils.close((Closeable[])new Closeable[]{indexReader});
        return results;
    }

    List<FacetResult> overlappingRangesCountFacetsOnly() throws IOException {
        DirectoryReader indexReader = DirectoryReader.open((Directory)this.indexDir);
        IndexSearcher searcher = new IndexSearcher((IndexReader)indexReader);
        MultiLongValuesSource valuesSource = MultiLongValuesSource.fromLongField((String)"Price");
        LongRange[] inputRanges = new LongRange[]{new LongRange("0-5", 0L, true, 5L, true), new LongRange("0-10", 0L, true, 10L, true)};
        LongRangeFacetCutter longRangeFacetCutter = LongRangeFacetCutter.create((MultiLongValuesSource)valuesSource, (LongRange[])inputRanges);
        CountFacetRecorder countRecorder = new CountFacetRecorder();
        FacetFieldCollectorManager collectorManager = new FacetFieldCollectorManager((FacetCutter)longRangeFacetCutter, (FacetRecorder)countRecorder);
        searcher.search((Query)new MatchAllDocsQuery(), (CollectorManager)collectorManager);
        RangeOrdToLabel ordToLabels = new RangeOrdToLabel((Range[])inputRanges);
        ComparableSupplier countComparable = ComparableUtils.byCount((CountFacetRecorder)countRecorder);
        TopnOrdinalIterator topByCountOrds = new TopnOrdinalIterator(countRecorder.recordedOrds(), countComparable, 10);
        ArrayList<FacetResult> results = new ArrayList<FacetResult>(2);
        int[] resultOrdinals = topByCountOrds.toArray();
        FacetLabel[] labels = ordToLabels.getLabels(resultOrdinals);
        ArrayList<LabelAndValue> labelsAndValues = new ArrayList<LabelAndValue>(labels.length);
        for (int i = 0; i < resultOrdinals.length; ++i) {
            labelsAndValues.add(new LabelAndValue(labels[i].lastComponent(), (Number)countRecorder.getCount(resultOrdinals[i])));
        }
        results.add(new FacetResult("Price", new String[0], (Number)0, labelsAndValues.toArray(new LabelAndValue[0]), 0));
        System.out.println("Computed counts");
        IOUtils.close((Closeable[])new Closeable[]{indexReader});
        return results;
    }

    List<FacetResult> exclusiveRangesAggregationFacets() throws IOException {
        int i;
        DirectoryReader indexReader = DirectoryReader.open((Directory)this.indexDir);
        IndexSearcher searcher = new IndexSearcher((IndexReader)indexReader);
        MultiLongValuesSource valuesSource = MultiLongValuesSource.fromLongField((String)"Price");
        LongRange[] inputRanges = new LongRange[]{new LongRange("0-5", 0L, true, 5L, true), new LongRange("5-10", 5L, false, 10L, true)};
        LongRangeFacetCutter longRangeFacetCutter = LongRangeFacetCutter.create((MultiLongValuesSource)valuesSource, (LongRange[])inputRanges);
        LongValuesSource[] longValuesSources = new LongValuesSource[2];
        Reducer[] reducers = new Reducer[2];
        longValuesSources[0] = DoubleValuesSource.fromDoubleField((String)"Popularity").toLongValuesSource();
        reducers[0] = Reducer.MAX;
        longValuesSources[1] = LongValuesSource.fromLongField((String)"Units");
        reducers[1] = Reducer.SUM;
        LongAggregationsFacetRecorder longAggregationsFacetRecorder = new LongAggregationsFacetRecorder(longValuesSources, reducers);
        CountFacetRecorder countRecorder = new CountFacetRecorder();
        MultiFacetsRecorder multiFacetsRecorder = new MultiFacetsRecorder(new FacetRecorder[]{countRecorder, longAggregationsFacetRecorder});
        FacetFieldCollectorManager collectorManager = new FacetFieldCollectorManager((FacetCutter)longRangeFacetCutter, (FacetRecorder)multiFacetsRecorder);
        searcher.search((Query)new MatchAllDocsQuery(), (CollectorManager)collectorManager);
        RangeOrdToLabel ordToLabels = new RangeOrdToLabel((Range[])inputRanges);
        OrdinalIterator recordedOrds = longAggregationsFacetRecorder.recordedOrds();
        ArrayList<FacetResult> results = new ArrayList<FacetResult>(2);
        ComparableSupplier comparableSupplier = ComparableUtils.byAggregatedValue((CountFacetRecorder)countRecorder, (LongAggregationsFacetRecorder)longAggregationsFacetRecorder, (int)1);
        TopnOrdinalIterator topOrds = new TopnOrdinalIterator(recordedOrds, comparableSupplier, 10);
        int[] resultOrdinals = topOrds.toArray();
        FacetLabel[] labels = ordToLabels.getLabels(resultOrdinals);
        ArrayList<LabelAndValue> labelsAndValues = new ArrayList<LabelAndValue>(labels.length);
        for (i = 0; i < resultOrdinals.length; ++i) {
            labelsAndValues.add(new LabelAndValue(labels[i].lastComponent(), (Number)longAggregationsFacetRecorder.getRecordedValue(resultOrdinals[i], 1)));
        }
        results.add(new FacetResult("Price", new String[0], (Number)0, labelsAndValues.toArray(new LabelAndValue[0]), 0));
        recordedOrds = longAggregationsFacetRecorder.recordedOrds();
        comparableSupplier = ComparableUtils.byAggregatedValue((CountFacetRecorder)countRecorder, (LongAggregationsFacetRecorder)longAggregationsFacetRecorder, (int)0);
        topOrds = new TopnOrdinalIterator(recordedOrds, comparableSupplier, 10);
        resultOrdinals = topOrds.toArray();
        labels = ordToLabels.getLabels(resultOrdinals);
        labelsAndValues = new ArrayList(labels.length);
        for (i = 0; i < resultOrdinals.length; ++i) {
            labelsAndValues.add(new LabelAndValue(labels[i].lastComponent(), (Number)longAggregationsFacetRecorder.getRecordedValue(resultOrdinals[i], 0)));
        }
        results.add(new FacetResult("Price", new String[0], (Number)0, labelsAndValues.toArray(new LabelAndValue[0]), 0));
        return results;
    }

    private List<FacetResult> facetsWithSearch() throws IOException {
        DirectoryReader indexReader = DirectoryReader.open((Directory)this.indexDir);
        IndexSearcher searcher = new IndexSearcher((IndexReader)indexReader);
        DirectoryTaxonomyReader taxoReader = new DirectoryTaxonomyReader(this.taxoDir);
        TaxonomyFacetsCutter defaultTaxoCutter = new TaxonomyFacetsCutter("$facets", this.config, (TaxonomyReader)taxoReader);
        CountFacetRecorder defaultRecorder = new CountFacetRecorder();
        FacetFieldCollectorManager taxoFacetsCollectorManager = new FacetFieldCollectorManager((FacetCutter)defaultTaxoCutter, (FacetRecorder)defaultRecorder);
        TopScoreDocCollectorManager hitsCollectorManager = new TopScoreDocCollectorManager(2, Integer.MAX_VALUE);
        MultiCollectorManager collectorManager = new MultiCollectorManager(new CollectorManager[]{hitsCollectorManager, taxoFacetsCollectorManager});
        Object[] results = (Object[])searcher.search((Query)new MatchAllDocsQuery(), (CollectorManager)collectorManager);
        TopDocs topDocs = (TopDocs)results[0];
        System.out.println("Search results: totalHits: " + String.valueOf(topDocs.totalHits) + ", collected hits: " + topDocs.scoreDocs.length);
        ComparableSupplier countComparable = ComparableUtils.byCount((CountFacetRecorder)defaultRecorder);
        ArrayList<FacetResult> facetResults = new ArrayList<FacetResult>(2);
        TaxonomyOrdLabelBiMap ordLabels = new TaxonomyOrdLabelBiMap((TaxonomyReader)taxoReader);
        for (String dimension : List.of("Author", "Publish Date")) {
            int dimensionOrdinal = ordLabels.getOrd(new FacetLabel(new String[]{dimension}));
            TaxonomyChildrenOrdinalIterator childrenIterator = new TaxonomyChildrenOrdinalIterator(defaultRecorder.recordedOrds(), taxoReader.getParallelTaxonomyArrays().parents(), dimensionOrdinal);
            TopnOrdinalIterator topByCountOrds = new TopnOrdinalIterator((OrdinalIterator)childrenIterator, countComparable, 10);
            int[] resultOrdinals = topByCountOrds.toArray();
            FacetLabel[] labels = ordLabels.getLabels(resultOrdinals);
            ArrayList<LabelAndValue> labelsAndValues = new ArrayList<LabelAndValue>(labels.length);
            for (int i = 0; i < resultOrdinals.length; ++i) {
                labelsAndValues.add(new LabelAndValue(labels[i].lastComponent(), (Number)defaultRecorder.getCount(resultOrdinals[i])));
            }
            int dimensionValue = defaultRecorder.getCount(dimensionOrdinal);
            facetResults.add(new FacetResult(dimension, new String[0], (Number)dimensionValue, labelsAndValues.toArray(new LabelAndValue[0]), labelsAndValues.size()));
        }
        IOUtils.close((Closeable[])new Closeable[]{indexReader, taxoReader});
        return facetResults;
    }

    FacetResult drillDown() throws IOException {
        DirectoryReader indexReader = DirectoryReader.open((Directory)this.indexDir);
        IndexSearcher searcher = new IndexSearcher((IndexReader)indexReader);
        DirectoryTaxonomyReader taxoReader = new DirectoryTaxonomyReader(this.taxoDir);
        TaxonomyFacetsCutter defaultTaxoCutter = new TaxonomyFacetsCutter("$facets", this.config, (TaxonomyReader)taxoReader);
        CountFacetRecorder defaultRecorder = new CountFacetRecorder();
        FacetFieldCollectorManager collectorManager = new FacetFieldCollectorManager((FacetCutter)defaultTaxoCutter, (FacetRecorder)defaultRecorder);
        DrillDownQuery q = new DrillDownQuery(this.config);
        q.add("Publish Date", new String[]{"2010"});
        searcher.search((Query)q, (CollectorManager)collectorManager);
        ComparableSupplier countComparable = ComparableUtils.byCount((CountFacetRecorder)defaultRecorder);
        TaxonomyOrdLabelBiMap ordLabels = new TaxonomyOrdLabelBiMap((TaxonomyReader)taxoReader);
        String dimension = "Author";
        int dimOrdinal = ordLabels.getOrd(new FacetLabel(new String[]{dimension}));
        TaxonomyChildrenOrdinalIterator childrenIterator = new TaxonomyChildrenOrdinalIterator(defaultRecorder.recordedOrds(), taxoReader.getParallelTaxonomyArrays().parents(), dimOrdinal);
        TopnOrdinalIterator topByCountOrds = new TopnOrdinalIterator((OrdinalIterator)childrenIterator, countComparable, 10);
        int[] resultOrdinals = topByCountOrds.toArray();
        FacetLabel[] labels = ordLabels.getLabels(resultOrdinals);
        ArrayList<LabelAndValue> labelsAndValues = new ArrayList<LabelAndValue>(labels.length);
        for (int i = 0; i < resultOrdinals.length; ++i) {
            labelsAndValues.add(new LabelAndValue(labels[i].lastComponent(), (Number)defaultRecorder.getCount(resultOrdinals[i])));
        }
        IOUtils.close((Closeable[])new Closeable[]{indexReader, taxoReader});
        int dimensionValue = defaultRecorder.getCount(dimOrdinal);
        return new FacetResult(dimension, new String[0], (Number)dimensionValue, labelsAndValues.toArray(new LabelAndValue[0]), labelsAndValues.size());
    }

    private List<FacetResult> drillSideways() throws IOException {
        DirectoryReader indexReader = DirectoryReader.open((Directory)this.indexDir);
        IndexSearcher searcher = new IndexSearcher((IndexReader)indexReader);
        DirectoryTaxonomyReader taxoReader = new DirectoryTaxonomyReader(this.taxoDir);
        TaxonomyFacetsCutter defaultTaxoCutter = new TaxonomyFacetsCutter("$facets", this.config, (TaxonomyReader)taxoReader);
        CountFacetRecorder drillDownRecorder = new CountFacetRecorder();
        FacetFieldCollectorManager drillDownCollectorManager = new FacetFieldCollectorManager((FacetCutter)defaultTaxoCutter, (FacetRecorder)drillDownRecorder);
        DrillDownQuery q = new DrillDownQuery(this.config);
        q.add("Publish Date", new String[]{"2010"});
        CountFacetRecorder publishDayDimensionRecorder = new CountFacetRecorder();
        FacetFieldCollectorManager publishDayDimensionCollectorManager = new FacetFieldCollectorManager((FacetCutter)defaultTaxoCutter, (FacetRecorder)publishDayDimensionRecorder);
        List<FacetFieldCollectorManager> drillSidewaysManagers = List.of(publishDayDimensionCollectorManager);
        DrillSideways ds = new DrillSideways(searcher, this.config, (TaxonomyReader)taxoReader);
        ds.search(q, (CollectorManager)drillDownCollectorManager, drillSidewaysManagers);
        ArrayList<FacetResult> facetResults = new ArrayList<FacetResult>(2);
        TaxonomyOrdLabelBiMap ordLabels = new TaxonomyOrdLabelBiMap((TaxonomyReader)taxoReader);
        ComparableSupplier countComparable = ComparableUtils.byCount((CountFacetRecorder)drillDownRecorder);
        int dimOrdinal = ordLabels.getOrd(new FacetLabel(new String[]{"Author"}));
        TaxonomyChildrenOrdinalIterator childrenIterator = new TaxonomyChildrenOrdinalIterator(drillDownRecorder.recordedOrds(), taxoReader.getParallelTaxonomyArrays().parents(), dimOrdinal);
        TopnOrdinalIterator topByCountOrds = new TopnOrdinalIterator((OrdinalIterator)childrenIterator, countComparable, 10);
        int[] resultOrdinals = topByCountOrds.toArray();
        FacetLabel[] labels = ordLabels.getLabels(resultOrdinals);
        ArrayList<LabelAndValue> labelsAndValues = new ArrayList<LabelAndValue>(labels.length);
        for (int i = 0; i < resultOrdinals.length; ++i) {
            labelsAndValues.add(new LabelAndValue(labels[i].lastComponent(), (Number)drillDownRecorder.getCount(resultOrdinals[i])));
        }
        int dimensionValue = drillDownRecorder.getCount(dimOrdinal);
        facetResults.add(new FacetResult("Author", new String[0], (Number)dimensionValue, labelsAndValues.toArray(new LabelAndValue[0]), labelsAndValues.size()));
        countComparable = ComparableUtils.byCount((CountFacetRecorder)publishDayDimensionRecorder);
        dimOrdinal = ordLabels.getOrd(new FacetLabel(new String[]{"Publish Date"}));
        childrenIterator = new TaxonomyChildrenOrdinalIterator(publishDayDimensionRecorder.recordedOrds(), taxoReader.getParallelTaxonomyArrays().parents(), dimOrdinal);
        topByCountOrds = new TopnOrdinalIterator((OrdinalIterator)childrenIterator, countComparable, 10);
        resultOrdinals = topByCountOrds.toArray();
        labels = ordLabels.getLabels(resultOrdinals);
        labelsAndValues = new ArrayList(labels.length);
        for (int i = 0; i < resultOrdinals.length; ++i) {
            labelsAndValues.add(new LabelAndValue(labels[i].lastComponent(), (Number)publishDayDimensionRecorder.getCount(resultOrdinals[i])));
        }
        dimensionValue = publishDayDimensionRecorder.getCount(dimOrdinal);
        facetResults.add(new FacetResult("Publish Date", new String[0], (Number)dimensionValue, labelsAndValues.toArray(new LabelAndValue[0]), labelsAndValues.size()));
        IOUtils.close((Closeable[])new Closeable[]{indexReader, taxoReader});
        return facetResults;
    }

    public List<FacetResult> runFacetOnly() throws IOException {
        this.index();
        return this.facetsOnly();
    }

    public List<FacetResult> runSearch() throws IOException {
        this.index();
        return this.facetsWithSearch();
    }

    public FacetResult runDrillDown() throws IOException {
        this.index();
        return this.drillDown();
    }

    public List<FacetResult> runDrillSideways() throws IOException {
        this.index();
        return this.drillSideways();
    }

    public List<FacetResult> runNonOverlappingRangesCountFacetsOnly() throws IOException {
        this.index();
        return this.exclusiveRangesCountFacetsOnly();
    }

    public List<FacetResult> runOverlappingRangesCountFacetsOnly() throws IOException {
        this.index();
        return this.overlappingRangesCountFacetsOnly();
    }

    public List<FacetResult> runNonOverlappingRangesAggregationFacets() throws IOException {
        this.index();
        return this.exclusiveRangesAggregationFacets();
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Facet counting example:");
        System.out.println("-----------------------");
        SandboxFacetsExample example = new SandboxFacetsExample();
        List<FacetResult> results1 = example.runFacetOnly();
        System.out.println("Author: " + String.valueOf(results1.get(0)));
        System.out.println("Publish Date: " + String.valueOf(results1.get(1)));
        System.out.println("Facet counting example (combined facets and search):");
        System.out.println("-----------------------");
        List<FacetResult> results = example.runSearch();
        System.out.println("Author: " + String.valueOf(results.get(0)));
        System.out.println("Publish Date: " + String.valueOf(results.get(1)));
        System.out.println("Facet drill-down example (Publish Date/2010):");
        System.out.println("---------------------------------------------");
        System.out.println("Author: " + String.valueOf(example.runDrillDown()));
        System.out.println("Facet drill-sideways example (Publish Date/2010):");
        System.out.println("---------------------------------------------");
        for (FacetResult result : example.runDrillSideways()) {
            System.out.println(result);
        }
        System.out.println("Facet counting example with exclusive ranges:");
        System.out.println("---------------------------------------------");
        for (FacetResult result : example.runNonOverlappingRangesCountFacetsOnly()) {
            System.out.println(result);
        }
        System.out.println("Facet counting example with overlapping ranges:");
        System.out.println("---------------------------------------------");
        for (FacetResult result : example.runOverlappingRangesCountFacetsOnly()) {
            System.out.println(result);
        }
        System.out.println("Facet aggregation example with exclusive ranges:");
        System.out.println("---------------------------------------------");
        for (FacetResult result : example.runNonOverlappingRangesAggregationFacets()) {
            System.out.println(result);
        }
    }
}

