/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.auth;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.NamedFactoriesListParseResult;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.server.auth.UserAuth;
import org.apache.sshd.server.auth.UserAuthFactory;
import org.apache.sshd.server.auth.gss.UserAuthGSSFactory;
import org.apache.sshd.server.auth.hostbased.UserAuthHostBasedFactory;
import org.apache.sshd.server.auth.keyboard.UserAuthKeyboardInteractiveFactory;
import org.apache.sshd.server.auth.password.UserAuthPasswordFactory;
import org.apache.sshd.server.auth.pubkey.UserAuthPublicKeyFactory;

public enum BuiltinUserAuthFactories implements NamedFactory<UserAuthFactory>
{
    PASSWORD(UserAuthPasswordFactory.INSTANCE),
    PUBLICKEY(UserAuthPublicKeyFactory.INSTANCE),
    KBINTERACTIVE(UserAuthKeyboardInteractiveFactory.INSTANCE),
    HOSTBASED(UserAuthHostBasedFactory.INSTANCE),
    GSS(UserAuthGSSFactory.INSTANCE);

    public static final Set<BuiltinUserAuthFactories> VALUES;
    private final UserAuthFactory factory;

    private BuiltinUserAuthFactories(UserAuthFactory factory) {
        this.factory = Objects.requireNonNull(factory, "No delegate factory instance");
    }

    public UserAuthFactory create() {
        return this.factory;
    }

    public String getName() {
        return this.factory.getName();
    }

    public static UserAuthFactory fromFactoryName(String name) {
        Factory factory = (Factory)NamedResource.findByName((String)name, (Comparator)String.CASE_INSENSITIVE_ORDER, VALUES);
        if (factory == null) {
            return null;
        }
        return (UserAuthFactory)factory.create();
    }

    public static ParseResult parseFactoriesList(String factories) {
        return BuiltinUserAuthFactories.parseFactoriesList(GenericUtils.split((String)factories, (char)','));
    }

    public static ParseResult parseFactoriesList(String ... factories) {
        return BuiltinUserAuthFactories.parseFactoriesList(GenericUtils.isEmpty((Object[])factories) ? Collections.emptyList() : Arrays.asList(factories));
    }

    public static ParseResult parseFactoriesList(Collection<String> factories) {
        if (GenericUtils.isEmpty(factories)) {
            return ParseResult.EMPTY;
        }
        ArrayList<UserAuthFactory> resolved = new ArrayList<UserAuthFactory>(factories.size());
        List<String> unknown = Collections.emptyList();
        for (String name : factories) {
            UserAuthFactory c = BuiltinUserAuthFactories.resolveFactory(name);
            if (c != null) {
                resolved.add(c);
                continue;
            }
            if (unknown.isEmpty()) {
                unknown = new ArrayList<String>();
            }
            unknown.add(name);
        }
        return new ParseResult(resolved, unknown);
    }

    public static UserAuthFactory resolveFactory(String name) {
        if (GenericUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        return BuiltinUserAuthFactories.fromFactoryName(name);
    }

    static {
        VALUES = Collections.unmodifiableSet(EnumSet.allOf(BuiltinUserAuthFactories.class));
    }

    public static class ParseResult
    extends NamedFactoriesListParseResult<UserAuth, UserAuthFactory> {
        public static final ParseResult EMPTY = new ParseResult(Collections.emptyList(), Collections.emptyList());

        public ParseResult(List<UserAuthFactory> parsed, List<String> unsupported) {
            super(parsed, unsupported);
        }
    }
}

