/****************************************************************************
 * arch/risc-v/src/hpm6000/hardware/hpm6300/hpm6300_pinmux.h
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.  The
 * ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 ****************************************************************************/

#ifndef __ARCH_RISCV_SRC_HPM6000_HARDWARE_HPM6300_HPM6300_PINMUX_H
#define __ARCH_RISCV_SRC_HPM6000_HARDWARE_HPM6300_HPM6300_PINMUX_H

/****************************************************************************
 * Included Files
 ****************************************************************************/

#include <nuttx/config.h>
#include "hpm_ioc.h"
#include "hpm_gpio.h"

#define GPIO_UART0_TXD1    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PA30_INDEX))
#define GPIO_UART0_TXD2    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PB22_INDEX))
#define GPIO_UART0_TXD3    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PC22_INDEX))
#define GPIO_UART0_TXD4    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PY06_INDEX))

#define GPIO_UART0_RXD1    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PA31_INDEX))
#define GPIO_UART0_RXD2    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PB23_INDEX))
#define GPIO_UART0_RXD3    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PC23_INDEX))
#define GPIO_UART0_RXD4    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PY07_INDEX))

#define GPIO_UART1_TXD1    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PA00_INDEX))
#define GPIO_UART1_TXD2    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PB00_INDEX))
#define GPIO_UART1_TXD3    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PB24_INDEX))
#define GPIO_UART1_TXD4    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PC24_INDEX))

#define GPIO_UART1_RXD1    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PA01_INDEX))
#define GPIO_UART1_RXD2    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PB01_INDEX))
#define GPIO_UART1_RXD3    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PB25_INDEX))
#define GPIO_UART1_RXD4    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PC25_INDEX))

#define GPIO_UART2_TXD1    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PA02_INDEX))
#define GPIO_UART2_TXD2    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PB02_INDEX))
#define GPIO_UART2_TXD3    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PB26_INDEX))
#define GPIO_UART2_TXD4    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PC26_INDEX))

#define GPIO_UART2_RXD1    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PA03_INDEX))
#define GPIO_UART2_RXD2    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PB03_INDEX))
#define GPIO_UART2_RXD3    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PB27_INDEX))
#define GPIO_UART2_RXD4    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PC27_INDEX))

#define GPIO_UART3_TXD1    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PA04_INDEX))
#define GPIO_UART3_TXD2    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PB04_INDEX))
#define GPIO_UART3_TXD3    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PB28_INDEX))
#define GPIO_UART3_TXD4    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PZ00_INDEX))

#define GPIO_UART3_RXD1    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PA05_INDEX))
#define GPIO_UART3_RXD2    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PB05_INDEX))
#define GPIO_UART3_RXD3    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PB28_INDEX))
#define GPIO_UART3_RXD4    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PZ01_INDEX))

#define GPIO_UART4_TXD1    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PA14_INDEX))
#define GPIO_UART4_TXD2    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PB06_INDEX))
#define GPIO_UART4_TXD3    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PC06_INDEX))
#define GPIO_UART4_TXD4    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PZ02_INDEX))

#define GPIO_UART4_RXD1    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PA15_INDEX))
#define GPIO_UART4_RXD2    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PB07_INDEX))
#define GPIO_UART4_RXD3    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PC07_INDEX))
#define GPIO_UART4_RXD4    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PZ03_INDEX))

#define GPIO_UART5_TXD1    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PA16_INDEX))
#define GPIO_UART5_TXD2    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PB08_INDEX))
#define GPIO_UART5_TXD3    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PC08_INDEX))
#define GPIO_UART5_TXD4    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PZ04_INDEX))

#define GPIO_UART5_RXD1    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PA17_INDEX))
#define GPIO_UART5_RXD2    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PB09_INDEX))
#define GPIO_UART5_RXD3    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PC09_INDEX))
#define GPIO_UART5_RXD4    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PZ05_INDEX))

#define GPIO_UART6_TXD1    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PA18_INDEX))
#define GPIO_UART6_TXD2    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PB10_INDEX))
#define GPIO_UART6_TXD3    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PC10_INDEX))
#define GPIO_UART6_TXD4    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PZ06_INDEX))

#define GPIO_UART6_RXD1    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PA19_INDEX))
#define GPIO_UART6_RXD2    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PB11_INDEX))
#define GPIO_UART6_RXD3    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PC11_INDEX))
#define GPIO_UART6_RXD4    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PZ07_INDEX))

#define GPIO_UART7_TXD1    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PA20_INDEX))
#define GPIO_UART7_TXD2    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PB12_INDEX))
#define GPIO_UART7_TXD3    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PC12_INDEX))
#define GPIO_UART7_TXD4    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PY04_INDEX))

#define GPIO_UART7_RXD1    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PA21_INDEX))
#define GPIO_UART7_RXD2    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PB13_INDEX))
#define GPIO_UART7_RXD3    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PC13_INDEX))
#define GPIO_UART7_RXD4    (GPIO_PERIPH | PAD_ALT2 | GPIO_PADMUX(HPM_IOC_PAD_PY05_INDEX))

#endif /* __ARCH_RISCV_SRC_HPM6000_HARDWARE_HPM6300_HPM6300_PINMUX_H */
