/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.dbcp2.PoolingConnection;

public class PStmtKey {
    private static final StatementBuilder CallConcurrency = (c, k) -> c.prepareCall(k.sql, k.resultSetType, k.resultSetConcurrency);
    private static final StatementBuilder CallHoldability = (c, k) -> c.prepareCall(k.sql, k.resultSetType, k.resultSetConcurrency, k.resultSetHoldability);
    private static final StatementBuilder CallSQL = (c, k) -> c.prepareCall(k.sql);
    private static final StatementBuilder StatementAutoGeneratedKeys = (c, k) -> c.prepareStatement(k.sql, k.autoGeneratedKeys);
    private static final StatementBuilder StatementColumnIndexes = (c, k) -> c.prepareStatement(k.sql, k.columnIndexes);
    private static final StatementBuilder StatementColumnNames = (c, k) -> c.prepareStatement(k.sql, k.columnNames);
    private static final StatementBuilder StatementConcurrency = (c, k) -> c.prepareStatement(k.sql, k.resultSetType, k.resultSetConcurrency);
    private static final StatementBuilder StatementHoldability = (c, k) -> c.prepareStatement(k.sql, k.resultSetType, k.resultSetConcurrency, k.resultSetHoldability);
    private static final StatementBuilder StatementSQL = (c, k) -> c.prepareStatement(k.sql);
    private final String sql;
    private final Integer resultSetType;
    private final Integer resultSetConcurrency;
    private final Integer resultSetHoldability;
    private final String catalog;
    private final String schema;
    private final Integer autoGeneratedKeys;
    private final int[] columnIndexes;
    private final String[] columnNames;
    private final transient StatementBuilder statementBuilder;
    private final PoolingConnection.StatementType statementType;

    private static StatementBuilder match(PoolingConnection.StatementType statementType, StatementBuilder prep, StatementBuilder call) {
        switch (Objects.requireNonNull(statementType, "statementType")) {
            case PREPARED_STATEMENT: {
                return prep;
            }
            case CALLABLE_STATEMENT: {
                return call;
            }
        }
        throw new IllegalArgumentException(statementType.toString());
    }

    @Deprecated
    public PStmtKey(String sql2) {
        this(sql2, null, PoolingConnection.StatementType.PREPARED_STATEMENT);
    }

    @Deprecated
    public PStmtKey(String sql2, int resultSetType, int resultSetConcurrency) {
        this(sql2, null, resultSetType, resultSetConcurrency, PoolingConnection.StatementType.PREPARED_STATEMENT);
    }

    @Deprecated
    public PStmtKey(String sql2, String catalog) {
        this(sql2, catalog, PoolingConnection.StatementType.PREPARED_STATEMENT);
    }

    @Deprecated
    public PStmtKey(String sql2, String catalog, int autoGeneratedKeys) {
        this(sql2, catalog, PoolingConnection.StatementType.PREPARED_STATEMENT, (Integer)autoGeneratedKeys);
    }

    @Deprecated
    public PStmtKey(String sql2, String catalog, int resultSetType, int resultSetConcurrency) {
        this(sql2, catalog, resultSetType, resultSetConcurrency, PoolingConnection.StatementType.PREPARED_STATEMENT);
    }

    @Deprecated
    public PStmtKey(String sql2, String catalog, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        this(sql2, catalog, resultSetType, resultSetConcurrency, resultSetHoldability, PoolingConnection.StatementType.PREPARED_STATEMENT);
    }

    @Deprecated
    public PStmtKey(String sql2, String catalog, int resultSetType, int resultSetConcurrency, int resultSetHoldability, PoolingConnection.StatementType statementType) {
        this(sql2, catalog, null, (Integer)resultSetType, (Integer)resultSetConcurrency, (Integer)resultSetHoldability, null, null, null, statementType, (PStmtKey k) -> PStmtKey.match(statementType, StatementHoldability, CallHoldability));
    }

    @Deprecated
    public PStmtKey(String sql2, String catalog, int resultSetType, int resultSetConcurrency, PoolingConnection.StatementType statementType) {
        this(sql2, catalog, null, (Integer)resultSetType, (Integer)resultSetConcurrency, null, null, null, null, statementType, (PStmtKey k) -> PStmtKey.match(statementType, StatementConcurrency, CallConcurrency));
    }

    @Deprecated
    public PStmtKey(String sql2, String catalog, int[] columnIndexes) {
        this(sql2, catalog, null, null, null, null, null, columnIndexes, null, PoolingConnection.StatementType.PREPARED_STATEMENT, StatementColumnIndexes);
    }

    @Deprecated
    public PStmtKey(String sql2, String catalog, PoolingConnection.StatementType statementType) {
        this(sql2, catalog, null, null, null, null, null, null, null, statementType, (PStmtKey k) -> PStmtKey.match(statementType, StatementSQL, CallSQL));
    }

    @Deprecated
    public PStmtKey(String sql2, String catalog, PoolingConnection.StatementType statementType, Integer autoGeneratedKeys) {
        this(sql2, catalog, null, null, null, null, autoGeneratedKeys, null, null, statementType, (PStmtKey k) -> PStmtKey.match(statementType, StatementAutoGeneratedKeys, CallSQL));
    }

    public PStmtKey(String sql2, String catalog, String schema) {
        this(sql2, catalog, schema, PoolingConnection.StatementType.PREPARED_STATEMENT);
    }

    public PStmtKey(String sql2, String catalog, String schema, int autoGeneratedKeys) {
        this(sql2, catalog, schema, PoolingConnection.StatementType.PREPARED_STATEMENT, (Integer)autoGeneratedKeys);
    }

    public PStmtKey(String sql2, String catalog, String schema, int resultSetType, int resultSetConcurrency) {
        this(sql2, catalog, schema, resultSetType, resultSetConcurrency, PoolingConnection.StatementType.PREPARED_STATEMENT);
    }

    public PStmtKey(String sql2, String catalog, String schema, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        this(sql2, catalog, schema, resultSetType, resultSetConcurrency, resultSetHoldability, PoolingConnection.StatementType.PREPARED_STATEMENT);
    }

    public PStmtKey(String sql2, String catalog, String schema, int resultSetType, int resultSetConcurrency, int resultSetHoldability, PoolingConnection.StatementType statementType) {
        this(sql2, catalog, schema, (Integer)resultSetType, (Integer)resultSetConcurrency, (Integer)resultSetHoldability, null, null, null, statementType, (PStmtKey k) -> PStmtKey.match(statementType, StatementHoldability, CallHoldability));
    }

    public PStmtKey(String sql2, String catalog, String schema, int resultSetType, int resultSetConcurrency, PoolingConnection.StatementType statementType) {
        this(sql2, catalog, schema, (Integer)resultSetType, (Integer)resultSetConcurrency, null, null, null, null, statementType, (PStmtKey k) -> PStmtKey.match(statementType, StatementConcurrency, CallConcurrency));
    }

    public PStmtKey(String sql2, String catalog, String schema, int[] columnIndexes) {
        this(sql2, catalog, schema, null, null, null, null, columnIndexes, null, PoolingConnection.StatementType.PREPARED_STATEMENT, StatementColumnIndexes);
    }

    private PStmtKey(String sql2, String catalog, String schema, Integer resultSetType, Integer resultSetConcurrency, Integer resultSetHoldability, Integer autoGeneratedKeys, int[] columnIndexes, String[] columnNames, PoolingConnection.StatementType statementType, Function<PStmtKey, StatementBuilder> statementBuilder) {
        this.sql = Objects.requireNonNull(sql2, "sql").trim();
        this.catalog = catalog;
        this.schema = schema;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = resultSetHoldability;
        this.autoGeneratedKeys = autoGeneratedKeys;
        this.columnIndexes = this.clone(columnIndexes);
        this.columnNames = this.clone(columnNames);
        this.statementBuilder = Objects.requireNonNull(Objects.requireNonNull(statementBuilder, "statementBuilder").apply(this), "statementBuilder");
        this.statementType = statementType;
    }

    private PStmtKey(String sql2, String catalog, String schema, Integer resultSetType, Integer resultSetConcurrency, Integer resultSetHoldability, Integer autoGeneratedKeys, int[] columnIndexes, String[] columnNames, PoolingConnection.StatementType statementType, StatementBuilder statementBuilder) {
        this.sql = sql2;
        this.catalog = catalog;
        this.schema = schema;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = resultSetHoldability;
        this.autoGeneratedKeys = autoGeneratedKeys;
        this.columnIndexes = this.clone(columnIndexes);
        this.columnNames = this.clone(columnNames);
        this.statementBuilder = Objects.requireNonNull(statementBuilder, "statementBuilder");
        this.statementType = statementType;
    }

    public PStmtKey(String sql2, String catalog, String schema, PoolingConnection.StatementType statementType) {
        this(sql2, catalog, schema, null, null, null, null, null, null, statementType, (PStmtKey k) -> PStmtKey.match(statementType, StatementSQL, CallSQL));
    }

    public PStmtKey(String sql2, String catalog, String schema, PoolingConnection.StatementType statementType, Integer autoGeneratedKeys) {
        this(sql2, catalog, schema, null, null, null, autoGeneratedKeys, null, null, statementType, (PStmtKey k) -> PStmtKey.match(statementType, StatementAutoGeneratedKeys, CallSQL));
    }

    public PStmtKey(String sql2, String catalog, String schema, String[] columnNames) {
        this(sql2, catalog, schema, null, null, null, null, null, columnNames, PoolingConnection.StatementType.PREPARED_STATEMENT, StatementColumnNames);
    }

    @Deprecated
    public PStmtKey(String sql2, String catalog, String[] columnNames) {
        this(sql2, catalog, null, null, null, null, null, null, columnNames, PoolingConnection.StatementType.PREPARED_STATEMENT, StatementColumnNames);
    }

    private int[] clone(int[] array) {
        return array == null ? null : (int[])array.clone();
    }

    private String[] clone(String[] array) {
        return array == null ? null : (String[])array.clone();
    }

    public Statement createStatement(Connection connection) throws SQLException {
        return this.statementBuilder.createStatement(connection, this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PStmtKey other = (PStmtKey)obj;
        if (!Objects.equals(this.autoGeneratedKeys, other.autoGeneratedKeys)) {
            return false;
        }
        if (!Objects.equals(this.catalog, other.catalog)) {
            return false;
        }
        if (!Arrays.equals(this.columnIndexes, other.columnIndexes)) {
            return false;
        }
        if (!Arrays.equals(this.columnNames, other.columnNames)) {
            return false;
        }
        if (!Objects.equals(this.resultSetConcurrency, other.resultSetConcurrency)) {
            return false;
        }
        if (!Objects.equals(this.resultSetHoldability, other.resultSetHoldability)) {
            return false;
        }
        if (!Objects.equals(this.resultSetType, other.resultSetType)) {
            return false;
        }
        if (!Objects.equals(this.schema, other.schema)) {
            return false;
        }
        if (!Objects.equals(this.sql, other.sql)) {
            return false;
        }
        return this.statementType == other.statementType;
    }

    public Integer getAutoGeneratedKeys() {
        return this.autoGeneratedKeys;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public int[] getColumnIndexes() {
        return this.clone(this.columnIndexes);
    }

    public String[] getColumnNames() {
        return this.clone(this.columnNames);
    }

    public Integer getResultSetConcurrency() {
        return this.resultSetConcurrency;
    }

    public Integer getResultSetHoldability() {
        return this.resultSetHoldability;
    }

    public Integer getResultSetType() {
        return this.resultSetType;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getSql() {
        return this.sql;
    }

    public PoolingConnection.StatementType getStmtType() {
        return this.statementType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.autoGeneratedKeys, this.catalog, Arrays.hashCode(this.columnIndexes), Arrays.hashCode(this.columnNames), this.resultSetConcurrency, this.resultSetHoldability, this.resultSetType, this.schema, this.sql, this.statementType});
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("PStmtKey: sql=");
        buf.append(this.sql);
        buf.append(", catalog=");
        buf.append(this.catalog);
        buf.append(", schema=");
        buf.append(this.schema);
        buf.append(", resultSetType=");
        buf.append(this.resultSetType);
        buf.append(", resultSetConcurrency=");
        buf.append(this.resultSetConcurrency);
        buf.append(", resultSetHoldability=");
        buf.append(this.resultSetHoldability);
        buf.append(", autoGeneratedKeys=");
        buf.append(this.autoGeneratedKeys);
        buf.append(", columnIndexes=");
        buf.append(Arrays.toString(this.columnIndexes));
        buf.append(", columnNames=");
        buf.append(Arrays.toString(this.columnNames));
        buf.append(", statementType=");
        buf.append((Object)this.statementType);
        return buf.toString();
    }

    @FunctionalInterface
    private static interface StatementBuilder {
        public Statement createStatement(Connection var1, PStmtKey var2) throws SQLException;
    }
}

