/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.spark.operator;

import org.apache.hadoop.util.RunJar;
import org.apache.pig.backend.hadoop.executionengine.JobCreationException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.RunJarSecurityManager;
import org.apache.pig.backend.hadoop.executionengine.spark.plan.SparkOperator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.tools.pigstats.PigStats;
import org.apache.pig.tools.pigstats.spark.SparkStatsUtil;

public class NativeSparkOperator
extends SparkOperator {
    private static final long serialVersionUID = 1L;
    private static int countJobs = 0;
    private String nativeSparkJar;
    private String[] params;
    private String jobId;

    public NativeSparkOperator(OperatorKey k, String sparkJar, String[] parameters) {
        super(k);
        this.nativeSparkJar = sparkJar;
        this.params = parameters;
        this.jobId = sparkJar + "_" + NativeSparkOperator.getJobNumber();
    }

    private static int getJobNumber() {
        return ++countJobs;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void runJob() throws JobCreationException {
        RunJarSecurityManager secMan = new RunJarSecurityManager();
        try {
            RunJar.main((String[])this.getNativeMRParams());
            SparkStatsUtil.addNativeJobStats(PigStats.get(), this);
        }
        catch (SecurityException se) {
            if (secMan.getExitInvoked()) {
                if (secMan.getExitCode() != 0) {
                    JobCreationException e = new JobCreationException("Native job returned with non-zero return code");
                    SparkStatsUtil.addFailedNativeJobStats(PigStats.get(), this, e);
                } else {
                    SparkStatsUtil.addNativeJobStats(PigStats.get(), this);
                }
            }
        }
        catch (Throwable t) {
            JobCreationException e = new JobCreationException("Cannot run native spark job " + t.getMessage(), t);
            SparkStatsUtil.addFailedNativeJobStats(PigStats.get(), this, e);
            throw e;
        }
        finally {
            secMan.retire();
        }
    }

    private String[] getNativeMRParams() {
        String[] paramArr = new String[this.params.length + 1];
        paramArr[0] = this.nativeSparkJar;
        for (int i = 0; i < this.params.length; ++i) {
            paramArr[i + 1] = this.params[i];
        }
        return paramArr;
    }

    public String getCommandString() {
        StringBuilder sb = new StringBuilder("hadoop jar ");
        sb.append(this.nativeSparkJar);
        for (String pr : this.params) {
            sb.append(" ");
            sb.append(pr);
        }
        return sb.toString();
    }
}

