/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.pig.EvalFunc;
import org.apache.pig.FuncSpec;
import org.apache.pig.PigWarning;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class REPLACE
extends EvalFunc<String> {
    private Pattern mPattern = null;

    @Override
    public String exec(Tuple input) throws IOException {
        if (input == null || input.size() < 3) {
            return null;
        }
        String source = (String)input.get(0);
        String target = (String)input.get(1);
        if (source == null) {
            return null;
        }
        if (target == null) {
            this.warn("Replace : Regular expression is null", PigWarning.UDF_WARNING_1);
            return null;
        }
        if (this.mPattern == null || !target.equals(this.mPattern.pattern())) {
            try {
                this.mPattern = Pattern.compile(target);
            }
            catch (Exception e) {
                this.warn("Replace : Mal-Formed Regular expression : " + target, PigWarning.UDF_WARNING_1);
                return null;
            }
        }
        String replacewith = (String)input.get(2);
        try {
            return this.mPattern.matcher(source).replaceAll(replacewith);
        }
        catch (Exception e) {
            this.warn("Replace : Failed to process input; error - " + e.getMessage(), PigWarning.UDF_WARNING_1);
            return null;
        }
    }

    @Override
    public Schema outputSchema(Schema input) {
        return new Schema(new Schema.FieldSchema(null, 55));
    }

    @Override
    public List<FuncSpec> getArgToFuncMapping() throws FrontendException {
        ArrayList<FuncSpec> funcList = new ArrayList<FuncSpec>();
        Schema s = new Schema();
        s.add(new Schema.FieldSchema(null, 55));
        s.add(new Schema.FieldSchema(null, 55));
        s.add(new Schema.FieldSchema(null, 55));
        funcList.add(new FuncSpec(this.getClass().getName(), s));
        return funcList;
    }

    @Override
    public boolean allowCompileTimeCalculation() {
        return true;
    }
}

