/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.RpcController;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.util.ByteStringer;

@InterfaceAudience.Private
public class MasterCoprocessorRpcChannel
extends CoprocessorRpcChannel {
    private static final Log LOG = LogFactory.getLog(MasterCoprocessorRpcChannel.class);
    private final ClusterConnection connection;

    public MasterCoprocessorRpcChannel(ClusterConnection conn) {
        this.connection = conn;
    }

    @Override
    protected Message callExecService(RpcController controller, Descriptors.MethodDescriptor method, Message request, Message responsePrototype) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Call: " + method.getName() + ", " + request.toString()));
        }
        ClientProtos.CoprocessorServiceCall call = ClientProtos.CoprocessorServiceCall.newBuilder().setRow(ByteStringer.wrap((byte[])HConstants.EMPTY_BYTE_ARRAY)).setServiceName(method.getService().getFullName()).setMethodName(method.getName()).setRequest(request.toByteString()).build();
        ClientProtos.CoprocessorServiceResponse result = ProtobufUtil.execService(controller, this.connection.getMaster(), call);
        Message response = null;
        if (result.getValue().hasValue()) {
            Message.Builder builder = responsePrototype.newBuilderForType();
            ProtobufUtil.mergeFrom(builder, result.getValue().getValue());
            response = builder.build();
        } else {
            response = responsePrototype.getDefaultInstanceForType();
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Master Result is value=" + response));
        }
        return response;
    }
}

