/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.jetty.client;

import org.spark_project.jetty.client.DuplexConnectionPool;
import org.spark_project.jetty.client.HttpDestination;
import org.spark_project.jetty.client.api.Connection;
import org.spark_project.jetty.client.api.Destination;
import org.spark_project.jetty.util.Callback;
import org.spark_project.jetty.util.LeakDetector;
import org.spark_project.jetty.util.component.LifeCycle;
import org.spark_project.jetty.util.log.Log;
import org.spark_project.jetty.util.log.Logger;

public class LeakTrackingConnectionPool
extends DuplexConnectionPool {
    private static final Logger LOG = Log.getLogger(LeakTrackingConnectionPool.class);
    private final LeakDetector<Connection> leakDetector = new LeakDetector<Connection>(){

        @Override
        protected void leaked(LeakDetector.LeakInfo leakInfo) {
            LeakTrackingConnectionPool.this.leaked(leakInfo);
        }
    };

    public LeakTrackingConnectionPool(Destination destination, int maxConnections, Callback requester) {
        super((HttpDestination)destination, maxConnections, requester);
        this.addBean(this.leakDetector);
    }

    @Override
    public void close() {
        LifeCycle.stop(this);
        super.close();
    }

    @Override
    protected void acquired(Connection connection) {
        if (!this.leakDetector.acquired(connection)) {
            LOG.info("Connection {}@{} not tracked", connection, this.leakDetector.id(connection));
        }
    }

    @Override
    protected void released(Connection connection) {
        if (!this.leakDetector.released(connection)) {
            LOG.info("Connection {}@{} released but not acquired", connection, this.leakDetector.id(connection));
        }
    }

    protected void leaked(LeakDetector.LeakInfo leakInfo) {
        LOG.info("Connection " + leakInfo.getResourceDescription() + " leaked at:", leakInfo.getStackFrames());
    }
}

