/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.io.Text;

public class NGramEstimator {
    private int k = 0;
    private int pf = 0;
    private int n = 0;
    private HashMap<ArrayList<String>, Double> ngrams = new HashMap();

    public boolean isInitialized() {
        return this.k != 0;
    }

    public void initialize(int pk, int ppf, int pn) throws HiveException {
        assert (pk > 0 && ppf > 0 && pn > 0);
        this.k = pk;
        this.pf = ppf;
        this.n = pn;
        if (this.k * this.pf < 1000) {
            this.pf = 1000 / this.k;
        }
    }

    public void reset() {
        this.ngrams.clear();
        this.k = 0;
        this.pf = 0;
        this.n = 0;
    }

    public ArrayList<Object[]> getNGrams() throws HiveException {
        this.trim(true);
        if (this.ngrams.size() < 1) {
            return null;
        }
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        ArrayList<Map.Entry<ArrayList<String>, Double>> list = new ArrayList<Map.Entry<ArrayList<String>, Double>>(this.ngrams.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<ArrayList<String>, Double>>(){

            @Override
            public int compare(Map.Entry<ArrayList<String>, Double> o1, Map.Entry<ArrayList<String>, Double> o2) {
                int result = o2.getValue().compareTo(o1.getValue());
                if (result != 0) {
                    return result;
                }
                ArrayList<String> key1 = o1.getKey();
                ArrayList<String> key2 = o2.getKey();
                for (int i = 0; i < key1.size() && i < key2.size(); ++i) {
                    result = key1.get(i).compareTo(key2.get(i));
                    if (result == 0) continue;
                    return result;
                }
                return key1.size() - key2.size();
            }
        });
        for (int i = 0; i < list.size(); ++i) {
            ArrayList<String> key = list.get(i).getKey();
            Double val = list.get(i).getValue();
            Object[] curGram = new Object[2];
            ArrayList<Text> ng = new ArrayList<Text>();
            for (int j = 0; j < key.size(); ++j) {
                ng.add(new Text(key.get(j)));
            }
            curGram[0] = ng;
            curGram[1] = new DoubleWritable(val.doubleValue());
            result.add(curGram);
        }
        return result;
    }

    public int size() {
        return this.ngrams.size();
    }

    public void add(ArrayList<String> ng) throws HiveException {
        assert (ng != null && ng.size() > 0 && ng.get(0) != null);
        Double curFreq = this.ngrams.get(ng);
        if (curFreq == null) {
            curFreq = new Double(1.0);
        } else {
            Double d = curFreq;
            Double d2 = curFreq = Double.valueOf(curFreq + 1.0);
        }
        this.ngrams.put(ng, curFreq);
        if (this.n == 0) {
            this.n = ng.size();
        } else if (this.n != ng.size()) {
            throw new HiveException(this.getClass().getSimpleName() + ": mismatch in value for 'n'" + ", which usually is caused by a non-constant expression. Found '" + this.n + "' and '" + ng.size() + "'.");
        }
        if (this.ngrams.size() > this.k * this.pf * 2) {
            this.trim(false);
        }
    }

    private void trim(boolean finalTrim) throws HiveException {
        ArrayList<Map.Entry<ArrayList<String>, Double>> list = new ArrayList<Map.Entry<ArrayList<String>, Double>>(this.ngrams.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<ArrayList<String>, Double>>(){

            @Override
            public int compare(Map.Entry<ArrayList<String>, Double> o1, Map.Entry<ArrayList<String>, Double> o2) {
                return o1.getValue().compareTo(o2.getValue());
            }
        });
        for (int i = 0; i < list.size() - (finalTrim ? this.k : this.pf * this.k); ++i) {
            this.ngrams.remove(list.get(i).getKey());
        }
    }

    public void merge(List other) throws HiveException {
        if (other == null) {
            return;
        }
        int otherK = Integer.parseInt(other.get(0).toString());
        int otherN = Integer.parseInt(other.get(1).toString());
        int otherPF = Integer.parseInt(other.get(2).toString());
        if (this.k > 0 && this.k != otherK) {
            throw new HiveException(this.getClass().getSimpleName() + ": mismatch in value for 'k'" + ", which usually is caused by a non-constant expression. Found '" + this.k + "' and '" + otherK + "'.");
        }
        if (this.n > 0 && otherN != this.n) {
            throw new HiveException(this.getClass().getSimpleName() + ": mismatch in value for 'n'" + ", which usually is caused by a non-constant expression. Found '" + this.n + "' and '" + otherN + "'.");
        }
        if (this.pf > 0 && otherPF != this.pf) {
            throw new HiveException(this.getClass().getSimpleName() + ": mismatch in value for 'pf'" + ", which usually is caused by a non-constant expression. Found '" + this.pf + "' and '" + otherPF + "'.");
        }
        this.k = otherK;
        this.pf = otherPF;
        this.n = otherN;
        for (int i = 3; i < other.size(); ++i) {
            ArrayList<String> key = new ArrayList<String>();
            for (int j = 0; j < this.n; ++j) {
                key.add(other.get(i + j).toString());
            }
            double val = Double.parseDouble(other.get(i += this.n).toString());
            Double myval = this.ngrams.get(key);
            myval = myval == null ? new Double(val) : Double.valueOf(myval + val);
            this.ngrams.put(key, myval);
        }
        this.trim(false);
    }

    public ArrayList<Text> serialize() throws HiveException {
        ArrayList<Text> result = new ArrayList<Text>();
        result.add(new Text(Integer.toString(this.k)));
        result.add(new Text(Integer.toString(this.n)));
        result.add(new Text(Integer.toString(this.pf)));
        for (ArrayList<String> mykey : this.ngrams.keySet()) {
            assert (mykey.size() > 0);
            for (int i = 0; i < mykey.size(); ++i) {
                result.add(new Text(mykey.get(i)));
            }
            Double myval = this.ngrams.get(mykey);
            result.add(new Text(myval.toString()));
        }
        return result;
    }
}

