/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.mapreduce;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.ClientSideIteratorScanner;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.IsolatedScanner;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.RowIterator;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableDeletedException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.TableOfflineException;
import org.apache.accumulo.core.client.impl.OfflineScanner;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.TabletLocator;
import org.apache.accumulo.core.client.mapreduce.AccumuloInputFormat;
import org.apache.accumulo.core.client.mapreduce.lib.util.InputConfigurator;
import org.apache.accumulo.core.client.mock.MockInstance;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.user.VersioningIterator;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.CredentialHelper;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public abstract class InputFormatBase<K, V>
extends InputFormat<K, V> {
    private static final Class<?> CLASS = AccumuloInputFormat.class;
    protected static final Logger log = Logger.getLogger(CLASS);

    public static void setConnectorInfo(Job job, String principal, AuthenticationToken token) throws AccumuloSecurityException {
        InputConfigurator.setConnectorInfo(CLASS, job.getConfiguration(), principal, token);
    }

    protected static Boolean isConnectorInfoSet(JobContext context) {
        return InputConfigurator.isConnectorInfoSet(CLASS, InputFormatBase.getConfiguration(context));
    }

    protected static String getPrincipal(JobContext context) {
        return InputConfigurator.getPrincipal(CLASS, InputFormatBase.getConfiguration(context));
    }

    protected static String getTokenClass(JobContext context) {
        return InputConfigurator.getTokenClass(CLASS, InputFormatBase.getConfiguration(context));
    }

    protected static byte[] getToken(JobContext context) {
        return InputConfigurator.getToken(CLASS, InputFormatBase.getConfiguration(context));
    }

    public static void setZooKeeperInstance(Job job, String instanceName, String zooKeepers) {
        InputConfigurator.setZooKeeperInstance(CLASS, job.getConfiguration(), instanceName, zooKeepers);
    }

    public static void setMockInstance(Job job, String instanceName) {
        InputConfigurator.setMockInstance(CLASS, job.getConfiguration(), instanceName);
    }

    protected static Instance getInstance(JobContext context) {
        return InputConfigurator.getInstance(CLASS, InputFormatBase.getConfiguration(context));
    }

    public static void setLogLevel(Job job, Level level) {
        InputConfigurator.setLogLevel(CLASS, job.getConfiguration(), level);
    }

    protected static Level getLogLevel(JobContext context) {
        return InputConfigurator.getLogLevel(CLASS, InputFormatBase.getConfiguration(context));
    }

    public static void setInputTableName(Job job, String tableName) {
        InputConfigurator.setInputTableName(CLASS, job.getConfiguration(), tableName);
    }

    protected static String getInputTableName(JobContext context) {
        return InputConfigurator.getInputTableName(CLASS, InputFormatBase.getConfiguration(context));
    }

    public static void setScanAuthorizations(Job job, Authorizations auths) {
        InputConfigurator.setScanAuthorizations(CLASS, job.getConfiguration(), auths);
    }

    protected static Authorizations getScanAuthorizations(JobContext context) {
        return InputConfigurator.getScanAuthorizations(CLASS, InputFormatBase.getConfiguration(context));
    }

    public static void setRanges(Job job, Collection<Range> ranges) {
        InputConfigurator.setRanges(CLASS, job.getConfiguration(), ranges);
    }

    protected static List<Range> getRanges(JobContext context) throws IOException {
        return InputConfigurator.getRanges(CLASS, InputFormatBase.getConfiguration(context));
    }

    public static void fetchColumns(Job job, Collection<Pair<Text, Text>> columnFamilyColumnQualifierPairs) {
        InputConfigurator.fetchColumns(CLASS, job.getConfiguration(), columnFamilyColumnQualifierPairs);
    }

    protected static Set<Pair<Text, Text>> getFetchedColumns(JobContext context) {
        return InputConfigurator.getFetchedColumns(CLASS, InputFormatBase.getConfiguration(context));
    }

    public static void addIterator(Job job, IteratorSetting cfg) {
        InputConfigurator.addIterator(CLASS, job.getConfiguration(), cfg);
    }

    protected static List<IteratorSetting> getIterators(JobContext context) {
        return InputConfigurator.getIterators(CLASS, InputFormatBase.getConfiguration(context));
    }

    public static void setAutoAdjustRanges(Job job, boolean enableFeature) {
        InputConfigurator.setAutoAdjustRanges(CLASS, job.getConfiguration(), enableFeature);
    }

    protected static boolean getAutoAdjustRanges(JobContext context) {
        return InputConfigurator.getAutoAdjustRanges(CLASS, InputFormatBase.getConfiguration(context));
    }

    public static void setScanIsolation(Job job, boolean enableFeature) {
        InputConfigurator.setScanIsolation(CLASS, job.getConfiguration(), enableFeature);
    }

    protected static boolean isIsolated(JobContext context) {
        return InputConfigurator.isIsolated(CLASS, InputFormatBase.getConfiguration(context));
    }

    public static void setLocalIterators(Job job, boolean enableFeature) {
        InputConfigurator.setLocalIterators(CLASS, job.getConfiguration(), enableFeature);
    }

    protected static boolean usesLocalIterators(JobContext context) {
        return InputConfigurator.usesLocalIterators(CLASS, InputFormatBase.getConfiguration(context));
    }

    public static void setOfflineTableScan(Job job, boolean enableFeature) {
        InputConfigurator.setOfflineTableScan(CLASS, job.getConfiguration(), enableFeature);
    }

    protected static boolean isOfflineScan(JobContext context) {
        return InputConfigurator.isOfflineScan(CLASS, InputFormatBase.getConfiguration(context));
    }

    protected static TabletLocator getTabletLocator(JobContext context) throws TableNotFoundException {
        return InputConfigurator.getTabletLocator(CLASS, InputFormatBase.getConfiguration(context));
    }

    protected static void validateOptions(JobContext context) throws IOException {
        InputConfigurator.validateOptions(CLASS, InputFormatBase.getConfiguration(context));
    }

    Map<String, Map<KeyExtent, List<Range>>> binOfflineTable(JobContext context, String tableName, List<Range> ranges) throws TableNotFoundException, AccumuloException, AccumuloSecurityException {
        HashMap<String, Map<KeyExtent, List<Range>>> binnedRanges = new HashMap<String, Map<KeyExtent, List<Range>>>();
        Instance instance = InputFormatBase.getInstance(context);
        Connector conn = instance.getConnector(InputFormatBase.getPrincipal(context), CredentialHelper.extractToken(InputFormatBase.getTokenClass(context), InputFormatBase.getToken(context)));
        String tableId = Tables.getTableId(instance, tableName);
        if (Tables.getTableState(instance, tableId) != TableState.OFFLINE) {
            Tables.clearCache(instance);
            if (Tables.getTableState(instance, tableId) != TableState.OFFLINE) {
                throw new AccumuloException("Table is online " + tableName + "(" + tableId + ") cannot scan table in offline mode ");
            }
        }
        block0: for (Range range : ranges) {
            Text startRow = range.getStartKey() != null ? range.getStartKey().getRow() : new Text();
            Range metadataRange = new Range(new KeyExtent(new Text(tableId), startRow, null).getMetadataEntry(), true, null, false);
            Scanner scanner = conn.createScanner("!METADATA", Constants.NO_AUTHS);
            Constants.METADATA_PREV_ROW_COLUMN.fetch(scanner);
            scanner.fetchColumnFamily(Constants.METADATA_LAST_LOCATION_COLUMN_FAMILY);
            scanner.fetchColumnFamily(Constants.METADATA_CURRENT_LOCATION_COLUMN_FAMILY);
            scanner.fetchColumnFamily(Constants.METADATA_FUTURE_LOCATION_COLUMN_FAMILY);
            scanner.setRange(metadataRange);
            RowIterator rowIter = new RowIterator(scanner);
            KeyExtent lastExtent = null;
            while (rowIter.hasNext()) {
                ArrayList<Range> rangeList;
                Object row = rowIter.next();
                String last = "";
                KeyExtent extent = null;
                String location = null;
                while (row.hasNext()) {
                    Map.Entry entry = (Map.Entry)row.next();
                    Key key = (Key)entry.getKey();
                    if (key.getColumnFamily().equals((Object)Constants.METADATA_LAST_LOCATION_COLUMN_FAMILY)) {
                        last = ((Value)entry.getValue()).toString();
                    }
                    if (key.getColumnFamily().equals((Object)Constants.METADATA_CURRENT_LOCATION_COLUMN_FAMILY) || key.getColumnFamily().equals((Object)Constants.METADATA_FUTURE_LOCATION_COLUMN_FAMILY)) {
                        location = ((Value)entry.getValue()).toString();
                    }
                    if (!Constants.METADATA_PREV_ROW_COLUMN.hasColumns(key)) continue;
                    extent = new KeyExtent(key.getRow(), (Value)entry.getValue());
                }
                if (location != null) {
                    return null;
                }
                if (!extent.getTableId().toString().equals(tableId)) {
                    throw new AccumuloException("Saw unexpected table Id " + tableId + " " + extent);
                }
                if (lastExtent != null && !extent.isPreviousExtent(lastExtent)) {
                    throw new AccumuloException(" " + lastExtent + " is not previous extent " + extent);
                }
                HashMap<KeyExtent, ArrayList<Range>> tabletRanges = (HashMap<KeyExtent, ArrayList<Range>>)binnedRanges.get(last);
                if (tabletRanges == null) {
                    tabletRanges = new HashMap<KeyExtent, ArrayList<Range>>();
                    binnedRanges.put(last, tabletRanges);
                }
                if ((rangeList = (ArrayList<Range>)tabletRanges.get(extent)) == null) {
                    rangeList = new ArrayList<Range>();
                    tabletRanges.put(extent, rangeList);
                }
                rangeList.add(range);
                if (extent.getEndRow() == null || range.afterEndKey(new Key(extent.getEndRow()).followingKey(PartialKey.ROW))) continue block0;
                lastExtent = extent;
            }
        }
        return binnedRanges;
    }

    public List<InputSplit> getSplits(JobContext context) throws IOException {
        List<Range> ranges;
        log.setLevel(InputFormatBase.getLogLevel(context));
        InputFormatBase.validateOptions(context);
        String tableName = InputFormatBase.getInputTableName(context);
        boolean autoAdjust = InputFormatBase.getAutoAdjustRanges(context);
        List<Range> list = ranges = autoAdjust ? Range.mergeOverlapping(InputFormatBase.getRanges(context)) : InputFormatBase.getRanges(context);
        if (ranges.isEmpty()) {
            ranges = new ArrayList<Range>(1);
            ranges.add(new Range());
        }
        Map<Object, Object> binnedRanges = new HashMap();
        try {
            if (InputFormatBase.isOfflineScan(context)) {
                binnedRanges = this.binOfflineTable(context, tableName, ranges);
                while (binnedRanges == null) {
                    UtilWaitThread.sleep(100 + (int)(Math.random() * 100.0));
                    binnedRanges = this.binOfflineTable(context, tableName, ranges);
                }
            } else {
                Instance instance = InputFormatBase.getInstance(context);
                String tableId = null;
                TabletLocator tl = InputFormatBase.getTabletLocator(context);
                tl.invalidateCache();
                while (!tl.binRanges(ranges, binnedRanges, new TCredentials(InputFormatBase.getPrincipal(context), InputFormatBase.getTokenClass(context), ByteBuffer.wrap(InputFormatBase.getToken(context)), InputFormatBase.getInstance(context).getInstanceID())).isEmpty()) {
                    if (!(instance instanceof MockInstance)) {
                        if (tableId == null) {
                            tableId = Tables.getTableId(instance, tableName);
                        }
                        if (!Tables.exists(instance, tableId)) {
                            throw new TableDeletedException(tableId);
                        }
                        if (Tables.getTableState(instance, tableId) == TableState.OFFLINE) {
                            throw new TableOfflineException(instance, tableId);
                        }
                    }
                    binnedRanges.clear();
                    log.warn((Object)"Unable to locate bins for specified ranges. Retrying.");
                    UtilWaitThread.sleep(100 + (int)(Math.random() * 100.0));
                    tl.invalidateCache();
                }
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>(ranges.size());
        HashMap<Range, ArrayList<String>> splitsToAdd = null;
        if (!autoAdjust) {
            splitsToAdd = new HashMap<Range, ArrayList<String>>();
        }
        HashMap<String, String> hostNameCache = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : binnedRanges.entrySet()) {
            String ip = ((String)entry.getKey()).split(":", 2)[0];
            String location = (String)hostNameCache.get(ip);
            if (location == null) {
                InetAddress inetAddress = InetAddress.getByName(ip);
                location = inetAddress.getHostName();
                hostNameCache.put(ip, location);
            }
            for (Map.Entry extentRanges : ((Map)entry.getValue()).entrySet()) {
                Range ke = ((KeyExtent)extentRanges.getKey()).toDataRange();
                for (Range r : (List)extentRanges.getValue()) {
                    if (autoAdjust) {
                        splits.add(new RangeInputSplit(tableName, ke.clip(r), new String[]{location}));
                        continue;
                    }
                    ArrayList<String> locations = (ArrayList<String>)splitsToAdd.get(r);
                    if (locations == null) {
                        locations = new ArrayList<String>(1);
                    }
                    locations.add(location);
                    splitsToAdd.put(r, locations);
                }
            }
        }
        if (!autoAdjust) {
            for (Map.Entry<Object, Object> entry : splitsToAdd.entrySet()) {
                splits.add(new RangeInputSplit(tableName, (Range)entry.getKey(), ((ArrayList)entry.getValue()).toArray(new String[0])));
            }
        }
        return splits;
    }

    @Deprecated
    public static void setIsolated(Configuration conf, boolean enable) {
        InputConfigurator.setScanIsolation(CLASS, conf, enable);
    }

    @Deprecated
    public static void setLocalIterators(Configuration conf, boolean enable) {
        InputConfigurator.setLocalIterators(CLASS, conf, enable);
    }

    @Deprecated
    public static void setInputInfo(Configuration conf, String user, byte[] passwd, String table, Authorizations auths) {
        try {
            InputConfigurator.setConnectorInfo(CLASS, conf, user, new PasswordToken(passwd));
        }
        catch (AccumuloSecurityException e) {
            throw new RuntimeException(e);
        }
        InputConfigurator.setInputTableName(CLASS, conf, table);
        InputConfigurator.setScanAuthorizations(CLASS, conf, auths);
    }

    @Deprecated
    public static void setZooKeeperInstance(Configuration conf, String instanceName, String zooKeepers) {
        InputConfigurator.setZooKeeperInstance(CLASS, conf, instanceName, zooKeepers);
    }

    @Deprecated
    public static void setMockInstance(Configuration conf, String instanceName) {
        InputConfigurator.setMockInstance(CLASS, conf, instanceName);
    }

    @Deprecated
    public static void setRanges(Configuration conf, Collection<Range> ranges) {
        InputConfigurator.setRanges(CLASS, conf, ranges);
    }

    @Deprecated
    public static void disableAutoAdjustRanges(Configuration conf) {
        InputConfigurator.setAutoAdjustRanges(CLASS, conf, false);
    }

    @Deprecated
    public static void setMaxVersions(Configuration conf, int maxVersions) throws IOException {
        IteratorSetting vers = new IteratorSetting(1, "vers", VersioningIterator.class);
        try {
            VersioningIterator.setMaxVersions(vers, maxVersions);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e);
        }
        InputConfigurator.addIterator(CLASS, conf, vers);
    }

    @Deprecated
    public static void setScanOffline(Configuration conf, boolean scanOff) {
        InputConfigurator.setOfflineTableScan(CLASS, conf, scanOff);
    }

    @Deprecated
    public static void fetchColumns(Configuration conf, Collection<Pair<Text, Text>> columnFamilyColumnQualifierPairs) {
        InputConfigurator.fetchColumns(CLASS, conf, columnFamilyColumnQualifierPairs);
    }

    @Deprecated
    public static void setLogLevel(Configuration conf, Level level) {
        InputConfigurator.setLogLevel(CLASS, conf, level);
    }

    @Deprecated
    public static void addIterator(Configuration conf, IteratorSetting cfg) {
        InputConfigurator.addIterator(CLASS, conf, cfg);
    }

    @Deprecated
    protected static boolean isIsolated(Configuration conf) {
        return InputConfigurator.isIsolated(CLASS, conf);
    }

    @Deprecated
    protected static boolean usesLocalIterators(Configuration conf) {
        return InputConfigurator.usesLocalIterators(CLASS, conf);
    }

    @Deprecated
    protected static String getPrincipal(Configuration conf) {
        return InputConfigurator.getPrincipal(CLASS, conf);
    }

    @Deprecated
    protected static byte[] getToken(Configuration conf) {
        return InputConfigurator.getToken(CLASS, conf);
    }

    @Deprecated
    protected static String getTablename(Configuration conf) {
        return InputConfigurator.getInputTableName(CLASS, conf);
    }

    @Deprecated
    protected static Authorizations getAuthorizations(Configuration conf) {
        return InputConfigurator.getScanAuthorizations(CLASS, conf);
    }

    @Deprecated
    protected static Instance getInstance(Configuration conf) {
        return InputConfigurator.getInstance(CLASS, conf);
    }

    @Deprecated
    protected static TabletLocator getTabletLocator(Configuration conf) throws TableNotFoundException {
        return InputConfigurator.getTabletLocator(CLASS, conf);
    }

    @Deprecated
    protected static List<Range> getRanges(Configuration conf) throws IOException {
        return InputConfigurator.getRanges(CLASS, conf);
    }

    @Deprecated
    protected static Set<Pair<Text, Text>> getFetchedColumns(Configuration conf) {
        return InputConfigurator.getFetchedColumns(CLASS, conf);
    }

    @Deprecated
    protected static boolean getAutoAdjustRanges(Configuration conf) {
        return InputConfigurator.getAutoAdjustRanges(CLASS, conf);
    }

    @Deprecated
    protected static Level getLogLevel(Configuration conf) {
        return InputConfigurator.getLogLevel(CLASS, conf);
    }

    @Deprecated
    protected static void validateOptions(Configuration conf) throws IOException {
        InputConfigurator.validateOptions(CLASS, conf);
    }

    @Deprecated
    protected static int getMaxVersions(Configuration conf) {
        List<IteratorSetting> iteratorSettings = InputConfigurator.getIterators(CLASS, conf);
        for (IteratorSetting setting : iteratorSettings) {
            if (!"vers".equals(setting.getName()) || 1 != setting.getPriority() || !VersioningIterator.class.getName().equals(setting.getIteratorClass())) continue;
            if (setting.getOptions().containsKey("maxVersions")) {
                return Integer.parseInt(setting.getOptions().get("maxVersions"));
            }
            return -1;
        }
        return -1;
    }

    @Deprecated
    protected static boolean isOfflineScan(Configuration conf) {
        return InputConfigurator.isOfflineScan(CLASS, conf);
    }

    @Deprecated
    protected static List<AccumuloIterator> getIterators(Configuration conf) {
        List<IteratorSetting> iteratorSettings = InputConfigurator.getIterators(CLASS, conf);
        ArrayList<AccumuloIterator> deprecatedIterators = new ArrayList<AccumuloIterator>(iteratorSettings.size());
        for (IteratorSetting setting : iteratorSettings) {
            AccumuloIterator deprecatedIter = new AccumuloIterator(new String(setting.getPriority() + ":" + setting.getIteratorClass() + ":" + setting.getName()));
            deprecatedIterators.add(deprecatedIter);
        }
        return deprecatedIterators;
    }

    @Deprecated
    protected static List<AccumuloIteratorOption> getIteratorOptions(Configuration conf) {
        List<IteratorSetting> iteratorSettings = InputConfigurator.getIterators(CLASS, conf);
        ArrayList<AccumuloIteratorOption> deprecatedIteratorOptions = new ArrayList<AccumuloIteratorOption>(iteratorSettings.size());
        for (IteratorSetting setting : iteratorSettings) {
            for (Map.Entry<String, String> opt : setting.getOptions().entrySet()) {
                String deprecatedOption;
                try {
                    deprecatedOption = new String(setting.getName() + ":" + URLEncoder.encode(opt.getKey(), "UTF-8") + ":" + URLEncoder.encode(opt.getValue(), "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                deprecatedIteratorOptions.add(new AccumuloIteratorOption(deprecatedOption));
            }
        }
        return deprecatedIteratorOptions;
    }

    static Configuration getConfiguration(JobContext context) {
        try {
            Class<?> c = InputFormatBase.class.getClassLoader().loadClass("org.apache.hadoop.mapreduce.JobContext");
            Method m = c.getMethod("getConfiguration", new Class[0]);
            Object o = m.invoke((Object)context, new Object[0]);
            return (Configuration)o;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    static class AccumuloIteratorOption {
        private static final String FIELD_SEP = ":";
        private String iteratorName;
        private String key;
        private String value;

        public AccumuloIteratorOption(String iteratorName, String key, String value) {
            this.iteratorName = iteratorName;
            this.key = key;
            this.value = value;
        }

        public AccumuloIteratorOption(String iteratorOption) {
            StringTokenizer tokenizer = new StringTokenizer(iteratorOption, FIELD_SEP);
            this.iteratorName = tokenizer.nextToken();
            try {
                this.key = URLDecoder.decode(tokenizer.nextToken(), "UTF-8");
                this.value = URLDecoder.decode(tokenizer.nextToken(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        public String getIteratorName() {
            return this.iteratorName;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            try {
                return new String(this.iteratorName + FIELD_SEP + URLEncoder.encode(this.key, "UTF-8") + FIELD_SEP + URLEncoder.encode(this.value, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Deprecated
    static class AccumuloIterator {
        private static final String FIELD_SEP = ":";
        private int priority;
        private String iteratorClass;
        private String iteratorName;

        public AccumuloIterator(int priority, String iteratorClass, String iteratorName) {
            this.priority = priority;
            this.iteratorClass = iteratorClass;
            this.iteratorName = iteratorName;
        }

        public AccumuloIterator(String iteratorSetting) {
            StringTokenizer tokenizer = new StringTokenizer(iteratorSetting, FIELD_SEP);
            this.priority = Integer.parseInt(tokenizer.nextToken());
            this.iteratorClass = tokenizer.nextToken();
            this.iteratorName = tokenizer.nextToken();
        }

        public int getPriority() {
            return this.priority;
        }

        public String getIteratorClass() {
            return this.iteratorClass;
        }

        public String getIteratorName() {
            return this.iteratorName;
        }

        public String toString() {
            return new String(this.priority + FIELD_SEP + this.iteratorClass + FIELD_SEP + this.iteratorName);
        }
    }

    public static class RangeInputSplit
    extends InputSplit
    implements Writable {
        private Range range;
        private String[] locations;

        public RangeInputSplit() {
            this.range = new Range();
            this.locations = new String[0];
        }

        public RangeInputSplit(RangeInputSplit split) throws IOException {
            this.setRange(split.getRange());
            this.setLocations(split.getLocations());
        }

        protected RangeInputSplit(String table, Range range, String[] locations) {
            this.range = range;
            this.locations = locations;
        }

        public Range getRange() {
            return this.range;
        }

        public void setRange(Range range) {
            this.range = range;
        }

        private static byte[] extractBytes(ByteSequence seq, int numBytes) {
            byte[] bytes = new byte[numBytes + 1];
            bytes[0] = 0;
            for (int i = 0; i < numBytes; ++i) {
                bytes[i + 1] = i >= seq.length() ? (byte)0 : seq.byteAt(i);
            }
            return bytes;
        }

        public static float getProgress(ByteSequence start, ByteSequence end, ByteSequence position) {
            int maxDepth = Math.min(Math.max(end.length(), start.length()), position.length());
            BigInteger startBI = new BigInteger(RangeInputSplit.extractBytes(start, maxDepth));
            BigInteger endBI = new BigInteger(RangeInputSplit.extractBytes(end, maxDepth));
            BigInteger positionBI = new BigInteger(RangeInputSplit.extractBytes(position, maxDepth));
            return (float)(positionBI.subtract(startBI).doubleValue() / endBI.subtract(startBI).doubleValue());
        }

        public float getProgress(Key currentKey) {
            if (currentKey == null) {
                return 0.0f;
            }
            if (this.range.getStartKey() != null && this.range.getEndKey() != null) {
                if (!this.range.getStartKey().equals(this.range.getEndKey(), PartialKey.ROW)) {
                    return RangeInputSplit.getProgress(this.range.getStartKey().getRowData(), this.range.getEndKey().getRowData(), currentKey.getRowData());
                }
                if (!this.range.getStartKey().equals(this.range.getEndKey(), PartialKey.ROW_COLFAM)) {
                    return RangeInputSplit.getProgress(this.range.getStartKey().getColumnFamilyData(), this.range.getEndKey().getColumnFamilyData(), currentKey.getColumnFamilyData());
                }
                if (!this.range.getStartKey().equals(this.range.getEndKey(), PartialKey.ROW_COLFAM_COLQUAL)) {
                    return RangeInputSplit.getProgress(this.range.getStartKey().getColumnQualifierData(), this.range.getEndKey().getColumnQualifierData(), currentKey.getColumnQualifierData());
                }
            }
            return 0.0f;
        }

        public long getLength() throws IOException {
            Text startRow = this.range.isInfiniteStartKey() ? new Text(new byte[]{-128}) : this.range.getStartKey().getRow();
            Text stopRow = this.range.isInfiniteStopKey() ? new Text(new byte[]{127}) : this.range.getEndKey().getRow();
            int maxCommon = Math.min(7, Math.min(startRow.getLength(), stopRow.getLength()));
            long diff = 0L;
            byte[] start = startRow.getBytes();
            byte[] stop = stopRow.getBytes();
            for (int i = 0; i < maxCommon; ++i) {
                diff |= (long)(0xFF & (start[i] ^ stop[i]));
                diff <<= 8;
            }
            if (startRow.getLength() != stopRow.getLength()) {
                diff |= 0xFFL;
            }
            return diff + 1L;
        }

        public String[] getLocations() throws IOException {
            return this.locations;
        }

        public void setLocations(String[] locations) {
            this.locations = locations;
        }

        public void readFields(DataInput in) throws IOException {
            this.range.readFields(in);
            int numLocs = in.readInt();
            this.locations = new String[numLocs];
            for (int i = 0; i < numLocs; ++i) {
                this.locations[i] = in.readUTF();
            }
        }

        public void write(DataOutput out) throws IOException {
            this.range.write(out);
            out.writeInt(this.locations.length);
            for (int i = 0; i < this.locations.length; ++i) {
                out.writeUTF(this.locations[i]);
            }
        }
    }

    protected static abstract class RecordReaderBase<K, V>
    extends RecordReader<K, V> {
        protected long numKeysRead;
        protected Iterator<Map.Entry<Key, Value>> scannerIterator;
        protected RangeInputSplit split;
        protected K currentK = null;
        protected V currentV = null;
        protected Key currentKey = null;
        protected Value currentValue = null;

        protected RecordReaderBase() {
        }

        protected void setupIterators(TaskAttemptContext context, Scanner scanner) {
            List<IteratorSetting> iterators = InputFormatBase.getIterators((JobContext)context);
            for (IteratorSetting iterator : iterators) {
                scanner.addScanIterator(iterator);
            }
        }

        public void initialize(InputSplit inSplit, TaskAttemptContext attempt) throws IOException {
            Scanner scanner;
            this.split = (RangeInputSplit)inSplit;
            log.debug((Object)("Initializing input split: " + this.split.range));
            Instance instance = InputFormatBase.getInstance((JobContext)attempt);
            String principal = InputFormatBase.getPrincipal((JobContext)attempt);
            String tokenClass = InputFormatBase.getTokenClass((JobContext)attempt);
            byte[] token = InputFormatBase.getToken((JobContext)attempt);
            Authorizations authorizations = InputFormatBase.getScanAuthorizations((JobContext)attempt);
            try {
                log.debug((Object)("Creating connector with user: " + principal));
                Connector conn = instance.getConnector(principal, CredentialHelper.extractToken(tokenClass, token));
                log.debug((Object)("Creating scanner for table: " + InputFormatBase.getInputTableName((JobContext)attempt)));
                log.debug((Object)("Authorizations are: " + authorizations));
                scanner = InputFormatBase.isOfflineScan((JobContext)attempt) ? new OfflineScanner(instance, new TCredentials(principal, tokenClass, ByteBuffer.wrap(token), instance.getInstanceID()), Tables.getTableId(instance, InputFormatBase.getInputTableName((JobContext)attempt)), authorizations) : conn.createScanner(InputFormatBase.getInputTableName((JobContext)attempt), authorizations);
                if (InputFormatBase.isIsolated((JobContext)attempt)) {
                    log.info((Object)"Creating isolated scanner");
                    scanner = new IsolatedScanner(scanner);
                }
                if (InputFormatBase.usesLocalIterators((JobContext)attempt)) {
                    log.info((Object)"Using local iterators");
                    scanner = new ClientSideIteratorScanner(scanner);
                }
                this.setupIterators(attempt, scanner);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            for (Pair<Text, Text> c : InputFormatBase.getFetchedColumns((JobContext)attempt)) {
                if (c.getSecond() != null) {
                    log.debug((Object)("Fetching column " + c.getFirst() + ":" + c.getSecond()));
                    scanner.fetchColumn(c.getFirst(), c.getSecond());
                    continue;
                }
                log.debug((Object)("Fetching column family " + c.getFirst()));
                scanner.fetchColumnFamily(c.getFirst());
            }
            scanner.setRange(this.split.range);
            this.numKeysRead = 0L;
            this.scannerIterator = scanner.iterator();
        }

        public void close() {
        }

        public float getProgress() throws IOException {
            if (this.numKeysRead > 0L && this.currentKey == null) {
                return 1.0f;
            }
            return this.split.getProgress(this.currentKey);
        }

        public K getCurrentKey() throws IOException, InterruptedException {
            return this.currentK;
        }

        public V getCurrentValue() throws IOException, InterruptedException {
            return this.currentV;
        }
    }
}

