/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetUnconfirmedServiceChoiceTagged is the corresponding interface of BACnetUnconfirmedServiceChoiceTagged
type BACnetUnconfirmedServiceChoiceTagged interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetHeader returns Header (property field)
	GetHeader() BACnetTagHeader
	// GetValue returns Value (property field)
	GetValue() BACnetUnconfirmedServiceChoice
	// IsBACnetUnconfirmedServiceChoiceTagged is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetUnconfirmedServiceChoiceTagged()
	// CreateBuilder creates a BACnetUnconfirmedServiceChoiceTaggedBuilder
	CreateBACnetUnconfirmedServiceChoiceTaggedBuilder() BACnetUnconfirmedServiceChoiceTaggedBuilder
}

// _BACnetUnconfirmedServiceChoiceTagged is the data-structure of this message
type _BACnetUnconfirmedServiceChoiceTagged struct {
	Header BACnetTagHeader
	Value  BACnetUnconfirmedServiceChoice

	// Arguments.
	TagNumber uint8
	TagClass  TagClass
}

var _ BACnetUnconfirmedServiceChoiceTagged = (*_BACnetUnconfirmedServiceChoiceTagged)(nil)

// NewBACnetUnconfirmedServiceChoiceTagged factory function for _BACnetUnconfirmedServiceChoiceTagged
func NewBACnetUnconfirmedServiceChoiceTagged(header BACnetTagHeader, value BACnetUnconfirmedServiceChoice, tagNumber uint8, tagClass TagClass) *_BACnetUnconfirmedServiceChoiceTagged {
	if header == nil {
		panic("header of type BACnetTagHeader for BACnetUnconfirmedServiceChoiceTagged must not be nil")
	}
	return &_BACnetUnconfirmedServiceChoiceTagged{Header: header, Value: value, TagNumber: tagNumber, TagClass: tagClass}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetUnconfirmedServiceChoiceTaggedBuilder is a builder for BACnetUnconfirmedServiceChoiceTagged
type BACnetUnconfirmedServiceChoiceTaggedBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(header BACnetTagHeader, value BACnetUnconfirmedServiceChoice) BACnetUnconfirmedServiceChoiceTaggedBuilder
	// WithHeader adds Header (property field)
	WithHeader(BACnetTagHeader) BACnetUnconfirmedServiceChoiceTaggedBuilder
	// WithHeaderBuilder adds Header (property field) which is build by the builder
	WithHeaderBuilder(func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetUnconfirmedServiceChoiceTaggedBuilder
	// WithValue adds Value (property field)
	WithValue(BACnetUnconfirmedServiceChoice) BACnetUnconfirmedServiceChoiceTaggedBuilder
	// WithArgTagNumber sets a parser argument
	WithArgTagNumber(uint8) BACnetUnconfirmedServiceChoiceTaggedBuilder
	// WithArgTagClass sets a parser argument
	WithArgTagClass(TagClass) BACnetUnconfirmedServiceChoiceTaggedBuilder
	// Build builds the BACnetUnconfirmedServiceChoiceTagged or returns an error if something is wrong
	Build() (BACnetUnconfirmedServiceChoiceTagged, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetUnconfirmedServiceChoiceTagged
}

// NewBACnetUnconfirmedServiceChoiceTaggedBuilder() creates a BACnetUnconfirmedServiceChoiceTaggedBuilder
func NewBACnetUnconfirmedServiceChoiceTaggedBuilder() BACnetUnconfirmedServiceChoiceTaggedBuilder {
	return &_BACnetUnconfirmedServiceChoiceTaggedBuilder{_BACnetUnconfirmedServiceChoiceTagged: new(_BACnetUnconfirmedServiceChoiceTagged)}
}

type _BACnetUnconfirmedServiceChoiceTaggedBuilder struct {
	*_BACnetUnconfirmedServiceChoiceTagged

	collectedErr []error
}

var _ (BACnetUnconfirmedServiceChoiceTaggedBuilder) = (*_BACnetUnconfirmedServiceChoiceTaggedBuilder)(nil)

func (b *_BACnetUnconfirmedServiceChoiceTaggedBuilder) WithMandatoryFields(header BACnetTagHeader, value BACnetUnconfirmedServiceChoice) BACnetUnconfirmedServiceChoiceTaggedBuilder {
	return b.WithHeader(header).WithValue(value)
}

func (b *_BACnetUnconfirmedServiceChoiceTaggedBuilder) WithHeader(header BACnetTagHeader) BACnetUnconfirmedServiceChoiceTaggedBuilder {
	b.Header = header
	return b
}

func (b *_BACnetUnconfirmedServiceChoiceTaggedBuilder) WithHeaderBuilder(builderSupplier func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetUnconfirmedServiceChoiceTaggedBuilder {
	builder := builderSupplier(b.Header.CreateBACnetTagHeaderBuilder())
	var err error
	b.Header, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetTagHeaderBuilder failed"))
	}
	return b
}

func (b *_BACnetUnconfirmedServiceChoiceTaggedBuilder) WithValue(value BACnetUnconfirmedServiceChoice) BACnetUnconfirmedServiceChoiceTaggedBuilder {
	b.Value = value
	return b
}

func (b *_BACnetUnconfirmedServiceChoiceTaggedBuilder) WithArgTagNumber(tagNumber uint8) BACnetUnconfirmedServiceChoiceTaggedBuilder {
	b.TagNumber = tagNumber
	return b
}
func (b *_BACnetUnconfirmedServiceChoiceTaggedBuilder) WithArgTagClass(tagClass TagClass) BACnetUnconfirmedServiceChoiceTaggedBuilder {
	b.TagClass = tagClass
	return b
}

func (b *_BACnetUnconfirmedServiceChoiceTaggedBuilder) Build() (BACnetUnconfirmedServiceChoiceTagged, error) {
	if b.Header == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'header' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetUnconfirmedServiceChoiceTagged.deepCopy(), nil
}

func (b *_BACnetUnconfirmedServiceChoiceTaggedBuilder) MustBuild() BACnetUnconfirmedServiceChoiceTagged {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetUnconfirmedServiceChoiceTaggedBuilder) DeepCopy() any {
	_copy := b.CreateBACnetUnconfirmedServiceChoiceTaggedBuilder().(*_BACnetUnconfirmedServiceChoiceTaggedBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetUnconfirmedServiceChoiceTaggedBuilder creates a BACnetUnconfirmedServiceChoiceTaggedBuilder
func (b *_BACnetUnconfirmedServiceChoiceTagged) CreateBACnetUnconfirmedServiceChoiceTaggedBuilder() BACnetUnconfirmedServiceChoiceTaggedBuilder {
	if b == nil {
		return NewBACnetUnconfirmedServiceChoiceTaggedBuilder()
	}
	return &_BACnetUnconfirmedServiceChoiceTaggedBuilder{_BACnetUnconfirmedServiceChoiceTagged: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetUnconfirmedServiceChoiceTagged) GetHeader() BACnetTagHeader {
	return m.Header
}

func (m *_BACnetUnconfirmedServiceChoiceTagged) GetValue() BACnetUnconfirmedServiceChoice {
	return m.Value
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetUnconfirmedServiceChoiceTagged(structType any) BACnetUnconfirmedServiceChoiceTagged {
	if casted, ok := structType.(BACnetUnconfirmedServiceChoiceTagged); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetUnconfirmedServiceChoiceTagged); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetUnconfirmedServiceChoiceTagged) GetTypeName() string {
	return "BACnetUnconfirmedServiceChoiceTagged"
}

func (m *_BACnetUnconfirmedServiceChoiceTagged) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (header)
	lengthInBits += m.Header.GetLengthInBits(ctx)

	// Manual Field (value)
	lengthInBits += uint16(int32(m.GetHeader().GetActualLength()) * int32(int32(8)))

	return lengthInBits
}

func (m *_BACnetUnconfirmedServiceChoiceTagged) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetUnconfirmedServiceChoiceTaggedParse(ctx context.Context, theBytes []byte, tagNumber uint8, tagClass TagClass) (BACnetUnconfirmedServiceChoiceTagged, error) {
	return BACnetUnconfirmedServiceChoiceTaggedParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), tagNumber, tagClass)
}

func BACnetUnconfirmedServiceChoiceTaggedParseWithBufferProducer(tagNumber uint8, tagClass TagClass) func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetUnconfirmedServiceChoiceTagged, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetUnconfirmedServiceChoiceTagged, error) {
		return BACnetUnconfirmedServiceChoiceTaggedParseWithBuffer(ctx, readBuffer, tagNumber, tagClass)
	}
}

func BACnetUnconfirmedServiceChoiceTaggedParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, tagClass TagClass) (BACnetUnconfirmedServiceChoiceTagged, error) {
	v, err := (&_BACnetUnconfirmedServiceChoiceTagged{TagNumber: tagNumber, TagClass: tagClass}).parse(ctx, readBuffer, tagNumber, tagClass)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetUnconfirmedServiceChoiceTagged) parse(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, tagClass TagClass) (__bACnetUnconfirmedServiceChoiceTagged BACnetUnconfirmedServiceChoiceTagged, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetUnconfirmedServiceChoiceTagged"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetUnconfirmedServiceChoiceTagged")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	header, err := ReadSimpleField[BACnetTagHeader](ctx, "header", ReadComplex[BACnetTagHeader](BACnetTagHeaderParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'header' field"))
	}
	m.Header = header

	// Validation
	if !(bool((header.GetTagClass()) == (tagClass))) {
		return nil, errors.WithStack(utils.ParseValidationError{Message: "tag class doesn't match"})
	}

	// Validation
	if !(bool((bool((header.GetTagClass()) == (TagClass_APPLICATION_TAGS)))) || bool((bool((header.GetActualTagNumber()) == (tagNumber))))) {
		return nil, errors.WithStack(utils.ParseAssertError{Message: "tagnumber doesn't match"})
	}

	value, err := ReadManualField[BACnetUnconfirmedServiceChoice](ctx, "value", readBuffer, EnsureType[BACnetUnconfirmedServiceChoice](ReadEnumGenericFailing(ctx, readBuffer, header.GetActualLength(), BACnetUnconfirmedServiceChoice_I_AM)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'value' field"))
	}
	m.Value = value

	if closeErr := readBuffer.CloseContext("BACnetUnconfirmedServiceChoiceTagged"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetUnconfirmedServiceChoiceTagged")
	}

	return m, nil
}

func (m *_BACnetUnconfirmedServiceChoiceTagged) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetUnconfirmedServiceChoiceTagged) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetUnconfirmedServiceChoiceTagged"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetUnconfirmedServiceChoiceTagged")
	}

	if err := WriteSimpleField[BACnetTagHeader](ctx, "header", m.GetHeader(), WriteComplex[BACnetTagHeader](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'header' field")
	}

	if err := WriteManualField[BACnetUnconfirmedServiceChoice](ctx, "value", func(ctx context.Context) error { return WriteEnumGeneric(ctx, writeBuffer, m.GetValue()) }, writeBuffer); err != nil {
		return errors.Wrap(err, "Error serializing 'value' field")
	}

	if popErr := writeBuffer.PopContext("BACnetUnconfirmedServiceChoiceTagged"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetUnconfirmedServiceChoiceTagged")
	}
	return nil
}

////
// Arguments Getter

func (m *_BACnetUnconfirmedServiceChoiceTagged) GetTagNumber() uint8 {
	return m.TagNumber
}
func (m *_BACnetUnconfirmedServiceChoiceTagged) GetTagClass() TagClass {
	return m.TagClass
}

//
////

func (m *_BACnetUnconfirmedServiceChoiceTagged) IsBACnetUnconfirmedServiceChoiceTagged() {}

func (m *_BACnetUnconfirmedServiceChoiceTagged) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetUnconfirmedServiceChoiceTagged) deepCopy() *_BACnetUnconfirmedServiceChoiceTagged {
	if m == nil {
		return nil
	}
	_BACnetUnconfirmedServiceChoiceTaggedCopy := &_BACnetUnconfirmedServiceChoiceTagged{
		utils.DeepCopy[BACnetTagHeader](m.Header),
		m.Value,
		m.TagNumber,
		m.TagClass,
	}
	return _BACnetUnconfirmedServiceChoiceTaggedCopy
}

func (m *_BACnetUnconfirmedServiceChoiceTagged) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
