/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// TransportType is the corresponding interface of TransportType
type TransportType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetDirection returns Direction (property field)
	GetDirection() bool
	// GetTrigger returns Trigger (property field)
	GetTrigger() uint8
	// GetClassTransport returns ClassTransport (property field)
	GetClassTransport() uint8
	// IsTransportType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsTransportType()
	// CreateBuilder creates a TransportTypeBuilder
	CreateTransportTypeBuilder() TransportTypeBuilder
}

// _TransportType is the data-structure of this message
type _TransportType struct {
	Direction      bool
	Trigger        uint8
	ClassTransport uint8
}

var _ TransportType = (*_TransportType)(nil)

// NewTransportType factory function for _TransportType
func NewTransportType(direction bool, trigger uint8, classTransport uint8) *_TransportType {
	return &_TransportType{Direction: direction, Trigger: trigger, ClassTransport: classTransport}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// TransportTypeBuilder is a builder for TransportType
type TransportTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(direction bool, trigger uint8, classTransport uint8) TransportTypeBuilder
	// WithDirection adds Direction (property field)
	WithDirection(bool) TransportTypeBuilder
	// WithTrigger adds Trigger (property field)
	WithTrigger(uint8) TransportTypeBuilder
	// WithClassTransport adds ClassTransport (property field)
	WithClassTransport(uint8) TransportTypeBuilder
	// Build builds the TransportType or returns an error if something is wrong
	Build() (TransportType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() TransportType
}

// NewTransportTypeBuilder() creates a TransportTypeBuilder
func NewTransportTypeBuilder() TransportTypeBuilder {
	return &_TransportTypeBuilder{_TransportType: new(_TransportType)}
}

type _TransportTypeBuilder struct {
	*_TransportType

	collectedErr []error
}

var _ (TransportTypeBuilder) = (*_TransportTypeBuilder)(nil)

func (b *_TransportTypeBuilder) WithMandatoryFields(direction bool, trigger uint8, classTransport uint8) TransportTypeBuilder {
	return b.WithDirection(direction).WithTrigger(trigger).WithClassTransport(classTransport)
}

func (b *_TransportTypeBuilder) WithDirection(direction bool) TransportTypeBuilder {
	b.Direction = direction
	return b
}

func (b *_TransportTypeBuilder) WithTrigger(trigger uint8) TransportTypeBuilder {
	b.Trigger = trigger
	return b
}

func (b *_TransportTypeBuilder) WithClassTransport(classTransport uint8) TransportTypeBuilder {
	b.ClassTransport = classTransport
	return b
}

func (b *_TransportTypeBuilder) Build() (TransportType, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._TransportType.deepCopy(), nil
}

func (b *_TransportTypeBuilder) MustBuild() TransportType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_TransportTypeBuilder) DeepCopy() any {
	_copy := b.CreateTransportTypeBuilder().(*_TransportTypeBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateTransportTypeBuilder creates a TransportTypeBuilder
func (b *_TransportType) CreateTransportTypeBuilder() TransportTypeBuilder {
	if b == nil {
		return NewTransportTypeBuilder()
	}
	return &_TransportTypeBuilder{_TransportType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_TransportType) GetDirection() bool {
	return m.Direction
}

func (m *_TransportType) GetTrigger() uint8 {
	return m.Trigger
}

func (m *_TransportType) GetClassTransport() uint8 {
	return m.ClassTransport
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastTransportType(structType any) TransportType {
	if casted, ok := structType.(TransportType); ok {
		return casted
	}
	if casted, ok := structType.(*TransportType); ok {
		return *casted
	}
	return nil
}

func (m *_TransportType) GetTypeName() string {
	return "TransportType"
}

func (m *_TransportType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (direction)
	lengthInBits += 1

	// Simple field (trigger)
	lengthInBits += 3

	// Simple field (classTransport)
	lengthInBits += 4

	return lengthInBits
}

func (m *_TransportType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func TransportTypeParse(ctx context.Context, theBytes []byte) (TransportType, error) {
	return TransportTypeParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func TransportTypeParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (TransportType, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (TransportType, error) {
		return TransportTypeParseWithBuffer(ctx, readBuffer)
	}
}

func TransportTypeParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (TransportType, error) {
	v, err := (&_TransportType{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_TransportType) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__transportType TransportType, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("TransportType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for TransportType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	direction, err := ReadSimpleField(ctx, "direction", ReadBoolean(readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'direction' field"))
	}
	m.Direction = direction

	trigger, err := ReadSimpleField(ctx, "trigger", ReadUnsignedByte(readBuffer, uint8(3)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'trigger' field"))
	}
	m.Trigger = trigger

	classTransport, err := ReadSimpleField(ctx, "classTransport", ReadUnsignedByte(readBuffer, uint8(4)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'classTransport' field"))
	}
	m.ClassTransport = classTransport

	if closeErr := readBuffer.CloseContext("TransportType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for TransportType")
	}

	return m, nil
}

func (m *_TransportType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_TransportType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("TransportType"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for TransportType")
	}

	if err := WriteSimpleField[bool](ctx, "direction", m.GetDirection(), WriteBoolean(writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'direction' field")
	}

	if err := WriteSimpleField[uint8](ctx, "trigger", m.GetTrigger(), WriteUnsignedByte(writeBuffer, 3)); err != nil {
		return errors.Wrap(err, "Error serializing 'trigger' field")
	}

	if err := WriteSimpleField[uint8](ctx, "classTransport", m.GetClassTransport(), WriteUnsignedByte(writeBuffer, 4)); err != nil {
		return errors.Wrap(err, "Error serializing 'classTransport' field")
	}

	if popErr := writeBuffer.PopContext("TransportType"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for TransportType")
	}
	return nil
}

func (m *_TransportType) IsTransportType() {}

func (m *_TransportType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_TransportType) deepCopy() *_TransportType {
	if m == nil {
		return nil
	}
	_TransportTypeCopy := &_TransportType{
		m.Direction,
		m.Trigger,
		m.ClassTransport,
	}
	return _TransportTypeCopy
}

func (m *_TransportType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
