/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import java.util.HashMap;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum ErrorCode {
  ABORT_APDU_TOO_LONG((int) 123),
  ABORT_APPLICATION_EXCEEDED_REPLY_TIME((int) 124),
  ABORT_BUFFER_OVERFLOW((int) 51),
  ABORT_INSUFFICIENT_SECURITY((int) 135),
  ABORT_INVALID_APDU_IN_THIS_STATE((int) 52),
  ABORT_OTHER((int) 56),
  ABORT_OUT_OF_RESOURCES((int) 125),
  ABORT_PREEMPTED_BY_HIGHER_PRIORITY_TASK((int) 53),
  ABORT_PROPRIETARY((int) 55),
  ABORT_SECURITY_ERROR((int) 136),
  ABORT_SEGMENTATION_NOT_SUPPORTED((int) 54),
  ABORT_TSM_TIMEOUT((int) 126),
  ABORT_WINDOW_SIZE_OUT_OF_RANGE((int) 127),
  ACCESS_DENIED((int) 85),
  ADDRESSING_ERROR((int) 115),
  BAD_DESTINATION_ADDRESS((int) 86),
  BAD_DESTINATION_DEVICE_ID((int) 87),
  BAD_SIGNATURE((int) 88),
  BAD_SOURCE_ADDRESS((int) 89),
  BAD_TIMESTAMP((int) 90),
  Busy((int) 82),
  CANNOT_USE_KEY((int) 91),
  CANNOT_VERIFY_MESSAGE_ID((int) 92),
  CHARACTER_SET_NOT_SUPPORTED((int) 41),
  COMMUNICATION_DISABLED((int) 83),
  CONFIGURATION_IN_PROGRESS((int) 2),
  CORRECT_KEY_REVISION((int) 93),
  COV_SUBSCRIPTION_FAILED((int) 43),
  DATATYPE_NOT_SUPPORTED((int) 47),
  DELETE_FDT_ENTRY_FAILED((int) 120),
  DESTINATION_DEVICE_ID_REQUIRED((int) 94),
  DEVICE_BUSY((int) 3),
  DISTRIBUTE_BROADCAST_FAILED((int) 121),
  DUPLICATE_ENTRY((int) 137),
  DUPLICATE_MESSAGE((int) 95),
  DUPLICATE_NAME((int) 48),
  DUPLICATE_OBJECT_ID((int) 49),
  DYNAMIC_CREATION_NOT_SUPPORTED((int) 4),
  ENCRYPTION_NOT_CONFIGURED((int) 96),
  ENCRYPTION_REQUIRED((int) 97),
  FILE_ACCESS_DENIED((int) 5),
  FILE_FULL((int) 128),
  INCONSISTENT_CONFIGURATION((int) 129),
  INCONSISTENT_OBJECT_TYPE((int) 130),
  INCONSISTENT_PARAMETERS((int) 7),
  INCONSISTENT_SELECTION_CRITERION((int) 8),
  INCORRECT_KEY((int) 98),
  INTERNAL_ERROR((int) 131),
  INVALID_ARRAY_INDEX((int) 42),
  INVALID_CONFIGURATION_DATA((int) 46),
  INVALID_DATA_TYPE((int) 9),
  D_PARAMETER_DATA_TYPE((int) 13),
  INVALID_TAG((int) 57),
  INVALID_TIMESTAMP((int) 14),
  INVALID_VALUE_IN_THIS_STATE((int) 138),
  KEY_UPDATE_IN_PROGRESS((int) 100),
  LIST_ELEMENT_NOT_FOUND((int) 81),
  LOG_BUFFER_FULL((int) 75),
  LOGGED_VALUE_PURGED((int) 76),
  MALFORMED_MESSAGE((int) 101),
  MESSAGE_TOO_LONG((int) 113),
  MISSING_REQUIRED_PARAMETER((int) 16),
  NETWORK_DOWN((int) 58),
  NO_ALARM_CONFIGURED((int) 74),
  NO_OBJECTS_OF_SPECIFIED_TYPE((int) 17),
  NO_PROPERTY_SPECIFIED((int) 77),
  NO_SPACE_FOR_OBJECT((int) 18),
  NO_SPACE_TO_ADD_LIST_ELEMENT((int) 19),
  NO_SPACE_TO_WRITE_PROPERTY((int) 20),
  NO_VT_SESSIONS_AVAILABLE((int) 21),
  NOT_CONFIGURED((int) 132),
  NOT_CONFIGURED_FOR_TRIGGERED_LOGGING((int) 78),
  NOT_COV_PROPERTY((int) 44),
  NOT_KEY_SERVER((int) 102),
  NOT_ROUTER_TO_DNET((int) 110),
  OBJECT_DELETION_NOT_PERMITTED((int) 23),
  OBJECT_IDENTIFIER_ALREADY_EXISTS((int) 24),
  OPERATIONAL_PROBLEM((int) 25),
  OPTIONAL_FUNCTIONALITY_NOT_SUPPORTED((int) 45),
  OTHER((int) 0),
  OUT_OF_MEMORY((int) 133),
  PARAMETER_OUT_OF_RANGE((int) 80),
  PASSWORD_FAILURE((int) 26),
  PROPERTY_IS_NOT_A_LIST((int) 22),
  PROPERTY_IS_NOT_AN_ARRAY((int) 50),
  READ_ACCESS_DENIED((int) 27),
  READ_BDT_FAILED((int) 117),
  READ_FDT_FAILED((int) 119),
  REGISTER_FOREIGN_DEVICE_FAILED((int) 118),
  REJECT_BUFFER_OVERFLOW((int) 59),
  REJECT_INCONSISTENT_PARAMETERS((int) 60),
  REJECT_INVALID_PARAMETER_DATA_TYPE((int) 61),
  REJECT_INVALID_TAG((int) 62),
  REJECT_MISSING_REQUIRED_PARAMETER((int) 63),
  REJECT_OTHER((int) 69),
  REJECT_PARAMETER_OUT_OF_RANGE((int) 64),
  REJECT_PROPRIETARY((int) 68),
  REJECT_TOO_MANY_ARGUMENTS((int) 65),
  REJECT_UNDEFINED_ENUMERATION((int) 66),
  REJECT_UNRECOGNIZED_SERVICE((int) 67),
  ROUTER_BUSY((int) 111),
  SECURITY_ERROR((int) 114),
  SECURITY_NOT_CONFIGURED((int) 103),
  SERVICE_REQUEST_DENIED((int) 29),
  SOURCE_SECURITY_REQUIRED((int) 104),
  SUCCESS((int) 84),
  TIMEOUT((int) 30),
  TOO_MANY_KEYS((int) 105),
  UNKNOWN_AUTHENTICATION_TYPE((int) 106),
  UNKNOWN_DEVICE((int) 70),
  UNKNOWN_FILE_SIZE((int) 122),
  UNKNOWN_KEY((int) 107),
  UNKNOWN_KEY_REVISION((int) 108),
  UNKNOWN_NETWORK_MESSAGE((int) 112),
  UNKNOWN_OBJECT((int) 31),
  UNKNOWN_PROPERTY((int) 32),
  UNKNOWN_ROUTE((int) 71),
  UNKNOWN_SOURCE_MESSAGE((int) 109),
  UNKNOWN_SUBSCRIPTION((int) 79),
  UNKNOWN_VT_CLASS((int) 34),
  UNKNOWN_VT_SESSION((int) 35),
  UNSUPPORTED_OBJECT_TYPE((int) 36),
  VALUE_NOT_INITIALIZED((int) 72),
  VALUE_OUT_OF_RANGE((int) 37),
  VALUE_TOO_LONG((int) 134),
  VT_SESSION_ALREADY_CLOSED((int) 38),
  VT_SESSION_TERMINATION_FAILURE((int) 39),
  WRITE_ACCESS_DENIED((int) 40),
  WRITE_BDT_FAILED((int) 116),
  VENDOR_PROPRIETARY_VALUE((int) 0XFFFF);
  private static final Map<Integer, ErrorCode> map;

  static {
    map = new HashMap<>();
    for (ErrorCode value : ErrorCode.values()) {
      map.put((int) value.getValue(), value);
    }
  }

  private final int value;

  ErrorCode(int value) {
    this.value = value;
  }

  public int getValue() {
    return value;
  }

  public static ErrorCode enumForValue(int value) {
    return map.get(value);
  }

  public static Boolean isDefined(int value) {
    return map.containsKey(value);
  }
}
