/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.knxnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class ApduDataDeviceDescriptorRead extends ApduData implements Message {

  // Accessors for discriminator values.
  public Byte getApciType() {
    return (byte) 0xC;
  }

  // Properties.
  protected final byte descriptorType;

  public ApduDataDeviceDescriptorRead(byte descriptorType) {
    super();
    this.descriptorType = descriptorType;
  }

  public byte getDescriptorType() {
    return descriptorType;
  }

  @Override
  protected void serializeApduDataChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("ApduDataDeviceDescriptorRead");

    // Simple Field (descriptorType)
    writeSimpleField("descriptorType", descriptorType, writeUnsignedByte(writeBuffer, 6));

    writeBuffer.popContext("ApduDataDeviceDescriptorRead");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    ApduDataDeviceDescriptorRead _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (descriptorType)
    lengthInBits += 6;

    return lengthInBits;
  }

  public static ApduDataBuilder staticParseApduDataBuilder(ReadBuffer readBuffer, Short dataLength)
      throws ParseException {
    readBuffer.pullContext("ApduDataDeviceDescriptorRead");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    byte descriptorType = readSimpleField("descriptorType", readUnsignedByte(readBuffer, 6));

    readBuffer.closeContext("ApduDataDeviceDescriptorRead");
    // Create the instance
    return new ApduDataDeviceDescriptorReadBuilderImpl(descriptorType);
  }

  public static class ApduDataDeviceDescriptorReadBuilderImpl implements ApduData.ApduDataBuilder {
    private final byte descriptorType;

    public ApduDataDeviceDescriptorReadBuilderImpl(byte descriptorType) {
      this.descriptorType = descriptorType;
    }

    public ApduDataDeviceDescriptorRead build() {
      ApduDataDeviceDescriptorRead apduDataDeviceDescriptorRead =
          new ApduDataDeviceDescriptorRead(descriptorType);
      return apduDataDeviceDescriptorRead;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof ApduDataDeviceDescriptorRead)) {
      return false;
    }
    ApduDataDeviceDescriptorRead that = (ApduDataDeviceDescriptorRead) o;
    return (getDescriptorType() == that.getDescriptorType()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getDescriptorType());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
