/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.elasticsearch.Version;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.GeoCentroid;

public class InternalGeoCentroid
extends InternalAggregation
implements GeoCentroid {
    private final GeoPoint centroid;
    private final long count;

    public static long encodeLatLon(double lat, double lon) {
        return Integer.toUnsignedLong(GeoEncodingUtils.encodeLatitude((double)lat)) << 32 | Integer.toUnsignedLong(GeoEncodingUtils.encodeLongitude((double)lon));
    }

    public static double decodeLatitude(long encodedLatLon) {
        return GeoEncodingUtils.decodeLatitude((int)((int)(encodedLatLon >>> 32)));
    }

    public static double decodeLongitude(long encodedLatLon) {
        return GeoEncodingUtils.decodeLongitude((int)((int)(encodedLatLon & 0xFFFFFFFFL)));
    }

    public InternalGeoCentroid(String name, GeoPoint centroid, long count, Map<String, Object> metadata) {
        super(name, metadata);
        assert (centroid == null == (count == 0L));
        this.centroid = centroid;
        assert (count >= 0L);
        this.count = count;
    }

    public InternalGeoCentroid(StreamInput in) throws IOException {
        super(in);
        this.count = in.readVLong();
        if (in.readBoolean()) {
            if (in.getVersion().onOrAfter(Version.V_7_2_0)) {
                this.centroid = new GeoPoint(in.readDouble(), in.readDouble());
            } else {
                long hash = in.readLong();
                this.centroid = new GeoPoint(InternalGeoCentroid.decodeLatitude(hash), InternalGeoCentroid.decodeLongitude(hash));
            }
        } else {
            this.centroid = null;
        }
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeVLong(this.count);
        if (this.centroid != null) {
            out.writeBoolean(true);
            if (out.getVersion().onOrAfter(Version.V_7_2_0)) {
                out.writeDouble(this.centroid.lat());
                out.writeDouble(this.centroid.lon());
            } else {
                out.writeLong(InternalGeoCentroid.encodeLatLon(this.centroid.lat(), this.centroid.lon()));
            }
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public String getWriteableName() {
        return "geo_centroid";
    }

    @Override
    public GeoPoint centroid() {
        return this.centroid;
    }

    @Override
    public long count() {
        return this.count;
    }

    @Override
    public InternalGeoCentroid reduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        double lonSum = Double.NaN;
        double latSum = Double.NaN;
        long totalCount = 0L;
        for (InternalAggregation aggregation : aggregations) {
            InternalGeoCentroid centroidAgg = (InternalGeoCentroid)aggregation;
            if (centroidAgg.count <= 0L) continue;
            totalCount += centroidAgg.count;
            if (Double.isNaN(lonSum)) {
                lonSum = (double)centroidAgg.count * centroidAgg.centroid.getLon();
                latSum = (double)centroidAgg.count * centroidAgg.centroid.getLat();
                continue;
            }
            lonSum += (double)centroidAgg.count * centroidAgg.centroid.getLon();
            latSum += (double)centroidAgg.count * centroidAgg.centroid.getLat();
        }
        GeoPoint result = Double.isNaN(lonSum) ? null : new GeoPoint(latSum / (double)totalCount, lonSum / (double)totalCount);
        return new InternalGeoCentroid(this.name, result, totalCount, this.getMetadata());
    }

    @Override
    protected boolean mustReduceOnSingleInternalAgg() {
        return false;
    }

    @Override
    public Object getProperty(List<String> path) {
        if (path.isEmpty()) {
            return this;
        }
        if (path.size() == 1) {
            String coordinate;
            switch (coordinate = path.get(0)) {
                case "value": {
                    return this.centroid;
                }
                case "lat": {
                    return this.centroid.lat();
                }
                case "lon": {
                    return this.centroid.lon();
                }
                case "count": {
                    return this.count;
                }
            }
            throw new IllegalArgumentException("Found unknown path element [" + coordinate + "] in [" + this.getName() + "]");
        }
        throw new IllegalArgumentException("path not supported for [" + this.getName() + "]: " + path);
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.centroid != null) {
            builder.startObject(Fields.CENTROID.getPreferredName());
            builder.field(Fields.CENTROID_LAT.getPreferredName(), this.centroid.lat());
            builder.field(Fields.CENTROID_LON.getPreferredName(), this.centroid.lon());
            builder.endObject();
        }
        builder.field(Fields.COUNT.getPreferredName(), this.count);
        return builder;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalGeoCentroid that = (InternalGeoCentroid)obj;
        return this.count == that.count && Objects.equals(this.centroid, that.centroid);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.centroid, this.count);
    }

    @Override
    public String toString() {
        return "InternalGeoCentroid{centroid=" + this.centroid + ", count=" + this.count + '}';
    }

    static class Fields {
        static final ParseField CENTROID = new ParseField("location", new String[0]);
        static final ParseField COUNT = new ParseField("count", new String[0]);
        static final ParseField CENTROID_LAT = new ParseField("lat", new String[0]);
        static final ParseField CENTROID_LON = new ParseField("lon", new String[0]);

        Fields() {
        }
    }
}

