/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.conf;

import com.alipay.sofa.jraft.conf.ConfigurationEntry;
import com.alipay.sofa.jraft.util.Requires;
import java.util.LinkedList;
import java.util.ListIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationManager {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationManager.class);
    private final LinkedList<ConfigurationEntry> configurations = new LinkedList();
    private ConfigurationEntry snapshot = new ConfigurationEntry();

    public boolean add(ConfigurationEntry entry) {
        if (!this.configurations.isEmpty() && this.configurations.peekLast().getId().getIndex() >= entry.getId().getIndex()) {
            LOG.error("Did you forget to call truncateSuffix before the last log index goes back.");
            return false;
        }
        return this.configurations.add(entry);
    }

    public void truncatePrefix(long firstIndexKept) {
        while (!this.configurations.isEmpty() && this.configurations.peekFirst().getId().getIndex() < firstIndexKept) {
            this.configurations.pollFirst();
        }
    }

    public void truncateSuffix(long lastIndexKept) {
        while (!this.configurations.isEmpty() && this.configurations.peekLast().getId().getIndex() > lastIndexKept) {
            this.configurations.pollLast();
        }
    }

    public ConfigurationEntry getSnapshot() {
        return this.snapshot;
    }

    public void setSnapshot(ConfigurationEntry snapshot) {
        this.snapshot = snapshot;
    }

    public ConfigurationEntry getLastConfiguration() {
        if (this.configurations.isEmpty()) {
            return this.snapshot;
        }
        return this.configurations.peekLast();
    }

    public ConfigurationEntry get(long lastIncludedIndex) {
        if (this.configurations.isEmpty()) {
            Requires.requireTrue(lastIncludedIndex >= this.snapshot.getId().getIndex(), "lastIncludedIndex %d is less than snapshot index %d", lastIncludedIndex, this.snapshot.getId().getIndex());
            return this.snapshot;
        }
        ListIterator it = this.configurations.listIterator();
        while (it.hasNext()) {
            if (((ConfigurationEntry)it.next()).getId().getIndex() <= lastIncludedIndex) continue;
            it.previous();
            break;
        }
        if (it.hasPrevious()) {
            return (ConfigurationEntry)it.previous();
        }
        return this.snapshot;
    }
}

