/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.agent.core.advisor.config;

import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarFile;
import lombok.Generated;
import org.apache.shardingsphere.agent.core.advisor.config.AdvisorConfiguration;
import org.apache.shardingsphere.agent.core.advisor.config.yaml.loader.YamlAdvisorsConfigurationLoader;
import org.apache.shardingsphere.agent.core.advisor.config.yaml.swapper.YamlAdvisorsConfigurationSwapper;
import org.apache.shardingsphere.agent.core.plugin.classloader.AgentPluginClassLoader;

public final class AdvisorConfigurationLoader {
    public static Map<String, AdvisorConfiguration> load(Collection<JarFile> pluginJars, Collection<String> pluginTypes) {
        HashMap<String, AdvisorConfiguration> result = new HashMap<String, AdvisorConfiguration>();
        AgentPluginClassLoader agentPluginClassLoader = new AgentPluginClassLoader(Thread.currentThread().getContextClassLoader(), pluginJars);
        for (String each : pluginTypes) {
            InputStream advisorsResourceStream = AdvisorConfigurationLoader.getResourceStream(agentPluginClassLoader, each);
            if (null == advisorsResourceStream) continue;
            AdvisorConfigurationLoader.mergeConfigurations(result, YamlAdvisorsConfigurationSwapper.swap(YamlAdvisorsConfigurationLoader.load(advisorsResourceStream), each));
        }
        return result;
    }

    private static InputStream getResourceStream(ClassLoader pluginClassLoader, String pluginType) {
        return pluginClassLoader.getResourceAsStream(String.join((CharSequence)File.separator, "META-INF", "conf", AdvisorConfigurationLoader.getFileName(pluginType)));
    }

    private static String getFileName(String pluginType) {
        return String.join((CharSequence)"-", pluginType.toLowerCase(), "advisors.yaml");
    }

    private static void mergeConfigurations(Map<String, AdvisorConfiguration> advisorConfigMap, Collection<AdvisorConfiguration> toBeMergedAdvisorConfigs) {
        for (AdvisorConfiguration each : toBeMergedAdvisorConfigs) {
            advisorConfigMap.computeIfAbsent(each.getTargetClassName(), key -> new AdvisorConfiguration(each.getTargetClassName())).getAdvisors().addAll(each.getAdvisors());
        }
    }

    @Generated
    private AdvisorConfigurationLoader() {
    }
}

