/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.distsql.handler.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.aware.DistSQLExecutorRuleAware;
import org.apache.shardingsphere.distsql.handler.engine.query.DistSQLQueryExecutor;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.shadow.config.ShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.distsql.statement.ShowShadowTableRulesStatement;
import org.apache.shardingsphere.shadow.rule.ShadowRule;

public final class ShowShadowTableRulesExecutor
implements DistSQLQueryExecutor<ShowShadowTableRulesStatement>,
DistSQLExecutorRuleAware<ShadowRule> {
    private static final String SHADOW_TABLE = "shadow_table";
    private static final String SHADOW_ALGORITHM_NAME = "shadow_algorithm_name";
    private ShadowRule rule;

    public Collection<String> getColumnNames(ShowShadowTableRulesStatement sqlStatement) {
        return Arrays.asList(SHADOW_TABLE, SHADOW_ALGORITHM_NAME);
    }

    public Collection<LocalDataQueryResultRow> getRows(ShowShadowTableRulesStatement sqlStatement, ContextManager contextManager) {
        return this.buildData(this.rule.getConfiguration(), sqlStatement).stream().map(each -> new LocalDataQueryResultRow(new Object[]{each.get(SHADOW_TABLE), each.get(SHADOW_ALGORITHM_NAME)})).collect(Collectors.toList());
    }

    private Collection<Map<String, String>> buildData(ShadowRuleConfiguration ruleConfig, ShowShadowTableRulesStatement sqlStatement) {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        if (this.isSpecified(sqlStatement)) {
            ruleConfig.getTables().forEach((key, value) -> {
                HashMap<String, String> map = new HashMap<String, String>();
                if (key.equalsIgnoreCase(sqlStatement.getTableName())) {
                    map.put(SHADOW_TABLE, (String)key);
                    map.put(SHADOW_ALGORITHM_NAME, this.convertToString(value.getShadowAlgorithmNames()));
                }
                result.add(map);
            });
        } else {
            ruleConfig.getTables().forEach((key, value) -> {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(SHADOW_TABLE, (String)key);
                map.put(SHADOW_ALGORITHM_NAME, this.convertToString(value.getShadowAlgorithmNames()));
                result.add(map);
            });
        }
        return result;
    }

    private boolean isSpecified(ShowShadowTableRulesStatement sqlStatement) {
        return null != sqlStatement.getTableName() && !sqlStatement.getTableName().isEmpty();
    }

    private String convertToString(Collection<String> shadowTables) {
        return null == shadowTables ? "" : String.join((CharSequence)",", shadowTables);
    }

    public Class<ShadowRule> getRuleClass() {
        return ShadowRule.class;
    }

    public Class<ShowShadowTableRulesStatement> getType() {
        return ShowShadowTableRulesStatement.class;
    }

    @Generated
    public void setRule(ShadowRule rule) {
        this.rule = rule;
    }
}

