/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.datasource.xa;

import com.atomikos.datasource.RecoverableResource;
import com.atomikos.datasource.ResourceException;
import com.atomikos.datasource.ResourceTransaction;
import com.atomikos.datasource.TransactionalResource;
import com.atomikos.datasource.xa.DefaultXidFactory;
import com.atomikos.datasource.xa.SiblingMapper;
import com.atomikos.datasource.xa.XAExceptionHelper;
import com.atomikos.datasource.xa.XID;
import com.atomikos.datasource.xa.XidFactory;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.RecoveryService;
import com.atomikos.icatch.SysException;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.recovery.PendingTransactionRecord;
import com.atomikos.recovery.xa.XARecoveryManager;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Stack;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;

public abstract class XATransactionalResource
implements TransactionalResource {
    private static final Logger LOGGER = LoggerFactory.createLogger(XATransactionalResource.class);
    protected XAResource xares_;
    private String uniqueResourceName;
    private Hashtable<String, SiblingMapper> rootTransactionToSiblingMapperMap;
    private XidFactory xidFact;
    private boolean closed;
    private String branchIdentifier;
    private static final String MAX_LONG_STR = String.valueOf(Long.MAX_VALUE);
    private static final int MAX_LONG_LEN = MAX_LONG_STR.getBytes().length;

    public XATransactionalResource(String uniqueResourceName) {
        this.uniqueResourceName = uniqueResourceName;
        this.rootTransactionToSiblingMapperMap = new Hashtable();
        if (uniqueResourceName.getBytes().length > 64 - MAX_LONG_LEN) {
            throw new RuntimeException("Max length of resource name exceeded: should be less than " + (64 - MAX_LONG_LEN));
        }
        this.xidFact = new DefaultXidFactory();
        this.closed = false;
    }

    public XATransactionalResource(String uniqueResourceName, XidFactory factory) {
        this(uniqueResourceName);
        this.xidFact = factory;
    }

    protected abstract XAResource refreshXAConnection() throws ResourceException;

    public XidFactory getXidFactory() {
        return this.xidFact;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSiblingMap(String root) {
        Hashtable<String, SiblingMapper> hashtable = this.rootTransactionToSiblingMapperMap;
        synchronized (hashtable) {
            this.rootTransactionToSiblingMapperMap.remove(root);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SiblingMapper getSiblingMap(String root) {
        Hashtable<String, SiblingMapper> hashtable = this.rootTransactionToSiblingMapperMap;
        synchronized (hashtable) {
            if (this.rootTransactionToSiblingMapperMap.containsKey(root)) {
                return this.rootTransactionToSiblingMapperMap.get(root);
            }
            SiblingMapper map = new SiblingMapper(this, root);
            this.rootTransactionToSiblingMapperMap.put(root, map);
            return map;
        }
    }

    protected boolean needsRefresh() {
        boolean ret;
        block3: {
            ret = true;
            try {
                if (this.xares_ != null) {
                    this.xares_.isSameRM(this.xares_);
                    ret = false;
                }
            }
            catch (XAException xa) {
                if (!LOGGER.isTraceEnabled()) break block3;
                LOGGER.logTrace(this.uniqueResourceName + ": XAResource needs refresh?", (Throwable)xa);
            }
        }
        return ret;
    }

    public boolean usesXAResource(XAResource xares) {
        XAResource xaresource = this.getXAResource();
        if (xaresource == null) {
            return false;
        }
        boolean ret = false;
        if (!xares.getClass().getName().equals(xaresource.getClass().getName())) {
            ret = false;
        } else {
            try {
                if (xares.isSameRM(xaresource)) {
                    ret = true;
                } else {
                    LOGGER.logTrace("XAResources claim to be different: " + xares + " and " + xaresource);
                }
            }
            catch (XAException xe) {
                throw new SysException("Error in XAResource comparison: " + xe.getMessage(), (Throwable)xe);
            }
        }
        return ret;
    }

    public synchronized XAResource getXAResource() {
        if (this.needsRefresh()) {
            this.refreshXAResource();
        }
        return this.xares_;
    }

    public ResourceTransaction getResourceTransaction(CompositeTransaction ct) throws ResourceException, IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException("XATransactionResource already closed");
        }
        if (ct == null) {
            return null;
        }
        Stack lineage = ct.getLineage();
        String root = null;
        if (lineage == null || lineage.isEmpty()) {
            root = ct.getTid();
        } else {
            Stack tmp = (Stack)lineage.clone();
            while (!tmp.isEmpty()) {
                CompositeTransaction next = (CompositeTransaction)tmp.pop();
                if (!next.isRoot()) continue;
                root = next.getTid();
            }
        }
        return this.getSiblingMap(root).findOrCreateBranchForTransaction(ct);
    }

    public String getName() {
        return this.uniqueResourceName;
    }

    public void close() throws ResourceException {
        this.closed = true;
    }

    public boolean isClosed() throws ResourceException {
        return this.closed;
    }

    public boolean isSameRM(RecoverableResource res) throws ResourceException {
        if (res == null || !(res instanceof XATransactionalResource)) {
            return false;
        }
        XATransactionalResource xatxres = (XATransactionalResource)res;
        if (xatxres.uniqueResourceName == null || this.uniqueResourceName == null) {
            return false;
        }
        if (xatxres.uniqueResourceName.equals(this.uniqueResourceName)) {
            return true;
        }
        try {
            XAResource other;
            if (this.xares_ != null && (other = xatxres.getXAResource()) != null) {
                return this.xares_.isSameRM(other);
            }
        }
        catch (XAException e) {
            String msg = "Failed to compare XAResources";
            XAExceptionHelper.formatLogMessage(msg, e, "pessimistically assuming they are different");
        }
        return false;
    }

    public void setRecoveryService(RecoveryService recoveryService) throws ResourceException {
        if (recoveryService != null) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace("Installing recovery service on resource " + this.getName());
            }
            this.branchIdentifier = recoveryService.getName();
        }
    }

    public void setXidFactory(XidFactory factory) {
        this.xidFact = factory;
    }

    protected XID createXid(String tid) {
        if (this.branchIdentifier == null) {
            throw new IllegalStateException("Not yet initialized");
        }
        return this.getXidFactory().createXid(tid, this.branchIdentifier, this.uniqueResourceName);
    }

    public boolean recover(long startOfRecoveryScan, Collection<PendingTransactionRecord> expiredCommittingCoordinators, Collection<PendingTransactionRecord> indoubtForeignCoordinatorsToKeep) {
        boolean ret = false;
        XARecoveryManager xaResourceRecoveryManager = XARecoveryManager.getInstance();
        if (xaResourceRecoveryManager != null && this.getXAResource() != null) {
            try {
                ret = xaResourceRecoveryManager.recover(this.getXAResource(), startOfRecoveryScan, expiredCommittingCoordinators, indoubtForeignCoordinatorsToKeep, this.uniqueResourceName);
            }
            catch (Exception e) {
                LOGGER.logWarning(e.getMessage(), (Throwable)e);
                this.refreshXAResource();
            }
        }
        return ret;
    }

    private void refreshXAResource() {
        LOGGER.logTrace(this.uniqueResourceName + ": refreshing XAResource...");
        this.xares_ = this.refreshXAConnection();
        LOGGER.logInfo(this.uniqueResourceName + ": refreshed XAResource");
    }

    public boolean equals(Object o) {
        boolean ret = false;
        if (o instanceof RecoverableResource) {
            RecoverableResource other = (RecoverableResource)o;
            return other.isSameRM((RecoverableResource)this);
        }
        return ret;
    }

    public int hashCode() {
        return 0;
    }

    public boolean hasPendingParticipantsFromLastRecoveryScan() {
        return XARecoveryManager.getInstance().hasPendingXids(this.uniqueResourceName);
    }
}

