/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.DataSourcePoolProperties;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstanceContext;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.manager.GenericSchemaManager;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.rule.builder.global.GlobalRulesBuilder;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.MetaDataContextsFactory;
import org.apache.shardingsphere.mode.metadata.ShardingSphereStatisticsFactory;
import org.apache.shardingsphere.mode.metadata.manager.DatabaseRuleConfigurationManager;
import org.apache.shardingsphere.mode.metadata.manager.GlobalConfigurationManager;
import org.apache.shardingsphere.mode.metadata.manager.ResourceSwitchManager;
import org.apache.shardingsphere.mode.metadata.manager.RuleItemManager;
import org.apache.shardingsphere.mode.metadata.manager.SchemaMetaDataManager;
import org.apache.shardingsphere.mode.metadata.manager.ShardingSphereDatabaseDataManager;
import org.apache.shardingsphere.mode.metadata.manager.StorageUnitManager;
import org.apache.shardingsphere.mode.metadata.manager.SwitchingResource;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistService;
import org.apache.shardingsphere.mode.spi.repository.PersistRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDataContextManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetaDataContextManager.class);
    private final MetaDataContexts metaDataContexts;
    private final ComputeNodeInstanceContext computeNodeInstanceContext;
    private final ShardingSphereDatabaseDataManager databaseManager;
    private final SchemaMetaDataManager schemaMetaDataManager;
    private final RuleItemManager ruleItemManager;
    private final ResourceSwitchManager resourceSwitchManager;
    private final MetaDataPersistService metaDataPersistService;
    private final StorageUnitManager storageUnitManager;
    private final DatabaseRuleConfigurationManager databaseRuleConfigurationManager;
    private final GlobalConfigurationManager globalConfigurationManager;

    public MetaDataContextManager(MetaDataContexts metaDataContexts, ComputeNodeInstanceContext computeNodeInstanceContext, PersistRepository repository) {
        this.metaDataContexts = metaDataContexts;
        this.computeNodeInstanceContext = computeNodeInstanceContext;
        this.resourceSwitchManager = new ResourceSwitchManager();
        this.databaseManager = new ShardingSphereDatabaseDataManager(metaDataContexts);
        this.storageUnitManager = new StorageUnitManager(metaDataContexts, computeNodeInstanceContext, repository, this.resourceSwitchManager);
        this.databaseRuleConfigurationManager = new DatabaseRuleConfigurationManager(metaDataContexts, computeNodeInstanceContext, repository);
        this.schemaMetaDataManager = new SchemaMetaDataManager(metaDataContexts, repository);
        this.ruleItemManager = new RuleItemManager(metaDataContexts, repository, this.databaseRuleConfigurationManager);
        this.globalConfigurationManager = new GlobalConfigurationManager(metaDataContexts, repository);
        this.metaDataPersistService = new MetaDataPersistService(repository);
    }

    public void dropSchemas(String databaseName, ShardingSphereDatabase reloadDatabase, ShardingSphereDatabase currentDatabase) {
        GenericSchemaManager.getToBeDroppedSchemaNames((ShardingSphereDatabase)reloadDatabase, (ShardingSphereDatabase)currentDatabase).forEach(each -> this.metaDataPersistService.getDatabaseMetaDataFacade().getSchema().drop(databaseName, (String)each));
    }

    public void renewMetaDataContexts(MetaDataContexts metaDataContexts) {
        this.metaDataContexts.update(metaDataContexts);
    }

    public void forceRefreshDatabaseMetaData(ShardingSphereDatabase database) {
        try {
            this.metaDataContexts.update(this.createMetaDataContexts(database));
            this.metaDataContexts.getMetaData().getDatabase(database.getName()).getAllSchemas().forEach(each -> {
                if (each.isEmpty()) {
                    this.metaDataPersistService.getDatabaseMetaDataFacade().getSchema().add(database.getName(), each.getName());
                }
                this.metaDataPersistService.getDatabaseMetaDataFacade().getTable().persist(database.getName(), each.getName(), each.getAllTables());
            });
        }
        catch (SQLException ex) {
            log.error("Refresh database meta data: {} failed", (Object)database.getName(), (Object)ex);
        }
    }

    public void refreshTableMetaData(ShardingSphereDatabase database) {
        try {
            MetaDataContexts reloadedMetaDataContexts = this.createMetaDataContexts(database);
            this.dropSchemas(database.getName(), reloadedMetaDataContexts.getMetaData().getDatabase(database.getName()), database);
            this.metaDataContexts.update(reloadedMetaDataContexts);
            this.metaDataContexts.getMetaData().getDatabase(database.getName()).getAllSchemas().forEach(each -> this.metaDataPersistService.getDatabaseMetaDataFacade().getSchema().alterByRefresh(database.getName(), (ShardingSphereSchema)each));
        }
        catch (SQLException ex) {
            log.error("Refresh table meta data: {} failed", (Object)database.getName(), (Object)ex);
        }
    }

    private MetaDataContexts createMetaDataContexts(ShardingSphereDatabase database) throws SQLException {
        Map<String, DataSourcePoolProperties> dataSourcePoolPropsFromRegCenter = this.metaDataPersistService.getDataSourceUnitService().load(database.getName());
        SwitchingResource switchingResource = this.resourceSwitchManager.switchByAlterStorageUnit(database.getResourceMetaData(), dataSourcePoolPropsFromRegCenter);
        Collection<RuleConfiguration> ruleConfigs = this.metaDataPersistService.getDatabaseRulePersistService().load(database.getName());
        ShardingSphereDatabase changedDatabase = MetaDataContextsFactory.createChangedDatabase(database.getName(), false, switchingResource, ruleConfigs, this.metaDataContexts, this.metaDataPersistService, this.computeNodeInstanceContext);
        this.metaDataContexts.getMetaData().putDatabase(changedDatabase);
        ConfigurationProperties props = new ConfigurationProperties(this.metaDataPersistService.getPropsService().load());
        Collection<RuleConfiguration> globalRuleConfigs = this.metaDataPersistService.getGlobalRuleService().load();
        RuleMetaData changedGlobalMetaData = new RuleMetaData(GlobalRulesBuilder.buildRules(globalRuleConfigs, (Collection)this.metaDataContexts.getMetaData().getAllDatabases(), (ConfigurationProperties)props));
        ShardingSphereMetaData metaData = new ShardingSphereMetaData(this.metaDataContexts.getMetaData().getAllDatabases(), this.metaDataContexts.getMetaData().getGlobalResourceMetaData(), changedGlobalMetaData, props);
        MetaDataContexts result = new MetaDataContexts(metaData, ShardingSphereStatisticsFactory.create(this.metaDataPersistService, metaData));
        switchingResource.closeStaleDataSources();
        return result;
    }

    @Generated
    public MetaDataContexts getMetaDataContexts() {
        return this.metaDataContexts;
    }

    @Generated
    public ComputeNodeInstanceContext getComputeNodeInstanceContext() {
        return this.computeNodeInstanceContext;
    }

    @Generated
    public ShardingSphereDatabaseDataManager getDatabaseManager() {
        return this.databaseManager;
    }

    @Generated
    public SchemaMetaDataManager getSchemaMetaDataManager() {
        return this.schemaMetaDataManager;
    }

    @Generated
    public RuleItemManager getRuleItemManager() {
        return this.ruleItemManager;
    }

    @Generated
    public ResourceSwitchManager getResourceSwitchManager() {
        return this.resourceSwitchManager;
    }

    @Generated
    public MetaDataPersistService getMetaDataPersistService() {
        return this.metaDataPersistService;
    }

    @Generated
    public StorageUnitManager getStorageUnitManager() {
        return this.storageUnitManager;
    }

    @Generated
    public DatabaseRuleConfigurationManager getDatabaseRuleConfigurationManager() {
        return this.databaseRuleConfigurationManager;
    }

    @Generated
    public GlobalConfigurationManager getGlobalConfigurationManager() {
        return this.globalConfigurationManager;
    }
}

