/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.ral.queryable;

import java.util.Collection;
import java.util.Collections;
import org.apache.shardingsphere.distsql.handler.aware.DistSQLExecutorDatabaseAware;
import org.apache.shardingsphere.distsql.handler.engine.query.DistSQLQueryExecutor;
import org.apache.shardingsphere.distsql.statement.ral.queryable.export.ExportDatabaseConfigurationStatement;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.proxy.backend.util.DatabaseExportMetaDataGenerator;
import org.apache.shardingsphere.proxy.backend.util.ExportUtils;

public final class ExportDatabaseConfigurationExecutor
implements DistSQLQueryExecutor<ExportDatabaseConfigurationStatement>,
DistSQLExecutorDatabaseAware {
    private ShardingSphereDatabase database;

    public Collection<String> getColumnNames(ExportDatabaseConfigurationStatement sqlStatement) {
        return Collections.singleton("result");
    }

    public Collection<LocalDataQueryResultRow> getRows(ExportDatabaseConfigurationStatement sqlStatement, ContextManager contextManager) {
        String exportedData = new DatabaseExportMetaDataGenerator(this.database).generateYAMLFormat();
        if (sqlStatement.getFilePath().isPresent()) {
            String filePath = (String)sqlStatement.getFilePath().get();
            ExportUtils.exportToFile(filePath, exportedData);
            return Collections.singleton(new LocalDataQueryResultRow(new Object[]{String.format("Successfully exported to: '%s'", filePath)}));
        }
        return Collections.singleton(new LocalDataQueryResultRow(new Object[]{exportedData}));
    }

    public void setDatabase(ShardingSphereDatabase database) {
        this.database = database;
    }

    public Class<ExportDatabaseConfigurationStatement> getType() {
        return ExportDatabaseConfigurationStatement.class;
    }
}

