/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.context.statement.ddl;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.segment.table.TablesContext;
import org.apache.shardingsphere.infra.binder.context.statement.CommonSQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.IndexAvailable;
import org.apache.shardingsphere.infra.binder.context.type.TableAvailable;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.AlterIndexStatement;

public final class AlterIndexStatementContext
extends CommonSQLStatementContext
implements TableAvailable,
IndexAvailable {
    private final TablesContext tablesContext;

    public AlterIndexStatementContext(AlterIndexStatement sqlStatement) {
        super((SQLStatement)sqlStatement);
        SimpleTableSegment simpleTableSegment = sqlStatement.getSimpleTable().orElse(null);
        this.tablesContext = new TablesContext(simpleTableSegment);
    }

    public AlterIndexStatement getSqlStatement() {
        return (AlterIndexStatement)super.getSqlStatement();
    }

    @Override
    public Collection<IndexSegment> getIndexes() {
        LinkedList<IndexSegment> result = new LinkedList<IndexSegment>();
        if (this.getSqlStatement().getIndex().isPresent()) {
            result.add((IndexSegment)this.getSqlStatement().getIndex().get());
        }
        this.getSqlStatement().getRenameIndex().ifPresent(result::add);
        return result;
    }

    @Override
    public Collection<ColumnSegment> getIndexColumns() {
        return Collections.emptyList();
    }

    @Override
    @Generated
    public TablesContext getTablesContext() {
        return this.tablesContext;
    }
}

