/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.instance;

import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import lombok.Generated;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstance;

public final class ClusterInstanceRegistry {
    private final Collection<ComputeNodeInstance> allClusterInstances = new CopyOnWriteArrayList<ComputeNodeInstance>();

    public Optional<ComputeNodeInstance> find(String instanceId) {
        return this.allClusterInstances.stream().filter(each -> instanceId.equals(each.getMetaData().getId())).findFirst();
    }

    public void add(ComputeNodeInstance instance) {
        this.allClusterInstances.removeIf(each -> each.getMetaData().getId().equalsIgnoreCase(instance.getMetaData().getId()));
        this.allClusterInstances.add(instance);
    }

    public void delete(ComputeNodeInstance instance) {
        this.allClusterInstances.removeIf(each -> each.getMetaData().getId().equalsIgnoreCase(instance.getMetaData().getId()));
    }

    @Generated
    public Collection<ComputeNodeInstance> getAllClusterInstances() {
        return this.allClusterInstances;
    }
}

