/*
 * Decompiled with CFR 0.152.
 */
package relocated_for_contentpackage.org.apache.http.impl.execchain;

import java.io.IOException;
import java.io.InterruptedIOException;
import relocated_for_contentpackage.org.apache.commons.logging.Log;
import relocated_for_contentpackage.org.apache.commons.logging.LogFactory;
import relocated_for_contentpackage.org.apache.http.Header;
import relocated_for_contentpackage.org.apache.http.HttpException;
import relocated_for_contentpackage.org.apache.http.annotation.Contract;
import relocated_for_contentpackage.org.apache.http.annotation.ThreadingBehavior;
import relocated_for_contentpackage.org.apache.http.client.ServiceUnavailableRetryStrategy;
import relocated_for_contentpackage.org.apache.http.client.methods.CloseableHttpResponse;
import relocated_for_contentpackage.org.apache.http.client.methods.HttpExecutionAware;
import relocated_for_contentpackage.org.apache.http.client.methods.HttpRequestWrapper;
import relocated_for_contentpackage.org.apache.http.client.protocol.HttpClientContext;
import relocated_for_contentpackage.org.apache.http.conn.routing.HttpRoute;
import relocated_for_contentpackage.org.apache.http.impl.execchain.ClientExecChain;
import relocated_for_contentpackage.org.apache.http.impl.execchain.RequestEntityProxy;
import relocated_for_contentpackage.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class ServiceUnavailableRetryExec
implements ClientExecChain {
    private final Log log = LogFactory.getLog(this.getClass());
    private final ClientExecChain requestExecutor;
    private final ServiceUnavailableRetryStrategy retryStrategy;

    public ServiceUnavailableRetryExec(ClientExecChain requestExecutor, ServiceUnavailableRetryStrategy retryStrategy) {
        Args.notNull(requestExecutor, "HTTP request executor");
        Args.notNull(retryStrategy, "Retry strategy");
        this.requestExecutor = requestExecutor;
        this.retryStrategy = retryStrategy;
    }

    @Override
    public CloseableHttpResponse execute(HttpRoute route, HttpRequestWrapper request, HttpClientContext context, HttpExecutionAware execAware) throws IOException, HttpException {
        Header[] origheaders = request.getAllHeaders();
        int c = 1;
        while (true) {
            CloseableHttpResponse response = this.requestExecutor.execute(route, request, context, execAware);
            try {
                if (this.retryStrategy.retryRequest(response, c, context) && RequestEntityProxy.isRepeatable(request)) {
                    response.close();
                    long nextInterval = this.retryStrategy.getRetryInterval();
                    if (nextInterval > 0L) {
                        try {
                            this.log.trace("Wait for " + nextInterval);
                            Thread.sleep(nextInterval);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new InterruptedIOException();
                        }
                    }
                } else {
                    return response;
                }
                request.setHeaders(origheaders);
            }
            catch (RuntimeException ex) {
                response.close();
                throw ex;
            }
            ++c;
        }
    }
}

