/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.lineage;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.apache.commons.lang3.tuple.MutableTriple;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.parser.DataIdentifier;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.instructions.Instruction;
import org.apache.sysds.runtime.instructions.cp.ComputationCPInstruction;
import org.apache.sysds.runtime.instructions.cp.Data;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.lineage.LineageCacheConfig;
import org.apache.sysds.runtime.lineage.LineageEstimatorEntry;
import org.apache.sysds.runtime.lineage.LineageEstimatorStatistics;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.utils.stats.InfrastructureAnalyzer;

public class LineageEstimator {
    private static final Map<LineageItem, LineageEstimatorEntry> _cache = new HashMap<LineageItem, LineageEstimatorEntry>();
    private static final Map<String, MutableTriple<String, Long, Double>> _savedPerOP = new HashMap<String, MutableTriple<String, Long, Double>>();
    protected static long _startTimestamp;
    protected static long _cachesize;
    protected static long _cacheFullCount;
    protected static long _totReusableSize;
    protected static long _totReusedSize;
    private static final double CACHE_FRAC = 0.05;
    protected static long CACHE_LIMIT;
    private static Comparator<MutableTriple<String, Long, Double>> savedOPComparator;
    protected static PriorityQueue<MutableTriple<String, Long, Double>> computeSavingInst;

    public static void processSingleInst(Instruction inst, ExecutionContext ec, long starttime) {
        if (!(inst instanceof ComputationCPInstruction)) {
            return;
        }
        long computetime = System.nanoTime() - starttime;
        ComputationCPInstruction cinst = (ComputationCPInstruction)inst;
        LineageItem li = (LineageItem)cinst.getLineageItem(ec).getValue();
        boolean isReusable = LineageCacheConfig.isReusable(inst, ec);
        Data data = ec.getVariable(((ComputationCPInstruction)inst).output);
        long datasize = 0L;
        if (data instanceof MatrixObject) {
            datasize = ((MatrixBlock)((MatrixObject)data).acquireReadAndRelease()).getInMemorySize();
        } else if (data instanceof ScalarObject) {
            datasize = ((ScalarObject)data).getSize();
        } else {
            return;
        }
        LineageEstimator.probePutValue(li, computetime, datasize, isReusable);
    }

    public static void stopEstimator(List<DataIdentifier> outputs, LineageItem[] liInputs, String name) {
        boolean allOutputsCached = true;
        for (int i = 0; i < outputs.size(); ++i) {
            String opcode = name + "%" + String.valueOf(i + 1);
            LineageItem li = new LineageItem(opcode, liInputs);
            if (_cache.containsKey(li)) continue;
            allOutputsCached = false;
        }
        if (allOutputsCached) {
            DMLScript.LINEAGE_ESTIMATE = false;
        }
    }

    public static void processFunc(List<DataIdentifier> outputs, LineageItem[] liInputs, String name, ExecutionContext ec, long computetime) {
        DMLScript.LINEAGE_ESTIMATE = true;
        for (int i = 0; i < outputs.size(); ++i) {
            String opcode = name + "%" + String.valueOf(i + 1);
            LineageItem li = new LineageItem(opcode, liInputs);
            String boundVarName = outputs.get(i).getName();
            LineageItem boundLI = ec.getLineage().get(boundVarName);
            if (boundLI != null) {
                boundLI.resetVisitStatusNR();
            }
            if (boundLI == null) continue;
            Data data = ec.getVariable(boundVarName);
            long datasize = 0L;
            if (data instanceof MatrixObject) {
                datasize = ((MatrixBlock)((MatrixObject)data).acquireReadAndRelease()).getInMemorySize();
            } else if (data instanceof ScalarObject) {
                datasize = ((ScalarObject)data).getSize();
            } else {
                return;
            }
            LineageEstimator.probePutValue(li, computetime, datasize, true);
        }
    }

    private static void probePutValue(LineageItem li, long computetime, long datasize, boolean isReusable) {
        if (_cache.containsKey(li)) {
            LineageEstimatorEntry ee = _cache.get(li);
            LineageEstimatorStatistics.incrementSavedComputeTime(ee.computeTime);
            if (isReusable && ee.reuseCount == 0L) {
                _totReusedSize += ee.memsize;
            }
            ee.updateStats();
            if (_savedPerOP.containsKey(LineageEstimator.getOpcode(li))) {
                MutableTriple<String, Long, Double> op = _savedPerOP.get(LineageEstimator.getOpcode(li));
                computeSavingInst.remove(op);
                op.setRight((Object)((Double)op.getRight() + (double)ee.computeTime * 1.0E-6));
                op.setMiddle((Object)((Long)op.getMiddle() + 1L));
                computeSavingInst.add(op);
            }
            return;
        }
        LineageEstimatorEntry ee = new LineageEstimatorEntry(li, computetime, datasize);
        _cache.put(li, ee);
        _cachesize += datasize;
        if (!_savedPerOP.containsKey(LineageEstimator.getOpcode(li))) {
            _savedPerOP.put(LineageEstimator.getOpcode(li), (MutableTriple<String, Long, Double>)MutableTriple.of((Object)LineageEstimator.getOpcode(li), (Object)0L, (Object)0.0));
            computeSavingInst.add((MutableTriple<String, Long, Double>)MutableTriple.of((Object)LineageEstimator.getOpcode(li), (Object)0L, (Object)0.0));
        }
        if (isReusable) {
            _totReusableSize += ee.memsize;
        }
        if (_cacheFullCount == 0L && _cachesize >= CACHE_LIMIT) {
            _cacheFullCount = _cache.size();
        }
    }

    private static String getOpcode(LineageItem li) {
        String opcode = li.getOpcode();
        if (opcode.indexOf("%") == -1) {
            return opcode;
        }
        return opcode.substring(0, opcode.indexOf("%"));
    }

    public static int computeCacheFullTime() {
        double d = (double)_cacheFullCount / (double)_cache.size() * 100.0;
        return (int)d;
    }

    public static void resetEstimatorCache() {
        _cache.clear();
        _savedPerOP.clear();
        _cachesize = 0L;
        _cacheFullCount = 0L;
        _totReusableSize = 0L;
        _totReusedSize = 0L;
    }

    static {
        _cachesize = 0L;
        _cacheFullCount = 0L;
        _totReusableSize = 0L;
        _totReusedSize = 0L;
        savedOPComparator = (op1, op2) -> op1.getRight() == op2.getRight() ? 0 : ((Double)op1.getRight() < (Double)op2.getRight() ? 1 : -1);
        computeSavingInst = new PriorityQueue<MutableTriple<String, Long, Double>>(savedOPComparator);
        long maxMem = InfrastructureAnalyzer.getLocalMaxMemory();
        CACHE_LIMIT = (long)(0.05 * (double)maxMem);
        _startTimestamp = System.currentTimeMillis();
    }
}

