/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.checkpoint;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.checkpoint.CheckpointID;
import org.apache.hadoop.mapreduce.checkpoint.CheckpointNamingService;
import org.apache.hadoop.mapreduce.checkpoint.CheckpointService;
import org.apache.hadoop.mapreduce.checkpoint.FSCheckpointID;

public class FSCheckpointService
implements CheckpointService {
    private final Path base;
    private final FileSystem fs;
    private final CheckpointNamingService namingPolicy;
    private final short replication;

    public FSCheckpointService(FileSystem fs, Path base, CheckpointNamingService namingPolicy, short replication) {
        this.fs = fs;
        this.base = base;
        this.namingPolicy = namingPolicy;
        this.replication = replication;
    }

    @Override
    public CheckpointService.CheckpointWriteChannel create() throws IOException {
        String name = this.namingPolicy.getNewName();
        Path p = new Path(name);
        if (p.isUriPathAbsolute()) {
            throw new IOException("Checkpoint cannot be an absolute path");
        }
        return this.createInternal(new Path(this.base, p));
    }

    CheckpointService.CheckpointWriteChannel createInternal(Path name) throws IOException {
        return new FSCheckpointWriteChannel(name, this.fs.create(FSCheckpointService.tmpfile(name), this.replication));
    }

    @Override
    public CheckpointService.CheckpointReadChannel open(CheckpointID id) throws IOException, InterruptedException {
        if (!(id instanceof FSCheckpointID)) {
            throw new IllegalArgumentException("Mismatched checkpoint type: " + id.getClass());
        }
        return new FSCheckpointReadChannel(this.fs.open(((FSCheckpointID)id).getPath()));
    }

    @Override
    public CheckpointID commit(CheckpointService.CheckpointWriteChannel ch) throws IOException, InterruptedException {
        FSCheckpointWriteChannel hch;
        Path dst;
        if (ch.isOpen()) {
            ch.close();
        }
        if (!this.fs.rename(FSCheckpointService.tmpfile(dst = (hch = (FSCheckpointWriteChannel)ch).getDestination()), dst)) {
            this.abort(ch);
            throw new IOException("Failed to promote checkpoint" + FSCheckpointService.tmpfile(dst) + " -> " + dst);
        }
        return new FSCheckpointID(hch.getDestination());
    }

    @Override
    public void abort(CheckpointService.CheckpointWriteChannel ch) throws IOException {
        if (ch.isOpen()) {
            ch.close();
        }
        FSCheckpointWriteChannel hch = (FSCheckpointWriteChannel)ch;
        Path tmp = FSCheckpointService.tmpfile(hch.getDestination());
        try {
            if (!this.fs.delete(tmp, false)) {
                throw new IOException("Failed to delete checkpoint during abort");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public boolean delete(CheckpointID id) throws IOException, InterruptedException {
        if (!(id instanceof FSCheckpointID)) {
            throw new IllegalArgumentException("Mismatched checkpoint type: " + id.getClass());
        }
        Path tmp = ((FSCheckpointID)id).getPath();
        try {
            return this.fs.delete(tmp, false);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return true;
        }
    }

    static final Path tmpfile(Path p) {
        return new Path(p.getParent(), p.getName() + ".tmp");
    }

    private static class FSCheckpointReadChannel
    implements CheckpointService.CheckpointReadChannel {
        private boolean isOpen = true;
        private final ReadableByteChannel in;

        FSCheckpointReadChannel(FSDataInputStream in) {
            this.in = Channels.newChannel((InputStream)in);
        }

        @Override
        public int read(ByteBuffer bb) throws IOException {
            return this.in.read(bb);
        }

        @Override
        public void close() throws IOException {
            this.isOpen = false;
            this.in.close();
        }

        @Override
        public boolean isOpen() {
            return this.isOpen;
        }
    }

    private static class FSCheckpointWriteChannel
    implements CheckpointService.CheckpointWriteChannel {
        private boolean isOpen = true;
        private final Path finalDst;
        private final WritableByteChannel out;

        FSCheckpointWriteChannel(Path finalDst, FSDataOutputStream out) {
            this.finalDst = finalDst;
            this.out = Channels.newChannel((OutputStream)out);
        }

        @Override
        public int write(ByteBuffer b) throws IOException {
            return this.out.write(b);
        }

        public Path getDestination() {
            return this.finalDst;
        }

        @Override
        public void close() throws IOException {
            this.isOpen = false;
            this.out.close();
        }

        @Override
        public boolean isOpen() {
            return this.isOpen;
        }
    }
}

