/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.shuffle;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.tez.runtime.library.common.InputAttemptIdentifier;
import org.apache.tez.runtime.library.common.shuffle.FetchedInputCallback;

@InterfaceAudience.Private
public abstract class FetchedInput {
    private static AtomicInteger ID_GEN = new AtomicInteger(0);
    private InputAttemptIdentifier inputAttemptIdentifier;
    private final FetchedInputCallback callback;
    private final int id;
    private byte state;

    protected FetchedInput(InputAttemptIdentifier inputAttemptIdentifier, FetchedInputCallback callbackHandler) {
        this.inputAttemptIdentifier = inputAttemptIdentifier;
        this.callback = callbackHandler;
        this.id = ID_GEN.getAndIncrement();
        this.state = (byte)State.PENDING.ordinal();
    }

    public abstract Type getType();

    protected boolean isState(State state) {
        return this.state == (byte)state.ordinal();
    }

    protected void setState(State state) {
        this.state = (byte)state.ordinal();
    }

    protected State getState() {
        if (this.isState(State.PENDING)) {
            return State.PENDING;
        }
        if (this.isState(State.COMMITTED)) {
            return State.COMMITTED;
        }
        if (this.isState(State.ABORTED)) {
            return State.ABORTED;
        }
        if (this.isState(State.FREED)) {
            return State.FREED;
        }
        return null;
    }

    protected int getId() {
        return this.id;
    }

    public abstract long getSize();

    public InputAttemptIdentifier getInputAttemptIdentifier() {
        return this.inputAttemptIdentifier;
    }

    public void notifyFetchComplete() {
        this.callback.fetchComplete(this);
    }

    public void notifyFetchFailure() {
        this.callback.fetchFailed(this);
    }

    public void notifyFreedResource() {
        this.callback.freeResources(this);
    }

    public abstract OutputStream getOutputStream() throws IOException;

    public abstract InputStream getInputStream() throws IOException;

    public abstract void commit() throws IOException;

    public abstract void abort() throws IOException;

    public abstract void free();

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FetchedInput other = (FetchedInput)obj;
        return this.id == other.id;
    }

    protected static enum State {
        PENDING,
        COMMITTED,
        ABORTED,
        FREED;

    }

    public static enum Type {
        WAIT,
        MEMORY,
        DISK,
        DISK_DIRECT;

    }
}

