/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.analyzer.plugins;

import java.util.Comparator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.tez.analyzer.Analyzer;
import org.apache.tez.analyzer.CSVResult;
import org.apache.tez.analyzer.Result;
import org.apache.tez.analyzer.plugins.TezAnalyzerBase;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.history.parser.datamodel.DagInfo;
import org.apache.tez.history.parser.datamodel.Event;
import org.apache.tez.history.parser.datamodel.TaskAttemptInfo;
import org.apache.tez.history.parser.datamodel.VertexInfo;

public class InputReadErrorAnalyzer
extends TezAnalyzerBase
implements Analyzer {
    private final String[] headers = new String[]{"vertex:attempt", "status", "time", "node", "diagnostics"};
    private final CSVResult csvResult = new CSVResult(this.headers);

    public InputReadErrorAnalyzer(Configuration config) {
        super(config);
    }

    @Override
    public void analyze(DagInfo dagInfo) throws TezException {
        for (VertexInfo vertex : dagInfo.getVertices()) {
            for (TaskAttemptInfo attempt : vertex.getTaskAttempts()) {
                String terminationCause = attempt.getTerminationCause();
                if (!"INPUT_READ_ERROR".equalsIgnoreCase(terminationCause) && !"OUTPUT_LOST".equalsIgnoreCase(terminationCause) && !"NODE_FAILED".equalsIgnoreCase(terminationCause)) continue;
                for (Event event : attempt.getEvents()) {
                    if (!event.getType().equalsIgnoreCase("TASK_ATTEMPT_FINISHED")) continue;
                    this.csvResult.addRecord(new String[]{vertex.getVertexName() + ":" + attempt.getTaskAttemptId(), attempt.getDetailedStatus(), String.valueOf(event.getTime()), attempt.getNodeId(), attempt.getDiagnostics().replaceAll(",", " ").replaceAll("\n", " ")});
                }
            }
        }
        this.csvResult.sort(new Comparator<String[]>(){

            @Override
            public int compare(String[] first, String[] second) {
                return (int)(Long.parseLong(second[2]) - Long.parseLong(first[2]));
            }
        });
    }

    @Override
    public Result getResult() throws TezException {
        return this.csvResult;
    }

    @Override
    public String getName() {
        return "Input read error analyzer";
    }

    @Override
    public String getDescription() {
        return "Prints every task attempt (with node) which are related to input read errors";
    }

    public static void main(String[] args) throws Exception {
        Configuration config = new Configuration();
        InputReadErrorAnalyzer analyzer = new InputReadErrorAnalyzer(config);
        int res = ToolRunner.run((Configuration)config, (Tool)analyzer, (String[])args);
        analyzer.printResults();
        System.exit(res);
    }
}

