/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.netcdf.base;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.sis.referencing.operation.builder.LocalizationGridBuilder;
import org.apache.sis.storage.netcdf.base.Linearizer;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.util.FactoryException;

final class GridCacheValue {
    final MathTransform gridToCRS;
    final Linearizer.Type linearizationType;
    final SingleCRS linearizationTarget;
    final boolean axisSwap;

    GridCacheValue(Set<Linearizer> linearizers, LocalizationGridBuilder grid, MathTransformFactory factory) throws FactoryException {
        this.gridToCRS = grid.create(factory);
        Optional<Map.Entry<String, MathTransform>> e = grid.linearizer(true);
        if (e.isPresent()) {
            String name = e.get().getKey();
            for (Linearizer linearizer : linearizers) {
                if (!name.equals(linearizer.name())) continue;
                this.linearizationType = linearizer.type;
                this.linearizationTarget = linearizer.getTargetCRS();
                this.axisSwap = linearizer.axisSwap();
                return;
            }
        }
        this.linearizationType = null;
        this.linearizationTarget = null;
        this.axisSwap = false;
    }
}

