/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.filter;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.computer.MemoryComputeKey;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.Barrier;
import org.apache.tinkerpop.gremlin.process.traversal.step.Bypassing;
import org.apache.tinkerpop.gremlin.process.traversal.step.GValue;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.RangeGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.AbstractStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.util.TraverserSet;
import org.apache.tinkerpop.gremlin.process.traversal.util.FastNoSuchElementException;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public final class TailGlobalStep<S>
extends AbstractStep<S, S>
implements Bypassing,
Barrier<TraverserSet<S>> {
    private final GValue<Long> limit;
    private Deque<Traverser.Admin<S>> tail;
    private long tailBulk = 0L;
    private boolean bypass = false;

    public TailGlobalStep(Traversal.Admin traversal, long limit) {
        this(traversal, GValue.ofLong(null, limit));
    }

    public TailGlobalStep(Traversal.Admin traversal, GValue<Long> limit) {
        super(traversal);
        this.limit = limit;
        this.tail = new ArrayDeque<Traverser.Admin<S>>(limit.get().intValue());
    }

    @Override
    public void setBypass(boolean bypass) {
        this.bypass = bypass;
    }

    @Override
    public Traverser.Admin<S> processNextStart() {
        if (this.bypass) {
            return this.starts.next();
        }
        if (this.starts.hasNext()) {
            this.starts.forEachRemaining(this::addTail);
        }
        Traverser.Admin<S> oldest = this.tail.pop();
        long excess = this.tailBulk - this.limit.get();
        if (excess > 0L) {
            oldest.setBulk(oldest.bulk() - excess);
            this.tailBulk -= excess;
        }
        this.tailBulk -= oldest.bulk();
        return oldest;
    }

    @Override
    public void reset() {
        super.reset();
        this.tail.clear();
        this.tailBulk = 0L;
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.limit.get());
    }

    @Override
    public TailGlobalStep<S> clone() {
        TailGlobalStep clone = (TailGlobalStep)super.clone();
        clone.tail = new ArrayDeque<Traverser.Admin<S>>(this.limit.get().intValue());
        clone.tailBulk = 0L;
        return clone;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ Long.hashCode(this.limit.get());
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return Collections.singleton(TraverserRequirement.BULK);
    }

    private void addTail(Traverser.Admin<S> start) {
        Traverser.Admin<S> oldest;
        long bulk;
        this.tailBulk += start.bulk();
        while (!this.tail.isEmpty() && this.tailBulk - (bulk = (oldest = this.tail.getFirst()).bulk()) >= this.limit.get()) {
            this.tail.pop();
            this.tailBulk -= bulk;
        }
        this.tail.add(start);
    }

    @Override
    public MemoryComputeKey<TraverserSet<S>> getMemoryComputeKey() {
        return MemoryComputeKey.of(this.getId(), new RangeGlobalStep.RangeBiOperator(this.limit.get()), false, true);
    }

    @Override
    public void processAllStarts() {
    }

    @Override
    public boolean hasNextBarrier() {
        return this.starts.hasNext();
    }

    @Override
    public TraverserSet<S> nextBarrier() throws NoSuchElementException {
        if (!this.starts.hasNext()) {
            throw FastNoSuchElementException.instance();
        }
        TraverserSet barrier = this.traversal.getTraverserSetSupplier().get();
        while (this.starts.hasNext()) {
            barrier.add(this.starts.next());
        }
        return barrier;
    }

    @Override
    public void addBarrier(TraverserSet<S> barrier) {
        IteratorUtils.removeOnNext(barrier.iterator()).forEachRemaining(traverser -> {
            traverser.setSideEffects(this.getTraversal().getSideEffects());
            this.addStart(traverser);
        });
    }
}

