/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.checksums.internal;

import java.util.zip.Checksum;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.checksums.internal.BaseCrcChecksum;
import software.amazon.awssdk.crt.checksums.CRC64NVME;
import software.amazon.awssdk.utils.DependencyValidate;
import software.amazon.awssdk.utils.NumericUtils;

@SdkInternalApi
public final class Crc64NvmeChecksum
extends BaseCrcChecksum {
    private static final String CRT_CRC64NVME_PATH = "software.amazon.awssdk.crt.checksums.CRC64NVME";
    private static final String CRT_MODULE = "software.amazon.awssdk.crt:aws-crt";

    public Crc64NvmeChecksum() {
        super((Checksum)Crc64NvmeChecksum.getCrc64Nvme());
    }

    private static CRC64NVME getCrc64Nvme() {
        DependencyValidate.requireClass((String)CRT_CRC64NVME_PATH, (String)CRT_MODULE, (String)"CRC64NVME");
        return new CRC64NVME();
    }

    @Override
    public Checksum cloneChecksum(Checksum checksum) {
        if (checksum instanceof CRC64NVME) {
            return (Checksum)((CRC64NVME)checksum).clone();
        }
        throw new IllegalStateException("Unsupported checksum");
    }

    @Override
    public byte[] getChecksumBytes() {
        return NumericUtils.longToByte((Long)this.getChecksum().getValue());
    }
}

