/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.binary.types;

import java.io.IOException;
import java.util.function.Function;
import org.apache.tinkerpop.gremlin.process.traversal.Merge;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.DataType;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.SimpleTypeSerializer;

public class EnumSerializer<E extends Enum>
extends SimpleTypeSerializer<E> {
    public static final EnumSerializer<Direction> DirectionSerializer = new EnumSerializer<Direction>(DataType.DIRECTION, Direction::valueOf);
    public static final EnumSerializer<T> TSerializer = new EnumSerializer<T>(DataType.T, T::valueOf);
    public static final EnumSerializer<Merge> MergeSerializer = new EnumSerializer<Merge>(DataType.MERGE, Merge::valueOf);
    private final Function<String, E> readFunc;

    private EnumSerializer(DataType dataType, Function<String, E> readFunc) {
        super(dataType);
        this.readFunc = readFunc;
    }

    @Override
    protected E readValue(Buffer buffer, GraphBinaryReader context) throws IOException {
        return (E)((Enum)this.readFunc.apply((String)context.read(buffer)));
    }

    @Override
    protected void writeValue(E value, Buffer buffer, GraphBinaryWriter context) throws IOException {
        context.write(((Enum)value).name(), buffer);
    }
}

