/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.component.creation;

import jakarta.enterprise.event.Observes;
import jakarta.enterprise.event.ObservesAsync;
import jakarta.enterprise.inject.Disposes;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.AnnotatedField;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedParameter;
import jakarta.enterprise.inject.spi.AnnotatedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import org.apache.webbeans.component.ProducerFieldBean;
import org.apache.webbeans.component.ProducerMethodBean;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.util.GenericsUtil;

public abstract class AbstractBeanBuilder<T> {
    protected void validateNoDisposerWithoutProducer(Set<AnnotatedMethod<? super T>> annotatedMethods, Set<ProducerMethodBean<?>> producerBeans, Set<ProducerFieldBean<?>> producerFields, Collection<AnnotatedMethod<?>> ignoredProducers) {
        block0: for (AnnotatedMethod<T> annotatedMethod : annotatedMethods) {
            for (AnnotatedParameter param : annotatedMethod.getParameters()) {
                if (!param.isAnnotationPresent(Disposes.class)) continue;
                boolean found = false;
                for (ProducerMethodBean<?> producerMethodBean : producerBeans) {
                    if (!GenericsUtil.satisfiesDependency(false, true, producerMethodBean.getCreatorMethod().getGenericReturnType(), param.getBaseType(), new HashMap<Type, Integer>())) continue;
                    found = true;
                    break;
                }
                if (found) continue block0;
                for (ProducerFieldBean producerFieldBean : producerFields) {
                    if (!GenericsUtil.satisfiesDependency(false, true, producerFieldBean.getCreatorField().getType(), param.getBaseType(), new HashMap<Type, Integer>())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    for (AnnotatedMethod annotatedMethod2 : ignoredProducers) {
                        if (!GenericsUtil.satisfiesDependency(false, true, annotatedMethod2.getJavaMember().getGenericReturnType(), param.getBaseType(), new HashMap<Type, Integer>())) continue;
                        found = true;
                        break;
                    }
                }
                if (found) continue block0;
                throw new WebBeansConfigurationException("@Disposes without @Produces " + annotatedMethod.getJavaMember());
            }
        }
    }

    protected void validateNoProducerOrObserverMethod(AnnotatedType<T> annotatedType) {
        Set annotatedMethods = annotatedType.getMethods();
        for (AnnotatedMethod annotatedMethod : annotatedMethods) {
            if (annotatedMethod.isAnnotationPresent(Produces.class)) {
                throw new WebBeansConfigurationException("This class must not have a @Produces method" + annotatedMethod.getJavaMember());
            }
            for (AnnotatedParameter parameter : annotatedMethod.getParameters()) {
                if (!parameter.isAnnotationPresent(Observes.class) && !parameter.isAnnotationPresent(ObservesAsync.class)) continue;
                throw new WebBeansConfigurationException("This class must not have an @Observes nor @ObservesAsync method " + annotatedMethod.getJavaMember());
            }
        }
        Set annotatedFields = annotatedType.getFields();
        for (AnnotatedField annotatedField : annotatedFields) {
            if (!annotatedField.isAnnotationPresent(Produces.class)) continue;
            throw new WebBeansConfigurationException("This class must not have a @Produces field" + annotatedField.getJavaMember());
        }
    }
}

