/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.services.callback;

import jakarta.batch.operations.JobOperator;
import jakarta.batch.runtime.JobExecution;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.batchee.container.exception.BatchContainerRuntimeException;
import org.apache.batchee.container.impl.jobinstance.RuntimeJobExecution;
import org.apache.batchee.spi.JobExecutionCallbackService;
import org.apache.batchee.util.Batches;

public class SimpleJobExecutionCallbackService
implements JobExecutionCallbackService {
    private final ConcurrentMap<Long, Collection<CountDownLatch>> waiters = new ConcurrentHashMap<Long, Collection<CountDownLatch>>();

    @Override
    public void onJobExecutionDone(RuntimeJobExecution jobExecution) {
        Collection toRealease = (Collection)this.waiters.remove(jobExecution.getExecutionId());
        if (toRealease != null) {
            for (CountDownLatch latch : toRealease) {
                latch.countDown();
            }
        }
    }

    @Override
    public void waitFor(JobOperator jobOperator, long id) {
        Collection<CountDownLatch> toRelease = (CopyOnWriteArrayList<CountDownLatch>)this.waiters.get(id);
        if (toRelease == null) {
            toRelease = new CopyOnWriteArrayList<CountDownLatch>();
            Collection existing = this.waiters.putIfAbsent(id, toRelease);
            if (existing != null) {
                toRelease = existing;
            }
        }
        if (this.checkIsDone(jobOperator, id)) {
            return;
        }
        CountDownLatch latch = new CountDownLatch(1);
        toRelease.add(latch);
        try {
            while (!latch.await(1L, TimeUnit.SECONDS)) {
                if (!this.checkIsDone(jobOperator, id)) continue;
                return;
            }
            this.waiters.remove(id);
        }
        catch (InterruptedException e) {
            throw new BatchContainerRuntimeException(e);
        }
    }

    @Override
    public void init(Properties batchConfig) {
    }

    private boolean checkIsDone(JobOperator jobOperator, long id) {
        JobExecution finalCheckExec = jobOperator.getJobExecution(id);
        if (finalCheckExec != null && Batches.isDone(finalCheckExec.getBatchStatus())) {
            this.waiters.remove(id);
            return true;
        }
        return false;
    }
}

