/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Code generated by informer-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	time "time"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"

	unifflev1alpha1 "github.com/apache/incubator-uniffle/deploy/kubernetes/operator/api/uniffle/v1alpha1"
	versioned "github.com/apache/incubator-uniffle/deploy/kubernetes/operator/pkg/generated/clientset/versioned"
	internalinterfaces "github.com/apache/incubator-uniffle/deploy/kubernetes/operator/pkg/generated/informers/externalversions/internalinterfaces"
	v1alpha1 "github.com/apache/incubator-uniffle/deploy/kubernetes/operator/pkg/generated/listers/uniffle/v1alpha1"
)

// RemoteShuffleServiceInformer provides access to a shared informer and lister for
// RemoteShuffleServices.
type RemoteShuffleServiceInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() v1alpha1.RemoteShuffleServiceLister
}

type remoteShuffleServiceInformer struct {
	factory          internalinterfaces.SharedInformerFactory
	tweakListOptions internalinterfaces.TweakListOptionsFunc
	namespace        string
}

// NewRemoteShuffleServiceInformer constructs a new informer for RemoteShuffleService type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewRemoteShuffleServiceInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredRemoteShuffleServiceInformer(client, namespace, resyncPeriod, indexers, nil)
}

// NewFilteredRemoteShuffleServiceInformer constructs a new informer for RemoteShuffleService type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredRemoteShuffleServiceInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions internalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.UniffleV1alpha1().RemoteShuffleServices(namespace).List(context.TODO(), options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.UniffleV1alpha1().RemoteShuffleServices(namespace).Watch(context.TODO(), options)
			},
		},
		&unifflev1alpha1.RemoteShuffleService{},
		resyncPeriod,
		indexers,
	)
}

func (f *remoteShuffleServiceInformer) defaultInformer(client versioned.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredRemoteShuffleServiceInformer(client, f.namespace, resyncPeriod, cache.Indexers{cache.NamespaceIndex: cache.MetaNamespaceIndexFunc}, f.tweakListOptions)
}

func (f *remoteShuffleServiceInformer) Informer() cache.SharedIndexInformer {
	return f.factory.InformerFor(&unifflev1alpha1.RemoteShuffleService{}, f.defaultInformer)
}

func (f *remoteShuffleServiceInformer) Lister() v1alpha1.RemoteShuffleServiceLister {
	return v1alpha1.NewRemoteShuffleServiceLister(f.Informer().GetIndexer())
}
