/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.storage.handler.impl;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.uniffle.common.ShuffleDataDistributionType;
import org.apache.uniffle.common.ShuffleDataResult;
import org.apache.uniffle.common.ShuffleDataSegment;
import org.apache.uniffle.common.ShuffleIndexResult;
import org.apache.uniffle.common.segment.SegmentSplitterFactory;
import org.apache.uniffle.storage.handler.impl.AbstractClientReadHandler;
import org.roaringbitmap.longlong.Roaring64NavigableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DataSkippableReadHandler
extends AbstractClientReadHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DataSkippableReadHandler.class);
    protected List<ShuffleDataSegment> shuffleDataSegments = Lists.newArrayList();
    protected int segmentIndex = 0;
    protected Roaring64NavigableMap expectBlockIds;
    protected Roaring64NavigableMap processBlockIds;
    protected ShuffleDataDistributionType distributionType;
    protected Roaring64NavigableMap expectTaskIds;

    public DataSkippableReadHandler(String appId, int shuffleId, int partitionId, int readBufferSize, Roaring64NavigableMap expectBlockIds, Roaring64NavigableMap processBlockIds, ShuffleDataDistributionType distributionType, Roaring64NavigableMap expectTaskIds) {
        this.appId = appId;
        this.shuffleId = shuffleId;
        this.partitionId = partitionId;
        this.readBufferSize = readBufferSize;
        this.expectBlockIds = expectBlockIds;
        this.processBlockIds = processBlockIds;
        this.distributionType = distributionType;
        this.expectTaskIds = expectTaskIds;
    }

    protected abstract ShuffleIndexResult readShuffleIndex();

    protected abstract ShuffleDataResult readShuffleData(ShuffleDataSegment var1);

    @Override
    public ShuffleDataResult readShuffleData() {
        if (this.shuffleDataSegments.isEmpty()) {
            ShuffleIndexResult shuffleIndexResult = this.readShuffleIndex();
            if (shuffleIndexResult == null || shuffleIndexResult.isEmpty()) {
                return null;
            }
            this.shuffleDataSegments = SegmentSplitterFactory.getInstance().get(this.distributionType, this.expectTaskIds, this.readBufferSize).split(shuffleIndexResult);
        }
        ShuffleDataResult result = null;
        while (this.segmentIndex < this.shuffleDataSegments.size()) {
            ShuffleDataSegment segment = this.shuffleDataSegments.get(this.segmentIndex);
            Roaring64NavigableMap blocksOfSegment = Roaring64NavigableMap.bitmapOf((long[])new long[0]);
            segment.getBufferSegments().forEach(block -> blocksOfSegment.addLong(block.getBlockId()));
            blocksOfSegment.and(this.expectBlockIds);
            if (!blocksOfSegment.isEmpty()) {
                blocksOfSegment.or(this.processBlockIds);
                blocksOfSegment.xor(this.processBlockIds);
                if (!blocksOfSegment.isEmpty()) {
                    result = this.readShuffleData(segment);
                    ++this.segmentIndex;
                    break;
                }
            }
            ++this.segmentIndex;
        }
        return result;
    }
}

