{$A+,B-,D-,E-,F-,I+,L-,N-,O-,R-,S-,V+}
{$M 2000,0,655360}
program Expand;

(*
expands packed words in ISPELL format to multiple words

Words in SPELL's main dictionary (but not the other dictionaries) may
have flags associated with them to indicate the legality of suffixes
without the need to keep the full suffixed words in the dictionary. The
flags have `names' consisting of single letters. Their meaning is as
follows:

Let # and @ be `variables' that can stand for any letter. Upper case
letters are constants. `...' stands for any string of zero or more
letters, but note that no word may exist in the dictionary which is not
at least 2 letters long, so, for example, FLY may not be produced by
placing the `Y' flag on `F'. Also, no flag is effective unless the word
that it creates is at least 4 letters long, so, for example, WED may not
be produced by placing the `D' flag on `W'.

`D' flag:
        ...E --> ...ED  as in CREATE --> CREATED
        if @ .ne. A, E, I, O, or U,
                ...@Y --> ...@IED  as in IMPLY --> IMPLIED
        if # .ne. E or Y, or (# = Y and @ = A, E, I, O, or U)
                ...@# --> ...@#ED  as in CROSS --> CROSSED
                                or CONVEY --> CONVEYED

`G' flag:
        ...E --> ...ING  as in FILE --> FILING
        if # .ne. E, ...# --> ...#ING  as in CROSS --> CROSSING

`H' flag:
        ...Y --> ...IETH  as in TWENTY --> TWENTIETH
     6   if # .ne. Y, ...# --> ...#TH  as in HUNDRED --> HUNDREDTH

`J' flag:
        ...E --> ...INGS  as in FILE --> FILINGS
        if # .ne. E, ...# --> ...#INGS  as in CROSS --> CROSSINGS

`M' flag:
        ... --> ...'S  as in DOG --> DOG'S

`N' flag:
        ...E --> ...ION  as in CREATE --> CREATION
        ...Y --> ...ICATION  as in MULTIPLY --> MULTIPLICATION
        if # .ne. E or Y, ...# --> ...#EN  as in FALL --> FALLEN

`P' flag:
        if @ .ne. A, E, I, O, or U,
                ...@Y --> ...@INESS  as in CLOUDY --> CLOUDINESS
        if # .ne. Y, or @ = A, E, I, O, or U,
                ...@# --> ...@#NESS  as in LATE --> LATENESS
                                or GRAY --> GRAYNESS

`R' flag:
        ...E --> ...ER  as in SKATE --> SKATER
        if @ .ne. A, E, I, O, or U,
                ...@Y --> ...@IER  as in MULTIPLY --> MULTIPLIER
        if # .ne. E or Y, or (# = Y and @ = A, E, I, O, or U)
                ...@# --> ...@#ER  as in BUILD --> BUILDER
                                or CONVEY --> CONVEYER

`S' flag:
        if @ .ne. A, E, I, O, or U,
                ...@Y --> ...@IES  as in IMPLY --> IMPLIES
        if # .eq. S, X, Z, or H,
                ...# --> ...#ES  as in FIX --> FIXES
        if # .ne. S, X, Z, H, or Y, or (# = Y and @ = A, E, I, O, or U)
                ...@# --> ...@#S  as in BAT --> BATS
                                or CONVEY --> CONVEYS

`T' flag:
        ...E --> ...EST  as in LATE --> LATEST
        if @ .ne. A, E, I, O, or U,
                ...@Y --> ...@IEST  as in DIRTY --> DIRTIEST
        if # .ne. E or Y, or (# = Y and @ = A, E, I, O, or U)
                ...@# --> ...@#EST  as in SMALL --> SMALLEST
                                or GRAY --> GRAYEST

`V' flag:
        ...E --> ...IVE  as in CREATE --> CREATIVE
        if # .ne. E, ...# --> ...#IVE  as in PREVENT --> PREVENTIVE

`X' flag:
        ...E --> ...IONS  as in CREATE --> CREATIONS
        ...Y --> ...ICATIONS  as in MULTIPLY --> MULTIPLICATIONS
        if # .ne. E or Y, ...# --> ...#ENS  as in WEAK --> WEAKENS

`Y' flag:
        ... --> ...LY  as in QUICK --> QUICKLY

`Z' flag:
        ...E --> ...ERS  as in SKATE --> SKATERS
        if @ .ne. A, E, I, O, or U,
                ...@Y --> ...@IERS  as in MULTIPLY --> MULTIPLIERS
        if # .ne. E or Y, or (# = Y and @ = A, E, I, O, or U)
                ...@# --> ...@#ERS  as in BUILD --> BUILDERS
                                or SLAY --> SLAYERS

*)

var
  gv_Input,
  gv_Output    : text;
  gv_Word,
  gv_CurWord,
  gv_Options   : string;
  gv_InCount,
  gv_OutCount,
  gv_SlashPos  : word;
  gv_Debug     : boolean;

const
  gs_Vowels   : set of char = ['a','e','i','o','u'];

procedure Message (pc_Message : string);
begin
Write (^G, 'Error: ', pc_Message, ' -', gv_Options [1], '- ');
WriteLn ('at -', gv_Word, '-')
end;

procedure LowerCase (var pv_Word : string);
var
  i : word;
begin
for i := 1 to Length (pv_Word) do
  if pv_Word [i] in ['A'..'Z'] then
    pv_Word [i] := Char (Byte (pv_Word [i]) + 32)
end;

procedure Strip;
begin
Dec (gv_CurWord [0])
end;

procedure Add (pc_Add : string);
begin
gv_CurWord := gv_CurWord + pc_Add
end;

procedure MakeWords;
var
  lv_X,
  lv_Y     : char;
  lv_Error : word;
begin
WriteLn (gv_Output, gv_Word);
Inc (gv_OutCount);
lv_X := gv_Word [Length (gv_Word) - 1];
lv_Y := gv_Word [Length (gv_Word)];
while Length (gv_Options) > 0 do
  begin
  gv_CurWord := gv_Word;
  lv_Error := 0;
  if gv_Debug then
    Write (gv_Output, gv_Options [1], '-');
  case gv_Options [1] of
  'd' :
    if lv_Y = 'e' then
      Add ('d')
    else
      if (lv_Y = 'y') and (not (lv_X in gs_Vowels)) then
        begin
        Strip;
        Add ('ied')
        end
      else
        Add ('ed');
  'g' :
    begin
    if lv_Y = 'e' then
      Strip;
    Add ('ing')
    end;
  'h' :
    if lv_Y = 'y' then
      begin
      Strip;
      Add ('ieth')
      end
    else
      Add ('th');
  'j' :
    begin
    if lv_Y = 'e' then
      Strip;
    Add ('ings')
    end;
  'm' :
    Add ('''s');
  'n':
    if lv_Y in ['e','y'] then
      begin
      Strip;
      Add ('ion')
      end
    else
      Add ('en');
  'p' :
    begin
    if lv_Y = 'y' then
      if not (lv_X in gs_Vowels) then
        gv_CurWord [Length (gv_CurWord)] := 'i';
    Add ('ness')
    end;
  'r' :
    if lv_Y = 'e' then
      Add ('r')
    else
      if (not (lv_X in gs_Vowels)) and
         (lv_Y = 'y') then
        begin
        Strip;
        Add ('ier')
        end
      else
        Add ('er');
  's' :
    if (lv_Y = 'y') and (not (lv_X in gs_Vowels)) then
      begin
      Strip;
      Add ('ies')
      end
    else
      if lv_Y in ['s','x','z','h'] then
        Add ('es')
      else
        Add ('s');
  't' :
    if lv_Y = 'e' then
      Add ('est')
    else
      if lv_Y = 'y' then
        if not (lv_X in gs_Vowels) then
          begin
          Strip;
          Add ('iest')
          end
        else
          Add ('est');
  'v' :
    begin
    if lv_Y = 'e' then
      Strip;
    Add ('ive')
    end;
  'x' :
    if lv_Y in ['e','y'] then
      begin
      Strip;
      Add ('ions')
      end
    else
      Add ('ens');
  'y' :
    Add ('ly');
  'z' :
    if lv_Y = 'e' then
      Add ('rs')
    else
      if (lv_Y = 'y') and (not (lv_X in gs_Vowels)) then
        begin
        Strip;
        Add ('iers')
        end
      else
        Add ('ers');
  else
    lv_Error := 1
  end; { case }
  if (lv_Error = 0) and (gv_CurWord = gv_Word) then
    lv_Error := 2;
  case lv_Error of
  0 :
    begin
    WriteLn (gv_Output, gv_CurWord);
    Inc (gv_OutCount)
    end;
  1 :
    Message ('Unknown code');
  2 :
    Message ('Ineffective code');
  end;
  gv_Options := Copy (gv_Options, 2, 255);
  end { while }
end;

begin
Assign (gv_Input, Paramstr (1));
Reset (gv_Input);
Assign (gv_Output, Paramstr (2));
Rewrite (gv_Output);
gv_Debug := ParamStr (3) <> '';
gv_InCount := 0;
gv_OutCount := 0;
if gv_Debug then
  WriteLn (gv_Output, '<=== ', ParamStr (1), ' ===> ', ParamStr (2));
while not Eof (gv_Input) do
  begin
  gv_Options := '';
  ReadLn (gv_Input, gv_Word);
  Inc (gv_InCount);
  LowerCase (gv_Word);
  gv_SlashPos := Pos ('/', gv_Word);
  if gv_SlashPos > 0 then
    begin
    gv_Options := Copy (gv_Word, gv_SlashPos + 1, 255);
    gv_Word := Copy (gv_Word, 1, gv_SlashPos - 1)
    end;
  MakeWords
  end;
Close (gv_Output);
Close (gv_Input);
WriteLn (gv_InCount, ' words read from ', ParamStr (1));
WriteLn (gv_OutCount, ' words written to ', ParamStr (2))
end.