/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bib2gls;

import com.dickimawbooks.bib2gls.Bib2GlsAdapter;
import com.dickimawbooks.bib2gls.Bib2GlsBibParser;
import com.dickimawbooks.bib2gls.Bib2GlsEntry;
import com.dickimawbooks.bib2gls.Bib2GlsException;
import com.dickimawbooks.bib2gls.Bib2GlsMessages;
import com.dickimawbooks.bib2gls.Bib2GlsPadNDigits;
import com.dickimawbooks.bib2gls.Bib2GlsSyntaxException;
import com.dickimawbooks.bib2gls.BibGlsContributor;
import com.dickimawbooks.bib2gls.BibGlsDateTime;
import com.dickimawbooks.bib2gls.BibGlsDefinitionIndex;
import com.dickimawbooks.bib2gls.BibGlsUseIndex;
import com.dickimawbooks.bib2gls.CompoundEntry;
import com.dickimawbooks.bib2gls.EnableTagging;
import com.dickimawbooks.bib2gls.FlattenedPostSort;
import com.dickimawbooks.bib2gls.FlattenedPreSort;
import com.dickimawbooks.bib2gls.GlsCombinedSep;
import com.dickimawbooks.bib2gls.GlsDisp;
import com.dickimawbooks.bib2gls.GlsEntryFieldValue;
import com.dickimawbooks.bib2gls.GlsEntryParentName;
import com.dickimawbooks.bib2gls.GlsHierName;
import com.dickimawbooks.bib2gls.GlsHyperLink;
import com.dickimawbooks.bib2gls.GlsIfHasKey;
import com.dickimawbooks.bib2gls.GlsLike;
import com.dickimawbooks.bib2gls.GlsLikeFamily;
import com.dickimawbooks.bib2gls.GlsRecord;
import com.dickimawbooks.bib2gls.GlsRecordNameRef;
import com.dickimawbooks.bib2gls.GlsRecordNameRefSelection;
import com.dickimawbooks.bib2gls.GlsRecordSelection;
import com.dickimawbooks.bib2gls.GlsResource;
import com.dickimawbooks.bib2gls.GlsSeeRecord;
import com.dickimawbooks.bib2gls.GlsUseField;
import com.dickimawbooks.bib2gls.GlsXtrIfFieldEqStr;
import com.dickimawbooks.bib2gls.GlsXtrIfHasField;
import com.dickimawbooks.bib2gls.GlsXtrIfHasNonZeroChildCount;
import com.dickimawbooks.bib2gls.GlsXtrMultiEntryAdjustedName;
import com.dickimawbooks.bib2gls.HexUnicodeChar;
import com.dickimawbooks.bib2gls.HrefChar;
import com.dickimawbooks.bib2gls.IfGlsFieldVoid;
import com.dickimawbooks.bib2gls.IfGlsHasChildren;
import com.dickimawbooks.bib2gls.PatternReplace;
import com.dickimawbooks.bib2gls.RecordCountRule;
import com.dickimawbooks.texparserlib.CaseChange;
import com.dickimawbooks.texparserlib.CharObject;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.FontEncoding;
import com.dickimawbooks.texparserlib.GenericCommand;
import com.dickimawbooks.texparserlib.Ignoreable;
import com.dickimawbooks.texparserlib.Other;
import com.dickimawbooks.texparserlib.TeXApp;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserListener;
import com.dickimawbooks.texparserlib.TeXPath;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.UndefAction;
import com.dickimawbooks.texparserlib.WhiteSpace;
import com.dickimawbooks.texparserlib.auxfile.AuxData;
import com.dickimawbooks.texparserlib.auxfile.AuxParser;
import com.dickimawbooks.texparserlib.bib.BibValueList;
import com.dickimawbooks.texparserlib.html.L2HStringConverter;
import com.dickimawbooks.texparserlib.latex.AtFirstOfOne;
import com.dickimawbooks.texparserlib.latex.AtFirstOfTwo;
import com.dickimawbooks.texparserlib.latex.AtSecondOfTwo;
import com.dickimawbooks.texparserlib.latex.CsvList;
import com.dickimawbooks.texparserlib.latex.Input;
import com.dickimawbooks.texparserlib.latex.LaTeXGenericCommand;
import com.dickimawbooks.texparserlib.latex.LaTeXSty;
import com.dickimawbooks.texparserlib.latex.NewCommand;
import com.dickimawbooks.texparserlib.latex.Overwrite;
import com.dickimawbooks.texparserlib.latex.fontenc.FontEncSty;
import com.dickimawbooks.texparserlib.latex.mfirstuc.CapitaliseWords;
import com.dickimawbooks.texparserlib.latex.mfirstuc.MfirstucSty;
import com.dickimawbooks.texparserlib.latex.textcase.MakeTextLowercase;
import com.dickimawbooks.texparserlib.latex.textcase.MakeTextUppercase;
import com.dickimawbooks.texparserlib.primitives.Relax;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.BreakIterator;
import java.text.MessageFormat;
import java.text.Normalizer;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.IllformedLocaleException;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Bib2Gls
implements TeXApp {
    public static final String NAME = "bib2gls";
    public static final String VERSION = "3.9";
    public static final String DATE = "2024-01-30";
    public int debugLevel = 0;
    public int verboseLevel = 0;
    private char openout_any = (char)112;
    private char openin_any = (char)97;
    private Path cwd;
    private Path texmfoutput = null;
    private Path basePath;
    private File auxFile;
    private File glgLogFile;
    private File texLogFile;
    private PrintWriter logWriter = null;
    private StringWriter pending = null;
    private PrintWriter pendingWriter = null;
    public static final Pattern PATTERN_PACKAGE = Pattern.compile("Package: ([^\\s]+)(?:\\s+(\\d{4})/(\\d{2})/(\\d{2}))?.*");
    public static final Pattern PATTERN_ENCDEF = Pattern.compile("File: ([^ ]+)enc\\.def .*");
    private Vector<String> fontencList = null;
    private boolean fontspec = false;
    private boolean hyperref = false;
    private boolean createHyperGroups = true;
    private boolean checkNonBibFields = true;
    private boolean warnUnknownEntryTypes = true;
    private boolean allowAuxCatChangers = false;
    private int altModifier = -1;
    private Vector<GlsResource> glsresources;
    private Vector<String> fields;
    private Vector<GlsRecord> records;
    private Vector<GlsSeeRecord> seeRecords;
    private Vector<String> selectedEntries;
    private Vector<String> knownGlossaries = null;
    private HashMap<String, CompoundEntry> compoundEntries;
    private Vector<String> mglsRefs;
    private Vector<String> mglsCs;
    public static final String[] SPAWN_SPECIAL_FIELDS = new String[]{"progeny", "progenitor", "adoptparents"};
    public static final String[] DUAL_SPECIAL_FIELDS = new String[]{"dualprefix", "dualprefixplural", "dualprefixfirst", "dualprefixfirstplural", "dualdescription"};
    public static final String[] OTHER_SPECIAL_FIELDS = new String[]{"definitionindex", "useindex"};
    private static final String[] NON_BIB_FIELDS = new String[]{"bibtexcontributor", "bibtexentry", "dual", "group", "progenitor", "progeny", "secondarygroup", "secondarysort"};
    private static final String[] PRIVATE_NON_BIB_FIELDS = new String[]{"childcount", "childlist", "currcount", "desc", "descplural", "firstpl", "flag", "index", "indexcounter", "level", "location", "loclist", "longpl", "originalentrytype", "originalid", "shortpl", "siblingcount", "siblinglist", "sortvalue", "prenumberlist", "prevcount", "prevunitmax", "prevunittotal", "primarylocations", "recordcount", "unitlist", "useri", "userii", "useriii", "useriv", "userv", "uservi"};
    private HashMap<String, GlsLike> glsLikeMap;
    private Vector<GlsLikeFamily> glsLikeFamilies;
    private HashMap<String, String> fieldMap;
    private HashMap<String, String> formatMap;
    private HashMap<GlsRecord, Integer> recordCount = null;
    private Vector<File> texFiles;
    private boolean addGroupField = false;
    private boolean saveRecordCount = false;
    private boolean saveRecordCountUnit = false;
    private boolean commonCommandsDone = false;
    private Charset texCharset = null;
    private Charset texLogCharset;
    private Charset defaultCharset = Charset.defaultCharset();
    private boolean useCiteAsRecord = false;
    private boolean mergeWrGlossaryLocations = true;
    private byte mergeNameRefOn = (byte)3;
    private static final byte MERGE_NAMEREF_ON_HREF = 0;
    private static final byte MERGE_NAMEREF_ON_TITLE = 1;
    private static final byte MERGE_NAMEREF_ON_LOCATION = 2;
    private static final byte MERGE_NAMEREF_ON_HCOUNTER = 3;
    private Bib2GlsMessages messages;
    private boolean mfirstucProtect = true;
    private boolean mfirstucMProtect = true;
    private String[] mfirstucProtectFields = null;
    private boolean mfirstucProtectWasSet = false;
    private boolean mfirstucMProtectWasSet = false;
    private String shortcuts = null;
    private boolean checkAcroShortcuts = false;
    private boolean checkAbbrvShortcuts = false;
    private GlsResource currentResource = null;
    private String docLocale = null;
    private Locale defaultLocale = null;
    private boolean trimFields = false;
    private Vector<String> trimOnlyFields = null;
    private Vector<String> trimExceptFields = null;
    private Vector<String> retainFormatList = null;
    private boolean expandFields = false;
    private boolean dateInHeader = false;
    private boolean interpret = true;
    private Vector<String> packages = null;
    private Vector<String> ignorePackages = null;
    private Vector<String> customPackages = null;
    public static final String[] AUTO_SUPPORT_PACKAGES = new String[]{"amsmath", "amssymb", "bpchem", "fontenc", "fontspec", "fourier", "hyperref", "lipsum", "mfirstuc", "mhchem", "MnSymbol", "natbib", "pifont", "siunitx", "stix", "textcase", "textcomp", "tipa", "upgreek", "wasysym"};
    public static final String[] EXTRA_SUPPORTED_PACKAGES = new String[]{"booktabs", "color", "datatool-base", "datatool", "etoolbox", "fontawesome", "graphics", "graphicx", "ifthen", "jmlrutils", "mfirstuc-english", "probsoln", "shortvrb", "twemojis", "xfor", "xspace"};
    private TeXParser interpreter = null;
    private MfirstucSty mfirstucSty = null;
    private boolean useNonBreakSpace = true;
    private boolean forceCrossResourceRefs = false;
    private boolean supportUnicodeSubSuperScripts = true;
    private boolean multiSuppSupported = false;
    private boolean collapseSamePageRange = true;
    private String glossariesExtraVersion = "????/??/??";
    private String glossariesVersion = "????/??/??";
    private String mfirstucVersion = "????/??/??";
    private static final String MFIRSTUC208 = "2022/10/14";
    private boolean hasNewCaseSupport = false;
    private static final String GLOSSARIES4_47 = "2021/09/20";
    private static final String GLOSSARIES_EXTRA_1_46 = "2021/09/20";
    private boolean hasNewHyperGroupSupport = false;
    private static final String GLOSSARIES_4_53 = "2023/09/29";
    private static final String GLOSSARIES_EXTRA_1_53 = "2023/09/29";
    private boolean hasNonASCIILabelSupport = false;
    private Vector<String> mfirstucExclusions;
    private Vector<String> mfirstucBlockers;
    private HashMap<String, String> mfirstucMappings;
    private Vector<String> dependencies = null;
    private HashMap<String, String> kpsewhichResults;
    private RecordCountRule recordCountRule;
    private boolean replaceQuotes = false;
    private int exitCode;
    private boolean shownVersion = false;
    private String[] nestedLinkCheckFields = new String[]{"name", "text", "plural", "first", "firstplural", "long", "longplural", "short", "shortplural", "symbol"};
    public static final String MIN_MULTI_SUPP_VERSION = "1.36";
    public static final int MIN_MULTI_SUPP_YEAR = 2018;
    public static final int MIN_MULTI_SUPP_MONTH = 8;
    public static final int MIN_MULTI_SUPP_DAY = 18;
    public static final int SUPERSCRIPT_ZERO = 8304;
    public static final int SUPERSCRIPT_ONE = 185;
    public static final int SUPERSCRIPT_TWO = 178;
    public static final int SUPERSCRIPT_THREE = 179;
    public static final int SUPERSCRIPT_FOUR = 8308;
    public static final int SUPERSCRIPT_FIVE = 8309;
    public static final int SUPERSCRIPT_SIX = 8310;
    public static final int SUPERSCRIPT_SEVEN = 8311;
    public static final int SUPERSCRIPT_EIGHT = 8312;
    public static final int SUPERSCRIPT_NINE = 8313;
    public static final int SUPERSCRIPT_PLUS = 8314;
    public static final int SUPERSCRIPT_MINUS = 8315;
    public static final int SUBSCRIPT_ZERO = 8320;
    public static final int SUBSCRIPT_ONE = 8321;
    public static final int SUBSCRIPT_TWO = 8322;
    public static final int SUBSCRIPT_THREE = 8323;
    public static final int SUBSCRIPT_FOUR = 8324;
    public static final int SUBSCRIPT_FIVE = 8325;
    public static final int SUBSCRIPT_SIX = 8326;
    public static final int SUBSCRIPT_SEVEN = 8327;
    public static final int SUBSCRIPT_EIGHT = 8328;
    public static final int SUBSCRIPT_NINE = 8329;
    public static final int SUBSCRIPT_PLUS = 8330;
    public static final int SUBSCRIPT_MINUS = 8331;
    public static final int MINUS = 8722;
    public static final String SUBSCRIPT_INT_PATTERN = String.format("[%c%c]?[%c%c%c%c%c%c%c%c%c%c]+", 8330, 8331, 8320, 8321, 8322, 8323, 8324, 8325, 8326, 8327, 8328, 8329);
    public static final String SUPERSCRIPT_INT_PATTERN = String.format("[%c%c]?[%c%c%c%c%c%c%c%c%c%c]+", 8314, 8315, 8304, 185, 178, 179, 8308, 8309, 8310, 8311, 8312, 8313);
    public static final Pattern INT_PATTERN = Pattern.compile(String.format("([+-%c]?\\p{javaDigit}+|%s|%s).*", 8722, SUBSCRIPT_INT_PATTERN, SUPERSCRIPT_INT_PATTERN));
    public static final int SYNTAX_ITEM_LINEWIDTH = 78;
    public static final int SYNTAX_ITEM_TAB = 30;
    public static final int TRUNCATE_MAX_OBJECTS = 40;
    public static final int TRUNCATE_MAX_CHARS = 160;

    public Bib2Gls(int n, int n2, String string) throws IOException, InterruptedException, Bib2GlsException {
        this.kpsewhichResults = new HashMap();
        try {
            this.pending = new StringWriter();
            this.pendingWriter = new PrintWriter(this.pending);
        }
        catch (Throwable throwable) {
            this.pendingWriter = null;
        }
        this.debugLevel = n;
        this.verboseLevel = n2;
        this.shownVersion = false;
        if (n > 0 && n2 > -1) {
            this.version();
            this.shownVersion = true;
        }
        this.initMessages(string);
        this.initSecuritySettings();
        if (this.verboseLevel >= 0 && !this.shownVersion) {
            this.version();
            this.shownVersion = true;
        }
        this.formatMap = new HashMap();
        this.texFiles = new Vector();
        this.packages = new Vector();
    }

    private void initSecuritySettings() throws IOException, InterruptedException, Bib2GlsException {
        File file;
        String string;
        int n;
        String string2 = this.kpsewhich("--var-value=openin_any");
        String string3 = this.kpsewhich("--var-value=openout_any");
        int n2 = string2 == null || string2.isEmpty() ? -1 : (int)string2.charAt(0);
        int n3 = n = string3 == null || string3.isEmpty() ? -1 : (int)string3.charAt(0);
        if (n2 == 97 || n2 == 112 || n2 == 114) {
            this.openin_any = (char)n2;
        } else if (n2 == -1) {
            this.debugMessage("error.missing.value", "openin_any");
            this.openin_any = (char)97;
        } else {
            this.warningMessage("error.invalid.opt.value", "openin_any", string2);
            this.openin_any = (char)97;
        }
        if (n == 97 || n == 112 || n == 114) {
            this.openout_any = (char)n;
        } else if (n == -1) {
            this.debugMessage("error.missing.value", "openout_any");
            this.openout_any = (char)112;
        } else {
            this.warningMessage("error.invalid.opt.value", "openout_any", string3);
            this.openout_any = (char)112;
        }
        try {
            string = this.kpsewhich("--var-value=TEXMFOUTPUT");
            if (string != null && !string.isEmpty()) {
                file = new TeXPath(null, string, false).getFile();
                if (file.isDirectory()) {
                    this.texmfoutput = file.toPath();
                } else {
                    System.err.println("TEXMFOUT not a directory: " + string);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        string = System.getProperty("user.dir");
        if (string == null) {
            throw new IOException("Can't determine current working directory");
        }
        file = new File(string);
        if (!file.isDirectory()) {
            throw new IOException("CWD is not a directory: " + string);
        }
        this.cwd = file.toPath();
    }

    public void checkReadAccess(TeXPath teXPath) throws IOException {
        if (!this.isReadAccessAllowed(teXPath)) {
            throw new IOException(this.getMessage("error.openin.forbidden", teXPath));
        }
    }

    public void checkReadAccess(Path path) throws IOException {
        if (!this.isReadAccessAllowed(path)) {
            throw new IOException(this.getMessage("error.openin.forbidden", path));
        }
    }

    public void checkReadAccess(File file) throws IOException {
        if (!this.isReadAccessAllowed(file.toPath())) {
            throw new IOException(this.getMessage("error.openin.forbidden", Character.valueOf(this.openin_any), file));
        }
    }

    public boolean isReadAccessAllowed(TeXPath teXPath) {
        Path path;
        this.debugMessage("message.checking.read", teXPath);
        if (this.openin_any == 'a') {
            return true;
        }
        if (teXPath.isHidden()) {
            return false;
        }
        if (this.openin_any == 'r') {
            return true;
        }
        if (teXPath.wasFoundByKpsewhich()) {
            return true;
        }
        Path path2 = teXPath.getBaseDir();
        Path path3 = teXPath.getRelativePath();
        Path path4 = path = path2 == null ? path3.normalize() : path2.resolve(path3).normalize();
        if (path.isAbsolute()) {
            if (path.startsWith(this.cwd)) {
                return true;
            }
            if (this.texmfoutput != null) {
                return path.startsWith(this.texmfoutput);
            }
            return false;
        }
        return path.toAbsolutePath().normalize().startsWith(this.cwd);
    }

    public boolean isReadAccessAllowed(File file) {
        return this.isReadAccessAllowed(file.toPath());
    }

    public boolean isReadAccessAllowed(Path path) {
        this.debugMessage("message.checking.read", path);
        if (this.openin_any == 'a') {
            return true;
        }
        if (this.isHidden(path)) {
            return false;
        }
        if (this.openin_any == 'r') {
            return true;
        }
        if (path.isAbsolute()) {
            if ((path = path.normalize()).startsWith(this.cwd)) {
                return true;
            }
            String string = this.kpsewhichResults.get(path.getName(path.getNameCount() - 1).toString());
            if (string != null) {
                File file;
                if (File.separatorChar == '/') {
                    file = new File(string);
                } else {
                    String[] stringArray = string.split("/");
                    file = new File(stringArray[0] + File.separator);
                    for (int i = 0; i < stringArray.length; ++i) {
                        file = new File(file, stringArray[i]);
                    }
                }
                try {
                    if (Files.isSameFile(path, file.toPath())) {
                        return true;
                    }
                }
                catch (IOException iOException) {
                    this.debug(iOException);
                }
            }
            if (this.texmfoutput != null) {
                return path.startsWith(this.texmfoutput);
            }
            return false;
        }
        return path.toAbsolutePath().normalize().startsWith(this.cwd);
    }

    public void checkWriteAccess(Path path) throws IOException {
        if (!this.isWriteAccessAllowed(path)) {
            throw new IOException(this.getMessage("error.openout.forbidden", path));
        }
    }

    public void checkWriteAccess(File file) throws IOException {
        if (!this.isWriteAccessAllowed(file.toPath())) {
            throw new IOException(this.getMessage("error.openout.forbidden", file));
        }
    }

    public void registerTeXFile(File file) throws IOException {
        this.checkWriteAccess(file);
        if (this.texFiles.contains(file)) {
            throw new IOException(this.getMessage("error.duplicate.resource", file));
        }
        this.texFiles.add(file);
    }

    public boolean isWriteAccessAllowed(TeXPath teXPath) {
        return this.isWriteAccessAllowed(teXPath.getPath());
    }

    public boolean isWriteAccessAllowed(File file) {
        return this.isWriteAccessAllowed(file.toPath());
    }

    public boolean isWriteAccessAllowed(Path path) {
        this.debugMessage("message.checking.write", path);
        String string = path.getName(path.getNameCount() - 1).toString().toLowerCase();
        int n = string.lastIndexOf(".");
        if (n > -1 && ((string = string.substring(n + 1)).equals("tex") || string.equals("ltx") || string.equals("sty") || string.equals("cls") || string.equals("bib") || string.equals("dtx") || string.equals("ins") || string.equals("def") || string.equals("ldf"))) {
            if (this.debugLevel > 0) {
                this.logAndPrintMessage(this.getMessageWithFallback("error.forbidden.ext", "Write access forbidden for extension: {0}", string));
            }
            return false;
        }
        if (this.openout_any == 'a') {
            return true;
        }
        if (this.isHidden(path)) {
            return false;
        }
        if (this.openout_any == 'r') {
            return true;
        }
        if (path.isAbsolute()) {
            if ((path = path.normalize()).startsWith(this.cwd)) {
                return true;
            }
            if (this.texmfoutput != null) {
                return path.startsWith(this.texmfoutput);
            }
            return false;
        }
        return path.toAbsolutePath().normalize().startsWith(this.cwd);
    }

    public boolean isHidden(Path path) {
        for (int i = path.getNameCount() - 1; i >= 0; --i) {
            String string = path.getName(i).toString();
            if (!string.startsWith(".") || string.equals(".") || string.equals("..")) continue;
            return true;
        }
        return false;
    }

    public File getWritableFile(File file) throws IOException {
        File file2 = file.getParentFile();
        if (file2 == null) {
            file2 = this.cwd.toFile();
        }
        if (this.texmfoutput != null && !file2.canWrite()) {
            this.warningMessage("warning.dir.no.write", file2, this.texmfoutput);
            file = new File(this.texmfoutput.toFile(), file.getName());
        }
        this.checkWriteAccess(file);
        return file;
    }

    public Path resolvePath(Path path) {
        return this.basePath.resolve(path).normalize();
    }

    public File resolveFile(File file) {
        file = file.getParentFile() == null ? new File(this.basePath.toFile(), file.getName()) : this.basePath.resolve(file.toPath()).toFile();
        return file;
    }

    public File resolveFile(String string) {
        return this.resolveFile(new File(string));
    }

    public File getAuxFile() {
        return this.auxFile;
    }

    private String texToJavaCharset(String string) throws Bib2GlsException {
        if (string.equals("ascii")) {
            return "US-ASCII";
        }
        if (string.equals("latin1")) {
            return "ISO-8859-1";
        }
        if (string.equals("latin2")) {
            return "ISO-8859-2";
        }
        if (string.equals("latin3")) {
            return "ISO-8859-3";
        }
        if (string.equals("latin4")) {
            return "ISO-8859-4";
        }
        if (string.equals("latin5")) {
            return "ISO-8859-9";
        }
        if (string.equals("latin6")) {
            return "ISO-8859-10";
        }
        if (string.equals("latin7")) {
            return "ISO-8859-13";
        }
        if (string.equals("latin8")) {
            return "ISO-8859-14";
        }
        if (string.equals("latin9")) {
            return "ISO-8859-15";
        }
        if (string.equals("latin10")) {
            return "ISO-8859-16";
        }
        if (string.equals("decmulti")) {
            return "DEC-MCS";
        }
        if (string.equals("cp850")) {
            return "Cp850";
        }
        if (string.equals("cp852")) {
            return "Cp852";
        }
        if (string.equals("cp858")) {
            return "Cp858";
        }
        if (string.equals("cp437") || string.equals("cp437de")) {
            return "Cp437";
        }
        if (string.equals("cp865")) {
            return "Cp865";
        }
        if (string.equals("applemac")) {
            return "MacRoman";
        }
        if (string.equals("macce")) {
            return "MacCentralEurope";
        }
        if (!string.equals("next")) {
            if (string.equals("cp1250")) {
                return "Cp1250";
            }
            if (string.equals("cp1252") || string.equals("ansinew")) {
                return "Cp1252";
            }
            if (string.equals("cp1257")) {
                return "Cp1257";
            }
            if (string.equals("utf8")) {
                return "UTF-8";
            }
        }
        throw new Bib2GlsException(string);
    }

    public boolean suppressFieldExpansion() {
        return !this.expandFields;
    }

    public boolean useNonBreakSpace() {
        return this.useNonBreakSpace;
    }

    public String getGlsTeXHeader() {
        if (this.dateInHeader) {
            return this.getMessage("comment.header", NAME, VERSION, new Date());
        }
        return this.getMessage("comment.header.no_date", NAME, VERSION);
    }

    public boolean useInterpreter() {
        return this.interpret;
    }

    public L2HStringConverter getInterpreterListener() {
        return this.interpreter == null ? null : (L2HStringConverter)this.interpreter.getListener();
    }

    public TeXObjectList getWordExceptionList() {
        ControlSequence controlSequence = this.interpreter.getControlSequence("@mfu@nocaplist");
        if (controlSequence == null) {
            return null;
        }
        TeXObjectList teXObjectList = null;
        if (controlSequence instanceof GenericCommand) {
            teXObjectList = ((GenericCommand)controlSequence).getDefinition();
        }
        return teXObjectList;
    }

    public Vector<String> getPackages() {
        return this.packages;
    }

    public boolean hasNonASCIILabelSupport() {
        return this.hasNonASCIILabelSupport;
    }

    public boolean fontSpecLoaded() {
        return this.fontspec;
    }

    public boolean hyperrefLoaded() {
        return this.hyperref;
    }

    public boolean createHyperGroupsOn() {
        return this.createHyperGroups;
    }

    public void setCreateHyperGroups(boolean bl) {
        this.createHyperGroups = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseLog() throws IOException {
        String string = this.auxFile.getName();
        String string2 = string;
        int n = string2.lastIndexOf(".aux");
        if (n < 1) {
            this.debug("Can't determine log file from " + this.auxFile);
            return;
        }
        String string3 = string2.substring(0, n);
        string2 = string3 + ".log";
        this.texLogFile = new File(this.auxFile.getParentFile(), string2);
        if (!this.texLogFile.exists()) {
            this.warningMessage("error.no_log", this.texLogFile, NAME);
            return;
        }
        BufferedReader bufferedReader = null;
        for (String object : this.packages) {
            if (!object.equals("fontspec")) continue;
            this.fontspec = true;
            this.verboseMessage("message.detected.sty_no_version", object);
            break;
        }
        try {
            this.checkReadAccess(this.texLogFile);
            this.logMessage(this.getMessage("message.reading", this.texLogFile));
            this.logEncoding(this.texLogCharset);
            bufferedReader = Files.newBufferedReader(this.texLogFile.toPath(), this.getTeXLogCharset());
            Iterator<String> iterator = null;
            while ((iterator = bufferedReader.readLine()) != null) {
                Matcher matcher = PATTERN_PACKAGE.matcher((CharSequence)((Object)iterator));
                if (matcher.matches()) {
                    String string4 = matcher.group(1).toLowerCase();
                    if (string4.equals("glossaries-extra")) {
                        try {
                            Calendar calendar = Calendar.getInstance();
                            calendar.set(2017, 1, 3);
                            int n2 = Integer.parseInt(matcher.group(2));
                            int n3 = Integer.parseInt(matcher.group(3));
                            int n4 = Integer.parseInt(matcher.group(4));
                            Calendar calendar2 = Calendar.getInstance();
                            calendar2.set(n2, n3 - 1, n4);
                            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd");
                            this.glossariesExtraVersion = simpleDateFormat.format(calendar2.getTime());
                            this.verboseMessage("message.detected.sty", string4, this.glossariesExtraVersion);
                            if (calendar2.compareTo(calendar) < 0) {
                                this.warningMessage("error.sty.too.old", "glossaries-extra", this.glossariesExtraVersion, simpleDateFormat.format(calendar.getTime()));
                                continue;
                            }
                            calendar.set(2018, 7, 18);
                            this.multiSuppSupported = calendar2.compareTo(calendar) >= 0;
                        }
                        catch (Exception exception) {
                            this.warningMessage("error.no.sty.version", "glossaries-extra");
                            this.debug(exception);
                        }
                        continue;
                    }
                    if (string4.equals("glossaries")) {
                        this.glossariesVersion = String.format("%s/%s/%s", matcher.group(2), matcher.group(3), matcher.group(4));
                        this.verboseMessage("message.detected.sty", string4, this.glossariesVersion);
                        continue;
                    }
                    if (string4.equals("mfirstuc")) {
                        this.mfirstucVersion = String.format("%s/%s/%s", matcher.group(2), matcher.group(3), matcher.group(4));
                        this.verboseMessage("message.detected.sty", string4, this.mfirstucVersion);
                        continue;
                    }
                    if (this.ignorePackages != null && this.ignorePackages.contains(string4)) continue;
                    if (string4.equals("hyperref")) {
                        this.hyperref = true;
                        continue;
                    }
                    if (string4.equals("fontspec")) {
                        if (this.fontspec) continue;
                        this.verboseMessage("message.detected.sty_no_version", string4);
                        this.fontspec = true;
                        continue;
                    }
                    if (Bib2Gls.isAutoSupportPackage(string4)) {
                        if (string4.equals("bpchem")) {
                            this.addBlocker("ce");
                        } else if (string4.equals("lipsum")) {
                            this.addBlocker("lipsum");
                        } else if (string4.equals("pifont")) {
                            this.addExclusion("ding");
                        } else if (string4.equals("siunitx")) {
                            this.addBlocker("num");
                            this.addBlocker("numlist");
                            this.addBlocker("numproduct");
                            this.addBlocker("numrange");
                            this.addBlocker("ang");
                            this.addBlocker("unit");
                            this.addBlocker("qty");
                            this.addBlocker("qtylist");
                            this.addBlocker("qtyproduct");
                            this.addBlocker("qtyrange");
                            this.addBlocker("complexnum");
                            this.addBlocker("complexqty");
                            this.addBlocker("si");
                            this.addBlocker("SI");
                            this.addBlocker("SIlist");
                            this.addBlocker("SIrange");
                        }
                        this.packages.add(string4);
                        continue;
                    }
                    if (string4.equals("twemojis")) {
                        this.addExclusion("twemoji");
                        continue;
                    }
                    if (!string4.equals("graphics")) continue;
                    this.addExclusion("includegraphics");
                    continue;
                }
                Matcher matcher2 = PATTERN_ENCDEF.matcher((CharSequence)((Object)iterator));
                if (matcher2.matches()) {
                    if (this.fontencList == null) {
                        this.fontencList = new Vector();
                    }
                    this.fontencList.add(matcher2.group(1));
                    continue;
                }
                if (!((String)((Object)iterator)).contains(string)) continue;
                break;
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        if (this.glossariesExtraVersion.equals("????/??/??")) {
            this.warningMessage("error.no_sty.version", "glossaries-extra", this.texLogFile);
        }
        if (this.debugLevel > 0 && this.packages.size() > 0) {
            if (this.packages.size() == 1) {
                this.debugMessage("message.1.sty", new Object[0]);
            } else {
                this.debugMessage("message.2.sty", this.packages.size());
            }
            for (String string5 : this.packages) {
                this.debug(string5);
            }
            this.debug();
        }
        if (this.glossariesVersion.compareTo("2023/09/29") >= 0) {
            if (this.glossariesExtraVersion.compareTo("2023/09/29") >= 0) {
                this.hasNewHyperGroupSupport = true;
            } else {
                this.warningMessage("warning.mismatched.sty", "glossaries", this.glossariesVersion, "glossaries-extra", this.glossariesExtraVersion);
            }
        }
        boolean bl = this.hasNewCaseSupport = this.mfirstucVersion.compareTo(MFIRSTUC208) >= 0;
        if (this.hasNewCaseSupport && this.glossariesVersion.compareTo(MFIRSTUC208) < 0) {
            this.hasNewCaseSupport = false;
            this.warningMessage("warning.mismatched.sty", "mfirstuc", this.mfirstucVersion, "glossaries", this.glossariesVersion);
        }
        if (this.hasNewCaseSupport && this.glossariesExtraVersion.compareTo(MFIRSTUC208) < 0) {
            this.hasNewCaseSupport = false;
            this.warningMessage("warning.mismatched.sty", "glossaries", this.glossariesVersion, "glossaries-extra", this.glossariesExtraVersion);
        }
        if (!(this.mfirstucProtectWasSet && this.mfirstucMProtectWasSet || !this.hasNewCaseSupport)) {
            this.verboseMessage("message.nomfirstuc.protect", new Object[0]);
            if (!this.mfirstucProtectWasSet) {
                this.mfirstucProtect = false;
                this.verboseMessage("message.default.arg", "--no-mfirstuc-protection", "--mfirstuc-protection");
            }
            if (!this.mfirstucMProtectWasSet) {
                this.mfirstucMProtect = false;
                this.verboseMessage("message.default.arg", "--no-mfirstuc-math-protection", "--mfirstuc-math-protection");
            }
        }
    }

    public String getGlossariesExtraVersion() {
        return this.glossariesExtraVersion;
    }

    public static boolean isAutoSupportPackage(String string) {
        for (String string2 : AUTO_SUPPORT_PACKAGES) {
            if (string2.compareToIgnoreCase(string) != 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isExtraSupportedPackage(String string) {
        for (String string2 : EXTRA_SUPPORTED_PACKAGES) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean isKnownPackage(String string) {
        return Bib2Gls.isAutoSupportPackage(string) || Bib2Gls.isExtraSupportedPackage(string);
    }

    private void initInterpreter(Vector<AuxData> vector) throws IOException {
        LaTeXSty laTeXSty;
        String string2;
        L2HStringConverter l2HStringConverter = new L2HStringConverter((TeXApp)new Bib2GlsAdapter(this), vector, this.customPackages != null){

            public void writeCodePoint(int n) throws IOException {
                if (this.getWriter() == null) {
                    return;
                }
                if (n == 38) {
                    this.getWriter().write("&amp;");
                } else if (n == 60) {
                    this.getWriter().write("&le;");
                } else if (n == 62) {
                    this.getWriter().write("&ge;");
                } else {
                    this.getWriter().write(new String(Character.toChars(n)));
                }
            }

            public void parsePackageFile(LaTeXSty laTeXSty, TeXObjectList teXObjectList) throws IOException {
                if (this.isParsePackageSupportOn() && Bib2Gls.this.customPackages.contains(laTeXSty.getName())) {
                    laTeXSty.parseFile(teXObjectList);
                }
            }
        };
        l2HStringConverter.setUndefinedAction(UndefAction.WARN);
        l2HStringConverter.setUseMathJax(false);
        l2HStringConverter.setIsInDocEnv(true);
        l2HStringConverter.setSupportUnicodeScript(this.supportUnicodeSubSuperScripts);
        this.interpreter = this.createTeXParser((TeXParserListener)l2HStringConverter);
        this.interpreter.setCatCode(64, 11);
        this.mfirstucSty = (MfirstucSty)l2HStringConverter.usepackage(null, "mfirstuc", false);
        Vector<String> vector2 = this.getPackages();
        if (vector2 != null) {
            for (String string2 : vector2) {
                laTeXSty = l2HStringConverter.usepackage(null, string2, false);
                if (this.fontencList == null || !string2.equals("fontenc")) continue;
                if (laTeXSty == null || !(laTeXSty instanceof FontEncSty)) {
                    laTeXSty = l2HStringConverter.getFontEncSty();
                }
                if (laTeXSty == null || !(laTeXSty instanceof FontEncSty)) continue;
                for (String string3 : this.fontencList) {
                    this.debugMessage("message.detected.fontenc", string3);
                    FontEncoding fontEncoding = ((FontEncSty)laTeXSty).getEncoding(string3.toUpperCase());
                    if (fontEncoding == null) continue;
                    fontEncoding.addDefinitions(this.interpreter.getSettings());
                }
                this.fontencList = null;
            }
        }
        l2HStringConverter.putControlSequence((ControlSequence)new NewCommand("renewcommand", Overwrite.ALLOW));
        l2HStringConverter.putControlSequence((ControlSequence)new NewCommand("glsxtrprovidecommand", Overwrite.ALLOW));
        l2HStringConverter.putControlSequence((ControlSequence)new MakeTextUppercase("bibglsuppercase"));
        l2HStringConverter.putControlSequence((ControlSequence)new MakeTextLowercase("bibglslowercase"));
        l2HStringConverter.putControlSequence((ControlSequence)new MakeTextLowercase("glslowercase"));
        l2HStringConverter.putControlSequence((ControlSequence)new AtFirstOfOne("glsxtrrevert"));
        l2HStringConverter.putControlSequence((ControlSequence)new GenericCommand(true, "bibglsfirstuc", null, (TeXObject)new TeXCsRef("makefirstuc")));
        l2HStringConverter.putControlSequence((ControlSequence)new CapitaliseWords(this.mfirstucSty, "bibglstitlecase"));
        l2HStringConverter.putControlSequence((ControlSequence)new CapitaliseWords(this.mfirstucSty, "glscapitalisewords"));
        l2HStringConverter.putControlSequence((ControlSequence)new GenericCommand(true, "BibGlsTitleCase", null, (TeXObject)new TeXCsRef("BibGlsLongOrText")));
        l2HStringConverter.putControlSequence((ControlSequence)new GenericCommand(true, "BibGlsTitleCasePlural", null, (TeXObject)new TeXCsRef("BibGlsLongOrTextPlural")));
        TeXObjectList teXObjectList = l2HStringConverter.createStack();
        teXObjectList.add((TeXObject)new TeXCsRef("ifglshaslong"));
        string2 = l2HStringConverter.createGroup();
        teXObjectList.add((TeXObject)string2);
        string2.add((TeXObject)l2HStringConverter.getParam(1));
        string2 = l2HStringConverter.createGroup();
        teXObjectList.add((TeXObject)string2);
        string2.add((TeXObject)new TeXCsRef("glsxtrfieldtitlecase"));
        laTeXSty = l2HStringConverter.createGroup();
        string2.add((TeXObject)laTeXSty);
        laTeXSty.add((TeXObject)l2HStringConverter.getParam(1));
        string2.add((TeXObject)l2HStringConverter.createGroup("long"));
        string2 = l2HStringConverter.createGroup();
        teXObjectList.add((TeXObject)string2);
        string2.add((TeXObject)new TeXCsRef("glsxtrfieldtitlecase"));
        laTeXSty = l2HStringConverter.createGroup();
        string2.add((TeXObject)laTeXSty);
        laTeXSty.add((TeXObject)l2HStringConverter.getParam(1));
        string2.add((TeXObject)l2HStringConverter.createGroup("text"));
        l2HStringConverter.putControlSequence((ControlSequence)new LaTeXGenericCommand(true, "BibGlsLongOrText", "m", teXObjectList));
        teXObjectList = l2HStringConverter.createStack();
        teXObjectList.add((TeXObject)new TeXCsRef("ifglshaslong"));
        string2 = l2HStringConverter.createGroup();
        teXObjectList.add((TeXObject)string2);
        string2.add((TeXObject)l2HStringConverter.getParam(1));
        string2 = l2HStringConverter.createGroup();
        teXObjectList.add((TeXObject)string2);
        string2.add((TeXObject)new TeXCsRef("glsxtrfieldtitlecase"));
        laTeXSty = l2HStringConverter.createGroup();
        string2.add((TeXObject)laTeXSty);
        laTeXSty.add((TeXObject)l2HStringConverter.getParam(1));
        string2.add((TeXObject)l2HStringConverter.createGroup("longplural"));
        string2 = l2HStringConverter.createGroup();
        teXObjectList.add((TeXObject)string2);
        string2.add((TeXObject)new TeXCsRef("glsxtrfieldtitlecase"));
        laTeXSty = l2HStringConverter.createGroup();
        string2.add((TeXObject)laTeXSty);
        laTeXSty.add((TeXObject)l2HStringConverter.getParam(1));
        string2.add((TeXObject)l2HStringConverter.createGroup("plural"));
        l2HStringConverter.putControlSequence((ControlSequence)new LaTeXGenericCommand(true, "BibGlsLongOrTextPlural", "m", teXObjectList));
        teXObjectList = l2HStringConverter.createStack();
        teXObjectList.add((TeXObject)new TeXCsRef("ifglshasshort"));
        string2 = l2HStringConverter.createGroup();
        teXObjectList.add((TeXObject)string2);
        string2.add((TeXObject)l2HStringConverter.getParam(1));
        string2 = l2HStringConverter.createGroup();
        teXObjectList.add((TeXObject)string2);
        string2.add((TeXObject)new TeXCsRef("glsxtrfieldtitlecase"));
        laTeXSty = l2HStringConverter.createGroup();
        string2.add((TeXObject)laTeXSty);
        laTeXSty.add((TeXObject)l2HStringConverter.getParam(1));
        string2.add((TeXObject)l2HStringConverter.createGroup("short"));
        string2 = l2HStringConverter.createGroup();
        teXObjectList.add((TeXObject)string2);
        string2.add((TeXObject)new TeXCsRef("glsxtrfieldtitlecase"));
        laTeXSty = l2HStringConverter.createGroup();
        string2.add((TeXObject)laTeXSty);
        laTeXSty.add((TeXObject)l2HStringConverter.getParam(1));
        string2.add((TeXObject)l2HStringConverter.createGroup("text"));
        l2HStringConverter.putControlSequence((ControlSequence)new LaTeXGenericCommand(true, "BibGlsShortOrText", "m", teXObjectList));
        teXObjectList = l2HStringConverter.createStack();
        teXObjectList.add((TeXObject)new TeXCsRef("ifglshasshort"));
        string2 = l2HStringConverter.createGroup();
        teXObjectList.add((TeXObject)string2);
        string2.add((TeXObject)l2HStringConverter.getParam(1));
        string2 = l2HStringConverter.createGroup();
        teXObjectList.add((TeXObject)string2);
        string2.add((TeXObject)new TeXCsRef("glsxtrfieldtitlecase"));
        laTeXSty = l2HStringConverter.createGroup();
        string2.add((TeXObject)laTeXSty);
        laTeXSty.add((TeXObject)l2HStringConverter.getParam(1));
        string2.add((TeXObject)l2HStringConverter.createGroup("shortplural"));
        string2 = l2HStringConverter.createGroup();
        teXObjectList.add((TeXObject)string2);
        string2.add((TeXObject)new TeXCsRef("glsxtrfieldtitlecase"));
        laTeXSty = l2HStringConverter.createGroup();
        string2.add((TeXObject)laTeXSty);
        laTeXSty.add((TeXObject)l2HStringConverter.getParam(1));
        string2.add((TeXObject)l2HStringConverter.createGroup("plural"));
        l2HStringConverter.putControlSequence((ControlSequence)new LaTeXGenericCommand(true, "BibGlsShortOrTextPlural", "m", teXObjectList));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsDisp());
        l2HStringConverter.putControlSequence((ControlSequence)new GlsDisp("glslink"));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsDisp("dglslink"));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsDisp("dglsdisp"));
        l2HStringConverter.putControlSequence((ControlSequence)new EnableTagging());
        l2HStringConverter.putControlSequence((ControlSequence)new AtFirstOfTwo("bibglscontributorlist"));
        l2HStringConverter.putControlSequence((ControlSequence)new AtFirstOfTwo("bibglshyperlink"));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsHyperLink(this));
        l2HStringConverter.putControlSequence((ControlSequence)new BibGlsContributor(this));
        l2HStringConverter.putControlSequence((ControlSequence)new BibGlsDateTime());
        l2HStringConverter.putControlSequence((ControlSequence)new BibGlsDateTime("bibglsdate", true, false));
        l2HStringConverter.putControlSequence((ControlSequence)new BibGlsDateTime("bibglstime", false, true));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("glsentryname", "name", this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("glsentrytext", "text", this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("glsentryshort", "short", this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("glsentrylong", "long", this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("glsentryfirst", "first", this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("glsentrysymbol", "symbol", this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("glsentryuseri", "user1", this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("glsentryuserii", "user2", this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("glsentryuseriii", "user3", this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("glsentryuseriv", "user4", this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("glsentryuserv", "user5", this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("glsentryuservi", "user6", this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("glsentryplural", "plural", this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("glsentryfirstplural", "firstplural", this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("glsentryshortpl", "shortplural", this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("glsentrylongpl", "longplural", this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("glsentrysymbolplural", "symbolplural", this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("Glsentryname", "name", CaseChange.SENTENCE, this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("Glsentrytext", "text", CaseChange.SENTENCE, this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("Glsentryshort", "short", CaseChange.SENTENCE, this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("Glsentrylong", "long", CaseChange.SENTENCE, this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("Glsentryfirst", "first", CaseChange.SENTENCE, this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("Glsentrysymbol", "symbol", CaseChange.SENTENCE, this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("Glsentryuseri", "user1", CaseChange.SENTENCE, this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("Glsentryuserii", "user2", CaseChange.SENTENCE, this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("Glsentryuseriii", "user3", CaseChange.SENTENCE, this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("Glsentryuseriv", "user4", CaseChange.SENTENCE, this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("Glsentryuserv", "user5", CaseChange.SENTENCE, this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("Glsentryuservi", "user6", CaseChange.SENTENCE, this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("Glsentryplural", "plural", CaseChange.SENTENCE, this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("Glsentryfirstplural", "firstplural", CaseChange.SENTENCE, this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("Glsentryshortpl", "shortplural", CaseChange.SENTENCE, this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("Glsentrylongpl", "longplural", CaseChange.SENTENCE, this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("Glsentrysymbolplural", "symbolplural", CaseChange.SENTENCE, this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("glsaccessname", "name", this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("glsaccesstext", "text", this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("glsaccessshort", "short", this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("glsaccesslong", "long", this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("glsaccessfirst", "first", this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("glsaccesssymbol", "symbol", this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("glsaccessuseri", "user1", this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("glsaccessuserii", "user2", this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("glsaccessuseriii", "user3", this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("glsaccessuseriv", "user4", this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("glsaccessuserv", "user5", this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("glsaccessuservi", "user6", this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("glsaccessplural", "plural", this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("glsaccessfirstplural", "firstplural", this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("glsaccessshortpl", "shortplural", this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("glsaccesslongpl", "longplural", this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("glsaccesssymbolplural", "symbolplural", this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("Glsaccessname", "name", CaseChange.SENTENCE, this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("Glsaccesstext", "text", CaseChange.SENTENCE, this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("Glsaccessshort", "short", CaseChange.SENTENCE, this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("Glsaccesslong", "long", CaseChange.SENTENCE, this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("Glsaccessfirst", "first", CaseChange.SENTENCE, this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("Glsaccesssymbol", "symbol", CaseChange.SENTENCE, this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("Glsaccessuseri", "user1", CaseChange.SENTENCE, this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("Glsaccessuserii", "user2", CaseChange.SENTENCE, this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("Glsaccessuseriii", "user3", CaseChange.SENTENCE, this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("Glsaccessuseriv", "user4", CaseChange.SENTENCE, this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("Glsaccessuserv", "user5", CaseChange.SENTENCE, this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("Glsaccessuservi", "user6", CaseChange.SENTENCE, this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("Glsaccessplural", "plural", CaseChange.SENTENCE, this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("Glsaccessfirstplural", "firstplural", CaseChange.SENTENCE, this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("Glsaccessshortpl", "shortplural", CaseChange.SENTENCE, this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("Glsaccesslongpl", "longplural", CaseChange.SENTENCE, this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("Glsaccesssymbolplural", "symbolplural", CaseChange.SENTENCE, this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsUseField(this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsUseField("Glsxtrusefield", CaseChange.SENTENCE, this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsUseField("GLSxtrusefield", CaseChange.TO_UPPER, this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsUseField("glsentrytitlecase", CaseChange.TITLE, this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsUseField("glsxtrfieldtitlecase", CaseChange.TITLE, this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryParentName(this));
        l2HStringConverter.putControlSequence((ControlSequence)new GenericCommand("glsxtrhiernamesep", null, (TeXObject)l2HStringConverter.createString(".")));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsHierName(this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsHierName("Glsxtrhiername", CaseChange.SENTENCE, true, this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsHierName("GlsXtrhiername", CaseChange.SENTENCE, false, this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsHierName("GLSxtrhiername", CaseChange.TO_UPPER, true, this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsHierName("GLSXTRhiername", CaseChange.TO_UPPER, false, this));
        l2HStringConverter.putControlSequence((ControlSequence)new AtFirstOfOne("MFUwordbreak"));
        l2HStringConverter.putControlSequence((ControlSequence)new AtFirstOfOne("MFUskippunc"));
        l2HStringConverter.putControlSequence((ControlSequence)new BibGlsDefinitionIndex(this));
        l2HStringConverter.putControlSequence((ControlSequence)new BibGlsUseIndex(this));
        l2HStringConverter.putControlSequence((ControlSequence)new IfGlsHasChildren(this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsIfHasKey("ifglshasparent", "parent", this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsIfHasKey("ifglshasdesc", "description", this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsIfHasKey("ifglshassymbol", "symbol", this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsIfHasKey("ifglshaslong", "long", this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsIfHasKey("ifglshasshort", "short", this));
        l2HStringConverter.putControlSequence((ControlSequence)new IfGlsFieldVoid(this));
        l2HStringConverter.putControlSequence((ControlSequence)new Relax("glscurrentfieldvalue"));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsXtrIfHasField(this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsXtrIfHasField("ifglshasfield", false, this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsXtrIfFieldEqStr(this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsXtrIfFieldEqStr("GlsXtrIfFieldEqXpStr", false, true, this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsXtrIfFieldEqStr("GlsXtrIfXpFieldEqXpStr", true, true, this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsXtrIfFieldEqStr("ifglsfieldeq", false, false, false, this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsXtrIfHasNonZeroChildCount(this));
        l2HStringConverter.putControlSequence((ControlSequence)l2HStringConverter.createSymbol("glshashchar", 35));
        l2HStringConverter.putControlSequence((ControlSequence)l2HStringConverter.createSymbol("bibglshashchar", 35));
        l2HStringConverter.putControlSequence((ControlSequence)l2HStringConverter.createSymbol("bibglsunderscorechar", 95));
        l2HStringConverter.putControlSequence((ControlSequence)l2HStringConverter.createSymbol("bibglsdollarchar", 36));
        l2HStringConverter.putControlSequence((ControlSequence)l2HStringConverter.createSymbol("bibglsampersandchar", 38));
        l2HStringConverter.putControlSequence((ControlSequence)l2HStringConverter.createSymbol("bibglscircumchar", 94));
        l2HStringConverter.putControlSequence((ControlSequence)l2HStringConverter.createSymbol("glsbackslash", 92));
        l2HStringConverter.putControlSequence((ControlSequence)l2HStringConverter.createSymbol("glstildechar", 126));
        l2HStringConverter.putControlSequence((ControlSequence)l2HStringConverter.createSymbol("glsopenbrace", 123));
        l2HStringConverter.putControlSequence((ControlSequence)l2HStringConverter.createSymbol("glsclosebrace", 125));
        l2HStringConverter.putControlSequence((ControlSequence)l2HStringConverter.createSymbol("bibglsaposchar", 39));
        l2HStringConverter.putControlSequence((ControlSequence)l2HStringConverter.createSymbol("bibglsdoublequotechar", 34));
        l2HStringConverter.putControlSequence((ControlSequence)new FlattenedPostSort());
        l2HStringConverter.putControlSequence((ControlSequence)new FlattenedPreSort());
        l2HStringConverter.putControlSequence((ControlSequence)new HrefChar());
        l2HStringConverter.putControlSequence((ControlSequence)new AtSecondOfTwo("bibglshrefunicode"));
        l2HStringConverter.putControlSequence((ControlSequence)new HexUnicodeChar());
        l2HStringConverter.putControlSequence((ControlSequence)new Bib2GlsPadNDigits());
        l2HStringConverter.putControlSequence((ControlSequence)new GlsCombinedSep());
        l2HStringConverter.putControlSequence((ControlSequence)new GlsCombinedSep("glscombinedfirstsep"));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsCombinedSep("glscombinedsepfirst"));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsCombinedSep("glscombinedfirstsepfirst"));
        l2HStringConverter.putControlSequence((ControlSequence)new GenericCommand(true, "glsxtrmultientryadjustednamesep", null, new TeXObject[]{new TeXCsRef("glscombinedfirstsepfirst")}));
        l2HStringConverter.putControlSequence((ControlSequence)new GenericCommand(true, "glsxtrmultientryadjustednamepresep", null, new TeXObject[]{new TeXCsRef("glsxtrmultientryadjustednamesep")}));
        l2HStringConverter.putControlSequence((ControlSequence)new GenericCommand(true, "glsxtrmultientryadjustednamepostsep", null, new TeXObject[]{new TeXCsRef("glsxtrmultientryadjustednamesep")}));
        l2HStringConverter.putControlSequence((ControlSequence)new AtFirstOfOne("glsxtrmultientryadjustednamefmt"));
        l2HStringConverter.putControlSequence((ControlSequence)new GenericCommand(true, "Glsxtrmultientryadjustednamefmt", null, new TeXObject[]{new TeXCsRef("makefirstuc")}));
        l2HStringConverter.putControlSequence((ControlSequence)new GenericCommand(true, "GlsXtrmultientryadjustednamefmt", null, new TeXObject[]{new TeXCsRef("glscapitalisewords")}));
        l2HStringConverter.putControlSequence((ControlSequence)new GenericCommand(true, "GLSxtrmultientryadjustednamefmt", null, new TeXObject[]{new TeXCsRef("mfirstucMakeUppercase")}));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("glsxtrmultientryadjustednameother", "name", CaseChange.NO_CHANGE, this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("Glsxtrmultientryadjustednameother", "name", CaseChange.SENTENCE, this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("GlsXtrmultientryadjustednameother", "name", CaseChange.TITLE, this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsEntryFieldValue("GLSxtrmultientryadjustednameother", "name", CaseChange.TO_UPPER, this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsXtrMultiEntryAdjustedName(this));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsXtrMultiEntryAdjustedName(this, "Glsxtrmultientryadjustedname", CaseChange.SENTENCE));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsXtrMultiEntryAdjustedName(this, "GlsXtrmultientryadjustedname", CaseChange.TITLE));
        l2HStringConverter.putControlSequence((ControlSequence)new GlsXtrMultiEntryAdjustedName(this, "GLSxtrmultientryadjustedname", CaseChange.TO_UPPER));
        if (this.customPackages != null) {
            for (String string3 : this.customPackages) {
                l2HStringConverter.usepackage(null, string3, false);
            }
        }
    }

    public void provideCommand(String string, String string2) {
        if (this.interpreter != null) {
            L2HStringConverter l2HStringConverter = (L2HStringConverter)this.interpreter.getListener();
            l2HStringConverter.putControlSequence((ControlSequence)new GenericCommand(string, null, (TeXObject)l2HStringConverter.createString(string2)));
        }
    }

    public void processPreamble(BibValueList bibValueList) throws IOException {
        if (this.interpreter == null) {
            return;
        }
        this.interpreter.addAll((Collection)bibValueList.expand(this.interpreter));
        if (this.getDebugLevel() > 0) {
            this.logAndPrintMessage(String.format("%n%s%n%s%n%n", this.getMessage("message.parsing.code", new Object[0]), this.interpreter.toString(this.interpreter)));
        }
        while (this.interpreter.size() > 0) {
            TeXObject teXObject = this.interpreter.pop();
            teXObject.process(this.interpreter);
        }
    }

    public String interpret(String string, TeXObjectList teXObjectList, boolean bl) {
        if (this.interpreter == null) {
            return string;
        }
        try {
            String string2;
            L2HStringConverter l2HStringConverter = (L2HStringConverter)this.interpreter.getListener();
            StringWriter stringWriter = new StringWriter();
            l2HStringConverter.setWriter((Writer)stringWriter);
            this.interpreter.addAll((Collection)teXObjectList);
            if (this.getDebugLevel() > 0) {
                this.logAndPrintMessage(String.format("%n%s%n%s%n%n", this.getMessage("message.parsing.code", new Object[0]), this.interpreter.toString(this.interpreter)));
            }
            while (this.interpreter.size() > 0) {
                string2 = this.interpreter.pop();
                string2.process(this.interpreter);
            }
            string2 = stringWriter.toString();
            if (this.getDebugLevel() > 0) {
                this.logAndPrintMessage(String.format("texparserlib:--> %s", string2));
            }
            string2 = string2.replaceAll("<[^>]+>", "");
            string2 = string2.replaceAll("\\&le;", "<");
            string2 = string2.replaceAll("\\&ge;", ">");
            string2 = string2.replaceAll("\\&amp;", "&");
            if (bl) {
                string2 = string2.trim();
            }
            this.logMessage(String.format("texparserlib: %s -> %s", string, string2));
            return string2;
        }
        catch (IOException iOException) {
            if (this.getDebugLevel() > 0) {
                this.debug("texparserlib: ");
                this.debug(iOException);
            }
            return string;
        }
    }

    public String interpret(String string, BibValueList bibValueList, boolean bl) {
        if (this.interpreter == null) {
            return string;
        }
        try {
            TeXObjectList teXObjectList = bibValueList.expand(this.interpreter);
            if (teXObjectList == null) {
                return string;
            }
            teXObjectList = (TeXObjectList)teXObjectList.clone();
            return this.interpret(string, teXObjectList, bl);
        }
        catch (IOException iOException) {
            if (this.getDebugLevel() > 0) {
                this.debug("texparserlib: ");
                this.debug(iOException);
            }
            return string;
        }
    }

    public String convertToLabel(TeXParser teXParser, BibValueList bibValueList, GlsResource glsResource, boolean bl) throws IOException {
        Vector<PatternReplace> vector;
        String string;
        TeXObjectList teXObjectList = bibValueList.expand(teXParser);
        String string2 = string = teXObjectList.toString(teXParser);
        if (string.matches("(?s).*[\\\\\\{\\}\\~\\$].*")) {
            string = this.interpret(string, bibValueList, true);
        }
        if ((vector = glsResource.getLabelifySubstitutions()) != null) {
            for (PatternReplace patternReplace : vector) {
                string = patternReplace.replaceAll(string);
            }
        }
        String string3 = " \\.\\-\\+\\:\\;\\|\\/\\!\\?\\*\\<\\>\\@\\'\\`";
        string = bl ? string.replaceAll("[^," + (String)string3 + "\\p{IsAlphabetic}\\p{IsDigit}]", "") : string.replaceAll("[^" + (String)string3 + "\\p{IsAlphabetic}\\p{IsDigit}]", "");
        if (!this.fontSpecLoaded()) {
            string = Normalizer.normalize(string, Normalizer.Form.NFD);
            string = string.replaceAll("[^," + (String)string3 + "a-zA-Z0-9]", "");
        }
        if (bl) {
            string = string.replaceAll(",,+", ",");
            string = string.replaceAll("^,|,$", "");
        }
        if (!(this.verboseLevel <= 0 || string2.equals(string) && this.debugLevel <= 0)) {
            this.logMessage(String.format("%s: %s -> %s", bl ? "labelify-list" : "labelify", string2, string));
        }
        return string;
    }

    public String toTruncatedString(TeXParser teXParser, TeXObjectList teXObjectList) {
        return teXObjectList.toTruncatedString(teXParser, 40, this.getMessage("message.etc", new Object[0]));
    }

    public String truncate(String string) {
        if (string.length() < 160) {
            return string;
        }
        return string.substring(0, 160) + this.getMessage("message.etc", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(String[] stringArray) throws IOException, InterruptedException, Bib2GlsException {
        int n;
        String string;
        String string2;
        Object object2;
        Vector vector;
        this.parseArgs(stringArray);
        if (this.saveRecordCount) {
            this.recordCount = new HashMap();
        }
        try {
            this.parseLog();
        }
        catch (MalformedInputException malformedInputException) {
            this.warningMessage("error.cant.parse.file.malformed.input", this.texLogFile, this.getTeXLogCharset(), "--log-encoding", "--default-encoding");
            this.debug(malformedInputException);
        }
        catch (IOException iOException) {
            this.warningMessage("warning.cant.parse.file", this.texLogFile, iOException.getMessage());
            this.debug(iOException);
        }
        if (this.texCharset == null && this.fontspec) {
            try {
                this.texCharset = Charset.forName("UTF-8");
            }
            catch (Exception exception) {
                this.debug(exception);
            }
        }
        Charset charset = this.texCharset == null ? this.getDefaultCharset() : this.texCharset;
        AuxParser auxParser = new AuxParser(this, charset){

            protected void addPredefined() {
                super.addPredefined();
                this.putControlSequence((ControlSequence)new Input("@bibgls@input", 1));
                this.addAuxCommand("glsxtr@resource", 2);
                this.addAuxCommand("glsxtr@fields", 1);
                this.addAuxCommand("glsxtr@record", 5);
                this.addAuxCommand("glsxtr@recordsee", 2);
                this.addAuxCommand("glsxtr@record@nameref", 8);
                this.addAuxCommand("glsxtr@select@entry", 5);
                this.addAuxCommand("glsxtr@select@entry@nameref", 8);
                this.addAuxCommand("glsxtr@texencoding", 1);
                this.addAuxCommand("glsxtr@langtag", 1);
                this.addAuxCommand("glsxtr@shortcutsval", 1);
                this.addAuxCommand("glsxtr@pluralsuffixes", 4);
                this.addAuxCommand("@glsxtr@altmodifier", 1);
                this.addAuxCommand("@glsxtr@newglslike", 2);
                this.addAuxCommand("@glsxtr@newglslikefamily", 8);
                this.addAuxCommand("@glsxtr@prefixlabellist", 1);
                this.addAuxCommand("@glsxtr@multientry", 4);
                this.addAuxCommand("@glsxtr@mglsrefs", 1);
                this.addAuxCommand("@glsxtr@mglslike", 1);
                this.addAuxCommand("@mfu@excls", 1);
                this.addAuxCommand("@mfu@blockers", 1);
                this.addAuxCommand("@mfu@mappings", 1);
                if (Bib2Gls.this.knownGlossaries != null) {
                    this.addAuxCommand("@newglossary", 4);
                }
            }
        };
        auxParser.setAllowCatCodeChangers(this.allowAuxCatChangers);
        TeXParser teXParser = this.createTeXParser((TeXParserListener)auxParser);
        try {
            auxParser.parseAuxFile(teXParser, this.auxFile);
        }
        catch (MalformedInputException malformedInputException) {
            this.warningMessage("error.cant.parse.file.malformed.input", this.auxFile, charset, "--tex-encoding", "--default-encoding");
            this.debug(malformedInputException);
            vector = auxParser.getAuxData();
            for (Object object2 : vector) {
                string2 = object2.getName();
                if (!string2.equals("glsxtr@texencoding")) continue;
                try {
                    string = object2.getArg(0).toString(teXParser).trim();
                    this.verboseMessage("message.found", "\\glsxtr@texencoding{" + string + "}");
                    this.texCharset = string.equals("\\inputencodingname") ? Charset.forName("UTF-8") : Charset.forName(this.texToJavaCharset(string));
                    if (!this.texCharset.equals(charset)) {
                        this.message(this.getMessage("message.reparsing_aux", this.auxFile, this.texCharset));
                        vector.clear();
                        charset = this.texCharset;
                        auxParser.setCharSet(charset);
                        auxParser.parseAuxFile(teXParser, this.auxFile);
                        continue;
                    }
                    this.warningMessage("message.lost_records", new Object[0]);
                }
                catch (MalformedInputException malformedInputException2) {
                    this.warningMessage("error.cant.parse.file.malformed.input", this.auxFile, charset, "--tex-encoding", "--default-encoding");
                    this.debug(malformedInputException2);
                    this.warningMessage("message.lost_records", new Object[0]);
                }
                catch (Bib2GlsException bib2GlsException) {
                    if (this.texCharset != null) continue;
                    this.texCharset = this.getDefaultCharset();
                    this.warningMessage("error.unknown.tex.charset", bib2GlsException.getMessage(), this.texCharset, "--tex-encoding");
                }
            }
        }
        this.glsresources = new Vector();
        this.fields = new Vector();
        this.fieldMap = new HashMap();
        this.records = new Vector();
        this.seeRecords = new Vector();
        this.selectedEntries = new Vector();
        vector = auxParser.getAuxData();
        if (this.interpret) {
            this.initInterpreter(vector);
        }
        Vector<AuxData> vector2 = new Vector<AuxData>();
        Object object3 = "s";
        object2 = "s";
        string2 = "s";
        string = "s";
        for (AuxData auxData : vector) {
            String string3;
            String string4;
            String string5;
            String string6;
            String string7;
            Object object4;
            Object object5;
            String string8 = auxData.getName();
            if (string8.equals("glsxtr@resource")) {
                object5 = auxData.getArg(1);
                if (object5 instanceof TeXObjectList) {
                    for (int i = ((TeXObjectList)object5).size() - 1; i >= 0; --i) {
                        object4 = (TeXObject)((TeXObjectList)object5).get(i);
                        if (!(object4 instanceof CharObject) || ((CharObject)object4).getCharCode() != 34) continue;
                        ((TeXObjectList)object5).remove(i);
                    }
                }
                vector2.add(auxData);
                continue;
            }
            if (string8.equals("glsxtr@shortcutsval")) {
                if (this.shortcuts != null) continue;
                this.setShortCuts(auxData.getArg(0).toString(teXParser));
                continue;
            }
            if (string8.equals("glsxtr@pluralsuffixes")) {
                object3 = auxData.getArg(0).toString(teXParser);
                object2 = auxData.getArg(1).toString(teXParser);
                string2 = auxData.getArg(2).toString(teXParser);
                string = auxData.getArg(3).toString(teXParser);
                continue;
            }
            if (string8.equals("@glsxtr@altmodifier")) {
                object5 = auxData.getArg(0).toString(teXParser).trim();
                if (((String)object5).isEmpty()) continue;
                this.altModifier = ((String)object5).codePointAt(0);
                continue;
            }
            if (string8.equals("@glsxtr@newglslike")) {
                this.addGlsLike(auxData.getArg(0).toString(teXParser), auxData.getArg(1).toString(teXParser).substring(1));
                continue;
            }
            if (string8.equals("@glsxtr@newglslikefamily")) {
                object5 = auxData.getArg(0).toString(teXParser).trim();
                String string9 = auxData.getArg(1).toString(teXParser).trim();
                object4 = auxData.getArg(2).toString(teXParser).trim();
                string7 = auxData.getArg(3).toString(teXParser).trim();
                string6 = auxData.getArg(4).toString(teXParser).trim();
                string5 = auxData.getArg(5).toString(teXParser).trim();
                string4 = auxData.getArg(6).toString(teXParser).trim();
                string3 = auxData.getArg(7).toString(teXParser).trim();
                if (((String)object4).startsWith("\\")) {
                    object4 = ((String)object4).substring(1);
                }
                if (string7.startsWith("\\")) {
                    string7 = string7.substring(1);
                }
                if (string6.startsWith("\\")) {
                    string6 = string6.substring(1);
                }
                if (string5.startsWith("\\")) {
                    string5 = string5.substring(1);
                }
                if (string4.startsWith("\\")) {
                    string4 = string4.substring(1);
                }
                if (string3.startsWith("\\")) {
                    string3 = string3.substring(1);
                }
                this.addGlsLikeFamily((String)object5, string9, (String)object4, string7, string6, string5, string4, string3);
                continue;
            }
            if (string8.equals("@glsxtr@multientry")) {
                this.addCompoundEntry(new CompoundEntry(auxData.getArg(1).toString(teXParser), auxData.getArg(3).toString(teXParser), auxData.getArg(2).toString(teXParser), auxData.getArg(0).toString(teXParser)));
                continue;
            }
            if (string8.equals("@glsxtr@mglsrefs")) {
                this.addMglsRef(auxData.getArg(0).toString(teXParser));
                continue;
            }
            if (string8.equals("@glsxtr@mglslike")) {
                this.addMglsCs(auxData.getArg(0).toString(teXParser));
                continue;
            }
            if (string8.equals("@glsxtr@prefixlabellist")) {
                Object object6;
                object5 = auxData.getArg(0).toString(teXParser).split(",");
                if (object5 == null || ((Object)object5).length <= 0 || ((String)(object6 = object5[((Object)object5).length - 1])).isEmpty()) continue;
                this.addGlsLike((String)object6, "dgls");
                this.addGlsLike((String)object6, "dGls");
                this.addGlsLike((String)object6, "dGLS");
                this.addGlsLike((String)object6, "dglspl");
                this.addGlsLike((String)object6, "dGlspl");
                this.addGlsLike((String)object6, "dGLSpl");
                this.addGlsLike((String)object6, "dglslink");
                this.addGlsLike((String)object6, "dglsdisp");
                continue;
            }
            if (string8.equals("glsxtr@langtag")) {
                object5 = this.getLocale(auxData.getArg(0).toString(teXParser));
                this.setDocDefaultLocale((Locale)object5);
                this.addExtraProperties((Locale)object5);
                continue;
            }
            if (string8.equals("glsxtr@locale")) {
                object5 = this.getLocale(auxData.getArg(0).toString(teXParser));
                this.addExtraProperties((Locale)object5);
                continue;
            }
            if (string8.equals("glsxtr@texencoding")) {
                block116: {
                    try {
                        object5 = auxData.getArg(0).toString(teXParser).trim();
                        this.texCharset = ((String)object5).equals("\\inputencodingname") ? Charset.forName("UTF-8") : Charset.forName(this.texToJavaCharset((String)object5));
                    }
                    catch (Bib2GlsException bib2GlsException) {
                        if (this.texCharset != null) break block116;
                        this.texCharset = this.getDefaultCharset();
                        this.warningMessage("error.unknown.tex.charset", bib2GlsException.getMessage(), this.texCharset, "--tex-encoding");
                    }
                }
                if (this.texCharset.equals(charset)) continue;
                this.warningMessage("error.aux.charset.mismatch", charset, this.texCharset, "--tex-encoding");
                continue;
            }
            if (string8.equals("glsxtr@fields")) {
                object5 = CsvList.getList((TeXParser)teXParser, (TeXObject)auxData.getArg(0));
                Iterator iterator = object5.iterator();
                while (iterator.hasNext()) {
                    object4 = (TeXObject)iterator.next();
                    string7 = (TeXObjectList)object4;
                    string6 = string7.popArg(teXParser);
                    string5 = string6.toString(teXParser);
                    this.fields.add(string5);
                    string6 = string7.popArg(teXParser);
                    string4 = string6.toString(teXParser);
                    if (!string4.equals(string5)) {
                        this.fieldMap.put(string5, string4);
                    }
                    if (this.debugLevel <= 0) continue;
                    this.logAndPrintMessage("Adding field: " + string5 + " (" + string4 + ")");
                }
                continue;
            }
            if (string8.equals("glsxtr@recordsee")) {
                this.seeRecords.add(new GlsSeeRecord(auxData.getArg(0), auxData.getArg(1), teXParser));
                continue;
            }
            if (string8.equals("glsxtr@record") || this.useCiteAsRecord && string8.equals("citation") || string8.equals("glsxtr@record@nameref") || string8.equals("glsxtr@select@entry") || string8.equals("glsxtr@select@entry@nameref")) {
                GlsRecord glsRecord;
                object5 = auxData.getArg(0).toString(teXParser);
                String[] stringArray2 = null;
                if (string8.startsWith("glsxtr@select@entry")) {
                    stringArray2 = ((String)object5).split(",");
                    object5 = stringArray2[0];
                }
                string4 = null;
                string3 = null;
                String string10 = null;
                if (auxData.getNumArgs() >= 5) {
                    object4 = auxData.getArg(1).toString(teXParser);
                    string7 = auxData.getArg(2).toString(teXParser);
                    string6 = auxData.getArg(3).toString(teXParser);
                    string5 = auxData.getArg(4).toString(teXParser);
                    if (string5.isEmpty()) {
                        if (this.debugLevel > 0 && !string6.equals("glsignore")) {
                            this.logAndPrintMessage();
                            this.logAndPrintMessage(this.getMessage("message.empty.location.ignored", object5, string7, string6));
                            this.logAndPrintMessage();
                        }
                        string6 = "glsignore";
                    }
                    if (auxData.getNumArgs() == 8) {
                        string4 = auxData.getArg(5).toString(teXParser);
                        string3 = auxData.getArg(6).toString(teXParser);
                        string10 = auxData.getArg(7).toString(teXParser);
                    }
                    if (string7.equals("wrglossary") && (glsRecord = AuxData.getPageReference((Vector)vector, (TeXParser)teXParser, (String)("wrglossary." + string5))) != null) {
                        string5 = String.format("\\glsxtr@wrglossarylocation{%s}{%s}", string5, glsRecord.toString(teXParser));
                    }
                } else {
                    if (((String)object5).equals("*")) {
                        this.verboseMessage("message.ignored.record", "\\citation{*}");
                        continue;
                    }
                    object4 = "";
                    string7 = "page";
                    string6 = "glsignore";
                    string5 = "";
                }
                glsRecord = string4 == null ? (stringArray2 == null ? new GlsRecord(this, (String)object5, (String)object4, string7, string6, string5) : new GlsRecordSelection(this, stringArray2, (String)object4, string7, string6, string5)) : (stringArray2 == null ? new GlsRecordNameRef(this, (String)object5, (String)object4, string7, string6, string5, string4, string3, string10) : new GlsRecordNameRefSelection(this, stringArray2, (String)object4, string7, string6, string5, string4, string3, string10));
                this.incRecordCount(glsRecord);
                boolean bl = false;
                for (int i = this.records.size() - 1; i >= 0; --i) {
                    GlsRecord glsRecord2 = this.records.get(i);
                    if (glsRecord2.equals(glsRecord)) {
                        bl = true;
                        break;
                    }
                    if (!glsRecord2.partialMatch(glsRecord)) continue;
                    String string11 = glsRecord.getFormat();
                    String string12 = glsRecord2.getFormat();
                    String string13 = "";
                    if (string11.startsWith("(") || string11.startsWith(")")) {
                        string13 = string11.substring(0, 1);
                        string11 = string11.length() == 1 ? "glsnumberformat" : string11.substring(1);
                    }
                    String string14 = "";
                    if (string12.startsWith("(") || string12.startsWith(")")) {
                        string14 = string12.substring(0, 1);
                        string12 = string12.length() == 1 ? "glsnumberformat" : string12.substring(1);
                    }
                    if (string14.equals(")") && string13.equals("(")) {
                        this.records.add(glsRecord);
                    } else if (string14.equals("(") && string13.equals(")")) {
                        if (this.collapseSamePageRange) {
                            glsRecord2.setFormat(string12);
                        } else if (string12.equals(string11)) {
                            this.records.add(glsRecord);
                        } else {
                            this.warningMessage("warning.conflicting.range.format", string14 + string12, string13 + string11, string13 + string12);
                            glsRecord.merge(string13 + string12, glsRecord2);
                            this.records.add(glsRecord);
                        }
                    } else if (this.isRetainFormat(string12) || this.isRetainFormat(string11)) {
                        this.records.add(glsRecord);
                    } else if (string13.isEmpty() && !string14.isEmpty()) {
                        if (this.debugLevel > 0) {
                            this.logAndPrintMessage();
                            this.logAndPrintMessage(this.getMessage("warning.discarding.conflicting.record", string11, string14 + string12, glsRecord, glsRecord2));
                            this.logAndPrintMessage();
                        }
                    } else if (!string13.isEmpty() && string14.isEmpty()) {
                        if (this.debugLevel > 0) {
                            this.logAndPrintMessage();
                            this.logAndPrintMessage(this.getMessage("warning.discarding.conflicting.record", string13 + string11, string14 + string12, glsRecord2, glsRecord));
                            this.logAndPrintMessage();
                        }
                        glsRecord2.merge(string13 + string11, glsRecord);
                    } else if (this.isIgnoredFormat(string11)) {
                        if (this.debugLevel > 0) {
                            this.logAndPrintMessage();
                            this.logAndPrintMessage(this.getMessage("warning.discarding.conflicting.record", string13 + string11, string14 + string12, glsRecord, glsRecord2));
                            this.logAndPrintMessage();
                        }
                    } else if (this.isIgnoredFormat(string12)) {
                        if (this.debugLevel > 0) {
                            this.logAndPrintMessage();
                            this.logAndPrintMessage(this.getMessage("warning.discarding.conflicting.record", string13 + string11, string14 + string12, glsRecord2, glsRecord));
                            this.logAndPrintMessage();
                        }
                        glsRecord2.merge(string13 + string11, glsRecord);
                    } else if (string11.equals("glsnumberformat")) {
                        if (this.debugLevel > 0) {
                            this.logAndPrintMessage();
                            this.logAndPrintMessage(this.getMessage("warning.discarding.conflicting.record", string13 + string11, string14 + string12, glsRecord, glsRecord2));
                            this.logAndPrintMessage();
                        }
                    } else if (string12.equals("glsnumberformat")) {
                        if (this.debugLevel > 0) {
                            this.logAndPrintMessage();
                            this.logAndPrintMessage(this.getMessage("warning.discarding.conflicting.record", string13 + string11, string14 + string12, glsRecord2, glsRecord));
                            this.logAndPrintMessage();
                        }
                        glsRecord2.merge(string13 + string11, glsRecord);
                    } else {
                        String string15 = this.formatMap.get(string11);
                        String string16 = this.formatMap.get(string12);
                        if (string15 != null && string15.equals(string12)) {
                            if (this.debugLevel > 0) {
                                this.logAndPrintMessage();
                                this.logAndPrintMessage(this.getMessage("warning.discarding.conflicting.record.using.map", string13 + string11, string13 + string15, glsRecord, glsRecord2));
                                this.logAndPrintMessage();
                            }
                        } else if (string16 != null && string16.equals(string11)) {
                            if (this.debugLevel > 0) {
                                this.logAndPrintMessage();
                                this.logAndPrintMessage(this.getMessage("warning.discarding.conflicting.record.using.map", string12, string16, glsRecord2, glsRecord));
                                this.logAndPrintMessage();
                            }
                            glsRecord2.merge(string13 + string11, glsRecord);
                        } else if (string16 != null && string15 != null && string16.equals(string15)) {
                            if (this.debugLevel > 0) {
                                this.logAndPrintMessage();
                                this.logAndPrintMessage(this.getMessage("warning.discarding.conflicting.record.using.map2", string12, string16, string11, string15, glsRecord2, glsRecord, String.format("{%s}{%s}{%s}{%s}{%s}", glsRecord2.getLabel(), glsRecord2.getPrefix(), glsRecord2.getCounter(), string15, glsRecord2.getLocation())));
                                this.logAndPrintMessage();
                            }
                            glsRecord2.merge(string13 + string15, glsRecord);
                        } else {
                            this.logMessage();
                            this.warningMessage("warning.discarding.conflicting.record", string13 + string11, string14 + string12, glsRecord, glsRecord2);
                            this.logMessage();
                        }
                    }
                    bl = true;
                    break;
                }
                if (bl) continue;
                this.records.add(glsRecord);
                continue;
            }
            if (string8.equals("@mfu@excls")) {
                this.addExclusions(auxData.getArg(0));
                continue;
            }
            if (string8.equals("@mfu@blockers")) {
                this.addBlockers(auxData.getArg(0));
                continue;
            }
            if (string8.equals("@mfu@mappings")) {
                this.addMappings(CsvList.getList((TeXParser)teXParser, (TeXObject)auxData.getArg(0)));
                continue;
            }
            if (this.knownGlossaries == null || !string8.equals("@newglossary")) continue;
            this.addGlossary(auxData.getArg(0).toString(teXParser));
        }
        this.updateGlsLikeFamilies();
        this.provideCommand("glspluralsuffix", (String)object3);
        this.provideCommand("abbrvpluralsuffix", (String)object2);
        this.provideCommand("acrpluralsuffix", string2);
        this.provideCommand("glsxtrabbrvpluralsuffix", string);
        if (this.texCharset == null) {
            this.texCharset = this.getDefaultCharset();
            this.logMessage(this.getMessage("message.unknown.tex.charset", this.texCharset, "--tex-encoding"));
        } else {
            this.verboseMessage("message.tex.charset", this.texCharset);
        }
        boolean bl = this.hasNonASCIILabelSupport = this.fontspec || "UTF-8".equals(this.texCharset.name()) && this.glossariesVersion.compareTo("2021/09/20") >= 0 && this.glossariesExtraVersion.compareTo("2021/09/20") >= 0;
        if (this.verboseLevel > 0) {
            Object object7 = this.getDefaultLocale();
            if (object7 == null) {
                object7 = Locale.getDefault();
            }
            this.logMessage(this.getMessage("message.default.locale", ((Locale)object7).toLanguageTag(), ((Locale)object7).getDisplayName()));
        }
        for (AuxData auxData : vector2) {
            this.glsresources.add(new GlsResource(teXParser, auxData, (String)object3, (String)object2));
        }
        if (this.glsresources.size() == 0) {
            throw new Bib2GlsException(this.getMessage("error.missing.aux.cs.require_cs_or", "glsxtr@resource", "glsxtrresourcefile", "GlsXtrLoadResources"));
        }
        if (this.fields.size() == 0) {
            this.warning(teXParser, this.getMessage("error.missing.aux.new.cs", "glsxtr@fields", "1.11"));
            this.fields.add("name");
            this.fields.add("sort");
            this.fieldMap.put("sort", "sortvalue");
            this.fields.add("type");
            this.fields.add("first");
            this.fields.add("firstplural");
            this.fieldMap.put("firstplural", "firstpl");
            this.fields.add("text");
            this.fields.add("plural");
            this.fields.add("description");
            this.fieldMap.put("description", "desc");
            this.fields.add("descriptionplural");
            this.fieldMap.put("description", "descplural");
            this.fields.add("symbol");
            this.fields.add("symbolplural");
            this.fields.add("user1");
            this.fieldMap.put("user1", "useri");
            this.fields.add("user2");
            this.fieldMap.put("user2", "userii");
            this.fields.add("user3");
            this.fieldMap.put("user3", "useriii");
            this.fields.add("user4");
            this.fieldMap.put("user4", "useriv");
            this.fields.add("user5");
            this.fieldMap.put("user5", "userv");
            this.fields.add("user6");
            this.fieldMap.put("user6", "uservi");
            this.fields.add("long");
            this.fields.add("longplural");
            this.fieldMap.put("long", "longpl");
            this.fields.add("short");
            this.fields.add("shortplural");
            this.fieldMap.put("short", "shortpl");
            this.fields.add("counter");
            this.fields.add("parent");
            this.fields.add("loclist");
            this.fields.add("see");
            this.fields.add("category");
        }
        if (this.useGroupField() && !this.fields.contains("group")) {
            this.warningMessage("warning.no_group_field", new Object[0]);
        }
        this.addField("dualshort");
        this.addField("dualshortplural");
        this.addField("duallong");
        this.addField("duallongplural");
        int n2 = 0;
        boolean bl2 = true;
        for (n = 0; n < this.glsresources.size(); ++n) {
            this.currentResource = this.glsresources.get(n);
            this.currentResource.parseBibFiles();
            if (!bl2 || this.forceCrossResourceRefs || this.currentResource.allowsCrossResourceRefs()) continue;
            this.debugMessage("message.cross-resource.notallowed", this.currentResource);
            bl2 = false;
        }
        if (bl2) {
            this.logMessage(this.getMessage("message.cross-resource.dep.allowed", new Object[0]));
            this.dependencies = new Vector();
            for (n = 0; n < this.glsresources.size(); ++n) {
                this.currentResource = this.glsresources.get(n);
                this.currentResource.processBibList();
            }
            for (n = 0; n < this.glsresources.size(); ++n) {
                this.currentResource = this.glsresources.get(n);
                int n3 = this.currentResource.processData();
                if (n3 <= 0) continue;
                n2 += n3;
            }
        } else {
            this.logMessage(this.getMessage("message.cross-resource.dep.notallowed", "--force-cross-resource-refs"));
            for (n = 0; n < this.glsresources.size(); ++n) {
                this.currentResource = this.glsresources.get(n);
                this.currentResource.processBibList();
                int n4 = this.currentResource.processData();
                if (n4 <= 0) continue;
                n2 += n4;
            }
        }
        this.currentResource = null;
        if (n2 == 0 && this.records.size() == 0) {
            this.error(this.getMessage("error.missing.records", new Object[0]));
        }
        if (this.glsresources.size() > 1) {
            this.message(this.getChoiceMessage("message.written.total", 0, "entry", 3, n2));
        }
        if (this.logWriter != null) {
            try {
                this.logWriter.close();
            }
            finally {
                this.logWriter = null;
            }
            this.message(this.getMessage("message.log.file", this.glgLogFile));
        }
    }

    public boolean isRetainFormat(String string) {
        if (this.retainFormatList == null) {
            return false;
        }
        return this.retainFormatList.contains(string);
    }

    public void registerDependencies(Bib2GlsEntry bib2GlsEntry) {
        if (this.dependencies == null || !bib2GlsEntry.hasDependencies()) {
            return;
        }
        Iterator<String> iterator = bib2GlsEntry.getDependencyIterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            this.addDependent(string);
        }
    }

    public void addDependent(String string) {
        if (!this.dependencies.contains(string)) {
            this.verboseMessage("message.added.dep", string);
            this.dependencies.add(string);
        }
    }

    public boolean isDependent(String string) {
        return this.dependencies == null ? false : this.dependencies.contains(string);
    }

    public boolean hasCrossResourceDependencies() {
        return this.dependencies != null;
    }

    public Iterator<String> getDependencyIterator() {
        return this.dependencies == null ? null : this.dependencies.iterator();
    }

    public boolean isIgnored(GlsRecord glsRecord) {
        return this.isIgnoredFormat(glsRecord.getFormat());
    }

    private boolean isIgnoredFormat(String string) {
        return string.equals("glsignore") || string.equals("glstriggerrecordformat");
    }

    public GlsResource getCurrentResource() {
        return this.currentResource;
    }

    public boolean isLastResource(GlsResource glsResource) {
        return this.glsresources == null ? false : this.glsresources.lastElement() == glsResource;
    }

    public Vector<GlsResource> getResources() {
        return this.glsresources;
    }

    public Charset getTeXCharset() {
        return this.texCharset;
    }

    public Charset getTeXLogCharset() {
        return this.texLogCharset == null ? this.getDefaultCharset() : this.texLogCharset;
    }

    public Charset getDefaultCharset() {
        return this.defaultCharset;
    }

    public boolean useCiteAsRecord() {
        return this.useCiteAsRecord;
    }

    public boolean mergeNameRefOnLocation() {
        return this.mergeNameRefOn == 2;
    }

    public boolean mergeNameRefOnTitle() {
        return this.mergeNameRefOn == 1;
    }

    public boolean mergeNameRefOnHref() {
        return this.mergeNameRefOn == 0;
    }

    public boolean mergeNameRefOnHcounter() {
        return this.mergeNameRefOn == 3;
    }

    public boolean mergeWrGlossaryLocations() {
        return this.mergeWrGlossaryLocations;
    }

    public boolean checkAcroShortcuts() {
        return this.checkAcroShortcuts;
    }

    public boolean checkAbbrvShortcuts() {
        return this.checkAbbrvShortcuts;
    }

    public int getAltModifier() {
        return this.altModifier;
    }

    public boolean isGlsLike(String string) {
        if (this.glsLikeMap == null) {
            return false;
        }
        return this.glsLikeMap.get(string) != null;
    }

    public void addGlsLike(String string, String string2) {
        if (this.glsLikeMap == null) {
            this.glsLikeMap = new HashMap();
        }
        GlsLike glsLike = new GlsLike(string, string2);
        this.glsLikeMap.put(string2, glsLike);
    }

    public GlsLike getGlsLike(String string) {
        return this.glsLikeMap == null ? null : this.glsLikeMap.get(string);
    }

    public String getGlsLikePrefix(String string) {
        GlsLike glsLike = this.getGlsLike(string);
        return glsLike == null ? null : glsLike.getPrefix();
    }

    private void updateGlsLikeFamilies() {
        GlsLike glsLike;
        if (this.glsLikeMap != null && this.glsLikeFamilies != null) {
            block0: for (String string : this.glsLikeMap.keySet()) {
                glsLike = this.glsLikeMap.get(string);
                if (glsLike.getFamily() != null) continue;
                for (GlsLikeFamily object : this.glsLikeFamilies) {
                    if (!object.hasMember(string)) continue;
                    glsLike.setFamily(object);
                    continue block0;
                }
            }
        } else if (this.glsLikeMap == null) {
            this.glsLikeMap = new HashMap();
        }
        this.addGlsFamily("gls", "glspl", "Gls", "Glspl", "GLS", "GLSpl");
        for (String string : this.glsLikeMap.keySet()) {
            glsLike = this.glsLikeMap.get(string);
            GlsLikeFamily glsLikeFamily = glsLike.getFamily();
            if (glsLikeFamily == null) {
                this.interpreter.putControlSequence(true, (ControlSequence)new GlsEntryFieldValue(glsLike.getName(), "text", CaseChange.NO_CHANGE, this, glsLike.getPrefix()));
                continue;
            }
            String string2 = glsLikeFamily.isPlural(string) ? "plural" : "text";
            this.interpreter.putControlSequence(true, (ControlSequence)new GlsEntryFieldValue(string, string2, glsLikeFamily.getMemberCase(string), this, glsLike.getPrefix()));
        }
    }

    private void addGlsFamily(String string, String string2, String string3, String string4, String string5, String string6) {
        GlsLikeFamily glsLikeFamily = new GlsLikeFamily();
        glsLikeFamily.setSingular(string);
        glsLikeFamily.setPlural(string2);
        glsLikeFamily.setSentence(string3);
        glsLikeFamily.setSentencePlural(string4);
        glsLikeFamily.setAllCaps(string5);
        glsLikeFamily.setAllCapsPlural(string6);
        GlsLike glsLike = new GlsLike("", string);
        glsLike.setFamily(glsLikeFamily);
        this.glsLikeMap.put(string, glsLike);
        glsLike = new GlsLike("", string2);
        glsLike.setFamily(glsLikeFamily);
        this.glsLikeMap.put(string2, glsLike);
        glsLike = new GlsLike("", string3);
        glsLike.setFamily(glsLikeFamily);
        this.glsLikeMap.put(string3, glsLike);
        glsLike = new GlsLike("", string4);
        glsLike.setFamily(glsLikeFamily);
        this.glsLikeMap.put(string4, glsLike);
        glsLike = new GlsLike("", string5);
        glsLike.setFamily(glsLikeFamily);
        this.glsLikeMap.put(string5, glsLike);
        glsLike = new GlsLike("", string6);
        glsLike.setFamily(glsLikeFamily);
        this.glsLikeMap.put(string6, glsLike);
    }

    private GlsLikeFamily findGlsLikeFamily(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        GlsLikeFamily glsLikeFamily = null;
        if (this.glsLikeFamilies != null) {
            for (GlsLikeFamily glsLikeFamily2 : this.glsLikeFamilies) {
                if (!string.equals(glsLikeFamily2.getOptions()) || !string2.equals(glsLikeFamily2.getPrefix())) continue;
                boolean bl = true;
                if (!string3.isEmpty() && glsLikeFamily2.hasSingular() || !string4.isEmpty() && glsLikeFamily2.hasPlural() || !string5.isEmpty() && glsLikeFamily2.hasSentence() || !string6.isEmpty() && glsLikeFamily2.hasSentencePlural() || !string7.isEmpty() && glsLikeFamily2.hasAllCaps() || !string8.isEmpty() && glsLikeFamily2.hasAllCapsPlural()) {
                    bl = false;
                }
                if (!bl) continue;
                break;
            }
        }
        return glsLikeFamily;
    }

    public void addGlsLikeFamily(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        GlsLikeFamily glsLikeFamily = null;
        if (this.glsLikeFamilies == null) {
            this.glsLikeFamilies = new Vector();
        } else if (string3.isEmpty() || string4.isEmpty() || string5.isEmpty() || string6.isEmpty() || string7.isEmpty() || string8.isEmpty()) {
            glsLikeFamily = this.findGlsLikeFamily(string, string2, string3, string4, string5, string6, string7, string8);
        }
        if (glsLikeFamily == null) {
            glsLikeFamily = new GlsLikeFamily();
            glsLikeFamily.setOptions(string);
            glsLikeFamily.setPrefix(string2);
            this.glsLikeFamilies.add(glsLikeFamily);
        }
        if (!string3.isEmpty()) {
            glsLikeFamily.setSingular(string3);
        }
        if (!string4.isEmpty()) {
            glsLikeFamily.setPlural(string4);
        }
        if (!string5.isEmpty()) {
            glsLikeFamily.setSentence(string5);
        }
        if (!string6.isEmpty()) {
            glsLikeFamily.setSentencePlural(string6);
        }
        if (!string7.isEmpty()) {
            glsLikeFamily.setAllCaps(string7);
        }
        if (!string8.isEmpty()) {
            glsLikeFamily.setAllCapsPlural(string8);
        }
    }

    public boolean isCaseExclusion(String string) {
        if (this.mfirstucExclusions == null) {
            return false;
        }
        return this.mfirstucExclusions.contains(string);
    }

    private void addExclusions(TeXObject teXObject) {
        if (this.mfirstucExclusions == null) {
            this.mfirstucExclusions = new Vector();
        }
        if (teXObject instanceof ControlSequence) {
            String string = ((ControlSequence)teXObject).getName();
            this.mfirstucExclusions.add(string);
            if (this.mfirstucSty != null) {
                this.mfirstucSty.addExclusion(string);
            }
        } else if (teXObject instanceof TeXObjectList) {
            TeXObjectList teXObjectList = (TeXObjectList)teXObject;
            for (int i = 0; i < teXObjectList.size(); ++i) {
                this.addExclusions((TeXObject)teXObjectList.get(i));
            }
        } else if (!(teXObject instanceof Ignoreable) && !(teXObject instanceof WhiteSpace)) {
            this.debugMessage("warning.exclusions.unknown.token", teXObject);
        }
    }

    private void addExclusion(String string) {
        if (this.mfirstucExclusions == null) {
            this.mfirstucExclusions = new Vector();
        }
        this.mfirstucExclusions.add(string);
        if (this.mfirstucSty != null) {
            this.mfirstucSty.addExclusion(string);
        }
    }

    public boolean isCaseBlocker(String string) {
        if (this.mfirstucBlockers == null) {
            return false;
        }
        return this.mfirstucBlockers.contains(string);
    }

    private void addBlockers(TeXObject teXObject) {
        if (this.mfirstucBlockers == null) {
            this.mfirstucBlockers = new Vector();
        }
        if (teXObject instanceof ControlSequence) {
            String string = ((ControlSequence)teXObject).getName();
            this.mfirstucBlockers.add(string);
            if (this.mfirstucSty != null) {
                this.mfirstucSty.addBlocker(string);
            }
        } else if (teXObject instanceof TeXObjectList) {
            TeXObjectList teXObjectList = (TeXObjectList)teXObject;
            for (int i = 0; i < teXObjectList.size(); ++i) {
                this.addBlockers((TeXObject)teXObjectList.get(i));
            }
        } else if (!(teXObject instanceof Ignoreable) && !(teXObject instanceof WhiteSpace)) {
            this.debugMessage("warning.blockers.unknown.token", teXObject);
        }
    }

    private void addBlocker(String string) {
        if (this.mfirstucBlockers == null) {
            this.mfirstucBlockers = new Vector();
        }
        this.mfirstucBlockers.add(string);
        if (this.mfirstucSty != null) {
            this.mfirstucSty.addBlocker(string);
        }
    }

    public String getCaseMapping(String string) {
        if (this.mfirstucMappings == null) {
            return null;
        }
        return this.mfirstucMappings.get(string);
    }

    private void addMappings(CsvList csvList) {
        if (this.mfirstucMappings == null) {
            this.mfirstucMappings = new HashMap();
        }
        for (int i = 0; i < csvList.size(); ++i) {
            TeXObject teXObject = csvList.getValue(i);
            if (teXObject instanceof TeXObjectList) {
                String string = null;
                String string2 = null;
                TeXObjectList teXObjectList = (TeXObjectList)teXObject;
                boolean bl = false;
                for (int j = 0; j < teXObjectList.size(); ++j) {
                    TeXObject teXObject2 = (TeXObject)teXObjectList.get(j);
                    if (teXObject2 instanceof Other && ((Other)teXObject2).getCharCode() == 61) {
                        bl = true;
                        continue;
                    }
                    ControlSequence controlSequence = this.getFirstCs(teXObject2);
                    if (controlSequence == null) continue;
                    if (bl) {
                        string2 = controlSequence.getName();
                        break;
                    }
                    string = controlSequence.getName();
                }
                if (string != null && string2 != null) {
                    this.mfirstucMappings.put(string, string2);
                    if (this.mfirstucSty == null) continue;
                    this.mfirstucSty.addMapping(string, string2);
                    continue;
                }
                this.debugMessage("warning.mappings.cant.parse", teXObject);
                continue;
            }
            if (teXObject instanceof Ignoreable || teXObject instanceof WhiteSpace) continue;
            this.debugMessage("warning.mappings.cant.parse", teXObject);
        }
    }

    private ControlSequence getFirstCs(TeXObject teXObject) {
        if (teXObject instanceof ControlSequence) {
            return (ControlSequence)teXObject;
        }
        if (teXObject instanceof TeXObjectList) {
            for (TeXObject teXObject2 : (TeXObjectList)teXObject) {
                ControlSequence controlSequence = this.getFirstCs(teXObject2);
                if (controlSequence == null) continue;
                return controlSequence;
            }
        }
        return null;
    }

    public boolean checkNestedLinkTextField(String string) {
        if (this.nestedLinkCheckFields == null) {
            return false;
        }
        for (int i = 0; i < this.nestedLinkCheckFields.length; ++i) {
            if (!string.equals(this.nestedLinkCheckFields[i])) continue;
            return true;
        }
        return false;
    }

    public void addMglsCs(String string) {
        String[] stringArray;
        if (this.mglsCs == null) {
            this.mglsCs = new Vector();
        }
        for (String string2 : stringArray = string.split(",")) {
            this.mglsCs.add(string2);
        }
    }

    public boolean isMglsCs(String string) {
        if (this.mglsCs == null) {
            return false;
        }
        return this.mglsCs.contains(string);
    }

    public void addMglsRef(String string) {
        String[] stringArray;
        if (this.mglsRefs == null) {
            this.mglsRefs = new Vector();
        }
        for (String string2 : stringArray = string.split(",")) {
            if (this.mglsRefs.contains(string2)) continue;
            this.debugMessage("message.mgls.found", string2);
            this.mglsRefs.add(string2);
        }
    }

    public boolean isMglsRefd(String string) {
        if (this.mglsRefs == null) {
            return false;
        }
        return this.mglsRefs.contains(string);
    }

    public Vector<String> getMglsRefdList() {
        return this.mglsRefs;
    }

    public CompoundEntry getCompoundEntry(String string) {
        if (this.compoundEntries == null) {
            return null;
        }
        return this.compoundEntries.get(string);
    }

    public void addCompoundEntry(CompoundEntry compoundEntry) {
        this.addCompoundEntry(compoundEntry, false);
    }

    public void addCompoundEntry(CompoundEntry compoundEntry, boolean bl) {
        String string = compoundEntry.getLabel();
        if (this.compoundEntries == null) {
            this.compoundEntries = new HashMap();
        } else if (!bl && this.compoundEntries.containsKey(string)) {
            return;
        }
        this.compoundEntries.put(string, compoundEntry);
    }

    public boolean hasCompoundEntries() {
        return this.compoundEntries != null;
    }

    public Iterator<String> getCompoundEntryKeyIterator() {
        if (this.compoundEntries == null) {
            return null;
        }
        return this.compoundEntries.keySet().iterator();
    }

    public Iterator<CompoundEntry> getCompoundEntryValueIterator() {
        if (this.compoundEntries == null) {
            return null;
        }
        return this.compoundEntries.values().iterator();
    }

    public CompoundEntry getCompoundEntryWithMain(String string) {
        if (this.compoundEntries == null) {
            return null;
        }
        Iterator<CompoundEntry> iterator = this.getCompoundEntryValueIterator();
        while (iterator.hasNext()) {
            CompoundEntry compoundEntry = iterator.next();
            if (!compoundEntry.getMainLabel().equals(string)) continue;
            return compoundEntry;
        }
        return null;
    }

    public CompoundEntry getUniqueCompoundEntryWithMain(String string) {
        if (this.compoundEntries == null) {
            return null;
        }
        CompoundEntry compoundEntry = null;
        Iterator<CompoundEntry> iterator = this.getCompoundEntryValueIterator();
        while (iterator.hasNext()) {
            CompoundEntry compoundEntry2 = iterator.next();
            if (!compoundEntry2.getMainLabel().equals(string)) continue;
            if (compoundEntry == null) {
                compoundEntry = compoundEntry2;
                continue;
            }
            return null;
        }
        return compoundEntry;
    }

    public boolean useGroupField() {
        return this.addGroupField;
    }

    public boolean isMultipleSupplementarySupported() {
        return this.multiSuppSupported;
    }

    public Vector<String> getFields() {
        return this.fields;
    }

    public void addField(String string) {
        if (!this.fields.contains(string)) {
            this.fields.add(string);
        }
    }

    public HashMap<String, String> getFieldMap() {
        return this.fieldMap;
    }

    public boolean isInternalField(String string) {
        return string.startsWith("bib2gls@");
    }

    public boolean isNonBibField(String string) {
        for (String string2 : NON_BIB_FIELDS) {
            if (!string2.equals(string)) continue;
            return true;
        }
        for (String string2 : PRIVATE_NON_BIB_FIELDS) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return this.isInternalField(string) || string.startsWith("bibtexentry@") || string.endsWith("endpunc") || string.startsWith("recordcount.") || string.startsWith("currcount@") || string.startsWith("prevcount@");
    }

    public boolean isPrivateNonBibField(String string) {
        for (String string2 : PRIVATE_NON_BIB_FIELDS) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return this.isInternalField(string) || string.startsWith("bibtexentry@") || string.startsWith("recordcount.") || string.startsWith("currcount@") || string.startsWith("prevcount@");
    }

    public String getFieldKey(String string) {
        for (String string2 : this.fields) {
            if (string2.equals(string)) {
                return string;
            }
            if (!string.equals(this.fieldMap.get(string2))) continue;
            return string2;
        }
        return string;
    }

    public boolean arePrefixFieldsKnown() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (String string : this.fields) {
            if (string.equals("prefix")) {
                bl = true;
                continue;
            }
            if (string.equals("prefixplural")) {
                bl2 = true;
                continue;
            }
            if (string.equals("prefixfirst")) {
                bl3 = true;
                continue;
            }
            if (!string.equals("prefixfirstplural")) continue;
            bl4 = true;
        }
        return bl && bl2 && bl3 && bl4;
    }

    public boolean isKnownField(String string) {
        if (this.fields.isEmpty()) {
            this.debug("Empty field list when checking for field '" + string + "'");
        }
        for (String string2 : this.fields) {
            if (string2.equals(string)) {
                return true;
            }
            if (!string.equals(this.fieldMap.get(string2))) continue;
            return true;
        }
        return false;
    }

    public boolean isKnownSpecialField(String string) {
        for (String string2 : SPAWN_SPECIAL_FIELDS) {
            if (!string2.equals(string)) continue;
            return true;
        }
        for (String string2 : DUAL_SPECIAL_FIELDS) {
            if (!string2.equals(string)) continue;
            return true;
        }
        for (String string2 : OTHER_SPECIAL_FIELDS) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isCheckNonBibFieldsOn() {
        return this.checkNonBibFields;
    }

    public boolean isWarnUnknownEntryTypesOn() {
        return this.warnUnknownEntryTypes;
    }

    public boolean isProvideGlossariesOn() {
        return this.knownGlossaries != null;
    }

    public boolean isKnownGlossary(String string) {
        return this.knownGlossaries != null && this.knownGlossaries.contains(string);
    }

    public void addGlossary(String string) {
        this.knownGlossaries.add(string);
    }

    public void selectedEntry(String string) {
        this.selectedEntries.add(string);
    }

    public boolean isEntrySelected(String string) {
        return this.selectedEntries.contains(string);
    }

    public boolean anyEntriesSelected() {
        return !this.selectedEntries.isEmpty();
    }

    public GlsSeeRecord getSeeRecord(String string) {
        for (GlsSeeRecord glsSeeRecord : this.seeRecords) {
            if (!glsSeeRecord.getLabel().equals(string)) continue;
            return glsSeeRecord;
        }
        return null;
    }

    public Vector<GlsRecord> getRecords() {
        return this.records;
    }

    public Vector<GlsSeeRecord> getSeeRecords() {
        return this.seeRecords;
    }

    public boolean hasRecord(String string) {
        for (GlsRecord glsRecord : this.records) {
            if (!string.equals(glsRecord.getLabel())) continue;
            return true;
        }
        return false;
    }

    public boolean hasSeeRecord(String string) {
        for (GlsSeeRecord glsSeeRecord : this.seeRecords) {
            if (!string.equals(glsSeeRecord.getLabel())) continue;
            return true;
        }
        return false;
    }

    public GlsRecord getRecordCountKey(GlsRecord glsRecord) {
        if (this.recordCount == null) {
            return null;
        }
        Set<GlsRecord> set = this.recordCount.keySet();
        for (GlsRecord glsRecord2 : set) {
            boolean bl;
            boolean bl2 = bl = glsRecord2.getLabel().equals(glsRecord.getLabel()) && glsRecord2.getCounter().equals(glsRecord.getCounter());
            if (this.saveRecordCountUnit) {
                boolean bl3 = bl = bl && glsRecord2.getLocation().equals(glsRecord.getLocation());
            }
            if (!bl) continue;
            return glsRecord2;
        }
        return null;
    }

    public boolean isRecordCountSet() {
        return this.recordCount != null;
    }

    public Set<GlsRecord> getRecordCountKeySet() {
        return this.recordCount == null ? null : this.recordCount.keySet();
    }

    public Integer getRecordCount(GlsRecord glsRecord) {
        return this.recordCount == null ? null : this.recordCount.get(glsRecord);
    }

    public void writeRecordCount(String string, PrintWriter printWriter) throws IOException {
        Set<GlsRecord> set = this.getRecordCountKeySet();
        if (set == null) {
            return;
        }
        int n = 0;
        for (GlsRecord glsRecord : set) {
            if (!glsRecord.getLabel().equals(string)) continue;
            Integer n2 = this.getRecordCount(glsRecord);
            n += n2.intValue();
            printWriter.format("\\bibglssetrecordcount{%s}{%s}{%d}%n", string, glsRecord.getCounter(), n2);
            if (!this.saveRecordCountUnit) continue;
            printWriter.format("\\bibglssetlocationrecordcount{%s}{%s}{%s}{%d}%n", string, glsRecord.getCounter(), glsRecord.getLocation(), n2);
        }
        printWriter.format("\\bibglssettotalrecordcount{%s}{%d}%n", string, n);
    }

    public String replaceSpecialChars(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        int n = 0;
        while (n < string.length()) {
            int n2 = string.codePointAt(n);
            n += Character.charCount(n2);
            if (n2 == 92) {
                if (n < string.length() && string.substring(n).startsWith("char`\\")) {
                    int n3 = string.codePointAt(n + 6);
                    int n4 = Character.charCount(n3);
                    String string2 = this.getCsNameForLiteral(n3);
                    if (string2 != null) {
                        stringBuilder.append("\\" + string2 + " ");
                        bl = true;
                    } else {
                        stringBuilder.append(string.substring(n - 1, n + 6 + n4));
                    }
                    n = n + 6 + n4;
                    continue;
                }
                stringBuilder.append("\\glsbackslash ");
                bl = true;
                continue;
            }
            String string3 = this.getCsNameForLiteral(n2);
            if (string3 != null) {
                stringBuilder.append("\\" + string3 + " ");
                bl = true;
                continue;
            }
            if (bl && Character.isWhitespace(n2)) {
                stringBuilder.append("\\space");
            }
            bl = false;
            stringBuilder.appendCodePoint(n2);
        }
        return stringBuilder.toString();
    }

    public String getCsNameForLiteral(int n) {
        switch (n) {
            case 92: {
                return "glsbackslash";
            }
            case 37: {
                return "glspercentchar";
            }
            case 123: {
                return "glsopenbrace";
            }
            case 125: {
                return "glsclosebrace";
            }
            case 126: {
                return "glstildechar";
            }
            case 35: {
                return "bibglshashchar";
            }
            case 95: {
                return "bibglsunderscorechar";
            }
            case 36: {
                return "bibglsdollarchar";
            }
            case 38: {
                return "bibglsampersandchar";
            }
            case 94: {
                return "bibglscircumchar";
            }
            case 39: {
                if (!this.replaceQuotes) break;
                return "bibglsaposchar";
            }
            case 34: {
                if (!this.replaceQuotes) break;
                return "bibglsdoublequotechar";
            }
        }
        return null;
    }

    public boolean hasNewHyperGroupSupport() {
        return this.hasNewHyperGroupSupport;
    }

    public void writeCommonCommands(PrintWriter printWriter) throws IOException {
        if (this.commonCommandsDone) {
            return;
        }
        if (this.replaceQuotes) {
            printWriter.println("\\providecommand{\\bibglsaposchar}{\\string'}");
            printWriter.println("\\providecommand{\\bibglsdoublequotechar}{\\string\"}");
        }
        printWriter.println("\\providecommand{\\bibglshashchar}{\\expandafter\\@gobble\\string\\#}");
        printWriter.println("\\providecommand{\\bibglscircumchar}{\\expandafter\\@gobble\\string\\^}");
        printWriter.println("\\providecommand{\\bibglsdollarchar}{\\expandafter\\@gobble\\string\\$}");
        printWriter.println("\\providecommand{\\bibglsampersandchar}{\\expandafter\\@gobble\\string\\&}");
        printWriter.println("\\providecommand{\\bibglsunderscorechar}{\\expandafter\\@gobble\\string\\_}");
        printWriter.println("\\providecommand{\\bibglshrefchar}[2]{\\glspercentchar #1}");
        if (this.fontspec) {
            printWriter.println("\\providecommand{\\bibglshrefunicode}[2]{#2}");
        }
        if (this.hyperref) {
            printWriter.println("\\providecommand{\\bibglshexunicodechar}[1]{\\csname ifHy@unicode\\endcsname\\texorpdfstring{\\symbol{\\string\"#1}}{\\unichar{\\string\"#1}}\\else\\symbol{\\string\"#1}\\fi}");
        } else {
            printWriter.println("\\providecommand{\\bibglshexunicodechar}[1]{\\symbol{\\string\"#1}}");
        }
        printWriter.println("\\providecommand{\\bibglsusesee}[1]{\\glsxtrusesee{#1}}");
        printWriter.println("\\providecommand{\\bibglsusealias}[1]{%");
        printWriter.println(" \\glsxtrifhasfield{alias}{#1}%");
        printWriter.println(" {\\expandafter\\glsseeformat\\expandafter{\\glscurrentfieldvalue}{}}%");
        printWriter.println(" {}%");
        printWriter.println("}");
        printWriter.println("\\providecommand{\\bibglsuseseealso}[1]{\\glsxtruseseealso{#1}}");
        printWriter.println("\\providecommand{\\bibglsdelimN}{\\delimN}");
        printWriter.println("\\providecommand{\\bibglslastDelimN}{,~}");
        printWriter.println("\\providecommand{\\bibglsrange}[1]{#1}");
        printWriter.println("\\providecommand{\\bibglsinterloper}[1]{#1\\bibglsdelimN }");
        printWriter.println("\\providecommand{\\bibglspassim}{ \\bibglspassimname}");
        printWriter.println("\\providecommand*{\\bibglshyperlink}[2]{\\glshyperlink[#1]{#2}}");
        printWriter.println();
        if (this.hasNewCaseSupport) {
            printWriter.println("\\providecommand{\\bibglsuppercase}{\\glsuppercase}");
            printWriter.println("\\providecommand{\\bibglslowercase}{\\glslowercase}");
        } else {
            printWriter.println("\\providecommand{\\bibglsuppercase}{\\MakeTextUppercase}");
            printWriter.println("\\providecommand{\\bibglslowercase}{\\MakeTextLowercase}");
        }
        printWriter.println("\\providecommand{\\bibglsfirstuc}{\\makefirstuc}");
        printWriter.println("\\providecommand{\\bibglstitlecase}{\\capitalisewords}");
        printWriter.println();
        printWriter.println("\\providecommand{\\bibglsprimaryprefixlabel}[1]{}");
        printWriter.println("\\providecommand{\\bibglsdualprefixlabel}[1]{}");
        printWriter.println("\\providecommand{\\bibglstertiaryprefixlabel}[1]{}");
        printWriter.println("\\providecommand{\\bibglsexternalprefixlabel}[2]{}");
        printWriter.println();
        if (this.recordCount != null) {
            printWriter.println("\\ifdef\\glsxtrenablerecordcount %glossaries-extra.sty v1.21+");
            printWriter.println("{\\glsxtrenablerecordcount}");
            printWriter.println("{");
            printWriter.println(" \\PackageWarning{bib2gls}{You need at least v1.21 of glossaries-extra with --record-count or --record-count-unit}");
            printWriter.println("}");
            printWriter.println();
            printWriter.println("\\providecommand*{\\bibglssetrecordcount}[3]{%");
            printWriter.println("   \\GlsXtrSetField{#1}{recordcount.#2}{#3}%");
            printWriter.println("}");
            printWriter.println("\\providecommand*{\\bibglssettotalrecordcount}[2]{%");
            printWriter.println("   \\GlsXtrSetField{#1}{recordcount}{#2}%");
            printWriter.println("}");
            if (this.saveRecordCountUnit) {
                printWriter.println("\\ifdef\\glsxtrdetoklocation");
                printWriter.println("{% glossaries-extra v1.21+");
                printWriter.println("  \\providecommand*{\\bibglssetlocationrecordcount}[4]{%");
                printWriter.println("     \\GlsXtrSetField{#1}{recordcount.#2.\\glsxtrdetoklocation{#3}}{#4}%");
                printWriter.println("  }");
                printWriter.println("}");
                printWriter.println("{");
                printWriter.println("  \\providecommand*{\\bibglssetlocationrecordcount}[4]{%");
                printWriter.println("     \\GlsXtrSetField{#1}{recordcount.#2.#3}{#4}%");
                printWriter.println("  }");
                printWriter.println("}");
            }
        }
        if (this.glossariesExtraVersion.compareTo("2021/09/20") <= 0) {
            printWriter.println("\\providecommand*{\\glsxtrapptocsvfield}[3]{%");
            printWriter.println(" \\ifcsdef{glo@\\glsdetoklabel{#1}@#2}%");
            printWriter.println(" {\\csappto{glo@\\glsdetoklabel{#1}@#2}{,#3}}%");
            printWriter.println(" {\\csdef{glo@\\glsdetoklabel{#1}@#2}{#3}}%");
            printWriter.println("}");
        }
        this.commonCommandsDone = true;
    }

    public void incRecordCount(GlsRecord glsRecord) {
        if (this.recordCount == null) {
            return;
        }
        GlsRecord glsRecord2 = this.getRecordCountKey(glsRecord);
        if (this.recordCountRule.isAllowed(glsRecord)) {
            if (glsRecord2 == null) {
                this.recordCount.put(glsRecord, 1);
            } else {
                Integer n = this.recordCount.get(glsRecord2);
                this.recordCount.put(glsRecord2, n + 1);
            }
        }
    }

    public boolean mfirstucProtection() {
        return this.mfirstucProtect;
    }

    public boolean mfirstucMathShiftProtection() {
        return this.mfirstucMProtect;
    }

    public String[] mfirstucProtectionFields() {
        return this.mfirstucProtectFields;
    }

    public TeXParser createTeXParser(TeXParserListener teXParserListener) {
        TeXParser teXParser = new TeXParser(teXParserListener);
        teXParser.setBaseDir(new File("."));
        if (this.debugLevel > 0) {
            teXParser.setDebugMode(this.debugLevel, this.logWriter);
        }
        return teXParser;
    }

    public void logEncodingDetected(Charset charset) {
        this.logMessage(this.getMessage("message.detected.charset", charset));
    }

    public void logEncoding(Charset charset) {
        if (charset == null) {
            this.logMessage(this.getMessage("message.charset", this.getMessage("message.null", new Object[0])));
        } else {
            this.logMessage(this.getMessage("message.charset", charset.name()));
        }
    }

    public void logEncoding(String string) {
        if (string == null) {
            this.logMessage(this.getMessage("message.charset", this.getMessage("message.null", new Object[0])));
        } else {
            this.logMessage(this.getMessage("message.charset", string));
        }
    }

    public void logDefaultEncoding(Charset charset) {
        if (charset == null) {
            this.logMessage(this.getMessage("message.default.charset", this.getMessage("message.null", new Object[0])));
        } else {
            this.logMessage(this.getMessage("message.default.charset", charset.name()));
        }
    }

    public void logDefaultEncoding(String string) {
        if (string == null) {
            this.logMessage(this.getMessage("message.default.charset", this.getMessage("message.null", new Object[0])));
        } else {
            this.logMessage(this.getMessage("message.default.charset", string));
        }
    }

    public void logMessageNoLn(String string) {
        if (this.logWriter != null) {
            this.logWriter.print(string);
        } else if (this.pendingWriter != null) {
            this.pendingWriter.print(string);
        }
    }

    public void logMessage(String string) {
        if (this.logWriter != null) {
            this.logWriter.println(string);
        } else if (this.pendingWriter != null) {
            this.pendingWriter.println(string);
        }
    }

    public void logMessage() {
        if (this.logWriter != null) {
            this.logWriter.println();
        } else if (this.pendingWriter != null) {
            this.pendingWriter.println();
        }
    }

    public void logAndPrintMessageNoLn(String string) {
        this.logMessageNoLn(string);
        System.out.print(string);
    }

    public void logAndPrintMessage(String string) {
        this.logMessage(string);
        System.out.println(string);
    }

    public void logAndPrintMessage() {
        this.logMessage();
        System.out.println();
    }

    public int getDebugLevel() {
        return this.debugLevel;
    }

    public int getVerboseLevel() {
        return this.verboseLevel;
    }

    public void debugMessage(String string, Object ... objectArray) {
        if (this.debugLevel > 0) {
            this.logAndPrintMessage(this.getMessage(string, objectArray));
        }
    }

    public void debug(String string) {
        if (this.debugLevel > 0) {
            this.logAndPrintMessage(string);
        }
    }

    public void debug(Throwable throwable) {
        if (this.debugLevel > 0) {
            String string = throwable.getMessage();
            if (string == null) {
                string = throwable.getClass().getSimpleName();
            }
            this.logAndPrintMessage(string);
            throwable.printStackTrace();
            if (this.logWriter != null) {
                throwable.printStackTrace(this.logWriter);
            } else if (this.pendingWriter != null) {
                throwable.printStackTrace(this.pendingWriter);
            }
        }
    }

    public void debug(String string, Throwable throwable) {
        if (this.debugLevel > 0) {
            String string2 = throwable.getMessage();
            if (string2 == null) {
                string2 = throwable.getClass().getSimpleName();
            }
            if (string != null) {
                string2 = string + string2;
            }
            this.logAndPrintMessage(string2);
            throwable.printStackTrace();
            if (this.logWriter != null) {
                throwable.printStackTrace(this.logWriter);
            } else if (this.pendingWriter != null) {
                throwable.printStackTrace(this.pendingWriter);
            }
        }
    }

    public void debug() {
        if (this.debugLevel > 0) {
            System.out.println();
            this.logMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String kpsewhich(String string) throws IOException, InterruptedException {
        String string2 = this.kpsewhichResults.get(string);
        if (string2 != null) {
            return string2;
        }
        this.debug(this.getMessageWithFallback("message.running", "Running {0}", String.format("kpsewhich '%s'", string)));
        Process process = null;
        int n = -1;
        try {
            process = new ProcessBuilder("kpsewhich", string).start();
            n = process.waitFor();
        }
        catch (Exception exception) {
            this.debug(exception);
            return null;
        }
        String string3 = null;
        if (n == 0) {
            InputStream inputStream = process.getInputStream();
            if (inputStream == null) {
                throw new IOException(this.getMessageWithFallback("error.cant.open.process.stream", "Unable to open input stream from process: {0}", String.format("kpsewhich '%s'", string)));
            }
            try (BufferedReader bufferedReader = null;){
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                string3 = bufferedReader.readLine();
                this.debug(this.getMessageWithFallback("message.process.result", "Processed returned: {0}", string3));
            }
        } else if (this.debugLevel > 0) {
            this.logAndPrintMessage(this.getMessageWithFallback("error.app_failed", "{0} failed with exit code {1}", String.format("kpsewhich '%s'", string), n));
        }
        this.kpsewhichResults.put(string, string3);
        return string3;
    }

    public TeXPath getBibFilePath(TeXParser teXParser, String string) throws IOException, InterruptedException {
        TeXPath teXPath = new TeXPath(teXParser, string, "bib", false);
        File file = teXPath.getFile();
        if (!file.exists()) {
            Object object;
            this.debug(this.getMessage("error.file.not.found", file));
            File file2 = file;
            if (this.basePath.equals(this.cwd)) {
                object = this.auxFile.getParentFile();
                file2 = new File((File)object, file.getName());
            } else {
                file2 = this.resolvePath(teXPath.getRelativePath()).toFile();
                if (!file2.exists()) {
                    this.debug(this.getMessage("error.file.not.found", file2));
                    object = this.auxFile.getParentFile();
                    file2 = new File((File)object, file.getName());
                }
            }
            if (!file2.exists() && (object = this.kpsewhich(file.getName())) != null && !((String)object).isEmpty()) {
                return new TeXPath(teXParser, (String)object, "", false);
            }
            if (file2.exists()) {
                teXPath = new TeXPath(teXParser, file2);
            } else {
                this.debug(this.getMessage("error.file.not.found", file2));
            }
        }
        return teXPath;
    }

    public String getTeXPathHref(TeXPath teXPath) {
        int n;
        String string = teXPath.toString();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); i += Character.charCount(n)) {
            n = string.codePointAt(i);
            if (n == 45 || n == 46 || n == 58 || n >= 47 && n <= 57 || n >= 65 && n <= 90 || n >= 97 && n <= 122) {
                stringBuilder.appendCodePoint(n);
                continue;
            }
            if (this.fontspec && n > 127) {
                stringBuilder.append(String.format("\\bibglshrefunicode{%02X}{%s}", n, new String(Character.toChars(n))));
                continue;
            }
            if (n == 92) {
                stringBuilder.append(String.format("\\bibglshrefchar{%02X}{\\glsbackslash }", n));
                continue;
            }
            if (n == 37) {
                stringBuilder.append(String.format("\\bibglshrefchar{%02X}{\\glspercentchar }", n));
                continue;
            }
            if (n == 35) {
                stringBuilder.append(String.format("\\bibglshrefchar{%02X}{\\bibglshashchar }", n));
                continue;
            }
            if (n == 36) {
                stringBuilder.append(String.format("\\bibglshrefchar{%02X}{\\bibglsdollarchar }", n));
                continue;
            }
            if (n == 95) {
                stringBuilder.append(String.format("\\bibglshrefchar{%02X}{\\bibglsunderscorechar }", n));
                continue;
            }
            if (n == 38) {
                stringBuilder.append(String.format("\\bibglshrefchar{%02X}{\\bibglsampersandchar }", n));
                continue;
            }
            if (n == 94) {
                stringBuilder.append(String.format("\\bibglshrefchar{%02X}{\\bibglscircumchar }", n));
                continue;
            }
            if (n == 123) {
                stringBuilder.append(String.format("\\bibglshrefchar{%02X}{\\glsopenbrace }", n));
                continue;
            }
            if (n == 125) {
                stringBuilder.append(String.format("\\bibglshrefchar{%02X}{\\glsclosebrace }", n));
                continue;
            }
            if (n == 126) {
                stringBuilder.append(String.format("\\bibglshrefchar{%02X}{\\glstildechar }", n));
                continue;
            }
            stringBuilder.append(String.format("\\bibglshrefchar{%02X}{%s}", n, new String(Character.toChars(n))));
        }
        return stringBuilder.toString();
    }

    public void epstopdf(File file, File file2) throws IOException, InterruptedException {
        if (this.debugLevel > 0) {
            System.err.format("Ignoring unexpected request to convert %s to %s%n", file.toString(), file2.toString());
        }
    }

    public void wmftoeps(File file, File file2) throws IOException, InterruptedException {
        if (this.debugLevel > 0) {
            System.err.format("Ignoring unexpected request to convert %s to %s%n", file.toString(), file2.toString());
        }
    }

    public void convertimage(int n, String[] stringArray, File file, String[] stringArray2, File file2) throws IOException, InterruptedException {
        if (this.debugLevel > 0) {
            System.err.format("Ignoring unexpected request to convert %s to %s%n", file.toString(), file2.toString());
        }
    }

    public void substituting(TeXParser teXParser, String string, String string2) {
        this.verboseMessage("warning.substituting", string, string2);
    }

    public void progress(int n) {
    }

    public String getMessage(String string, Object ... objectArray) {
        if (this.messages == null) {
            String string2 = objectArray.length == 0 ? "" : objectArray[0].toString();
            for (int i = 1; i < objectArray.length; ++i) {
                string2 = string2 + "," + objectArray[0].toString();
            }
            return String.format("%s[%s]", string, string2);
        }
        String string3 = string;
        try {
            string3 = this.messages.getMessage(string, objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.warning("Can't find message for label: " + string, illegalArgumentException);
        }
        return string3;
    }

    public String getMessage(TeXParser teXParser, String string, Object ... objectArray) {
        if (teXParser == null) {
            return this.getMessage(string, objectArray);
        }
        int n = teXParser.getLineNumber();
        File file = teXParser.getCurrentFile();
        if (n == -1 || file == null) {
            return this.getMessage(string, objectArray);
        }
        return Bib2Gls.fileLineMessage(file, n, this.getMessage(string, objectArray));
    }

    public String getMessageWithFallback(String string, String string2, Object ... objectArray) {
        if (this.messages == null) {
            MessageFormat messageFormat = new MessageFormat(string2);
            return MessageFormat.format(string2, objectArray);
        }
        try {
            return this.messages.getMessage(string, objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.warning("Can't find message for label: " + string, illegalArgumentException);
            MessageFormat messageFormat = new MessageFormat(string2);
            return MessageFormat.format(string2, objectArray);
        }
    }

    public String getMessageIfExists(String string) {
        if (this.messages == null) {
            return null;
        }
        String string2 = this.messages.getMessageIfExists(string, new Object[0]);
        if (string2 == null && this.getDebugLevel() > 0) {
            this.debug("No message for label '" + string + "'");
        }
        return string2;
    }

    public String getChoiceMessage(String string, int n, String string2, int n2, Object ... objectArray) {
        if (this.messages == null) {
            String string3 = objectArray.length == 0 ? "" : objectArray[0].toString();
            for (int i = 1; i < objectArray.length; ++i) {
                string3 = string3 + "," + objectArray[0].toString();
            }
            return String.format("%s[%s]", string, string3);
        }
        String string4 = string;
        try {
            string4 = this.messages.getChoiceMessage(string, n, string2, n2, objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.warning("Can't find message for label: " + string, illegalArgumentException);
        }
        return string4;
    }

    public String getLocalisationText(String string, Locale locale, String string2, String string3) {
        if (locale != null) {
            String string4;
            String string5 = locale.toLanguageTag();
            String string6 = this.getMessageIfExists(String.format("%s.%s.%s", string, string5, string2));
            if (string6 != null) {
                return string6;
            }
            String string7 = locale.getCountry();
            String string8 = locale.getLanguage();
            if (!(string7 == null || string7.isEmpty() || string8 == null || string8.isEmpty() || (string4 = String.format("%s-%s", string8, string7)).equals(string5) || (string6 = this.getMessageIfExists(String.format("%s.%s.%s", string, string4, string2))) == null)) {
                return string6;
            }
            if (string8 != null && !string8.isEmpty() && !string8.equals(string5) && (string6 = this.getMessageIfExists(String.format("%s.%s.%s", string, string8, string2))) != null) {
                return string6;
            }
        }
        return string3;
    }

    public String getLocalisationText(String string, Locale locale, String string2) {
        String string3 = this.getLocalisationTextIfExists(string, locale, string2);
        if (string3 == null) {
            this.warning(String.format("Can't find message for label: %s.%s", string, string2));
            string3 = String.format("%s.%s", string, string2);
        }
        return string3;
    }

    public String getLocalisationTextIfExists(String string, Locale locale, String string2) {
        String string3;
        if (locale != null && (string3 = this.getLocalisationText(string, locale, string2, null)) != null) {
            return string3;
        }
        if (this.defaultLocale != null && !this.defaultLocale.equals(locale) && (string3 = this.getLocalisationText(string, this.defaultLocale, string2, null)) != null) {
            return string3;
        }
        if (!(this.docLocale == null || locale != null && locale.toLanguageTag().equals(this.docLocale) || (string3 = this.getMessageIfExists(String.format("%s.%s.%s", string, this.docLocale, string2))) == null)) {
            return string3;
        }
        return this.getMessageIfExists(String.format("%s.%s", string, string2));
    }

    public void message(String string) {
        if (this.verboseLevel >= 0) {
            System.out.println(string);
        }
        this.logMessage(string);
    }

    public void verboseMessage(String string, Object ... objectArray) {
        this.verbose(this.getMessage(string, objectArray));
    }

    public void verbose(String string) {
        if (this.verboseLevel > 0) {
            System.out.println(string);
        }
        this.logMessage(string);
    }

    public void verbose() {
        if (this.verboseLevel > 0) {
            System.out.println();
        }
        this.logMessage();
    }

    public void verbose(TeXParser teXParser, String string) {
        int n = teXParser.getLineNumber();
        File file = teXParser.getCurrentFile();
        if (n != -1 && file != null) {
            string = Bib2Gls.fileLineMessage(file, n, string);
        }
        this.verbose(string);
    }

    public static String fileLineMessage(File file, int n, String string) {
        return String.format("%s:%d: %s", file.toString(), n, string);
    }

    public static boolean isScriptDigit(int n) {
        return Bib2Gls.isSubscriptDigit(n) || Bib2Gls.isSuperscriptDigit(n);
    }

    public static boolean isSubscriptDigit(int n) {
        switch (n) {
            case 8320: 
            case 8321: 
            case 8322: 
            case 8323: 
            case 8324: 
            case 8325: 
            case 8326: 
            case 8327: 
            case 8328: 
            case 8329: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSuperscriptDigit(int n) {
        switch (n) {
            case 178: 
            case 179: 
            case 185: 
            case 8304: 
            case 8308: 
            case 8309: 
            case 8310: 
            case 8311: 
            case 8312: 
            case 8313: {
                return true;
            }
        }
        return false;
    }

    public static Integer parseInt(String string) throws NumberFormatException {
        try {
            if (string.codePointAt(0) == 8722) {
                return Integer.valueOf("-" + string.substring(1));
            }
            return Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            int n;
            StringBuilder stringBuilder = new StringBuilder();
            block16: for (int i = 0; i < string.length(); i += Character.charCount(n)) {
                n = string.codePointAt(i);
                switch (n) {
                    case 8304: 
                    case 8320: {
                        stringBuilder.append('0');
                        continue block16;
                    }
                    case 185: 
                    case 8321: {
                        stringBuilder.append('1');
                        continue block16;
                    }
                    case 178: 
                    case 8322: {
                        stringBuilder.append('2');
                        continue block16;
                    }
                    case 179: 
                    case 8323: {
                        stringBuilder.append('3');
                        continue block16;
                    }
                    case 8308: 
                    case 8324: {
                        stringBuilder.append('4');
                        continue block16;
                    }
                    case 8309: 
                    case 8325: {
                        stringBuilder.append('5');
                        continue block16;
                    }
                    case 8310: 
                    case 8326: {
                        stringBuilder.append('6');
                        continue block16;
                    }
                    case 8311: 
                    case 8327: {
                        stringBuilder.append('7');
                        continue block16;
                    }
                    case 8312: 
                    case 8328: {
                        stringBuilder.append('8');
                        continue block16;
                    }
                    case 8313: 
                    case 8329: {
                        stringBuilder.append('9');
                        continue block16;
                    }
                    case 8314: 
                    case 8330: {
                        stringBuilder.append('+');
                        continue block16;
                    }
                    case 8315: 
                    case 8331: {
                        stringBuilder.append('-');
                        continue block16;
                    }
                }
                stringBuilder.appendCodePoint(n);
            }
            return Integer.valueOf(stringBuilder.toString());
        }
    }

    public void warning(TeXParser teXParser, String string) {
        if (this.verboseLevel >= 0) {
            int n = teXParser.getLineNumber();
            File file = teXParser.getCurrentFile();
            if (n == -1 || file == null) {
                this.warning(string);
            } else {
                this.warning(file, n, string);
            }
        }
    }

    public void warning(File file, int n, String string) {
        if (this.verboseLevel >= 0) {
            this.warning(Bib2Gls.fileLineMessage(file, n, string));
        }
    }

    public void warning(File file, int n, String string, Exception exception) {
        if (this.verboseLevel >= 0) {
            this.warning(Bib2Gls.fileLineMessage(file, n, string), exception);
        }
    }

    public void warning(String string) {
        string = this.getMessageWithFallback("warning.title", "Warning: {0}", string);
        if (this.verboseLevel >= 0) {
            System.err.println(string);
        }
        this.logMessage(string);
    }

    public void warningMessage(String string, Object ... objectArray) {
        this.warning(this.getMessage(string, objectArray));
    }

    public void warning() {
        if (this.verboseLevel >= 0) {
            System.err.println();
        }
        this.logMessage();
    }

    public void warning(String string, Exception exception) {
        if (this.verboseLevel >= 0) {
            System.err.println(string);
        }
        this.logMessage(string);
        if (this.debugLevel > 0) {
            exception.printStackTrace();
            for (StackTraceElement stackTraceElement : exception.getStackTrace()) {
                this.logMessage(stackTraceElement.toString());
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void error(Exception exception) {
        block10: {
            if (exception instanceof TeXSyntaxException) {
                TeXParser teXParser = ((TeXSyntaxException)exception).getParser();
                if (teXParser == null || teXParser.getListener() instanceof Bib2GlsBibParser) {
                    this.error(((TeXSyntaxException)exception).getMessage((TeXApp)this));
                    break block10;
                } else {
                    this.warning(((TeXSyntaxException)exception).getMessage((TeXApp)this));
                    if (this.debugLevel > 0) {
                        exception.printStackTrace();
                        for (StackTraceElement stackTraceElement : exception.getStackTrace()) {
                            this.logMessage(stackTraceElement.toString());
                        }
                    }
                    return;
                }
            }
            if (exception instanceof NoSuchFileException) {
                this.error(this.getMessage("tex.error.file.not.found", ((NoSuchFileException)exception).getFile()));
            } else {
                void var2_5;
                String string = exception.getMessage();
                if (string == null) {
                    String string2 = exception.getClass().getSimpleName();
                }
                this.error((String)var2_5);
            }
        }
        if (this.debugLevel > 0) {
            exception.printStackTrace();
            for (StackTraceElement stackTraceElement : exception.getStackTrace()) {
                this.logMessage(stackTraceElement.toString());
            }
        }
        this.exitCode = 2;
    }

    public void error(String string) {
        string = this.getMessageWithFallback("error.title", "Error: {0}", string);
        System.err.println(string);
        this.logMessage(string);
    }

    public void copyFile(File file, File file2) throws IOException, InterruptedException {
        if (this.debugLevel > 0) {
            System.err.format("Ignoring unexpected request to copy files %s -> %s%n", file.toString(), file2.toString());
        }
    }

    public String requestUserInput(String string) throws IOException {
        if (this.debugLevel > 0) {
            System.err.format("Ignoring unexpected request for user input. Message: %s%n", string);
        }
        return "";
    }

    public String getApplicationName() {
        return NAME;
    }

    public String getApplicationVersion() {
        return VERSION;
    }

    public void version() {
        System.out.println(this.getMessageWithFallback("about.version", "{0} version {1} ({2})", NAME, VERSION, DATE));
    }

    public void license() {
        System.out.println("https://github.com/nlct/bib2gls");
        System.out.println();
        System.out.format("Copyright 2017-%s Nicola Talbot%n", DATE.substring(0, 4));
        System.out.println(this.getMessage("about.license", new Object[0]));
    }

    public void libraryVersion() {
        System.out.println();
        System.out.println(this.getMessageWithFallback("about.library.version", "Bundled with {0} version {1} ({2})", "texparserlib.jar", "0.9.9b", DATE));
        System.out.println("https://github.com/nlct/texparser");
    }

    private void printSyntaxItem(String string) {
        String[] stringArray = string.split("\t", 2);
        if (stringArray.length == 2) {
            String string2 = stringArray[1].replaceAll(" *\\n", " ");
            int n = stringArray[0].length();
            int n2 = string2.length();
            System.out.print("  " + stringArray[0]);
            int n3 = 30 - n - 2;
            if (n3 <= 0) {
                n3 = 2;
            }
            int n4 = n + 2 + n3;
            int n5 = 78 - n4;
            for (int i = 0; i < n3; ++i) {
                System.out.print(' ');
            }
            if (n5 >= n2) {
                System.out.println(string2);
            } else {
                BreakIterator breakIterator = BreakIterator.getLineInstance();
                breakIterator.setText(string2);
                int n6 = breakIterator.first();
                int n7 = 0;
                int n8 = 48;
                n3 = 30;
                int n9 = breakIterator.next();
                while (n9 != -1) {
                    int n10 = n9 - n6;
                    if ((n7 += n10) >= n5) {
                        System.out.println();
                        for (int i = 0; i < n3; ++i) {
                            System.out.print(' ');
                        }
                        n7 = n10;
                        n5 = n8;
                    }
                    System.out.print(string2.substring(n6, n9));
                    n6 = n9;
                    n9 = breakIterator.next();
                }
                System.out.println();
            }
        } else if (stringArray.length == 1) {
            String string3 = stringArray[0].replaceAll(" *\\n", " ");
            int n = string3.length();
            if (n <= 78) {
                System.out.println(string3);
            } else {
                BreakIterator breakIterator = BreakIterator.getLineInstance();
                breakIterator.setText(string3);
                int n11 = breakIterator.first();
                int n12 = 0;
                int n13 = breakIterator.next();
                while (n13 != -1) {
                    int n14 = n13 - n11;
                    if ((n12 += n14) >= 78) {
                        System.out.println();
                        n12 = n14;
                    }
                    System.out.print(string3.substring(n11, n13));
                    n11 = n13;
                    n13 = breakIterator.next();
                }
                System.out.println();
            }
        }
    }

    public void help() {
        System.out.println(this.getMessage("syntax.usage", NAME));
        System.out.println();
        this.printSyntaxItem(this.getMessage("syntax.info", "--dir"));
        System.out.println();
        System.out.println(this.getMessage("syntax.options.common", new Object[0]));
        System.out.println();
        this.printSyntaxItem(this.getMessage("syntax.help", "--help", "-h"));
        this.printSyntaxItem(this.getMessage("syntax.version", "--version", "-v"));
        this.printSyntaxItem(this.getMessage("syntax.debug", "--[no-]debug"));
        this.printSyntaxItem(this.getMessage("syntax.debug-mode", "--debug-mode"));
        this.printSyntaxItem(this.getMessage("syntax.verbose", "--[no-]verbose"));
        this.printSyntaxItem(this.getMessage("syntax.silent", "--silent", "-q", "--quiet"));
        this.printSyntaxItem(this.getMessage("syntax.group", "--[no-]group", "-g"));
        System.out.println();
        System.out.println(this.getMessage("syntax.options.files", new Object[0]));
        System.out.println();
        this.printSyntaxItem(this.getMessage("syntax.dir", "--dir", "-d"));
        this.printSyntaxItem(this.getMessage("syntax.log", "--log-file", "-t"));
        this.printSyntaxItem(this.getMessage("syntax.tex.encoding", "--tex-encoding"));
        this.printSyntaxItem(this.getMessage("syntax.log.encoding", "--log-encoding"));
        this.printSyntaxItem(this.getMessage("syntax.default.encoding", "--default-encoding"));
        this.printSyntaxItem(this.getMessage("syntax.date_in_header", "--[no-]date-in-header"));
        System.out.println();
        System.out.println(this.getMessage("syntax.options.interpreter", new Object[0]));
        System.out.println();
        this.printSyntaxItem(this.getMessage("syntax.break.space", "--[no-]break-space"));
        this.printSyntaxItem(this.getMessage("syntax.obey.aux.catcode", "--[no-]obey-aux-catcode"));
        this.printSyntaxItem(this.getMessage("syntax.custom.packages", "--custom-packages"));
        this.printSyntaxItem(this.getMessage("syntax.ignore.packages", "--ignore-packages", "-k"));
        this.printSyntaxItem(this.getMessage("syntax.interpret", "--[no-]interpret"));
        this.printSyntaxItem(this.getMessage("syntax.list.known.packages", "--list-known-packages"));
        this.printSyntaxItem(this.getMessage("syntax.packages", "--packages", "-p"));
        this.printSyntaxItem(this.getMessage("syntax.support.unicode.script", "--[no-]support-unicode-script"));
        System.out.println();
        System.out.println(this.getMessage("syntax.options.records", new Object[0]));
        System.out.println();
        this.printSyntaxItem(this.getMessage("syntax.cite.as.record", "--[no-]cite-as-record"));
        this.printSyntaxItem(this.getMessage("syntax.collapse.same.location.range", "--[no-]collapse-same-location-range"));
        this.printSyntaxItem(this.getMessage("syntax.format.map", "--map-format", "-m"));
        this.printSyntaxItem(this.getMessage("syntax.merge.nameref.on", "--merge-nameref-on"));
        this.printSyntaxItem(this.getMessage("syntax.merge.wrglossary.records", "--[no-]merge-wrglossary-records"));
        this.printSyntaxItem(this.getMessage("syntax.record.count.rule", "--record-count-rule", "-r"));
        this.printSyntaxItem(this.getMessage("syntax.record.count", "--[no-]record-count", "-c"));
        this.printSyntaxItem(this.getMessage("syntax.record.count.unit", "--record-count-unit", "-n"));
        this.printSyntaxItem(this.getMessage("syntax.retain.formats", "--[no-]retain-formats"));
        System.out.println();
        System.out.println(this.getMessage("syntax.options.bib", new Object[0]));
        System.out.println();
        this.printSyntaxItem(this.getMessage("syntax.warn.non.bib.fields", "--[no-]warn-non-bib-fields"));
        this.printSyntaxItem(this.getMessage("syntax.warn.unknown.entry.types", "--[no-]warn-unknown-entry-types"));
        System.out.println();
        System.out.println(this.getMessage("syntax.options.fields", new Object[0]));
        System.out.println();
        this.printSyntaxItem(this.getMessage("syntax.expand.fields", "--[no-]expand-fields"));
        this.printSyntaxItem(this.getMessage("syntax.math.mfirstuc", "--[no-]mfirstuc-math-protection"));
        this.printSyntaxItem(this.getMessage("syntax.mfirstuc", "--[no-]mfirstuc-protection", "-u"));
        this.printSyntaxItem(this.getMessage("syntax.check.nested", "--[no-]nested-link-check"));
        this.printSyntaxItem(this.getMessage("syntax.check.shortcuts", "--shortcuts"));
        this.printSyntaxItem(this.getMessage("syntax.trim.fields", "--[no-]trim-fields"));
        this.printSyntaxItem(this.getMessage("syntax.trim.except.fields", "--trim-except-fields"));
        this.printSyntaxItem(this.getMessage("syntax.trim.only.fields", "--trim-only-fields"));
        System.out.println();
        System.out.println(this.getMessage("syntax.options.other", new Object[0]));
        System.out.println();
        this.printSyntaxItem(this.getMessage("syntax.force.cross.resource.refs", "--[no-]force-cross-resource-refs", "-x"));
        this.printSyntaxItem(this.getMessage("syntax.locale", "--locale", "-l"));
        this.printSyntaxItem(this.getMessage("syntax.provide.glossaries", "--[no-]provide-glossaries"));
        this.printSyntaxItem(this.getMessage("syntax.replace.quotes", "--[no-]replace-quotes"));
        System.out.println();
        System.out.println(this.getMessage("syntax.furtherinfo", new Object[0]));
        System.out.println();
        System.out.println(this.getMessage("syntax.tutorial", NAME, "texdoc bib2gls-begin"));
        System.out.println(this.getMessage("syntax.userguide", NAME, "texdoc bib2gls"));
        System.out.println(this.getMessage("syntax.ctan", NAME, "https://ctan.org/pkg/bib2gls"));
        System.out.println(this.getMessage("syntax.home", NAME, "https://www.dickimaw-books.com/software/bib2gls/"));
        System.out.println(this.getMessage("syntax.faq", NAME, "https://www.dickimaw-books.com/faq.php?category=bib2gls"));
        System.exit(0);
    }

    private String getLanguageFileName(String string, String string2) {
        return String.format("/resources/%s-%s.xml", string, string2);
    }

    private URL getLanguageUrl(String string, Locale locale, String string2) {
        String string3 = locale.toLanguageTag();
        String string4 = this.getLanguageFileName(string, string3);
        URL uRL = this.getClass().getResource(string4);
        String string5 = null;
        if (this.debugLevel > 0) {
            string5 = this.getClass().getProtectionDomain().getCodeSource().getLocation().toString();
        }
        if (uRL == null) {
            if (string5 != null) {
                this.debug(String.format("Can't find language resource: %s!%s", string5, string4));
            }
            string3 = locale.getLanguage();
            string4 = this.getLanguageFileName(string, string3);
            this.debug("Trying: " + string4);
            uRL = this.getClass().getResource(string4);
            if (uRL == null) {
                this.debug(String.format("Can't find language resource: %s!%s", string5, string4));
                String string6 = locale.getScript();
                if (string6 != null && !string6.isEmpty()) {
                    string4 = this.getLanguageFileName(string, String.format("%s-%s", string3, string6));
                    this.debug("Trying: " + string4);
                    uRL = this.getClass().getResource(string4);
                    if (uRL == null && string2 != null && !string3.equals(string2)) {
                        this.debug(String.format("Can't find language resource: %s!%s%nDefaulting to '%s'", string5, string4, string2));
                        uRL = this.getClass().getResource(this.getLanguageFileName(string, string2));
                    }
                } else if (string2 != null && !string3.equals(string2)) {
                    if (this.debugLevel > 0) {
                        this.debug(String.format("Defaulting to '%s'", string2));
                    }
                    uRL = this.getClass().getResource(this.getLanguageFileName(string, string2));
                }
            }
        }
        return uRL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMessages(String string) throws Bib2GlsException, IOException {
        Locale locale;
        if (string == null || "".equals(string)) {
            locale = this.defaultLocale == null ? Locale.getDefault() : this.defaultLocale;
        } else {
            try {
                this.setDocDefaultLocale(string);
                locale = this.getDefaultLocale();
            }
            catch (IllformedLocaleException illformedLocaleException) {
                locale = Locale.getDefault();
                this.setDocDefaultLocale(locale);
                this.error(illformedLocaleException.getMessage());
                this.debug(illformedLocaleException);
            }
        }
        URL uRL = this.getLanguageUrl(NAME, locale, "en");
        if (uRL == null) {
            throw new Bib2GlsException("Can't find language resource file.");
        }
        InputStream inputStream = null;
        try {
            this.debug("Reading " + uRL);
            inputStream = uRL.openStream();
            Properties properties = new Properties();
            properties.loadFromXML(inputStream);
            inputStream.close();
            inputStream = null;
            this.messages = new Bib2GlsMessages(properties);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
                inputStream = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExtraProperties(Locale locale) throws IOException, Bib2GlsException {
        URL uRL = this.getLanguageUrl("bib2gls-extra", locale, null);
        if (uRL != null) {
            InputStream inputStream = null;
            try {
                this.debug("Reading " + uRL);
                inputStream = uRL.openStream();
                Properties properties = new Properties();
                properties.loadFromXML(inputStream);
                inputStream.close();
                inputStream = null;
                this.messages.addProperties(properties);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                    inputStream = null;
                }
            }
        }
    }

    private void setShortCuts(String string) {
        if (string.startsWith("ac")) {
            this.shortcuts = string;
            this.checkAcroShortcuts = true;
        } else if (string.startsWith("ab")) {
            this.shortcuts = string;
            this.checkAbbrvShortcuts = true;
        } else if (string.equals("all") || string.equals("true")) {
            this.shortcuts = string;
            this.checkAcroShortcuts = true;
            this.checkAbbrvShortcuts = true;
        } else if (string.equals("none") || string.equals("false") || string.equals("other")) {
            this.shortcuts = string;
            this.checkAcroShortcuts = false;
            this.checkAbbrvShortcuts = false;
        } else {
            throw new IllegalArgumentException("Invalid shortcut value: " + string);
        }
    }

    public void setDocDefaultLocale(Locale locale) {
        this.docLocale = locale.toLanguageTag();
        this.defaultLocale = locale;
    }

    public void setDocDefaultLocale(String string) throws IllformedLocaleException {
        this.docLocale = string;
        this.defaultLocale = new Locale.Builder().setLanguageTag(string).build();
    }

    public String getDocDefaultLocale() {
        return this.docLocale;
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public Locale getLocale(String string) {
        return this.getLocale(string, true);
    }

    public Locale getLocale(String string, boolean bl) {
        try {
            return new Locale.Builder().setLanguageTag(string).build();
        }
        catch (IllformedLocaleException illformedLocaleException) {
            Locale locale = this.defaultLocale;
            if (locale == null) {
                locale = Locale.getDefault();
            }
            if (bl) {
                this.warningMessage("warning.invalid.locale", string, locale);
            }
            return locale;
        }
    }

    public void setTrimFields(boolean bl) {
        this.trimFields = bl;
    }

    @Deprecated
    public boolean trimFields() {
        return this.trimFields;
    }

    public boolean isTrimFieldOn(String string) {
        if (this.trimOnlyFields == null && this.trimExceptFields == null) {
            return this.trimFields;
        }
        if (this.trimOnlyFields != null) {
            return this.trimOnlyFields.contains(string);
        }
        return !this.trimExceptFields.contains(string);
    }

    private static int parseArgVal(String[] stringArray, int n, Object[] objectArray) {
        String[] stringArray2 = stringArray[n].startsWith("--") ? stringArray[n].split("=", 2) : new String[]{stringArray[n]};
        objectArray[0] = stringArray2[0];
        if (stringArray2.length == 2) {
            objectArray[1] = stringArray2[1];
            return n;
        }
        if (n == stringArray.length - 1 || stringArray[n + 1].startsWith("-")) {
            objectArray[1] = null;
            return n;
        }
        objectArray[1] = stringArray[++n];
        return n;
    }

    private int parseArgInt(String[] stringArray, int n, Object[] objectArray) {
        return Bib2Gls.parseArgInt(stringArray, n, objectArray, this);
    }

    private int parseArgInt(String[] stringArray, int n, Object[] objectArray, int n2) {
        return Bib2Gls.parseArgInt(stringArray, n, objectArray, n2, this);
    }

    private static int parseArgInt(String[] stringArray, int n, Object[] objectArray, Bib2Gls bib2Gls) {
        n = Bib2Gls.parseArgVal(stringArray, n, objectArray);
        if (objectArray[1] != null) {
            try {
                objectArray[1] = Integer.valueOf((String)objectArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                if (bib2Gls == null) {
                    throw new IllegalArgumentException("Invalid integer argument", numberFormatException);
                }
                throw new IllegalArgumentException(bib2Gls.getMessage("error.invalid.opt.int.value", objectArray[0], objectArray[1]), numberFormatException);
            }
        }
        return n;
    }

    private static int parseArgInt(String[] stringArray, int n, Object[] objectArray, int n2, Bib2Gls bib2Gls) {
        n = Bib2Gls.parseArgVal(stringArray, n, objectArray);
        if (objectArray[1] == null) {
            objectArray[1] = n2;
        } else {
            try {
                objectArray[1] = Integer.valueOf((String)objectArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                objectArray[1] = n2;
                return n - 1;
            }
        }
        return n;
    }

    private static boolean isArg(String string, String string2, String string3) {
        return string.equals("-" + string2) || string.equals("--" + string3) || string.startsWith("--" + string3 + "=");
    }

    private static boolean isArg(String string, String string2) {
        return string.equals("--" + string2) || string.startsWith("--" + string2 + "=");
    }

    private void parseArgs(String[] stringArray) throws IOException, Bib2GlsSyntaxException {
        String string = null;
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        this.mfirstucProtectWasSet = false;
        this.mfirstucMProtectWasSet = false;
        this.debugMessage("message.parsing.args", new Object[0]);
        this.recordCountRule = new RecordCountRule(this);
        Object[] objectArray = new Object[2];
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            String[] stringArray2;
            if (Bib2Gls.isArg(stringArray[i], "debug")) {
                i = this.parseArgInt(stringArray, i, objectArray, 0x40000000);
                int n2 = (Integer)objectArray[1];
                if (n2 < 0) {
                    throw new IllegalArgumentException(this.getMessage("error.invalid.opt.minint.value", objectArray[0], n2, 0));
                }
                this.verboseLevel = this.debugLevel = n2;
                continue;
            }
            if (stringArray[i].equals("--no-debug") || stringArray[i].equals("--nodebug")) {
                this.debugLevel = 0;
                continue;
            }
            if (stringArray[i].equals("--debug-mode")) {
                String[] stringArray3;
                i = Bib2Gls.parseArgVal(stringArray, i, objectArray);
                this.debugLevel = 0;
                stringArray2 = stringArray3 = objectArray[1].toString().split(",");
                int n3 = stringArray2.length;
                for (n = 0; n < n3; ++n) {
                    String string4 = stringArray2[n];
                    if ((string4 = string4.trim()).equals("all")) {
                        this.debugLevel = Integer.MAX_VALUE;
                        continue;
                    }
                    if (string4.equals("io")) {
                        this.debugLevel |= 1;
                        continue;
                    }
                    if (string4.equals("popped")) {
                        this.debugLevel |= 2;
                        continue;
                    }
                    if (string4.equals("decl")) {
                        this.debugLevel |= 4;
                        continue;
                    }
                    if (string4.equals("sty-data")) {
                        this.debugLevel |= 8;
                        continue;
                    }
                    if (string4.equals("expansion")) {
                        this.debugLevel |= 0x10;
                        continue;
                    }
                    if (string4.equals("expansion-list")) {
                        this.debugLevel |= 0x20;
                        continue;
                    }
                    if (string4.equals("expansion-once")) {
                        this.debugLevel |= 0x1000;
                        continue;
                    }
                    if (string4.equals("expansion-once-list")) {
                        this.debugLevel |= 0x2000;
                        continue;
                    }
                    if (string4.equals("process")) {
                        this.debugLevel |= 0x40;
                        continue;
                    }
                    if (string4.equals("process-stack")) {
                        this.debugLevel |= 0x80;
                        continue;
                    }
                    if (string4.equals("process-stack-list")) {
                        this.debugLevel |= 0x100;
                        continue;
                    }
                    if (string4.equals("cs")) {
                        this.debugLevel |= 0x400;
                        continue;
                    }
                    if (string4.equals("process-generic-cs")) {
                        this.debugLevel |= 0x800;
                        continue;
                    }
                    if (string4.equals("catcode")) {
                        this.debugLevel |= 0x4000;
                        continue;
                    }
                    if (string4.equals("read")) {
                        this.debugLevel |= 0x8000;
                        continue;
                    }
                    throw new Bib2GlsSyntaxException(this.getMessage("error.syntax.unknown_debug_mode", string4));
                }
                this.verboseLevel = 1;
                continue;
            }
            if (stringArray[i].equals("--verbose")) {
                this.verboseLevel = 1;
                continue;
            }
            if (stringArray[i].equals("--no-verbose") || stringArray[i].equals("--noverbose")) {
                this.verboseLevel = 0;
                continue;
            }
            if (stringArray[i].equals("--silent") || stringArray[i].equals("--quiet") || stringArray[i].equals("-q")) {
                this.verboseLevel = -1;
                continue;
            }
            if (Bib2Gls.isArg(stringArray[i], "l", "locale")) {
                i = Bib2Gls.parseArgVal(stringArray, i, objectArray);
                if (objectArray[1] != null) continue;
                throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", objectArray[0]));
            }
            if (stringArray[i].equals("-h") || stringArray[i].equals("--help")) {
                this.help();
                continue;
            }
            if (stringArray[i].equals("-v") || stringArray[i].equals("--version")) {
                if (!this.shownVersion) {
                    this.version();
                }
                this.license();
                this.libraryVersion();
                System.exit(0);
                continue;
            }
            if (Bib2Gls.isArg(stringArray[i], "t", "log-file")) {
                i = Bib2Gls.parseArgVal(stringArray, i, objectArray);
                if (objectArray[1] == null) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", objectArray[0]));
                }
                string3 = (String)objectArray[1];
                continue;
            }
            if (Bib2Gls.isArg(stringArray[i], "p", "packages")) {
                String[] stringArray4;
                i = Bib2Gls.parseArgVal(stringArray, i, objectArray);
                if (objectArray[1] == null) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", objectArray[0]));
                }
                stringArray2 = stringArray4 = ((String)objectArray[1]).trim().split("\\s*,\\s*");
                int n4 = stringArray2.length;
                for (n = 0; n < n4; ++n) {
                    String string5 = stringArray2[n];
                    if (!Bib2Gls.isKnownPackage(string5)) {
                        throw new Bib2GlsSyntaxException(this.getMessage("error.unsupported.package", string5, "--custom-packages"));
                    }
                    this.packages.add(string5);
                }
                continue;
            }
            if (Bib2Gls.isArg(stringArray[i], "custom-packages")) {
                i = Bib2Gls.parseArgVal(stringArray, i, objectArray);
                if (objectArray[1] == null) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", objectArray[0]));
                }
                String[] stringArray5 = ((String)objectArray[1]).trim().split("\\s*,\\s*");
                if (this.customPackages == null) {
                    this.customPackages = new Vector();
                }
                stringArray2 = stringArray5;
                int n5 = stringArray2.length;
                for (n = 0; n < n5; ++n) {
                    String string6 = stringArray2[n];
                    if (Bib2Gls.isKnownPackage(string6)) {
                        throw new Bib2GlsSyntaxException(this.getMessage("error.supported.package", string6, "--packages"));
                    }
                    this.customPackages.add(string6);
                }
                continue;
            }
            if (Bib2Gls.isArg(stringArray[i], "k", "ignore-packages")) {
                i = Bib2Gls.parseArgVal(stringArray, i, objectArray);
                if (objectArray[1] == null) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", objectArray[0]));
                }
                String[] stringArray6 = ((String)objectArray[1]).trim().split("\\s*,\\s*");
                if (this.ignorePackages == null) {
                    this.ignorePackages = new Vector();
                }
                stringArray2 = stringArray6;
                int n6 = stringArray2.length;
                for (n = 0; n < n6; ++n) {
                    String string7 = stringArray2[n];
                    if (Bib2Gls.isKnownPackage(string7)) {
                        this.ignorePackages.add(string7);
                        continue;
                    }
                    this.warningMessage("error.invalid.opt.value", objectArray[0], string7);
                }
                continue;
            }
            if (stringArray[i].equals("--list-known-packages")) {
                int n7;
                System.out.println(this.getMessage("message.list.known.packages.auto", new Object[0]));
                for (n7 = 0; n7 < AUTO_SUPPORT_PACKAGES.length; ++n7) {
                    if (n7 % 5 == 0) {
                        if (n7 > 0) {
                            System.out.print(",");
                        }
                        System.out.println();
                        System.out.print("\t");
                    } else {
                        System.out.print(", ");
                    }
                    System.out.print(AUTO_SUPPORT_PACKAGES[n7]);
                }
                System.out.println();
                System.out.println();
                System.out.println(this.getMessage("message.list.known.packages.extra", new Object[0]));
                for (n7 = 0; n7 < EXTRA_SUPPORTED_PACKAGES.length; ++n7) {
                    if (n7 % 5 == 0) {
                        if (n7 > 0) {
                            System.out.print(",");
                        }
                        System.out.println();
                        System.out.print("\t");
                    } else {
                        System.out.print(", ");
                    }
                    System.out.print(EXTRA_SUPPORTED_PACKAGES[n7]);
                }
                System.out.println();
                System.out.println(this.getMessage("message.list.known.packages.info", new Object[0]));
                System.exit(0);
                continue;
            }
            if (stringArray[i].equals("--expand-fields")) {
                this.expandFields = true;
                continue;
            }
            if (stringArray[i].equals("--no-expand-fields")) {
                this.expandFields = false;
                continue;
            }
            if (stringArray[i].equals("--warn-non-bib-fields")) {
                this.checkNonBibFields = true;
                continue;
            }
            if (stringArray[i].equals("--no-warn-non-bib-fields")) {
                this.checkNonBibFields = false;
                continue;
            }
            if (stringArray[i].equals("--warn-unknown-entry-types")) {
                this.warnUnknownEntryTypes = true;
                continue;
            }
            if (stringArray[i].equals("--no-warn-unknown-entry-types")) {
                this.warnUnknownEntryTypes = false;
                continue;
            }
            if (stringArray[i].equals("--interpret")) {
                this.interpret = true;
                continue;
            }
            if (stringArray[i].equals("--no-interpret")) {
                this.interpret = false;
                continue;
            }
            if (stringArray[i].equals("--break-space")) {
                this.useNonBreakSpace = false;
                continue;
            }
            if (stringArray[i].equals("--no-break-space")) {
                this.useNonBreakSpace = true;
                continue;
            }
            if (stringArray[i].equals("--obey-aux-catcode")) {
                this.allowAuxCatChangers = true;
                continue;
            }
            if (stringArray[i].equals("--no-obey-aux-catcode")) {
                this.allowAuxCatChangers = false;
                continue;
            }
            if (stringArray[i].equals("--cite-as-record")) {
                this.useCiteAsRecord = true;
                continue;
            }
            if (stringArray[i].equals("--no-cite-as-record")) {
                this.useCiteAsRecord = false;
                continue;
            }
            if (stringArray[i].equals("--merge-wrglossary-records")) {
                this.mergeWrGlossaryLocations = true;
                continue;
            }
            if (stringArray[i].equals("--no-merge-wrglossary-records")) {
                this.mergeWrGlossaryLocations = false;
                continue;
            }
            if (Bib2Gls.isArg(stringArray[i], "merge-nameref-on")) {
                i = Bib2Gls.parseArgVal(stringArray, i, objectArray);
                String string8 = (String)objectArray[1];
                if (string8 == null) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", objectArray[0]));
                }
                if (string8.equals("href")) {
                    this.mergeNameRefOn = 0;
                    continue;
                }
                if (string8.equals("title")) {
                    this.mergeNameRefOn = 1;
                    continue;
                }
                if (string8.equals("location")) {
                    this.mergeNameRefOn = (byte)2;
                    continue;
                }
                if (string8.equals("hcounter")) {
                    this.mergeNameRefOn = (byte)3;
                    continue;
                }
                throw new Bib2GlsSyntaxException(this.getMessage("error.invalid.choice.value", objectArray[0], string8));
            }
            if (stringArray[i].equals("--force-cross-resource-refs") || stringArray[i].equals("-x")) {
                this.forceCrossResourceRefs = true;
                continue;
            }
            if (stringArray[i].equals("--no-force-cross-resource-refs")) {
                this.forceCrossResourceRefs = false;
                continue;
            }
            if (stringArray[i].equals("--support-unicode-script")) {
                this.supportUnicodeSubSuperScripts = true;
                continue;
            }
            if (stringArray[i].equals("--no-support-unicode-script")) {
                this.supportUnicodeSubSuperScripts = false;
                continue;
            }
            if (stringArray[i].equals("--replace-quotes")) {
                this.replaceQuotes = true;
                continue;
            }
            if (stringArray[i].equals("--no-replace-quotes")) {
                this.replaceQuotes = false;
                continue;
            }
            if (stringArray[i].equals("--collapse-same-location-range")) {
                this.collapseSamePageRange = true;
                continue;
            }
            if (stringArray[i].equals("--no-collapse-same-location-range")) {
                this.collapseSamePageRange = false;
                continue;
            }
            if (stringArray[i].equals("--no-mfirstuc-protection")) {
                this.mfirstucProtect = false;
                this.mfirstucProtectWasSet = true;
                continue;
            }
            if (Bib2Gls.isArg(stringArray[i], "u", "mfirstuc-protection")) {
                i = Bib2Gls.parseArgVal(stringArray, i, objectArray);
                this.mfirstucProtect = true;
                this.mfirstucProtectWasSet = true;
                String string9 = (String)objectArray[1];
                if (string9 == null) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", objectArray[0]));
                }
                if (string9.equals("all")) {
                    this.mfirstucProtectFields = null;
                    continue;
                }
                if (string9.isEmpty()) {
                    this.mfirstucProtect = false;
                    continue;
                }
                this.mfirstucProtectFields = string9.split(" *, *");
                continue;
            }
            if (stringArray[i].equals("--no-mfirstuc-math-protection")) {
                this.mfirstucMProtect = false;
                this.mfirstucMProtectWasSet = true;
                continue;
            }
            if (stringArray[i].equals("--mfirstuc-math-protection")) {
                this.mfirstucMProtect = true;
                this.mfirstucMProtectWasSet = true;
                continue;
            }
            if (Bib2Gls.isArg(stringArray[i], "shortcuts")) {
                i = Bib2Gls.parseArgVal(stringArray, i, objectArray);
                String string10 = (String)objectArray[1];
                if (string10 == null) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", objectArray[0]));
                }
                try {
                    this.setShortCuts(string10);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.invalid.choice.value", objectArray[0], string10), illegalArgumentException);
                }
            }
            if (Bib2Gls.isArg(stringArray[i], "nested-link-check")) {
                i = Bib2Gls.parseArgVal(stringArray, i, objectArray);
                String string11 = (String)objectArray[1];
                if (string11 == null) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", objectArray[0]));
                }
                if (string11.equals("none") || string11.isEmpty()) {
                    this.nestedLinkCheckFields = null;
                    continue;
                }
                this.nestedLinkCheckFields = string11.split(" *, *");
                continue;
            }
            if (stringArray[i].equals("--no-nested-link-check")) {
                this.nestedLinkCheckFields = null;
                continue;
            }
            if (Bib2Gls.isArg(stringArray[i], "d", "dir")) {
                i = Bib2Gls.parseArgVal(stringArray, i, objectArray);
                if (objectArray[1] == null) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", objectArray[0]));
                }
                string = (String)objectArray[1];
                continue;
            }
            if (Bib2Gls.isArg(stringArray[i], "m", "map-format")) {
                i = Bib2Gls.parseArgVal(stringArray, i, objectArray);
                String string12 = (String)objectArray[1];
                if (string12 == null) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", objectArray[0]));
                }
                String[] stringArray7 = stringArray2 = string12.trim().split(" *, *");
                n = stringArray7.length;
                for (int j = 0; j < n; ++j) {
                    String string13 = stringArray7[j];
                    String[] stringArray8 = string13.split(" *: *");
                    if (stringArray8.length != 2) {
                        throw new Bib2GlsSyntaxException(this.getMessage("error.invalid.opt.value", objectArray[0], string12));
                    }
                    this.formatMap.put(stringArray8[0], stringArray8[1]);
                }
                continue;
            }
            if (Bib2Gls.isArg(stringArray[i], "retain-formats")) {
                i = Bib2Gls.parseArgVal(stringArray, i, objectArray);
                if (objectArray[1] == null) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", objectArray[0]));
                }
                String[] stringArray9 = ((String)objectArray[1]).trim().split("\\s*,\\s*");
                if (this.retainFormatList == null) {
                    this.retainFormatList = new Vector();
                }
                stringArray2 = stringArray9;
                int n8 = stringArray2.length;
                for (n = 0; n < n8; ++n) {
                    String string14 = stringArray2[n];
                    this.retainFormatList.add(string14);
                }
                continue;
            }
            if (stringArray[i].equals("--no-retain-formats")) {
                this.retainFormatList = null;
                continue;
            }
            if (stringArray[i].equals("--group") || stringArray[i].equals("-g")) {
                this.addGroupField = true;
                continue;
            }
            if (stringArray[i].equals("--no-group")) {
                this.addGroupField = false;
                continue;
            }
            if (Bib2Gls.isArg(stringArray[i], "r", "record-count-rule")) {
                i = Bib2Gls.parseArgVal(stringArray, i, objectArray);
                if (objectArray[1] == null) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", objectArray[0]));
                }
                this.recordCountRule.setRule((String)objectArray[1]);
                this.saveRecordCount = true;
                continue;
            }
            if (stringArray[i].equals("--record-count") || stringArray[i].equals("-c")) {
                this.saveRecordCount = true;
                continue;
            }
            if (stringArray[i].equals("--no-record-count")) {
                this.saveRecordCount = false;
                this.saveRecordCountUnit = false;
                continue;
            }
            if (stringArray[i].equals("--record-count-unit") || stringArray[i].equals("-n")) {
                this.saveRecordCountUnit = true;
                this.saveRecordCount = true;
                continue;
            }
            if (stringArray[i].equals("--no-record-count-unit")) {
                this.saveRecordCountUnit = false;
                continue;
            }
            if (Bib2Gls.isArg(stringArray[i], "D", "date-in-header")) {
                this.dateInHeader = true;
                continue;
            }
            if (stringArray[i].equals("--no-date-in-header")) {
                this.dateInHeader = false;
                continue;
            }
            if (Bib2Gls.isArg(stringArray[i], "tex-encoding")) {
                i = Bib2Gls.parseArgVal(stringArray, i, objectArray);
                String string15 = (String)objectArray[1];
                if (string15 == null) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", objectArray[0]));
                }
                try {
                    this.texCharset = Charset.forName(string15);
                    continue;
                }
                catch (UnsupportedCharsetException unsupportedCharsetException) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.unknown.charset", string15), unsupportedCharsetException);
                }
            }
            if (Bib2Gls.isArg(stringArray[i], "default-encoding")) {
                i = Bib2Gls.parseArgVal(stringArray, i, objectArray);
                String string16 = (String)objectArray[1];
                if (string16 == null) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", objectArray[0]));
                }
                try {
                    this.defaultCharset = Charset.forName(string16);
                    continue;
                }
                catch (UnsupportedCharsetException unsupportedCharsetException) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.unknown.charset", string16), unsupportedCharsetException);
                }
            }
            if (Bib2Gls.isArg(stringArray[i], "log-encoding")) {
                i = Bib2Gls.parseArgVal(stringArray, i, objectArray);
                String string17 = (String)objectArray[1];
                if (string17 == null) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", objectArray[0]));
                }
                try {
                    this.texLogCharset = Charset.forName(string17);
                    continue;
                }
                catch (UnsupportedCharsetException unsupportedCharsetException) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.unknown.charset", string17), unsupportedCharsetException);
                }
            }
            if (stringArray[i].equals("--trim-fields")) {
                this.trimFields = true;
                this.trimOnlyFields = null;
                this.trimExceptFields = null;
                continue;
            }
            if (stringArray[i].equals("--no-trim-fields")) {
                this.trimFields = false;
                this.trimOnlyFields = null;
                this.trimExceptFields = null;
                continue;
            }
            if (Bib2Gls.isArg(stringArray[i], "trim-only-fields")) {
                if (this.trimExceptFields != null) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.option.clash", "--trim-only-fields", "--trim-except-fields"));
                }
                i = Bib2Gls.parseArgVal(stringArray, i, objectArray);
                if (objectArray[1] == null) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", objectArray[0]));
                }
                String[] stringArray10 = ((String)objectArray[1]).trim().split("\\s*,\\s*");
                if (this.trimOnlyFields == null) {
                    this.trimOnlyFields = new Vector();
                }
                stringArray2 = stringArray10;
                int n9 = stringArray2.length;
                for (n = 0; n < n9; ++n) {
                    String string18 = stringArray2[n];
                    this.trimOnlyFields.add(string18);
                }
                this.trimFields = true;
                continue;
            }
            if (Bib2Gls.isArg(stringArray[i], "trim-except-fields")) {
                if (this.trimOnlyFields != null) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.option.clash", "--trim-only-fields", "--trim-except-fields"));
                }
                i = Bib2Gls.parseArgVal(stringArray, i, objectArray);
                if (objectArray[1] == null) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", objectArray[0]));
                }
                String[] stringArray11 = ((String)objectArray[1]).trim().split("\\s*,\\s*");
                if (this.trimExceptFields == null) {
                    this.trimExceptFields = new Vector();
                }
                stringArray2 = stringArray11;
                int n10 = stringArray2.length;
                for (n = 0; n < n10; ++n) {
                    String string19 = stringArray2[n];
                    this.trimExceptFields.add(string19);
                }
                this.trimFields = true;
                continue;
            }
            if (stringArray[i].equals("--provide-glossaries")) {
                bl = true;
                continue;
            }
            if (stringArray[i].equals("--no-provide-glossaries")) {
                bl = false;
                continue;
            }
            if (stringArray[i].startsWith("-")) {
                throw new Bib2GlsSyntaxException(this.getMessage("error.syntax.unknown_option", stringArray[i]));
            }
            if (string2 == null) {
                string2 = stringArray[i];
                continue;
            }
            throw new Bib2GlsSyntaxException(this.getMessage("error.only.one.aux", new Object[0]));
        }
        if (bl) {
            this.knownGlossaries = new Vector();
        }
        if (string2 == null) {
            throw new Bib2GlsSyntaxException(this.getMessage("error.no.aux", this.getMessage("syntax.usage", NAME)));
        }
        if (!string2.endsWith(".aux")) {
            string2 = string2 + ".aux";
        }
        File file = null;
        this.auxFile = new File(string2);
        if (string != null) {
            file = new File(string);
            this.basePath = file.toPath();
            if (!file.exists()) {
                System.err.println(this.getMessage("error.dir.not.found", string));
                System.exit(1);
            }
            if (!file.isDirectory()) {
                System.err.println(this.getMessage("error.not.dir", string));
                System.exit(1);
            }
            this.auxFile = this.auxFile.getParentFile() == null ? new File(file, string2) : file.toPath().resolve(this.auxFile.toPath()).toFile();
        } else {
            file = this.auxFile.getParentFile();
            this.basePath = this.cwd;
        }
        if (!this.auxFile.exists()) {
            System.err.println(this.getMessage("error.file.not.found", string2));
            System.exit(0);
        }
        this.glgLogFile = null;
        if (string3 == null) {
            String string20 = this.auxFile.getName();
            this.glgLogFile = new File(file, string20.substring(0, string20.lastIndexOf(".")) + ".glg");
        } else {
            this.glgLogFile = this.resolveFile(string3);
        }
        this.glgLogFile = this.getWritableFile(this.glgLogFile);
        try {
            this.logWriter = new PrintWriter(Files.newBufferedWriter(this.glgLogFile.toPath(), this.defaultCharset, new OpenOption[0]));
        }
        catch (IOException iOException) {
            this.logWriter = null;
            System.err.println(this.getMessage("error.cant.open.log", this.glgLogFile.toString()));
            this.error(iOException);
        }
        this.logMessage(this.getMessage("about.version", NAME, VERSION, DATE));
        if (this.getDebugLevel() > 0) {
            this.logMessage("Java " + System.getProperty("java.version"));
            this.logMessage(String.format("texparserlib.jar %s (%s)", "0.9.9b", DATE));
        }
        this.logDefaultEncoding(this.defaultCharset);
        if (this.logWriter != null) {
            this.logWriter.print(this.pending.toString());
            this.logWriter.flush();
        }
        this.pendingWriter.close();
        this.pendingWriter = null;
        this.pending = null;
        if (this.getDebugLevel() > 0) {
            this.logAndPrintMessage(String.format("openin_any=%s%nopenout_any=%s%nTEXMFOUTPUT=%s%ncwd=%s", Character.valueOf(this.openin_any), Character.valueOf(this.openout_any), this.texmfoutput == null ? "" : this.texmfoutput, this.cwd));
        }
    }

    public static void exit(Bib2Gls bib2Gls, int n) {
        if (bib2Gls != null && bib2Gls.logWriter != null) {
            bib2Gls.logWriter.close();
            bib2Gls.message(bib2Gls.getMessageWithFallback("message.log.file", "Transcript written to {0}.", bib2Gls.glgLogFile));
            bib2Gls.logWriter = null;
        }
        System.exit(n);
    }

    public static void main(String[] stringArray) {
        Bib2Gls bib2Gls = null;
        int n = 0;
        int n2 = 0;
        String string = null;
        Object[] objectArray = new Object[2];
        for (int i = 0; i < stringArray.length; ++i) {
            if (Bib2Gls.isArg(stringArray[i], "debug")) {
                try {
                    i = Bib2Gls.parseArgInt(stringArray, i, objectArray, 1, null);
                    n = (Integer)objectArray[1];
                }
                catch (Exception exception) {
                    n = 1;
                }
                continue;
            }
            if (stringArray[i].equals("--no-debug") || stringArray[i].equals("--nodebug")) {
                n = 0;
                continue;
            }
            if (stringArray[i].equals("--silent") || stringArray[i].equals("--quiet") || stringArray[i].equals("-q") || stringArray[i].equals("--help") || stringArray[i].equals("-h")) {
                n2 = -1;
                continue;
            }
            if (stringArray[i].equals("--verbose")) {
                n2 = 1;
                continue;
            }
            if (stringArray[i].equals("--noverbose")) {
                n2 = 0;
                continue;
            }
            if (!Bib2Gls.isArg(stringArray[i], "l", "locale")) continue;
            i = Bib2Gls.parseArgVal(stringArray, i, objectArray);
            string = (String)objectArray[1];
        }
        try {
            bib2Gls = new Bib2Gls(n, n2, string);
            bib2Gls.process(stringArray);
            if (bib2Gls.exitCode != 0) {
                Bib2Gls.exit(bib2Gls, bib2Gls.exitCode);
            }
        }
        catch (Bib2GlsSyntaxException bib2GlsSyntaxException) {
            System.err.println(bib2GlsSyntaxException.getMessage());
            System.err.println(bib2Gls.getMessage("syntax.use.help", new Object[0]));
            System.exit(1);
        }
        catch (Exception exception) {
            if (bib2Gls == null) {
                System.err.println("Fatal error: " + exception.getMessage());
                if (n > 0) {
                    exception.printStackTrace();
                }
            } else {
                bib2Gls.error(exception);
            }
            Bib2Gls.exit(bib2Gls, 3);
        }
    }
}

