/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bib2gls;

import com.dickimawbooks.bib2gls.Bib2Gls;
import com.dickimawbooks.bib2gls.Bib2GlsEntry;
import com.dickimawbooks.bib2gls.Bib2GlsException;
import com.dickimawbooks.bib2gls.FieldValueElement;
import com.dickimawbooks.bib2gls.GlsResource;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.bib.BibUserString;
import com.dickimawbooks.texparserlib.bib.BibValue;
import com.dickimawbooks.texparserlib.bib.BibValueList;
import java.io.IOException;

public class FieldValueLabelify
implements FieldValueElement {
    private FieldValueElement fieldValueElem;
    private boolean allowLists = false;

    public FieldValueLabelify(FieldValueElement fieldValueElement, boolean bl) {
        this.fieldValueElem = fieldValueElement;
        this.allowLists = bl;
    }

    @Override
    public BibValue getValue(Bib2GlsEntry bib2GlsEntry) throws Bib2GlsException, IOException {
        String string = this.getStringValue(bib2GlsEntry);
        if (string == null) {
            return null;
        }
        TeXParser teXParser = bib2GlsEntry.getResource().getParser();
        return new BibUserString((TeXObject)teXParser.getListener().createString(string));
    }

    @Override
    public String getStringValue(Bib2GlsEntry bib2GlsEntry) throws IOException, Bib2GlsException {
        BibValueList bibValueList;
        Bib2Gls bib2Gls = bib2GlsEntry.getBib2Gls();
        BibValue bibValue = this.fieldValueElem.getValue(bib2GlsEntry);
        if (bibValue == null) {
            return null;
        }
        GlsResource glsResource = bib2GlsEntry.getResource();
        TeXParser teXParser = glsResource.getParser();
        TeXObjectList teXObjectList = (TeXObjectList)bibValue.expand(teXParser).clone();
        if (bibValue instanceof BibValueList) {
            bibValueList = (BibValueList)bibValue;
        } else {
            bibValueList = new BibValueList();
            bibValueList.add((Object)bibValue);
        }
        return bib2Gls.convertToLabel(teXParser, bibValueList, glsResource, this.allowLists);
    }

    public String toString() {
        if (this.allowLists) {
            return String.format("\\LABELIFYLIST{%s}", this.fieldValueElem);
        }
        return String.format("\\LABELIFY{%s}", this.fieldValueElem);
    }
}

