/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bib2gls;

import com.dickimawbooks.bib2gls.Bib2Gls;
import com.dickimawbooks.bib2gls.Bib2GlsEntry;
import com.dickimawbooks.bib2gls.Bib2GlsException;
import com.dickimawbooks.bib2gls.GlsResource;
import com.dickimawbooks.bib2gls.GroupTitle;
import com.dickimawbooks.bib2gls.PatternReplace;
import com.dickimawbooks.bib2gls.SortSettings;
import com.dickimawbooks.bib2gls.UnicodeGroupTitle;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.bib.BibValueList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Vector;

public abstract class SortComparator
implements Comparator<Bib2GlsEntry> {
    protected String sortStorageField = "bib2gls@sort";
    protected String sortFallbackField = "bib2gls@sortfallback";
    protected String sortField;
    protected String groupField;
    protected String entryType;
    protected boolean overrideType = false;
    private HashMap<String, Integer> sortCount;
    protected Bib2Gls bib2gls;
    protected Vector<Bib2GlsEntry> entries;
    protected SortSettings settings;

    public SortComparator(Bib2Gls bib2Gls, Vector<Bib2GlsEntry> vector, SortSettings sortSettings, String string, String string2, String string3, boolean bl) {
        this.sortField = string;
        this.groupField = string2;
        this.entryType = string3;
        this.bib2gls = bib2Gls;
        this.entries = vector;
        this.settings = sortSettings;
        this.overrideType = bl;
    }

    protected abstract long getDefaultGroupId(Bib2GlsEntry var1, int var2, Object var3);

    protected abstract GroupTitle createDefaultGroupTitle(int var1, Object var2, String var3, String var4);

    protected String setGroupTitle(Bib2GlsEntry bib2GlsEntry, int n, Object object, String string, String string2) {
        GroupTitle groupTitle;
        String string3;
        int n2 = this.settings.getGroupFormation();
        GlsResource glsResource = this.bib2gls.getCurrentResource();
        if (n == -1 && n2 != 0) {
            string3 = object.toString();
            if (string3.isEmpty()) {
                n2 = 0;
            } else {
                n = string3.codePointAt(0);
            }
        }
        if ((groupTitle = n2 == 0 ? glsResource.getGroupTitle(string2, this.getDefaultGroupId(bib2GlsEntry, n, object), bib2GlsEntry.getParent()) : glsResource.getGroupTitle(string2, UnicodeGroupTitle.getGroupId(n, n2), bib2GlsEntry.getParent())) == null) {
            groupTitle = n2 == 0 ? this.createDefaultGroupTitle(n, object, string2, bib2GlsEntry.getParent()) : UnicodeGroupTitle.createUnicodeGroupTitle(this.bib2gls, n, string2, bib2GlsEntry.getParent(), n2);
            glsResource.putGroupTitle(groupTitle, bib2GlsEntry);
            string3 = groupTitle.format();
        } else {
            string3 = groupTitle.format(string);
        }
        glsResource.assignGroupField(bib2GlsEntry, this.groupField, String.format("\\%s%s", groupTitle.getCsLabelName(), string3), groupTitle);
        return groupTitle.getTitle();
    }

    protected boolean useSortSuffix() {
        return this.settings.getSuffixOption() != 0;
    }

    protected String getType(Bib2GlsEntry bib2GlsEntry) {
        if (this.overrideType) {
            return this.entryType == null ? "" : this.entryType;
        }
        GlsResource glsResource = this.bib2gls.getCurrentResource();
        String string = glsResource.getType(bib2GlsEntry, this.entryType);
        if (string == null) {
            string = "";
        }
        return string;
    }

    protected String adjustSort(Bib2GlsEntry bib2GlsEntry, String string) {
        return string;
    }

    protected String padNumbers(Bib2GlsEntry bib2GlsEntry, String string, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        int n2 = 0;
        int n3 = string.length();
        while (n2 < n3) {
            int n4;
            StringBuilder stringBuilder2;
            int n5;
            int n6;
            block39: {
                block38: {
                    n6 = string.codePointAt(n2);
                    n2 += Character.charCount(n6);
                    if (n6 == 43) {
                        int n7 = n5 = n2 < n3 ? string.codePointAt(n2) : -1;
                        if (Character.isDigit(n5)) {
                            stringBuilder.append(this.settings.getPadPlus());
                        } else {
                            stringBuilder.appendCodePoint(n6);
                        }
                        bl = true;
                        continue;
                    }
                    if (n6 == 8330) {
                        n5 = n2 < n3 ? string.codePointAt(n2) : -1;
                        if (Bib2Gls.isSubscriptDigit(n5)) {
                            stringBuilder.append(this.settings.getPadPlus());
                        } else {
                            stringBuilder.appendCodePoint(n6);
                        }
                        bl = true;
                        continue;
                    }
                    if (n6 == 8314) {
                        n5 = n2 < n3 ? string.codePointAt(n2) : -1;
                        if (Bib2Gls.isSuperscriptDigit(n5)) {
                            stringBuilder.append(this.settings.getPadPlus());
                        } else {
                            stringBuilder.appendCodePoint(n6);
                        }
                        bl = true;
                        continue;
                    }
                    if (n6 == 45) break block38;
                    if (n6 != 8722) break block39;
                }
                int n8 = n5 = n2 < n3 ? string.codePointAt(n2) : -1;
                if (Character.isDigit(n5)) {
                    stringBuilder.append(this.settings.getPadMinus());
                } else {
                    stringBuilder.appendCodePoint(n6);
                }
                bl = true;
                continue;
            }
            if (n6 == 8331) {
                n5 = n2 < n3 ? string.codePointAt(n2) : -1;
                if (Bib2Gls.isSubscriptDigit(n5)) {
                    stringBuilder.append(this.settings.getPadMinus());
                    continue;
                }
                stringBuilder.appendCodePoint(n6);
                continue;
            }
            if (n6 == 8315) {
                n5 = n2 < n3 ? string.codePointAt(n2) : -1;
                if (Bib2Gls.isSuperscriptDigit(n5)) {
                    stringBuilder.append(this.settings.getPadMinus());
                } else {
                    stringBuilder.appendCodePoint(n6);
                }
                bl = true;
                continue;
            }
            if (Character.isDigit(n6)) {
                if (!bl) {
                    stringBuilder.append(this.settings.getPadPlus());
                }
                n5 = 48;
                try {
                    n5 = n6 - Integer.parseInt(String.format("%c", n6));
                }
                catch (NumberFormatException numberFormatException) {
                    this.bib2gls.debug(numberFormatException);
                }
                stringBuilder2 = new StringBuilder();
                stringBuilder2.appendCodePoint(n6);
                n4 = 1;
                if (n2 < n3) {
                    n6 = string.codePointAt(n2);
                    while (Character.isDigit(n6)) {
                        ++n4;
                        if ((n2 += Character.charCount(n6)) >= n3) break;
                        stringBuilder2.appendCodePoint(n6);
                        n6 = string.codePointAt(n2);
                    }
                }
                while (n4 < n) {
                    stringBuilder.appendCodePoint(n5);
                    ++n4;
                }
                stringBuilder.append((CharSequence)stringBuilder2);
                bl = false;
                continue;
            }
            if (Bib2Gls.isSubscriptDigit(n6)) {
                if (!bl) {
                    stringBuilder.append(this.settings.getPadPlus());
                }
                n5 = 8320;
                stringBuilder2 = new StringBuilder();
                stringBuilder2.appendCodePoint(n6);
                n4 = 1;
                if (n2 < n3) {
                    n6 = string.codePointAt(n2);
                    while (true) {
                        if (!Bib2Gls.isSubscriptDigit(n6)) break;
                        ++n4;
                        if ((n2 += Character.charCount(n6)) >= n3) break;
                        stringBuilder2.appendCodePoint(n6);
                        n6 = string.codePointAt(n2);
                    }
                }
                while (n4 < n) {
                    stringBuilder.appendCodePoint(n5);
                    ++n4;
                }
                stringBuilder.append((CharSequence)stringBuilder2);
                bl = false;
                continue;
            }
            if (Bib2Gls.isSuperscriptDigit(n6)) {
                if (!bl) {
                    stringBuilder.append(this.settings.getPadPlus());
                }
                n5 = 8304;
                stringBuilder2 = new StringBuilder();
                stringBuilder2.appendCodePoint(n6);
                n4 = 1;
                if (n2 < n3) {
                    n6 = string.codePointAt(n2);
                    while (true) {
                        if (!Bib2Gls.isSuperscriptDigit(n6)) break;
                        ++n4;
                        if ((n2 += Character.charCount(n6)) >= n3) break;
                        stringBuilder2.appendCodePoint(n6);
                        n6 = string.codePointAt(n2);
                    }
                }
                while (n4 < n) {
                    stringBuilder.appendCodePoint(n5);
                    ++n4;
                }
                stringBuilder.append((CharSequence)stringBuilder2);
                bl = false;
                continue;
            }
            stringBuilder.appendCodePoint(n6);
            bl = false;
        }
        return stringBuilder.toString();
    }

    protected String updateSortValue(Bib2GlsEntry bib2GlsEntry, Vector<Bib2GlsEntry> vector) {
        Object object;
        Object object22;
        Object object3;
        BibValueList bibValueList;
        String string = bib2GlsEntry.getId();
        String string2 = null;
        Object object4 = this.sortField;
        if (!this.settings.requiresSortField()) {
            string2 = "";
        } else if (((String)object4).equals("id")) {
            string2 = string;
        } else {
            string2 = bib2GlsEntry.getFieldValue((String)object4);
            bibValueList = bib2GlsEntry.getField((String)object4);
            if (string2 == null && (object3 = this.settings.getMissingFieldFallback()) != null) {
                this.bib2gls.debugMessage("message.missing.sort.fallback", string, object4, object3);
                string2 = bib2GlsEntry.getFieldValue((String)object3);
                bibValueList = bib2GlsEntry.getField((String)object3);
                object4 = object3;
            }
            if (string2 == null) {
                string2 = bib2GlsEntry.getFallbackValue((String)object4);
                bibValueList = bib2GlsEntry.getFallbackContents((String)object4);
            }
            if (string2 == null) {
                string2 = string;
                this.bib2gls.debugMessage("warning.no.default.sort", string, object4, bib2GlsEntry.getEntryType());
            } else if (this.bib2gls.useInterpreter() && bibValueList != null && string2.matches("(?s).*[\\\\\\$\\{\\}\\~].*")) {
                string2 = this.bib2gls.interpret(string2, bibValueList, this.settings.isTrimOn());
            }
            if (this.useSortSuffix()) {
                string2 = this.applySuffix(bib2GlsEntry, string2);
            }
        }
        bibValueList = this.settings.getRegexList();
        if (bibValueList != null) {
            for (Object object22 : bibValueList) {
                string2 = ((PatternReplace)object22).replaceAll(string2);
            }
        }
        if (this.settings.getNumberPad() > 1) {
            string2 = this.padNumbers(bib2GlsEntry, string2, this.settings.getNumberPad());
        }
        string2 = this.adjustSort(bib2GlsEntry, string2);
        object3 = this.bib2gls.getCurrentResource().getSortEncapCsName();
        if (object3 != null) {
            object22 = this.bib2gls.getInterpreterListener();
            object = new TeXObjectList();
            object.add((TeXObject)new TeXCsRef((String)object3));
            object.add((TeXObject)object22.createGroup(string2));
            object.add((TeXObject)object22.createGroup(bib2GlsEntry.getId()));
            string2 = this.bib2gls.interpret(String.format("\\%s{%s}{%s}", object3, string2, bib2GlsEntry.getId()), (TeXObjectList)object, false);
        }
        bib2GlsEntry.putField(this.sortStorageField, string2);
        if (this.settings.getIdenticalSortAction() == 2) {
            object22 = this.settings.getIdenticalSortField();
            object = bib2GlsEntry.getFieldValue((String)object22);
            BibValueList bibValueList2 = bib2GlsEntry.getField((String)object22);
            if (object == null) {
                object = "";
            } else if (this.bib2gls.useInterpreter() && bibValueList2 != null && ((String)object).matches("(?s).*[\\\\\\$\\{\\}\\~].*")) {
                object = this.bib2gls.interpret((String)object, bibValueList2, this.settings.isTrimOn());
            }
            bib2GlsEntry.putField(this.sortFallbackField, (String)object);
        }
        return string2;
    }

    protected String applySuffix(Bib2GlsEntry bib2GlsEntry, String string) {
        switch (this.settings.getSuffixOption()) {
            case 2: {
                Object object;
                String string2 = this.settings.getSuffixField();
                String string3 = bib2GlsEntry.getFieldValue(string2);
                if (string3 == null) break;
                if (this.bib2gls.useInterpreter() && string3.matches(".*[\\\\\\$\\{\\}\\~].*") && (object = bib2GlsEntry.getField(string2)) != null) {
                    string3 = this.bib2gls.interpret(string3, (BibValueList)object, this.settings.isTrimOn());
                }
                object = this.settings.getSuffixMarker() + string3;
                if (this.bib2gls.getVerboseLevel() > 0) {
                    this.bib2gls.logMessage(this.bib2gls.getMessage("message.sort_suffix", object, string, bib2GlsEntry.getId()));
                }
                string = string + (String)object;
                break;
            }
            case 1: {
                String string4 = this.sortSuffix(string, bib2GlsEntry);
                if (string4 == null) break;
                string4 = this.settings.getSuffixMarker() + string4;
                if (this.bib2gls.getVerboseLevel() > 0) {
                    this.bib2gls.logMessage(this.bib2gls.getMessage("message.sort_suffix", string4, string, bib2GlsEntry.getId()));
                }
                string = string + string4;
            }
        }
        return string;
    }

    protected String sortSuffix(String string, Bib2GlsEntry bib2GlsEntry) {
        if (this.sortCount == null) {
            return null;
        }
        String string2 = bib2GlsEntry.getParent();
        String string3 = this.getType(bib2GlsEntry);
        String string4 = String.format("%s\u001f%s\u001f%s", string3, string2 == null ? "" : string2, string);
        Integer n = this.sortCount.get(string4);
        if (n == null) {
            this.sortCount.put(string4, 0);
            if (this.bib2gls.getDebugLevel() > 0) {
                this.bib2gls.logMessage(String.format("%s: %s -> 0", bib2GlsEntry.getId(), string4));
            }
            return null;
        }
        this.bib2gls.verbose(this.bib2gls.getMessage("message.non_unique_sort", string, bib2GlsEntry.getOriginalId()));
        n = n + 1;
        this.sortCount.put(string4, n);
        if (this.bib2gls.getDebugLevel() > 0) {
            this.bib2gls.logMessage(String.format("%s: %s -> %d", bib2GlsEntry.getId(), string4, n));
        }
        return n.toString();
    }

    protected abstract int compareElements(Bib2GlsEntry var1, Bib2GlsEntry var2);

    private int getIdenticalSortFallback(Bib2GlsEntry bib2GlsEntry, Bib2GlsEntry bib2GlsEntry2) {
        this.bib2gls.verboseMessage("warning.identical", bib2GlsEntry.getId(), bib2GlsEntry2.getId());
        switch (this.settings.getIdenticalSortAction()) {
            case 1: {
                this.bib2gls.verboseMessage("warning.identical.id", new Object[0]);
                return bib2GlsEntry.getId().compareTo(bib2GlsEntry2.getId());
            }
            case 3: {
                this.bib2gls.verboseMessage("warning.identical.original_id", new Object[0]);
                return bib2GlsEntry.getOriginalId().compareTo(bib2GlsEntry2.getOriginalId());
            }
            case 5: {
                this.bib2gls.verboseMessage("warning.identical.use", new Object[0]);
                return Long.compare(bib2GlsEntry.getRecordIndex(), bib2GlsEntry.getRecordIndex());
            }
            case 4: {
                this.bib2gls.verboseMessage("warning.identical.def", new Object[0]);
                return Long.compare(bib2GlsEntry.getDefinitionIndex(), bib2GlsEntry.getDefinitionIndex());
            }
            case 2: {
                String string = bib2GlsEntry.getFieldValue(this.sortFallbackField);
                String string2 = bib2GlsEntry2.getFieldValue(this.sortFallbackField);
                int n = string.compareTo(string2);
                this.bib2gls.verboseMessage("warning.identical.field", this.settings.getIdenticalSortField(), string, string2, n);
                return n;
            }
        }
        this.bib2gls.verboseMessage("warning.identical.none", new Object[0]);
        return 0;
    }

    @Override
    public int compare(Bib2GlsEntry bib2GlsEntry, Bib2GlsEntry bib2GlsEntry2) {
        boolean bl = this.settings.isReverse();
        if (this.bib2gls.getCurrentResource().flattenSort()) {
            int n = this.compareElements(bib2GlsEntry, bib2GlsEntry2);
            if (n == 0) {
                n = this.getIdenticalSortFallback(bib2GlsEntry, bib2GlsEntry2);
            }
            return bl ? -n : n;
        }
        if (bib2GlsEntry.getId().equals(bib2GlsEntry2.getParent())) {
            return -1;
        }
        if (bib2GlsEntry2.getId().equals(bib2GlsEntry.getParent())) {
            return 1;
        }
        if (bib2GlsEntry.equals((Object)bib2GlsEntry2)) {
            return 0;
        }
        int n = bib2GlsEntry.getHierarchyCount();
        int n2 = bib2GlsEntry2.getHierarchyCount();
        int n3 = Integer.min(n, n2);
        for (int i = 0; i < n3; ++i) {
            Bib2GlsEntry bib2GlsEntry3;
            Bib2GlsEntry bib2GlsEntry4 = bib2GlsEntry.getHierarchyElement(i);
            if (bib2GlsEntry4.equals((Object)(bib2GlsEntry3 = bib2GlsEntry2.getHierarchyElement(i)))) continue;
            int n4 = this.compareElements(bib2GlsEntry4, bib2GlsEntry3);
            if (n4 == 0) {
                n4 = this.getIdenticalSortFallback(bib2GlsEntry4, bib2GlsEntry3);
            }
            if (bl) {
                n4 = -n4;
            }
            if (this.bib2gls.getDebugLevel() > 0) {
                this.bib2gls.logAndPrintMessage(String.format("%s %c %s", bib2GlsEntry4.getFieldValue(this.sortStorageField), Character.valueOf((char)(n4 == 0 ? 61 : (n4 < 0 ? 60 : 62))), bib2GlsEntry3.getFieldValue(this.sortStorageField)));
            }
            if (n4 == 0) continue;
            return n4;
        }
        return n == n2 ? 0 : (n < n2 ? -1 : 1);
    }

    protected void setActualSortField(Bib2GlsEntry bib2GlsEntry) {
        String string = bib2GlsEntry.getFieldValue(this.sortStorageField);
        bib2GlsEntry.putField("sort", this.bib2gls.replaceSpecialChars(string));
    }

    public void sortEntries() throws Bib2GlsException {
        if (this.settings.getSuffixOption() == 1) {
            this.sortCount = new HashMap();
        }
        for (Bib2GlsEntry bib2GlsEntry : this.entries) {
            bib2GlsEntry.updateHierarchy(this.entries);
            this.updateSortValue(bib2GlsEntry, this.entries);
            this.setActualSortField(bib2GlsEntry);
        }
        this.entries.sort(this);
    }
}

